/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class PacketReader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int FD_EVENTS = 5;
    private static int UNREGISTER_THIS_FD = 0;
    public static int DEFAULT_RECV_BUF_SIZE = 2048;
    private Handler mHandler;
    private MessageQueue mQueue;
    private byte[] mPacket;
    private FileDescriptor mFd;
    private long mPacketsReceived;

    private static final void $$robo$$android_net_util_PacketReader$closeFd(FileDescriptor fd) {
        IoUtils.closeQuietly(fd);
    }

    private void $$robo$$android_net_util_PacketReader$__constructor__(Handler h) {
    }

    private void $$robo$$android_net_util_PacketReader$__constructor__(Handler h, int recvbufsize) {
        this.mHandler = h;
        this.mQueue = this.mHandler.getLooper().getQueue();
        this.mPacket = new byte[Math.max(recvbufsize, 2048)];
    }

    private final void $$robo$$android_net_util_PacketReader$start() {
        if (this.onCorrectThread()) {
            this.createAndRegisterFd();
        } else {
            this.mHandler.post(() -> {
                this.logError("start() called from off-thread", null);
                this.createAndRegisterFd();
            });
        }
    }

    private final void $$robo$$android_net_util_PacketReader$stop() {
        if (this.onCorrectThread()) {
            this.unregisterAndDestroyFd();
        } else {
            this.mHandler.post(() -> {
                this.logError("stop() called from off-thread", null);
                this.unregisterAndDestroyFd();
            });
        }
    }

    private final Handler $$robo$$android_net_util_PacketReader$getHandler() {
        return this.mHandler;
    }

    private final int $$robo$$android_net_util_PacketReader$recvBufSize() {
        return this.mPacket.length;
    }

    private final long $$robo$$android_net_util_PacketReader$numPacketsReceived() {
        return this.mPacketsReceived;
    }

    protected abstract FileDescriptor createFd();

    private final int $$robo$$android_net_util_PacketReader$readPacket(FileDescriptor fd, byte[] packetBuffer) throws Exception {
        return Os.read(fd, packetBuffer, 0, packetBuffer.length);
    }

    private final void $$robo$$android_net_util_PacketReader$handlePacket(byte[] recvbuf, int length) {
    }

    private final void $$robo$$android_net_util_PacketReader$logError(String msg, Exception e) {
    }

    private final void $$robo$$android_net_util_PacketReader$onStart() {
    }

    private final void $$robo$$android_net_util_PacketReader$onStop() {
    }

    private final void $$robo$$android_net_util_PacketReader$createAndRegisterFd() {
        if (this.mFd != null) {
            return;
        }
        try {
            this.mFd = this.createFd();
            if (this.mFd != null) {
                IoUtils.setBlocking(this.mFd, false);
            }
        }
        catch (Exception e) {
            this.logError("Failed to create socket: ", e);
            PacketReader.closeFd(this.mFd);
            this.mFd = null;
            return;
        }
        if (this.mFd == null) {
            return;
        }
        this.mQueue.addOnFileDescriptorEventListener(this.mFd, 5, new MessageQueue.OnFileDescriptorEventListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PacketReader this$0;

            private void $$robo$$android_net_util_PacketReader_1$__constructor__(PacketReader this$0) {
                this.this$0 = this$0;
            }

            private final int $$robo$$android_net_util_PacketReader_1$onFileDescriptorEvents(FileDescriptor fd, int events) {
                if (!this.this$0.isRunning() || !this.this$0.handleInput()) {
                    this.this$0.unregisterAndDestroyFd();
                    return 0;
                }
                return 5;
            }

            private void __constructor__(PacketReader packetReader) {
                this.$$robo$$android_net_util_PacketReader_1$__constructor__(packetReader);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_PacketReader_1$__constructor__(android.net.util.PacketReader ), this, packetReader);
            }

            @Override
            public int onFileDescriptorEvents(FileDescriptor fileDescriptor, int n) {
                return (int)InvokeDynamicSupport.bootstrap("onFileDescriptorEvents", $$robo$$android_net_util_PacketReader_1$onFileDescriptorEvents(java.io.FileDescriptor int ), this, fileDescriptor, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.onStart();
    }

    private final boolean $$robo$$android_net_util_PacketReader$isRunning() {
        return this.mFd != null && this.mFd.valid();
    }

    private final boolean $$robo$$android_net_util_PacketReader$handleInput() {
        while (this.isRunning()) {
            int bytesRead;
            try {
                bytesRead = this.readPacket(this.mFd, this.mPacket);
                if (bytesRead < 1) {
                    if (!this.isRunning()) break;
                    this.logError("Socket closed, exiting", null);
                    break;
                }
                ++this.mPacketsReceived;
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EAGAIN) {
                    return true;
                }
                if (e.errno == OsConstants.EINTR) continue;
                if (!this.isRunning()) break;
                this.logError("readPacket error: ", e);
                break;
            }
            catch (Exception e) {
                if (!this.isRunning()) break;
                this.logError("readPacket error: ", e);
                break;
            }
            try {
                this.handlePacket(this.mPacket, bytesRead);
            }
            catch (Exception e) {
                this.logError("handlePacket error: ", e);
                break;
            }
        }
        return false;
    }

    private final void $$robo$$android_net_util_PacketReader$unregisterAndDestroyFd() {
        if (this.mFd == null) {
            return;
        }
        this.mQueue.removeOnFileDescriptorEventListener(this.mFd);
        PacketReader.closeFd(this.mFd);
        this.mFd = null;
        this.onStop();
    }

    private final boolean $$robo$$android_net_util_PacketReader$onCorrectThread() {
        return this.mHandler.getLooper() == Looper.myLooper();
    }

    protected static void closeFd(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("closeFd", $$robo$$android_net_util_PacketReader$closeFd(java.io.FileDescriptor ), (FileDescriptor)fileDescriptor);
    }

    private void __constructor__(Handler handler) {
        this.$$robo$$android_net_util_PacketReader$__constructor__(handler);
    }

    public PacketReader(Handler handler) {
        this(handler, 2048);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_PacketReader$__constructor__(android.os.Handler ), this, handler);
    }

    private void __constructor__(Handler handler, int n) {
        this.$$robo$$android_net_util_PacketReader$__constructor__(handler, n);
    }

    public PacketReader(Handler handler, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_util_PacketReader$__constructor__(android.os.Handler int ), this, handler, n);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_net_util_PacketReader$start(), this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_util_PacketReader$stop(), this);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_net_util_PacketReader$getHandler(), this);
    }

    public int recvBufSize() {
        return (int)InvokeDynamicSupport.bootstrap("recvBufSize", $$robo$$android_net_util_PacketReader$recvBufSize(), this);
    }

    public long numPacketsReceived() {
        return (long)InvokeDynamicSupport.bootstrap("numPacketsReceived", $$robo$$android_net_util_PacketReader$numPacketsReceived(), this);
    }

    protected int readPacket(FileDescriptor fileDescriptor, byte[] byArray) throws Exception {
        return (int)InvokeDynamicSupport.bootstrap("readPacket", $$robo$$android_net_util_PacketReader$readPacket(java.io.FileDescriptor byte[] ), this, fileDescriptor, byArray);
    }

    protected void handlePacket(byte[] byArray, int n) {
        InvokeDynamicSupport.bootstrap("handlePacket", $$robo$$android_net_util_PacketReader$handlePacket(byte[] int ), this, byArray, n);
    }

    protected void logError(String string2, Exception exception) {
        InvokeDynamicSupport.bootstrap("logError", $$robo$$android_net_util_PacketReader$logError(java.lang.String java.lang.Exception ), this, string2, exception);
    }

    protected void onStart() {
        InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_net_util_PacketReader$onStart(), this);
    }

    protected void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_net_util_PacketReader$onStop(), this);
    }

    private void createAndRegisterFd() {
        InvokeDynamicSupport.bootstrap("createAndRegisterFd", $$robo$$android_net_util_PacketReader$createAndRegisterFd(), this);
    }

    private boolean isRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRunning", $$robo$$android_net_util_PacketReader$isRunning(), this);
    }

    private boolean handleInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("handleInput", $$robo$$android_net_util_PacketReader$handleInput(), this);
    }

    private void unregisterAndDestroyFd() {
        InvokeDynamicSupport.bootstrap("unregisterAndDestroyFd", $$robo$$android_net_util_PacketReader$unregisterAndDestroyFd(), this);
    }

    private boolean onCorrectThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("onCorrectThread", $$robo$$android_net_util_PacketReader$onCorrectThread(), this);
    }

    public /* synthetic */ PacketReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PacketReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

