/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.net.IpConfiguration;
import android.net.MacAddress;
import android.net.ProxyInfo;
import android.net.StaticIpConfiguration;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.BackupUtils;
import android.util.Log;
import android.util.TimeUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiConfiguration
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiConfiguration";
    private static int BACKUP_VERSION = 2;
    public static String ssidVarName = "ssid";
    public static String bssidVarName = "bssid";
    public static String pskVarName = "psk";
    @Deprecated
    public static String[] wepKeyVarNames;
    @Deprecated
    public static String wepTxKeyIdxVarName = "wep_tx_keyidx";
    public static String priorityVarName = "priority";
    public static String hiddenSSIDVarName = "scan_ssid";
    public static String pmfVarName = "ieee80211w";
    public static String updateIdentiferVarName = "update_identifier";
    public static int INVALID_NETWORK_ID = -1;
    public static int LOCAL_ONLY_NETWORK_ID = -2;
    private String mPasspointManagementObjectTree;
    private static int MAXIMUM_RANDOM_MAC_GENERATION_RETRY = 3;
    public static int UNKNOWN_UID = -1;
    public int networkId;
    public int status;
    public String SSID;
    public String BSSID;
    public static int AP_BAND_2GHZ = 0;
    public static int AP_BAND_5GHZ = 1;
    public static int AP_BAND_ANY = -1;
    public int apBand;
    public int apChannel;
    public String preSharedKey;
    @Deprecated
    public String[] wepKeys;
    @Deprecated
    public int wepTxKeyIndex;
    @Deprecated
    public int priority;
    public boolean hiddenSSID;
    public boolean requirePMF;
    public String updateIdentifier;
    public BitSet allowedKeyManagement;
    public BitSet allowedProtocols;
    public BitSet allowedAuthAlgorithms;
    public BitSet allowedPairwiseCiphers;
    public BitSet allowedGroupCiphers;
    public WifiEnterpriseConfig enterpriseConfig;
    public String FQDN;
    public String providerFriendlyName;
    public boolean isHomeProviderNetwork;
    public long[] roamingConsortiumIds;
    public boolean shared;
    private IpConfiguration mIpConfiguration;
    public String dhcpServer;
    public String defaultGwMacAddress;
    public boolean validatedInternetAccess;
    public int dtimInterval;
    public boolean isLegacyPasspointConfig;
    @SystemApi
    public int creatorUid;
    public int lastConnectUid;
    @SystemApi
    public int lastUpdateUid;
    @SystemApi
    public String creatorName;
    @SystemApi
    public String lastUpdateName;
    public int userApproved;
    public static int INVALID_RSSI;
    public static int USER_UNSPECIFIED = 0;
    public static int USER_APPROVED = 1;
    public static int USER_BANNED = 2;
    public static int USER_PENDING = 3;
    public int numNoInternetAccessReports;
    public String updateTime;
    public String creationTime;
    public boolean noInternetAccessExpected;
    public long lastConnected;
    public long lastDisconnected;
    public boolean selfAdded;
    public boolean didSelfAdd;
    public String peerWifiConfiguration;
    public boolean ephemeral;
    @SystemApi
    public boolean meteredHint;
    public static int METERED_OVERRIDE_NONE = 0;
    public static int METERED_OVERRIDE_METERED = 1;
    public static int METERED_OVERRIDE_NOT_METERED = 2;
    public int meteredOverride;
    @SystemApi
    public boolean useExternalScores;
    @SystemApi
    public int numScorerOverride;
    @SystemApi
    public int numScorerOverrideAndSwitchedNetwork;
    @SystemApi
    public int numAssociation;
    private MacAddress mRandomizedMacAddress;
    public static int HOME_NETWORK_RSSI_BOOST = 5;
    private NetworkSelectionStatus mNetworkSelectionStatus;
    public RecentFailure recentFailure;
    public HashMap<String, Integer> linkedConfigurations;
    String mCachedConfigKey;
    public static Parcelable.Creator<WifiConfiguration> CREATOR;

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiConfiguration$hasNoInternetAccess() {
        return this.numNoInternetAccessReports > 0 && !this.validatedInternetAccess;
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isNoInternetAccessExpected() {
        return this.noInternetAccessExpected;
    }

    @SystemApi
    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isEphemeral() {
        return this.ephemeral;
    }

    private static final boolean $$robo$$android_net_wifi_WifiConfiguration$isMetered(WifiConfiguration config, WifiInfo info) {
        boolean metered = false;
        if (info != null && info.getMeteredHint()) {
            metered = true;
        }
        if (config != null && config.meteredHint) {
            metered = true;
        }
        if (config != null && config.meteredOverride == 1) {
            metered = true;
        }
        if (config != null && config.meteredOverride == 2) {
            metered = false;
        }
        return metered;
    }

    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isOpenNetwork() {
        int cardinality = this.allowedKeyManagement.cardinality();
        boolean hasNoKeyMgmt = cardinality == 0 || cardinality == 1 && this.allowedKeyManagement.get(0);
        boolean hasNoWepKeys = true;
        if (this.wepKeys != null) {
            for (int i = 0; i < this.wepKeys.length; ++i) {
                if (this.wepKeys[i] == null) continue;
                hasNoWepKeys = false;
                break;
            }
        }
        return hasNoKeyMgmt && hasNoWepKeys;
    }

    private static final boolean $$robo$$android_net_wifi_WifiConfiguration$isValidMacAddressForRandomization(MacAddress mac) {
        return mac != null && !mac.isMulticastAddress() && mac.isLocallyAssigned() && !MacAddress.fromString("02:00:00:00:00:00").equals(mac);
    }

    private final MacAddress $$robo$$android_net_wifi_WifiConfiguration$getOrCreateRandomizedMacAddress() {
        for (int randomMacGenerationCount = 0; !WifiConfiguration.isValidMacAddressForRandomization(this.mRandomizedMacAddress) && randomMacGenerationCount < 3; ++randomMacGenerationCount) {
            this.mRandomizedMacAddress = MacAddress.createRandomUnicastAddress();
        }
        if (!WifiConfiguration.isValidMacAddressForRandomization(this.mRandomizedMacAddress)) {
            this.mRandomizedMacAddress = MacAddress.fromString("02:00:00:00:00:00");
        }
        return this.mRandomizedMacAddress;
    }

    private final MacAddress $$robo$$android_net_wifi_WifiConfiguration$getRandomizedMacAddress() {
        return this.mRandomizedMacAddress;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setRandomizedMacAddress(MacAddress mac) {
        if (mac == null) {
            Log.e("WifiConfiguration", "setRandomizedMacAddress received null MacAddress.");
            return;
        }
        this.mRandomizedMacAddress = mac;
    }

    private final NetworkSelectionStatus $$robo$$android_net_wifi_WifiConfiguration$getNetworkSelectionStatus() {
        return this.mNetworkSelectionStatus;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setNetworkSelectionStatus(NetworkSelectionStatus status) {
        this.mNetworkSelectionStatus = status;
    }

    private void $$robo$$android_net_wifi_WifiConfiguration$__constructor__() {
        this.apBand = 0;
        this.apChannel = 0;
        this.dtimInterval = 0;
        this.isLegacyPasspointConfig = false;
        this.userApproved = 0;
        this.meteredOverride = 0;
        this.mNetworkSelectionStatus = new NetworkSelectionStatus();
        this.recentFailure = new RecentFailure();
        this.networkId = -1;
        this.SSID = null;
        this.BSSID = null;
        this.FQDN = null;
        this.roamingConsortiumIds = new long[0];
        this.priority = 0;
        this.hiddenSSID = false;
        this.allowedKeyManagement = new BitSet();
        this.allowedProtocols = new BitSet();
        this.allowedAuthAlgorithms = new BitSet();
        this.allowedPairwiseCiphers = new BitSet();
        this.allowedGroupCiphers = new BitSet();
        this.wepKeys = new String[4];
        for (int i = 0; i < this.wepKeys.length; ++i) {
            this.wepKeys[i] = null;
        }
        this.enterpriseConfig = new WifiEnterpriseConfig();
        this.selfAdded = false;
        this.didSelfAdd = false;
        this.ephemeral = false;
        this.meteredHint = false;
        this.meteredOverride = 0;
        this.useExternalScores = false;
        this.validatedInternetAccess = false;
        this.mIpConfiguration = new IpConfiguration();
        this.lastUpdateUid = -1;
        this.creatorUid = -1;
        this.shared = true;
        this.dtimInterval = 0;
        this.mRandomizedMacAddress = MacAddress.fromString("02:00:00:00:00:00");
    }

    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isPasspoint() {
        return !TextUtils.isEmpty(this.FQDN) && !TextUtils.isEmpty(this.providerFriendlyName) && this.enterpriseConfig != null && this.enterpriseConfig.getEapMethod() != -1;
    }

    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isLinked(WifiConfiguration config) {
        return config != null && config.linkedConfigurations != null && this.linkedConfigurations != null && config.linkedConfigurations.get(this.configKey()) != null && this.linkedConfigurations.get(config.configKey()) != null;
    }

    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isEnterprise() {
        return (this.allowedKeyManagement.get(2) || this.allowedKeyManagement.get(3)) && this.enterpriseConfig != null && this.enterpriseConfig.getEapMethod() != -1;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$toString() {
        StringBuilder sbuf = new StringBuilder();
        if (this.status == 0) {
            sbuf.append("* ");
        } else if (this.status == 1) {
            sbuf.append("- DSBLE ");
        }
        sbuf.append("ID: ").append(this.networkId).append(" SSID: ").append(this.SSID).append(" PROVIDER-NAME: ").append(this.providerFriendlyName).append(" BSSID: ").append(this.BSSID).append(" FQDN: ").append(this.FQDN).append(" PRIO: ").append(this.priority).append(" HIDDEN: ").append(this.hiddenSSID).append('\n');
        sbuf.append(" NetworkSelectionStatus ").append(this.mNetworkSelectionStatus.getNetworkStatusString() + "\n");
        if (this.mNetworkSelectionStatus.getNetworkSelectionDisableReason() > 0) {
            sbuf.append(" mNetworkSelectionDisableReason ").append(this.mNetworkSelectionStatus.getNetworkDisableReasonString() + "\n");
            int index = 0;
            while (true) {
                if (index >= 14) break;
                if (this.mNetworkSelectionStatus.getDisableReasonCounter(index) != 0) {
                    sbuf.append(NetworkSelectionStatus.getNetworkDisableReasonString(index) + " counter:" + this.mNetworkSelectionStatus.getDisableReasonCounter(index) + "\n");
                }
                ++index;
            }
        }
        if (this.mNetworkSelectionStatus.getConnectChoice() != null) {
            sbuf.append(" connect choice: ").append(this.mNetworkSelectionStatus.getConnectChoice());
            sbuf.append(" connect choice set time: ").append(TimeUtils.logTimeOfDay(this.mNetworkSelectionStatus.getConnectChoiceTimestamp()));
        }
        sbuf.append(" hasEverConnected: ").append(this.mNetworkSelectionStatus.getHasEverConnected()).append("\n");
        if (this.numAssociation > 0) {
            sbuf.append(" numAssociation ").append(this.numAssociation).append("\n");
        }
        if (this.numNoInternetAccessReports > 0) {
            sbuf.append(" numNoInternetAccessReports ");
            sbuf.append(this.numNoInternetAccessReports).append("\n");
        }
        if (this.updateTime != null) {
            sbuf.append(" update ").append(this.updateTime).append("\n");
        }
        if (this.creationTime != null) {
            sbuf.append(" creation ").append(this.creationTime).append("\n");
        }
        if (this.didSelfAdd) {
            sbuf.append(" didSelfAdd");
        }
        if (this.selfAdded) {
            sbuf.append(" selfAdded");
        }
        if (this.validatedInternetAccess) {
            sbuf.append(" validatedInternetAccess");
        }
        if (this.ephemeral) {
            sbuf.append(" ephemeral");
        }
        if (this.meteredHint) {
            sbuf.append(" meteredHint");
        }
        if (this.useExternalScores) {
            sbuf.append(" useExternalScores");
        }
        if (this.didSelfAdd || this.selfAdded || this.validatedInternetAccess || this.ephemeral || this.meteredHint || this.useExternalScores) {
            sbuf.append("\n");
        }
        if (this.meteredOverride != 0) {
            sbuf.append(" meteredOverride ").append(this.meteredOverride).append("\n");
        }
        sbuf.append(" KeyMgmt:");
        for (int k = 0; k < this.allowedKeyManagement.size(); ++k) {
            if (!this.allowedKeyManagement.get(k)) continue;
            sbuf.append(" ");
            if (k < KeyMgmt.strings.length) {
                sbuf.append(KeyMgmt.strings[k]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append(" Protocols:");
        for (int p = 0; p < this.allowedProtocols.size(); ++p) {
            if (!this.allowedProtocols.get(p)) continue;
            sbuf.append(" ");
            if (p < Protocol.strings.length) {
                sbuf.append(Protocol.strings[p]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" AuthAlgorithms:");
        for (int a = 0; a < this.allowedAuthAlgorithms.size(); ++a) {
            if (!this.allowedAuthAlgorithms.get(a)) continue;
            sbuf.append(" ");
            if (a < AuthAlgorithm.strings.length) {
                sbuf.append(AuthAlgorithm.strings[a]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" PairwiseCiphers:");
        for (int pc = 0; pc < this.allowedPairwiseCiphers.size(); ++pc) {
            if (!this.allowedPairwiseCiphers.get(pc)) continue;
            sbuf.append(" ");
            if (pc < PairwiseCipher.strings.length) {
                sbuf.append(PairwiseCipher.strings[pc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupCiphers:");
        for (int gc = 0; gc < this.allowedGroupCiphers.size(); ++gc) {
            if (!this.allowedGroupCiphers.get(gc)) continue;
            sbuf.append(" ");
            if (gc < GroupCipher.strings.length) {
                sbuf.append(GroupCipher.strings[gc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n').append(" PSK: ");
        if (this.preSharedKey != null) {
            sbuf.append('*');
        }
        sbuf.append("\nEnterprise config:\n");
        sbuf.append(this.enterpriseConfig);
        sbuf.append("IP config:\n");
        sbuf.append(this.mIpConfiguration.toString());
        if (this.mNetworkSelectionStatus.getNetworkSelectionBSSID() != null) {
            sbuf.append(" networkSelectionBSSID=" + this.mNetworkSelectionStatus.getNetworkSelectionBSSID());
        }
        long now_ms = SystemClock.elapsedRealtime();
        if (this.mNetworkSelectionStatus.getDisableTime() != -1L) {
            sbuf.append('\n');
            long diff = now_ms - this.mNetworkSelectionStatus.getDisableTime();
            if (diff <= 0L) {
                sbuf.append(" blackListed since <incorrect>");
            } else {
                sbuf.append(" blackListed: ").append(Long.toString(diff / 1000L)).append("sec ");
            }
        }
        if (this.creatorUid != 0) {
            sbuf.append(" cuid=" + this.creatorUid);
        }
        if (this.creatorName != null) {
            sbuf.append(" cname=" + this.creatorName);
        }
        if (this.lastUpdateUid != 0) {
            sbuf.append(" luid=" + this.lastUpdateUid);
        }
        if (this.lastUpdateName != null) {
            sbuf.append(" lname=" + this.lastUpdateName);
        }
        sbuf.append(" lcuid=" + this.lastConnectUid);
        sbuf.append(" userApproved=" + WifiConfiguration.userApprovedAsString(this.userApproved));
        sbuf.append(" noInternetAccessExpected=" + this.noInternetAccessExpected);
        sbuf.append(" ");
        if (this.lastConnected != 0L) {
            sbuf.append('\n');
            sbuf.append("lastConnected: ").append(TimeUtils.logTimeOfDay(this.lastConnected));
            sbuf.append(" ");
        }
        sbuf.append('\n');
        if (this.linkedConfigurations != null) {
            for (String key : this.linkedConfigurations.keySet()) {
                sbuf.append(" linked: ").append(key);
                sbuf.append('\n');
            }
        }
        sbuf.append("recentFailure: ").append("Association Rejection code: ").append(this.recentFailure.getAssociationStatus()).append("\n");
        return sbuf.toString();
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$getPrintableSsid() {
        if (this.SSID == null) {
            return "";
        }
        int length = this.SSID.length();
        if (length > 2 && this.SSID.charAt(0) == '\"' && this.SSID.charAt(length - 1) == '\"') {
            return this.SSID.substring(1, length - 1);
        }
        if (length > 3 && this.SSID.charAt(0) == 'P' && this.SSID.charAt(1) == '\"' && this.SSID.charAt(length - 1) == '\"') {
            WifiSsid wifiSsid = WifiSsid.createFromAsciiEncoded(this.SSID.substring(2, length - 1));
            return wifiSsid.toString();
        }
        return this.SSID;
    }

    private static final String $$robo$$android_net_wifi_WifiConfiguration$userApprovedAsString(int userApproved) {
        switch (userApproved) {
            case 1: {
                return "USER_APPROVED";
            }
            case 2: {
                return "USER_BANNED";
            }
            case 0: {
                return "USER_UNSPECIFIED";
            }
        }
        return "INVALID";
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$getKeyIdForCredentials(WifiConfiguration current) {
        String keyMgmt = null;
        try {
            if (TextUtils.isEmpty(this.SSID)) {
                this.SSID = current.SSID;
            }
            if (this.allowedKeyManagement.cardinality() == 0) {
                this.allowedKeyManagement = current.allowedKeyManagement;
            }
            if (this.allowedKeyManagement.get(2)) {
                keyMgmt = KeyMgmt.strings[2];
            }
            if (this.allowedKeyManagement.get(5)) {
                keyMgmt = KeyMgmt.strings[5];
            }
            if (this.allowedKeyManagement.get(3)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[3];
            }
            if (TextUtils.isEmpty(keyMgmt)) {
                throw new IllegalStateException("Not an EAP network");
            }
            return this.trimStringForKeyId(this.SSID) + "_" + keyMgmt + "_" + this.trimStringForKeyId(this.enterpriseConfig.getKeyId(current != null ? current.enterpriseConfig : null));
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Invalid config details");
        }
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$trimStringForKeyId(String string2) {
        return string2.replace("\"", "").replace(" ", "");
    }

    private static final BitSet $$robo$$android_net_wifi_WifiConfiguration$readBitSet(Parcel src) {
        int cardinality = src.readInt();
        BitSet set = new BitSet();
        for (int i = 0; i < cardinality; ++i) {
            set.set(src.readInt());
        }
        return set;
    }

    private static final void $$robo$$android_net_wifi_WifiConfiguration$writeBitSet(Parcel dest, BitSet set) {
        int nextSetBit = -1;
        dest.writeInt(set.cardinality());
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            dest.writeInt(nextSetBit);
        }
    }

    private final int $$robo$$android_net_wifi_WifiConfiguration$getAuthType() {
        if (this.allowedKeyManagement.cardinality() > 1) {
            throw new IllegalStateException("More than one auth type set");
        }
        if (this.allowedKeyManagement.get(1)) {
            return 1;
        }
        if (this.allowedKeyManagement.get(4)) {
            return 4;
        }
        if (this.allowedKeyManagement.get(2)) {
            return 2;
        }
        if (this.allowedKeyManagement.get(3)) {
            return 3;
        }
        return 0;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$configKey(boolean allowCached) {
        String key;
        if (allowCached && this.mCachedConfigKey != null) {
            key = this.mCachedConfigKey;
        } else if (this.providerFriendlyName != null) {
            key = this.FQDN + KeyMgmt.strings[2];
            if (!this.shared) {
                key = key + "-" + Integer.toString(UserHandle.getUserId(this.creatorUid));
            }
        } else {
            key = this.allowedKeyManagement.get(1) ? this.SSID + KeyMgmt.strings[1] : (this.allowedKeyManagement.get(2) || this.allowedKeyManagement.get(3) ? this.SSID + KeyMgmt.strings[2] : (this.wepKeys[0] != null ? this.SSID + "WEP" : this.SSID + KeyMgmt.strings[0]));
            if (!this.shared) {
                key = key + "-" + Integer.toString(UserHandle.getUserId(this.creatorUid));
            }
            this.mCachedConfigKey = key;
        }
        return key;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$configKey() {
        return this.configKey(false);
    }

    private final IpConfiguration $$robo$$android_net_wifi_WifiConfiguration$getIpConfiguration() {
        return this.mIpConfiguration;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setIpConfiguration(IpConfiguration ipConfiguration) {
        if (ipConfiguration == null) {
            ipConfiguration = new IpConfiguration();
        }
        this.mIpConfiguration = ipConfiguration;
    }

    private final StaticIpConfiguration $$robo$$android_net_wifi_WifiConfiguration$getStaticIpConfiguration() {
        return this.mIpConfiguration.getStaticIpConfiguration();
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this.mIpConfiguration.setStaticIpConfiguration(staticIpConfiguration);
    }

    private final IpConfiguration.IpAssignment $$robo$$android_net_wifi_WifiConfiguration$getIpAssignment() {
        return this.mIpConfiguration.ipAssignment;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setIpAssignment(IpConfiguration.IpAssignment ipAssignment) {
        this.mIpConfiguration.ipAssignment = ipAssignment;
    }

    private final IpConfiguration.ProxySettings $$robo$$android_net_wifi_WifiConfiguration$getProxySettings() {
        return this.mIpConfiguration.proxySettings;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setProxySettings(IpConfiguration.ProxySettings proxySettings) {
        this.mIpConfiguration.proxySettings = proxySettings;
    }

    private final ProxyInfo $$robo$$android_net_wifi_WifiConfiguration$getHttpProxy() {
        if (this.mIpConfiguration.proxySettings == IpConfiguration.ProxySettings.NONE) {
            return null;
        }
        return new ProxyInfo(this.mIpConfiguration.httpProxy);
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setHttpProxy(ProxyInfo httpProxy) {
        ProxyInfo httpProxyCopy;
        IpConfiguration.ProxySettings proxySettingCopy;
        if (httpProxy == null) {
            this.mIpConfiguration.setProxySettings(IpConfiguration.ProxySettings.NONE);
            this.mIpConfiguration.setHttpProxy(null);
            return;
        }
        if (!Uri.EMPTY.equals(httpProxy.getPacFileUrl())) {
            proxySettingCopy = IpConfiguration.ProxySettings.PAC;
            httpProxyCopy = new ProxyInfo(httpProxy.getPacFileUrl(), httpProxy.getPort());
        } else {
            proxySettingCopy = IpConfiguration.ProxySettings.STATIC;
            httpProxyCopy = new ProxyInfo(httpProxy.getHost(), httpProxy.getPort(), httpProxy.getExclusionListAsString());
        }
        if (!httpProxyCopy.isValid()) {
            throw new IllegalArgumentException("Invalid ProxyInfo: " + httpProxyCopy.toString());
        }
        this.mIpConfiguration.setProxySettings(proxySettingCopy);
        this.mIpConfiguration.setHttpProxy(httpProxyCopy);
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setProxy(IpConfiguration.ProxySettings settings, ProxyInfo proxy) {
        this.mIpConfiguration.proxySettings = settings;
        this.mIpConfiguration.httpProxy = proxy;
    }

    private final int $$robo$$android_net_wifi_WifiConfiguration$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setPasspointManagementObjectTree(String passpointManagementObjectTree) {
        this.mPasspointManagementObjectTree = passpointManagementObjectTree;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$getMoTree() {
        return this.mPasspointManagementObjectTree;
    }

    private void $$robo$$android_net_wifi_WifiConfiguration$__constructor__(WifiConfiguration source) {
        this.apBand = 0;
        this.apChannel = 0;
        this.dtimInterval = 0;
        this.isLegacyPasspointConfig = false;
        this.userApproved = 0;
        this.meteredOverride = 0;
        this.mNetworkSelectionStatus = new NetworkSelectionStatus();
        this.recentFailure = new RecentFailure();
        if (source != null) {
            this.networkId = source.networkId;
            this.status = source.status;
            this.SSID = source.SSID;
            this.BSSID = source.BSSID;
            this.FQDN = source.FQDN;
            this.roamingConsortiumIds = (long[])source.roamingConsortiumIds.clone();
            this.providerFriendlyName = source.providerFriendlyName;
            this.isHomeProviderNetwork = source.isHomeProviderNetwork;
            this.preSharedKey = source.preSharedKey;
            this.mNetworkSelectionStatus.copy(source.getNetworkSelectionStatus());
            this.apBand = source.apBand;
            this.apChannel = source.apChannel;
            this.wepKeys = new String[4];
            for (int i = 0; i < this.wepKeys.length; ++i) {
                this.wepKeys[i] = source.wepKeys[i];
            }
            this.wepTxKeyIndex = source.wepTxKeyIndex;
            this.priority = source.priority;
            this.hiddenSSID = source.hiddenSSID;
            this.allowedKeyManagement = (BitSet)source.allowedKeyManagement.clone();
            this.allowedProtocols = (BitSet)source.allowedProtocols.clone();
            this.allowedAuthAlgorithms = (BitSet)source.allowedAuthAlgorithms.clone();
            this.allowedPairwiseCiphers = (BitSet)source.allowedPairwiseCiphers.clone();
            this.allowedGroupCiphers = (BitSet)source.allowedGroupCiphers.clone();
            this.enterpriseConfig = new WifiEnterpriseConfig(source.enterpriseConfig);
            this.defaultGwMacAddress = source.defaultGwMacAddress;
            this.mIpConfiguration = new IpConfiguration(source.mIpConfiguration);
            if (source.linkedConfigurations != null && source.linkedConfigurations.size() > 0) {
                this.linkedConfigurations = new HashMap();
                this.linkedConfigurations.putAll(source.linkedConfigurations);
            }
            this.mCachedConfigKey = null;
            this.selfAdded = source.selfAdded;
            this.validatedInternetAccess = source.validatedInternetAccess;
            this.isLegacyPasspointConfig = source.isLegacyPasspointConfig;
            this.ephemeral = source.ephemeral;
            this.meteredHint = source.meteredHint;
            this.meteredOverride = source.meteredOverride;
            this.useExternalScores = source.useExternalScores;
            this.didSelfAdd = source.didSelfAdd;
            this.lastConnectUid = source.lastConnectUid;
            this.lastUpdateUid = source.lastUpdateUid;
            this.creatorUid = source.creatorUid;
            this.creatorName = source.creatorName;
            this.lastUpdateName = source.lastUpdateName;
            this.peerWifiConfiguration = source.peerWifiConfiguration;
            this.lastConnected = source.lastConnected;
            this.lastDisconnected = source.lastDisconnected;
            this.numScorerOverride = source.numScorerOverride;
            this.numScorerOverrideAndSwitchedNetwork = source.numScorerOverrideAndSwitchedNetwork;
            this.numAssociation = source.numAssociation;
            this.userApproved = source.userApproved;
            this.numNoInternetAccessReports = source.numNoInternetAccessReports;
            this.noInternetAccessExpected = source.noInternetAccessExpected;
            this.creationTime = source.creationTime;
            this.updateTime = source.updateTime;
            this.shared = source.shared;
            this.recentFailure.setAssociationStatus(source.recentFailure.getAssociationStatus());
            this.mRandomizedMacAddress = source.mRandomizedMacAddress;
        }
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.networkId);
        dest.writeInt(this.status);
        this.mNetworkSelectionStatus.writeToParcel(dest);
        dest.writeString(this.SSID);
        dest.writeString(this.BSSID);
        dest.writeInt(this.apBand);
        dest.writeInt(this.apChannel);
        dest.writeString(this.FQDN);
        dest.writeString(this.providerFriendlyName);
        dest.writeInt(this.isHomeProviderNetwork ? 1 : 0);
        dest.writeInt(this.roamingConsortiumIds.length);
        for (long roamingConsortiumId : this.roamingConsortiumIds) {
            dest.writeLong(roamingConsortiumId);
        }
        dest.writeString(this.preSharedKey);
        for (String wepKey : this.wepKeys) {
            dest.writeString(wepKey);
        }
        dest.writeInt(this.wepTxKeyIndex);
        dest.writeInt(this.priority);
        dest.writeInt(this.hiddenSSID ? 1 : 0);
        dest.writeInt(this.requirePMF ? 1 : 0);
        dest.writeString(this.updateIdentifier);
        WifiConfiguration.writeBitSet(dest, this.allowedKeyManagement);
        WifiConfiguration.writeBitSet(dest, this.allowedProtocols);
        WifiConfiguration.writeBitSet(dest, this.allowedAuthAlgorithms);
        WifiConfiguration.writeBitSet(dest, this.allowedPairwiseCiphers);
        WifiConfiguration.writeBitSet(dest, this.allowedGroupCiphers);
        dest.writeParcelable(this.enterpriseConfig, flags);
        dest.writeParcelable(this.mIpConfiguration, flags);
        dest.writeString(this.dhcpServer);
        dest.writeString(this.defaultGwMacAddress);
        dest.writeInt(this.selfAdded ? 1 : 0);
        dest.writeInt(this.didSelfAdd ? 1 : 0);
        dest.writeInt(this.validatedInternetAccess ? 1 : 0);
        dest.writeInt(this.isLegacyPasspointConfig ? 1 : 0);
        dest.writeInt(this.ephemeral ? 1 : 0);
        dest.writeInt(this.meteredHint ? 1 : 0);
        dest.writeInt(this.meteredOverride);
        dest.writeInt(this.useExternalScores ? 1 : 0);
        dest.writeInt(this.creatorUid);
        dest.writeInt(this.lastConnectUid);
        dest.writeInt(this.lastUpdateUid);
        dest.writeString(this.creatorName);
        dest.writeString(this.lastUpdateName);
        dest.writeInt(this.numScorerOverride);
        dest.writeInt(this.numScorerOverrideAndSwitchedNetwork);
        dest.writeInt(this.numAssociation);
        dest.writeInt(this.userApproved);
        dest.writeInt(this.numNoInternetAccessReports);
        dest.writeInt(this.noInternetAccessExpected ? 1 : 0);
        dest.writeInt(this.shared ? 1 : 0);
        dest.writeString(this.mPasspointManagementObjectTree);
        dest.writeInt(this.recentFailure.getAssociationStatus());
        dest.writeParcelable(this.mRandomizedMacAddress, flags);
    }

    private final byte[] $$robo$$android_net_wifi_WifiConfiguration$getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(2);
        BackupUtils.writeString(out, this.SSID);
        out.writeInt(this.apBand);
        out.writeInt(this.apChannel);
        BackupUtils.writeString(out, this.preSharedKey);
        out.writeInt(this.getAuthType());
        return baos.toByteArray();
    }

    private static final WifiConfiguration $$robo$$android_net_wifi_WifiConfiguration$getWifiConfigFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        WifiConfiguration config = new WifiConfiguration();
        int version = in.readInt();
        if (version < 1 || version > 2) {
            throw new BackupUtils.BadVersionException("Unknown Backup Serialization Version");
        }
        if (version == 1) {
            return null;
        }
        config.SSID = BackupUtils.readString(in);
        config.apBand = in.readInt();
        config.apChannel = in.readInt();
        config.preSharedKey = BackupUtils.readString(in);
        config.allowedKeyManagement.set(in.readInt());
        return config;
    }

    static void __staticInitializer__() {
        wepKeyVarNames = new String[]{"wep_key0", "wep_key1", "wep_key2", "wep_key3"};
        INVALID_RSSI = -127;
        CREATOR = new Parcelable.Creator<WifiConfiguration>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiConfiguration_1$__constructor__() {
            }

            private final WifiConfiguration $$robo$$android_net_wifi_WifiConfiguration_1$createFromParcel(Parcel in) {
                int i;
                WifiConfiguration config = new WifiConfiguration();
                config.networkId = in.readInt();
                config.status = in.readInt();
                config.mNetworkSelectionStatus.readFromParcel(in);
                config.SSID = in.readString();
                config.BSSID = in.readString();
                config.apBand = in.readInt();
                config.apChannel = in.readInt();
                config.FQDN = in.readString();
                config.providerFriendlyName = in.readString();
                config.isHomeProviderNetwork = in.readInt() != 0;
                int numRoamingConsortiumIds = in.readInt();
                config.roamingConsortiumIds = new long[numRoamingConsortiumIds];
                for (i = 0; i < numRoamingConsortiumIds; ++i) {
                    config.roamingConsortiumIds[i] = in.readLong();
                }
                config.preSharedKey = in.readString();
                for (i = 0; i < config.wepKeys.length; ++i) {
                    config.wepKeys[i] = in.readString();
                }
                config.wepTxKeyIndex = in.readInt();
                config.priority = in.readInt();
                config.hiddenSSID = in.readInt() != 0;
                config.requirePMF = in.readInt() != 0;
                config.updateIdentifier = in.readString();
                config.allowedKeyManagement = WifiConfiguration.readBitSet(in);
                config.allowedProtocols = WifiConfiguration.readBitSet(in);
                config.allowedAuthAlgorithms = WifiConfiguration.readBitSet(in);
                config.allowedPairwiseCiphers = WifiConfiguration.readBitSet(in);
                config.allowedGroupCiphers = WifiConfiguration.readBitSet(in);
                config.enterpriseConfig = (WifiEnterpriseConfig)in.readParcelable(null);
                config.setIpConfiguration((IpConfiguration)in.readParcelable(null));
                config.dhcpServer = in.readString();
                config.defaultGwMacAddress = in.readString();
                config.selfAdded = in.readInt() != 0;
                config.didSelfAdd = in.readInt() != 0;
                config.validatedInternetAccess = in.readInt() != 0;
                config.isLegacyPasspointConfig = in.readInt() != 0;
                config.ephemeral = in.readInt() != 0;
                config.meteredHint = in.readInt() != 0;
                config.meteredOverride = in.readInt();
                config.useExternalScores = in.readInt() != 0;
                config.creatorUid = in.readInt();
                config.lastConnectUid = in.readInt();
                config.lastUpdateUid = in.readInt();
                config.creatorName = in.readString();
                config.lastUpdateName = in.readString();
                config.numScorerOverride = in.readInt();
                config.numScorerOverrideAndSwitchedNetwork = in.readInt();
                config.numAssociation = in.readInt();
                config.userApproved = in.readInt();
                config.numNoInternetAccessReports = in.readInt();
                config.noInternetAccessExpected = in.readInt() != 0;
                config.shared = in.readInt() != 0;
                config.mPasspointManagementObjectTree = in.readString();
                config.recentFailure.setAssociationStatus(in.readInt());
                config.mRandomizedMacAddress = (MacAddress)in.readParcelable(null);
                return config;
            }

            private final WifiConfiguration[] $$robo$$android_net_wifi_WifiConfiguration_1$newArray(int size) {
                return new WifiConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiConfiguration_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_1$__constructor__(), this);
            }

            @Override
            public WifiConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiConfiguration_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WifiConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiConfiguration_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    @SystemApi
    public boolean hasNoInternetAccess() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNoInternetAccess", $$robo$$android_net_wifi_WifiConfiguration$hasNoInternetAccess(), this);
    }

    @SystemApi
    public boolean isNoInternetAccessExpected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNoInternetAccessExpected", $$robo$$android_net_wifi_WifiConfiguration$isNoInternetAccessExpected(), this);
    }

    @SystemApi
    public boolean isEphemeral() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEphemeral", $$robo$$android_net_wifi_WifiConfiguration$isEphemeral(), this);
    }

    public static boolean isMetered(WifiConfiguration wifiConfiguration, WifiInfo wifiInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMetered", $$robo$$android_net_wifi_WifiConfiguration$isMetered(android.net.wifi.WifiConfiguration android.net.wifi.WifiInfo ), (WifiConfiguration)wifiConfiguration, (WifiInfo)wifiInfo);
    }

    public boolean isOpenNetwork() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpenNetwork", $$robo$$android_net_wifi_WifiConfiguration$isOpenNetwork(), this);
    }

    public static boolean isValidMacAddressForRandomization(MacAddress macAddress) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMacAddressForRandomization", $$robo$$android_net_wifi_WifiConfiguration$isValidMacAddressForRandomization(android.net.MacAddress ), (MacAddress)macAddress);
    }

    public MacAddress getOrCreateRandomizedMacAddress() {
        return InvokeDynamicSupport.bootstrap("getOrCreateRandomizedMacAddress", $$robo$$android_net_wifi_WifiConfiguration$getOrCreateRandomizedMacAddress(), this);
    }

    public MacAddress getRandomizedMacAddress() {
        return InvokeDynamicSupport.bootstrap("getRandomizedMacAddress", $$robo$$android_net_wifi_WifiConfiguration$getRandomizedMacAddress(), this);
    }

    public void setRandomizedMacAddress(MacAddress macAddress) {
        InvokeDynamicSupport.bootstrap("setRandomizedMacAddress", $$robo$$android_net_wifi_WifiConfiguration$setRandomizedMacAddress(android.net.MacAddress ), this, macAddress);
    }

    public NetworkSelectionStatus getNetworkSelectionStatus() {
        return InvokeDynamicSupport.bootstrap("getNetworkSelectionStatus", $$robo$$android_net_wifi_WifiConfiguration$getNetworkSelectionStatus(), this);
    }

    public void setNetworkSelectionStatus(NetworkSelectionStatus networkSelectionStatus) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionStatus", $$robo$$android_net_wifi_WifiConfiguration$setNetworkSelectionStatus(android.net.wifi.WifiConfiguration$NetworkSelectionStatus ), this, networkSelectionStatus);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiConfiguration$__constructor__();
    }

    public WifiConfiguration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration$__constructor__(), this);
    }

    public boolean isPasspoint() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPasspoint", $$robo$$android_net_wifi_WifiConfiguration$isPasspoint(), this);
    }

    public boolean isLinked(WifiConfiguration wifiConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLinked", $$robo$$android_net_wifi_WifiConfiguration$isLinked(android.net.wifi.WifiConfiguration ), this, wifiConfiguration);
    }

    public boolean isEnterprise() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnterprise", $$robo$$android_net_wifi_WifiConfiguration$isEnterprise(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiConfiguration$toString(), this);
    }

    public String getPrintableSsid() {
        return InvokeDynamicSupport.bootstrap("getPrintableSsid", $$robo$$android_net_wifi_WifiConfiguration$getPrintableSsid(), this);
    }

    public static String userApprovedAsString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("userApprovedAsString", $$robo$$android_net_wifi_WifiConfiguration$userApprovedAsString(int ), (int)n);
    }

    public String getKeyIdForCredentials(WifiConfiguration wifiConfiguration) {
        return InvokeDynamicSupport.bootstrap("getKeyIdForCredentials", $$robo$$android_net_wifi_WifiConfiguration$getKeyIdForCredentials(android.net.wifi.WifiConfiguration ), this, wifiConfiguration);
    }

    private String trimStringForKeyId(String string2) {
        return InvokeDynamicSupport.bootstrap("trimStringForKeyId", $$robo$$android_net_wifi_WifiConfiguration$trimStringForKeyId(java.lang.String ), this, string2);
    }

    private static BitSet readBitSet(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readBitSet", $$robo$$android_net_wifi_WifiConfiguration$readBitSet(android.os.Parcel ), (Parcel)parcel);
    }

    private static void writeBitSet(Parcel parcel, BitSet bitSet) {
        InvokeDynamicSupport.bootstrapStatic("writeBitSet", $$robo$$android_net_wifi_WifiConfiguration$writeBitSet(android.os.Parcel java.util.BitSet ), (Parcel)parcel, (BitSet)bitSet);
    }

    public int getAuthType() {
        return (int)InvokeDynamicSupport.bootstrap("getAuthType", $$robo$$android_net_wifi_WifiConfiguration$getAuthType(), this);
    }

    public String configKey(boolean bl) {
        return InvokeDynamicSupport.bootstrap("configKey", $$robo$$android_net_wifi_WifiConfiguration$configKey(boolean ), this, bl);
    }

    public String configKey() {
        return InvokeDynamicSupport.bootstrap("configKey", $$robo$$android_net_wifi_WifiConfiguration$configKey(), this);
    }

    public IpConfiguration getIpConfiguration() {
        return InvokeDynamicSupport.bootstrap("getIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$getIpConfiguration(), this);
    }

    public void setIpConfiguration(IpConfiguration ipConfiguration) {
        InvokeDynamicSupport.bootstrap("setIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$setIpConfiguration(android.net.IpConfiguration ), this, ipConfiguration);
    }

    public StaticIpConfiguration getStaticIpConfiguration() {
        return InvokeDynamicSupport.bootstrap("getStaticIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$getStaticIpConfiguration(), this);
    }

    public void setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        InvokeDynamicSupport.bootstrap("setStaticIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$setStaticIpConfiguration(android.net.StaticIpConfiguration ), this, staticIpConfiguration);
    }

    public IpConfiguration.IpAssignment getIpAssignment() {
        return InvokeDynamicSupport.bootstrap("getIpAssignment", $$robo$$android_net_wifi_WifiConfiguration$getIpAssignment(), this);
    }

    public void setIpAssignment(IpConfiguration.IpAssignment ipAssignment) {
        InvokeDynamicSupport.bootstrap("setIpAssignment", $$robo$$android_net_wifi_WifiConfiguration$setIpAssignment(android.net.IpConfiguration$IpAssignment ), this, ipAssignment);
    }

    public IpConfiguration.ProxySettings getProxySettings() {
        return InvokeDynamicSupport.bootstrap("getProxySettings", $$robo$$android_net_wifi_WifiConfiguration$getProxySettings(), this);
    }

    public void setProxySettings(IpConfiguration.ProxySettings proxySettings) {
        InvokeDynamicSupport.bootstrap("setProxySettings", $$robo$$android_net_wifi_WifiConfiguration$setProxySettings(android.net.IpConfiguration$ProxySettings ), this, proxySettings);
    }

    public ProxyInfo getHttpProxy() {
        return InvokeDynamicSupport.bootstrap("getHttpProxy", $$robo$$android_net_wifi_WifiConfiguration$getHttpProxy(), this);
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setHttpProxy", $$robo$$android_net_wifi_WifiConfiguration$setHttpProxy(android.net.ProxyInfo ), this, proxyInfo);
    }

    public void setProxy(IpConfiguration.ProxySettings proxySettings, ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setProxy", $$robo$$android_net_wifi_WifiConfiguration$setProxy(android.net.IpConfiguration$ProxySettings android.net.ProxyInfo ), this, proxySettings, proxyInfo);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiConfiguration$describeContents(), this);
    }

    public void setPasspointManagementObjectTree(String string2) {
        InvokeDynamicSupport.bootstrap("setPasspointManagementObjectTree", $$robo$$android_net_wifi_WifiConfiguration$setPasspointManagementObjectTree(java.lang.String ), this, string2);
    }

    public String getMoTree() {
        return InvokeDynamicSupport.bootstrap("getMoTree", $$robo$$android_net_wifi_WifiConfiguration$getMoTree(), this);
    }

    private void __constructor__(WifiConfiguration wifiConfiguration) {
        this.$$robo$$android_net_wifi_WifiConfiguration$__constructor__(wifiConfiguration);
    }

    public WifiConfiguration(WifiConfiguration wifiConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration$__constructor__(android.net.wifi.WifiConfiguration ), this, wifiConfiguration);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiConfiguration$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public byte[] getBytesForBackup() throws IOException {
        return InvokeDynamicSupport.bootstrap("getBytesForBackup", $$robo$$android_net_wifi_WifiConfiguration$getBytesForBackup(), this);
    }

    public static WifiConfiguration getWifiConfigFromBackup(DataInputStream dataInputStream) throws IOException, BackupUtils.BadVersionException {
        return InvokeDynamicSupport.bootstrapStatic("getWifiConfigFromBackup", $$robo$$android_net_wifi_WifiConfiguration$getWifiConfigFromBackup(java.io.DataInputStream ), (DataInputStream)dataInputStream);
    }

    static {
        RobolectricInternals.classInitializing(WifiConfiguration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RecentFailure
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        public static int STATUS_AP_UNABLE_TO_HANDLE_NEW_STA = 17;
        private int mAssociationStatus;

        private void $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$__constructor__() {
            this.mAssociationStatus = 0;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$setAssociationStatus(int status) {
            this.mAssociationStatus = status;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$clear() {
            this.mAssociationStatus = 0;
        }

        private final int $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$getAssociationStatus() {
            return this.mAssociationStatus;
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_RecentFailure$__constructor__();
        }

        public RecentFailure() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$__constructor__(), this);
        }

        public void setAssociationStatus(int n) {
            InvokeDynamicSupport.bootstrap("setAssociationStatus", $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$setAssociationStatus(int ), this, n);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$clear(), this);
        }

        public int getAssociationStatus() {
            return (int)InvokeDynamicSupport.bootstrap("getAssociationStatus", $$robo$$android_net_wifi_WifiConfiguration_RecentFailure$getAssociationStatus(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecentFailure)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class NetworkSelectionStatus
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NETWORK_SELECTION_ENABLED = 0;
        public static int NETWORK_SELECTION_TEMPORARY_DISABLED = 1;
        public static int NETWORK_SELECTION_PERMANENTLY_DISABLED = 2;
        public static int NETWORK_SELECTION_STATUS_MAX = 3;
        public static String[] QUALITY_NETWORK_SELECTION_STATUS;
        public static int NETWORK_SELECTION_ENABLE = 0;
        public static int NETWORK_SELECTION_DISABLED_STARTING_INDEX = 1;
        public static int DISABLED_BAD_LINK = 1;
        public static int DISABLED_ASSOCIATION_REJECTION = 2;
        public static int DISABLED_AUTHENTICATION_FAILURE = 3;
        public static int DISABLED_DHCP_FAILURE = 4;
        public static int DISABLED_DNS_FAILURE = 5;
        public static int DISABLED_NO_INTERNET_TEMPORARY = 6;
        public static int DISABLED_WPS_START = 7;
        public static int DISABLED_TLS_VERSION_MISMATCH = 8;
        public static int DISABLED_AUTHENTICATION_NO_CREDENTIALS = 9;
        public static int DISABLED_NO_INTERNET_PERMANENT = 10;
        public static int DISABLED_BY_WIFI_MANAGER = 11;
        public static int DISABLED_DUE_TO_USER_SWITCH = 12;
        public static int DISABLED_BY_WRONG_PASSWORD = 13;
        public static int NETWORK_SELECTION_DISABLED_MAX = 14;
        public static String[] QUALITY_NETWORK_SELECTION_DISABLE_REASON;
        public static long INVALID_NETWORK_SELECTION_DISABLE_TIMESTAMP = -1L;
        private static int CONNECT_CHOICE_EXISTS = 1;
        private static int CONNECT_CHOICE_NOT_EXISTS = -1;
        private int mStatus;
        private int mNetworkSelectionDisableReason;
        private long mTemporarilyDisabledTimestamp;
        private int[] mNetworkSeclectionDisableCounter;
        private String mConnectChoice;
        private long mConnectChoiceTimestamp;
        private ScanResult mCandidate;
        private int mCandidateScore;
        private boolean mSeenInLastQualifiedNetworkSelection;
        private boolean mHasEverConnected;
        private boolean mNotRecommended;
        private String mNetworkSelectionBSSID;

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNotRecommended(boolean notRecommended) {
            this.mNotRecommended = notRecommended;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNotRecommended() {
            return this.mNotRecommended;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setSeenInLastQualifiedNetworkSelection(boolean seen) {
            this.mSeenInLastQualifiedNetworkSelection = seen;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getSeenInLastQualifiedNetworkSelection() {
            return this.mSeenInLastQualifiedNetworkSelection;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setCandidate(ScanResult scanCandidate) {
            this.mCandidate = scanCandidate;
        }

        private final ScanResult $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getCandidate() {
            return this.mCandidate;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setCandidateScore(int score) {
            this.mCandidateScore = score;
        }

        private final int $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getCandidateScore() {
            return this.mCandidateScore;
        }

        private final String $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getConnectChoice() {
            return this.mConnectChoice;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setConnectChoice(String newConnectChoice) {
            this.mConnectChoice = newConnectChoice;
        }

        private final long $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getConnectChoiceTimestamp() {
            return this.mConnectChoiceTimestamp;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setConnectChoiceTimestamp(long timeStamp) {
            this.mConnectChoiceTimestamp = timeStamp;
        }

        private final String $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkStatusString() {
            return QUALITY_NETWORK_SELECTION_STATUS[this.mStatus];
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setHasEverConnected(boolean value) {
            this.mHasEverConnected = value;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getHasEverConnected() {
            return this.mHasEverConnected;
        }

        private void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$__constructor__() {
            this.mTemporarilyDisabledTimestamp = -1L;
            this.mNetworkSeclectionDisableCounter = new int[14];
            this.mConnectChoiceTimestamp = -1L;
            this.mHasEverConnected = false;
        }

        private static final String $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkDisableReasonString(int reason) {
            if (reason >= 0 && reason < 14) {
                return QUALITY_NETWORK_SELECTION_DISABLE_REASON[reason];
            }
            return null;
        }

        private final String $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkDisableReasonString() {
            return QUALITY_NETWORK_SELECTION_DISABLE_REASON[this.mNetworkSelectionDisableReason];
        }

        private final int $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkSelectionStatus() {
            return this.mStatus;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNetworkEnabled() {
            return this.mStatus == 0;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNetworkTemporaryDisabled() {
            return this.mStatus == 1;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNetworkPermanentlyDisabled() {
            return this.mStatus == 2;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNetworkSelectionStatus(int status) {
            if (status >= 0 && status < 3) {
                this.mStatus = status;
            }
        }

        private final int $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkSelectionDisableReason() {
            return this.mNetworkSelectionDisableReason;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNetworkSelectionDisableReason(int reason) {
            if (reason < 0 || reason >= 14) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            this.mNetworkSelectionDisableReason = reason;
        }

        private final boolean $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isDisabledByReason(int reason) {
            return this.mNetworkSelectionDisableReason == reason;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setDisableTime(long timeStamp) {
            this.mTemporarilyDisabledTimestamp = timeStamp;
        }

        private final long $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getDisableTime() {
            return this.mTemporarilyDisabledTimestamp;
        }

        private final int $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getDisableReasonCounter(int reason) {
            if (reason >= 0 && reason < 14) {
                return this.mNetworkSeclectionDisableCounter[reason];
            }
            throw new IllegalArgumentException("Illegal reason value: " + reason);
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setDisableReasonCounter(int reason, int value) {
            if (reason < 0 || reason >= 14) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            this.mNetworkSeclectionDisableCounter[reason] = value;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$incrementDisableReasonCounter(int reason) {
            if (reason < 0 || reason >= 14) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            int n = reason;
            this.mNetworkSeclectionDisableCounter[n] = this.mNetworkSeclectionDisableCounter[n] + 1;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$clearDisableReasonCounter(int reason) {
            if (reason < 0 || reason >= 14) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            this.mNetworkSeclectionDisableCounter[reason] = 0;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$clearDisableReasonCounter() {
            Arrays.fill(this.mNetworkSeclectionDisableCounter, 0);
        }

        private final String $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkSelectionBSSID() {
            return this.mNetworkSelectionBSSID;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNetworkSelectionBSSID(String bssid) {
            this.mNetworkSelectionBSSID = bssid;
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$copy(NetworkSelectionStatus source) {
            this.mStatus = source.mStatus;
            this.mNetworkSelectionDisableReason = source.mNetworkSelectionDisableReason;
            for (int index = 0; index < 14; ++index) {
                this.mNetworkSeclectionDisableCounter[index] = source.mNetworkSeclectionDisableCounter[index];
            }
            this.mTemporarilyDisabledTimestamp = source.mTemporarilyDisabledTimestamp;
            this.mNetworkSelectionBSSID = source.mNetworkSelectionBSSID;
            this.setSeenInLastQualifiedNetworkSelection(source.getSeenInLastQualifiedNetworkSelection());
            this.setCandidate(source.getCandidate());
            this.setCandidateScore(source.getCandidateScore());
            this.setConnectChoice(source.getConnectChoice());
            this.setConnectChoiceTimestamp(source.getConnectChoiceTimestamp());
            this.setHasEverConnected(source.getHasEverConnected());
            this.setNotRecommended(source.isNotRecommended());
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$writeToParcel(Parcel dest) {
            dest.writeInt(this.getNetworkSelectionStatus());
            dest.writeInt(this.getNetworkSelectionDisableReason());
            for (int index = 0; index < 14; ++index) {
                dest.writeInt(this.getDisableReasonCounter(index));
            }
            dest.writeLong(this.getDisableTime());
            dest.writeString(this.getNetworkSelectionBSSID());
            if (this.getConnectChoice() != null) {
                dest.writeInt(1);
                dest.writeString(this.getConnectChoice());
                dest.writeLong(this.getConnectChoiceTimestamp());
            } else {
                dest.writeInt(-1);
            }
            dest.writeInt(this.getHasEverConnected() ? 1 : 0);
            dest.writeInt(this.isNotRecommended() ? 1 : 0);
        }

        private final void $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$readFromParcel(Parcel in) {
            this.setNetworkSelectionStatus(in.readInt());
            this.setNetworkSelectionDisableReason(in.readInt());
            for (int index = 0; index < 14; ++index) {
                this.setDisableReasonCounter(index, in.readInt());
            }
            this.setDisableTime(in.readLong());
            this.setNetworkSelectionBSSID(in.readString());
            if (in.readInt() == 1) {
                this.setConnectChoice(in.readString());
                this.setConnectChoiceTimestamp(in.readLong());
            } else {
                this.setConnectChoice(null);
                this.setConnectChoiceTimestamp(-1L);
            }
            this.setHasEverConnected(in.readInt() != 0);
            this.setNotRecommended(in.readInt() != 0);
        }

        static void __staticInitializer__() {
            QUALITY_NETWORK_SELECTION_STATUS = new String[]{"NETWORK_SELECTION_ENABLED", "NETWORK_SELECTION_TEMPORARY_DISABLED", "NETWORK_SELECTION_PERMANENTLY_DISABLED"};
            QUALITY_NETWORK_SELECTION_DISABLE_REASON = new String[]{"NETWORK_SELECTION_ENABLE", "NETWORK_SELECTION_DISABLED_BAD_LINK", "NETWORK_SELECTION_DISABLED_ASSOCIATION_REJECTION ", "NETWORK_SELECTION_DISABLED_AUTHENTICATION_FAILURE", "NETWORK_SELECTION_DISABLED_DHCP_FAILURE", "NETWORK_SELECTION_DISABLED_DNS_FAILURE", "NETWORK_SELECTION_DISABLED_NO_INTERNET_TEMPORARY", "NETWORK_SELECTION_DISABLED_WPS_START", "NETWORK_SELECTION_DISABLED_TLS_VERSION", "NETWORK_SELECTION_DISABLED_AUTHENTICATION_NO_CREDENTIALS", "NETWORK_SELECTION_DISABLED_NO_INTERNET_PERMANENT", "NETWORK_SELECTION_DISABLED_BY_WIFI_MANAGER", "NETWORK_SELECTION_DISABLED_BY_USER_SWITCH", "NETWORK_SELECTION_DISABLED_BY_WRONG_PASSWORD"};
        }

        public void setNotRecommended(boolean bl) {
            InvokeDynamicSupport.bootstrap("setNotRecommended", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNotRecommended(boolean ), this, bl);
        }

        public boolean isNotRecommended() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNotRecommended", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNotRecommended(), this);
        }

        public void setSeenInLastQualifiedNetworkSelection(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSeenInLastQualifiedNetworkSelection", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setSeenInLastQualifiedNetworkSelection(boolean ), this, bl);
        }

        public boolean getSeenInLastQualifiedNetworkSelection() {
            return (boolean)InvokeDynamicSupport.bootstrap("getSeenInLastQualifiedNetworkSelection", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getSeenInLastQualifiedNetworkSelection(), this);
        }

        public void setCandidate(ScanResult scanResult) {
            InvokeDynamicSupport.bootstrap("setCandidate", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setCandidate(android.net.wifi.ScanResult ), this, scanResult);
        }

        public ScanResult getCandidate() {
            return InvokeDynamicSupport.bootstrap("getCandidate", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getCandidate(), this);
        }

        public void setCandidateScore(int n) {
            InvokeDynamicSupport.bootstrap("setCandidateScore", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setCandidateScore(int ), this, n);
        }

        public int getCandidateScore() {
            return (int)InvokeDynamicSupport.bootstrap("getCandidateScore", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getCandidateScore(), this);
        }

        public String getConnectChoice() {
            return InvokeDynamicSupport.bootstrap("getConnectChoice", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getConnectChoice(), this);
        }

        public void setConnectChoice(String string2) {
            InvokeDynamicSupport.bootstrap("setConnectChoice", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setConnectChoice(java.lang.String ), this, string2);
        }

        public long getConnectChoiceTimestamp() {
            return (long)InvokeDynamicSupport.bootstrap("getConnectChoiceTimestamp", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getConnectChoiceTimestamp(), this);
        }

        public void setConnectChoiceTimestamp(long l) {
            InvokeDynamicSupport.bootstrap("setConnectChoiceTimestamp", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setConnectChoiceTimestamp(long ), this, l);
        }

        public String getNetworkStatusString() {
            return InvokeDynamicSupport.bootstrap("getNetworkStatusString", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkStatusString(), this);
        }

        public void setHasEverConnected(boolean bl) {
            InvokeDynamicSupport.bootstrap("setHasEverConnected", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setHasEverConnected(boolean ), this, bl);
        }

        public boolean getHasEverConnected() {
            return (boolean)InvokeDynamicSupport.bootstrap("getHasEverConnected", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getHasEverConnected(), this);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$__constructor__();
        }

        public NetworkSelectionStatus() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$__constructor__(), this);
        }

        public static String getNetworkDisableReasonString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getNetworkDisableReasonString", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkDisableReasonString(int ), (int)n);
        }

        public String getNetworkDisableReasonString() {
            return InvokeDynamicSupport.bootstrap("getNetworkDisableReasonString", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkDisableReasonString(), this);
        }

        public int getNetworkSelectionStatus() {
            return (int)InvokeDynamicSupport.bootstrap("getNetworkSelectionStatus", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkSelectionStatus(), this);
        }

        public boolean isNetworkEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNetworkEnabled", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNetworkEnabled(), this);
        }

        public boolean isNetworkTemporaryDisabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNetworkTemporaryDisabled", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNetworkTemporaryDisabled(), this);
        }

        public boolean isNetworkPermanentlyDisabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isNetworkPermanentlyDisabled", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isNetworkPermanentlyDisabled(), this);
        }

        public void setNetworkSelectionStatus(int n) {
            InvokeDynamicSupport.bootstrap("setNetworkSelectionStatus", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNetworkSelectionStatus(int ), this, n);
        }

        public int getNetworkSelectionDisableReason() {
            return (int)InvokeDynamicSupport.bootstrap("getNetworkSelectionDisableReason", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkSelectionDisableReason(), this);
        }

        public void setNetworkSelectionDisableReason(int n) {
            InvokeDynamicSupport.bootstrap("setNetworkSelectionDisableReason", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNetworkSelectionDisableReason(int ), this, n);
        }

        public boolean isDisabledByReason(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isDisabledByReason", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$isDisabledByReason(int ), this, n);
        }

        public void setDisableTime(long l) {
            InvokeDynamicSupport.bootstrap("setDisableTime", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setDisableTime(long ), this, l);
        }

        public long getDisableTime() {
            return (long)InvokeDynamicSupport.bootstrap("getDisableTime", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getDisableTime(), this);
        }

        public int getDisableReasonCounter(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getDisableReasonCounter", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getDisableReasonCounter(int ), this, n);
        }

        public void setDisableReasonCounter(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setDisableReasonCounter", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setDisableReasonCounter(int int ), this, n, n2);
        }

        public void incrementDisableReasonCounter(int n) {
            InvokeDynamicSupport.bootstrap("incrementDisableReasonCounter", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$incrementDisableReasonCounter(int ), this, n);
        }

        public void clearDisableReasonCounter(int n) {
            InvokeDynamicSupport.bootstrap("clearDisableReasonCounter", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$clearDisableReasonCounter(int ), this, n);
        }

        public void clearDisableReasonCounter() {
            InvokeDynamicSupport.bootstrap("clearDisableReasonCounter", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$clearDisableReasonCounter(), this);
        }

        public String getNetworkSelectionBSSID() {
            return InvokeDynamicSupport.bootstrap("getNetworkSelectionBSSID", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$getNetworkSelectionBSSID(), this);
        }

        public void setNetworkSelectionBSSID(String string2) {
            InvokeDynamicSupport.bootstrap("setNetworkSelectionBSSID", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$setNetworkSelectionBSSID(java.lang.String ), this, string2);
        }

        public void copy(NetworkSelectionStatus networkSelectionStatus) {
            InvokeDynamicSupport.bootstrap("copy", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$copy(android.net.wifi.WifiConfiguration$NetworkSelectionStatus ), this, networkSelectionStatus);
        }

        public void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$writeToParcel(android.os.Parcel ), this, parcel);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_net_wifi_WifiConfiguration_NetworkSelectionStatus$readFromParcel(android.os.Parcel ), this, parcel);
        }

        static {
            RobolectricInternals.classInitializing(NetworkSelectionStatus.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkSelectionStatus)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Status
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int CURRENT = 0;
        public static int DISABLED = 1;
        public static int ENABLED = 2;
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_Status$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"current", "disabled", "enabled"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_Status$__constructor__();
        }

        public Status() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_Status$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(Status.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Status)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GroupCipher
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public static int WEP40 = 0;
        @Deprecated
        public static int WEP104 = 1;
        public static int TKIP = 2;
        public static int CCMP = 3;
        public static int GTK_NOT_USED = 4;
        public static String varName = "group";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_GroupCipher$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"WEP40", "WEP104", "TKIP", "CCMP", "GTK_NOT_USED"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_GroupCipher$__constructor__();
        }

        public GroupCipher() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_GroupCipher$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(GroupCipher.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GroupCipher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PairwiseCipher
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        @Deprecated
        public static int TKIP = 1;
        public static int CCMP = 2;
        public static String varName = "pairwise";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_PairwiseCipher$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"NONE", "TKIP", "CCMP"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_PairwiseCipher$__constructor__();
        }

        public PairwiseCipher() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_PairwiseCipher$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(PairwiseCipher.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PairwiseCipher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AuthAlgorithm
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int OPEN = 0;
        @Deprecated
        public static int SHARED = 1;
        public static int LEAP = 2;
        public static String varName = "auth_alg";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_AuthAlgorithm$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"OPEN", "SHARED", "LEAP"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_AuthAlgorithm$__constructor__();
        }

        public AuthAlgorithm() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_AuthAlgorithm$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(AuthAlgorithm.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthAlgorithm)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Protocol
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        @Deprecated
        public static int WPA = 0;
        public static int RSN = 1;
        public static int OSEN = 2;
        public static String varName = "proto";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_Protocol$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"WPA", "RSN", "OSEN"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_Protocol$__constructor__();
        }

        public Protocol() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_Protocol$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(Protocol.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Protocol)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class KeyMgmt
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        public static int WPA_PSK = 1;
        public static int WPA_EAP = 2;
        public static int IEEE8021X = 3;
        @SystemApi
        public static int WPA2_PSK = 4;
        public static int OSEN = 5;
        public static int FT_PSK = 6;
        public static int FT_EAP = 7;
        public static String varName = "key_mgmt";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_KeyMgmt$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"NONE", "WPA_PSK", "WPA_EAP", "IEEE8021X", "WPA2_PSK", "OSEN", "FT_PSK", "FT_EAP"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_KeyMgmt$__constructor__();
        }

        public KeyMgmt() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_KeyMgmt$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(KeyMgmt.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyMgmt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

