/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.nsd.DnsSdTxtRecord;
import android.net.wifi.p2p.nsd.WifiP2pServiceInfo;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pDnsSdServiceInfo
extends WifiP2pServiceInfo
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int VERSION_1 = 1;
    public static int DNS_TYPE_PTR = 12;
    public static int DNS_TYPE_TXT = 16;
    private static Map<String, String> sVmPacket;

    private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$__constructor__(List<String> queryList) {
    }

    private static final WifiP2pDnsSdServiceInfo $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$newInstance(String instanceName, String serviceType, Map<String, String> txtMap) {
        if (TextUtils.isEmpty(instanceName) || TextUtils.isEmpty(serviceType)) {
            throw new IllegalArgumentException("instance name or service type cannot be empty");
        }
        DnsSdTxtRecord txtRecord = new DnsSdTxtRecord();
        if (txtMap != null) {
            for (String key : txtMap.keySet()) {
                txtRecord.set(key, txtMap.get(key));
            }
        }
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(WifiP2pDnsSdServiceInfo.createPtrServiceQuery(instanceName, serviceType));
        queries.add(WifiP2pDnsSdServiceInfo.createTxtServiceQuery(instanceName, serviceType, txtRecord));
        return new WifiP2pDnsSdServiceInfo(queries);
    }

    private static final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$createPtrServiceQuery(String instanceName, String serviceType) {
        StringBuffer sb = new StringBuffer();
        sb.append("bonjour ");
        sb.append(WifiP2pDnsSdServiceInfo.createRequest(serviceType + ".local.", 12, 1));
        sb.append(" ");
        byte[] data = instanceName.getBytes();
        sb.append(String.format(Locale.US, "%02x", data.length));
        sb.append(WifiP2pServiceInfo.bin2HexStr(data));
        sb.append("c027");
        return sb.toString();
    }

    private static final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$createTxtServiceQuery(String instanceName, String serviceType, DnsSdTxtRecord txtRecord) {
        StringBuffer sb = new StringBuffer();
        sb.append("bonjour ");
        sb.append(WifiP2pDnsSdServiceInfo.createRequest(instanceName + "." + serviceType + ".local.", 16, 1));
        sb.append(" ");
        byte[] rawData = txtRecord.getRawData();
        if (rawData.length == 0) {
            sb.append("00");
        } else {
            sb.append(WifiP2pDnsSdServiceInfo.bin2HexStr(rawData));
        }
        return sb.toString();
    }

    private static final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$createRequest(String dnsName, int dnsType, int version) {
        StringBuffer sb = new StringBuffer();
        if (dnsType == 16) {
            dnsName = dnsName.toLowerCase(Locale.ROOT);
        }
        sb.append(WifiP2pDnsSdServiceInfo.compressDnsName(dnsName));
        sb.append(String.format(Locale.US, "%04x", dnsType));
        sb.append(String.format(Locale.US, "%02x", version));
        return sb.toString();
    }

    private static final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$compressDnsName(String dnsName) {
        StringBuffer sb = new StringBuffer();
        while (true) {
            String data;
            if ((data = sVmPacket.get(dnsName)) != null) {
                sb.append(data);
                break;
            }
            int i = dnsName.indexOf(46);
            if (i == -1) {
                if (dnsName.length() > 0) {
                    sb.append(String.format(Locale.US, "%02x", dnsName.length()));
                    sb.append(WifiP2pServiceInfo.bin2HexStr(dnsName.getBytes()));
                }
                sb.append("00");
                break;
            }
            String name = dnsName.substring(0, i);
            dnsName = dnsName.substring(i + 1);
            sb.append(String.format(Locale.US, "%02x", name.length()));
            sb.append(WifiP2pServiceInfo.bin2HexStr(name.getBytes()));
        }
        return sb.toString();
    }

    static void __staticInitializer__() {
        sVmPacket = new HashMap<String, String>();
        sVmPacket.put("_tcp.local.", "c00c");
        sVmPacket.put("local.", "c011");
        sVmPacket.put("_udp.local.", "c01c");
    }

    private void __constructor__(List<String> list) {
        this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$__constructor__(list);
    }

    public WifiP2pDnsSdServiceInfo(List<String> list) {
        super(list);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$__constructor__(java.util.List<java.lang.String> ), this, list);
    }

    public static WifiP2pDnsSdServiceInfo newInstance(String string2, String string3, Map<String, String> map) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$newInstance(java.lang.String java.lang.String java.util.Map<java.lang.String, java.lang.String> ), (String)string2, (String)string3, map);
    }

    private static String createPtrServiceQuery(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createPtrServiceQuery", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$createPtrServiceQuery(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    private static String createTxtServiceQuery(String string2, String string3, DnsSdTxtRecord dnsSdTxtRecord) {
        return InvokeDynamicSupport.bootstrapStatic("createTxtServiceQuery", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$createTxtServiceQuery(java.lang.String java.lang.String android.net.nsd.DnsSdTxtRecord ), (String)string2, (String)string3, (DnsSdTxtRecord)dnsSdTxtRecord);
    }

    static String createRequest(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createRequest", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$createRequest(java.lang.String int int ), (String)string2, (int)n, (int)n2);
    }

    private static String compressDnsName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("compressDnsName", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceInfo$compressDnsName(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pDnsSdServiceInfo.class);
    }

    public /* synthetic */ WifiP2pDnsSdServiceInfo() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pDnsSdServiceInfo)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

