/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.nsd.WifiP2pServiceResponse;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pDnsSdServiceResponse
extends WifiP2pServiceResponse
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mDnsQueryName;
    private String mInstanceName;
    private int mDnsType;
    private int mVersion;
    private HashMap<String, String> mTxtRecord;
    private static Map<Integer, String> sVmpack;

    private final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getDnsQueryName() {
        return this.mDnsQueryName;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getDnsType() {
        return this.mDnsType;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getVersion() {
        return this.mVersion;
    }

    private final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getInstanceName() {
        return this.mInstanceName;
    }

    private final Map<String, String> $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getTxtRecord() {
        return this.mTxtRecord;
    }

    private final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("serviceType:DnsSd(").append(this.mServiceType).append(")");
        sbuf.append(" status:").append(WifiP2pServiceResponse.Status.toString(this.mStatus));
        sbuf.append(" srcAddr:").append(this.mDevice.deviceAddress);
        sbuf.append(" version:").append(String.format("%02x", this.mVersion));
        sbuf.append(" dnsName:").append(this.mDnsQueryName);
        sbuf.append(" TxtRecord:");
        for (String key : this.mTxtRecord.keySet()) {
            sbuf.append(" key:").append(key).append(" value:").append(this.mTxtRecord.get(key));
        }
        if (this.mInstanceName != null) {
            sbuf.append(" InsName:").append(this.mInstanceName);
        }
        return sbuf.toString();
    }

    private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$__constructor__(int status, int tranId, WifiP2pDevice dev, byte[] data) {
        this.mTxtRecord = new HashMap();
        if (!this.parse()) {
            throw new IllegalArgumentException("Malformed bonjour service response");
        }
    }

    private final boolean $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$parse() {
        String rData;
        if (this.mData == null) {
            return true;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.mData));
        this.mDnsQueryName = this.readDnsName(dis);
        if (this.mDnsQueryName == null) {
            return false;
        }
        try {
            this.mDnsType = dis.readUnsignedShort();
            this.mVersion = dis.readUnsignedByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.mDnsType == 12) {
            rData = this.readDnsName(dis);
            if (rData == null) {
                return false;
            }
            if (rData.length() <= this.mDnsQueryName.length()) {
                return false;
            }
        } else {
            if (this.mDnsType == 16) {
                return this.readTxtData(dis);
            }
            return false;
        }
        this.mInstanceName = rData.substring(0, rData.length() - this.mDnsQueryName.length() - 1);
        return true;
    }

    private final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$readDnsName(DataInputStream dis) {
        StringBuffer sb = new StringBuffer();
        HashMap<Integer, String> vmpack = new HashMap<Integer, String>(sVmpack);
        if (this.mDnsQueryName != null) {
            vmpack.put(39, this.mDnsQueryName);
        }
        try {
            while (true) {
                int i;
                if ((i = dis.readUnsignedByte()) == 0) {
                    return sb.toString();
                }
                if (i == 192) {
                    String ref = vmpack.get(dis.readUnsignedByte());
                    if (ref == null) {
                        return null;
                    }
                    sb.append(ref);
                    return sb.toString();
                }
                byte[] data = new byte[i];
                dis.readFully(data);
                sb.append(new String(data));
                sb.append(".");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final boolean $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$readTxtData(DataInputStream dis) {
        try {
            int len;
            while (dis.available() > 0 && (len = dis.readUnsignedByte()) != 0) {
                byte[] data = new byte[len];
                dis.readFully(data);
                String[] keyVal = new String(data).split("=");
                if (keyVal.length != 2) {
                    return false;
                }
                this.mTxtRecord.put(keyVal[0], keyVal[1]);
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static final WifiP2pDnsSdServiceResponse $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$newInstance(int status, int transId, WifiP2pDevice dev, byte[] data) {
        if (status != 0) {
            return new WifiP2pDnsSdServiceResponse(status, transId, dev, null);
        }
        try {
            return new WifiP2pDnsSdServiceResponse(status, transId, dev, data);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }

    static void __staticInitializer__() {
        sVmpack = new HashMap<Integer, String>();
        sVmpack.put(12, "_tcp.local.");
        sVmpack.put(17, "local.");
        sVmpack.put(28, "_udp.local.");
    }

    public String getDnsQueryName() {
        return InvokeDynamicSupport.bootstrap("getDnsQueryName", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getDnsQueryName(), this);
    }

    public int getDnsType() {
        return (int)InvokeDynamicSupport.bootstrap("getDnsType", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getDnsType(), this);
    }

    public int getVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getVersion", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getVersion(), this);
    }

    public String getInstanceName() {
        return InvokeDynamicSupport.bootstrap("getInstanceName", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getInstanceName(), this);
    }

    public Map<String, String> getTxtRecord() {
        return InvokeDynamicSupport.bootstrap("getTxtRecord", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$getTxtRecord(), this);
    }

    @Override
    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$toString(), this);
    }

    private void __constructor__(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$__constructor__(n, n2, wifiP2pDevice, byArray);
    }

    public WifiP2pDnsSdServiceResponse(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        super(1, n, n2, wifiP2pDevice, byArray);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$__constructor__(int int android.net.wifi.p2p.WifiP2pDevice byte[] ), this, n, n2, wifiP2pDevice, byArray);
    }

    private boolean parse() {
        return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$parse(), this);
    }

    private String readDnsName(DataInputStream dataInputStream) {
        return InvokeDynamicSupport.bootstrap("readDnsName", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$readDnsName(java.io.DataInputStream ), this, dataInputStream);
    }

    private boolean readTxtData(DataInputStream dataInputStream) {
        return (boolean)InvokeDynamicSupport.bootstrap("readTxtData", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$readTxtData(java.io.DataInputStream ), this, dataInputStream);
    }

    static WifiP2pDnsSdServiceResponse newInstance(int n, int n2, WifiP2pDevice wifiP2pDevice, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_wifi_p2p_nsd_WifiP2pDnsSdServiceResponse$newInstance(int int android.net.wifi.p2p.WifiP2pDevice byte[] ), (int)n, (int)n2, (WifiP2pDevice)wifiP2pDevice, (byte[])byArray);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pDnsSdServiceResponse.class);
    }

    public /* synthetic */ WifiP2pDnsSdServiceResponse() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pDnsSdServiceResponse)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

