/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.aware.PeerHandle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RangingResult
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "RangingResult";
    private static byte[] EMPTY_BYTE_ARRAY;
    public static int STATUS_SUCCESS = 0;
    public static int STATUS_FAIL = 1;
    public static int STATUS_RESPONDER_DOES_NOT_SUPPORT_IEEE80211MC = 2;
    private int mStatus;
    private MacAddress mMac;
    private PeerHandle mPeerHandle;
    private int mDistanceMm;
    private int mDistanceStdDevMm;
    private int mRssi;
    private int mNumAttemptedMeasurements;
    private int mNumSuccessfulMeasurements;
    private byte[] mLci;
    private byte[] mLcr;
    private long mTimestamp;
    public static Parcelable.Creator<RangingResult> CREATOR;

    private void $$robo$$android_net_wifi_rtt_RangingResult$__constructor__(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, long timestamp) {
        this.mStatus = status;
        this.mMac = mac;
        this.mPeerHandle = null;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mNumAttemptedMeasurements = numAttemptedMeasurements;
        this.mNumSuccessfulMeasurements = numSuccessfulMeasurements;
        this.mLci = lci == null ? EMPTY_BYTE_ARRAY : lci;
        this.mLcr = lcr == null ? EMPTY_BYTE_ARRAY : lcr;
        this.mTimestamp = timestamp;
    }

    private void $$robo$$android_net_wifi_rtt_RangingResult$__constructor__(int status, PeerHandle peerHandle, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, long timestamp) {
        this.mStatus = status;
        this.mMac = null;
        this.mPeerHandle = peerHandle;
        this.mDistanceMm = distanceMm;
        this.mDistanceStdDevMm = distanceStdDevMm;
        this.mRssi = rssi;
        this.mNumAttemptedMeasurements = numAttemptedMeasurements;
        this.mNumSuccessfulMeasurements = numSuccessfulMeasurements;
        this.mLci = lci == null ? EMPTY_BYTE_ARRAY : lci;
        this.mLcr = lcr == null ? EMPTY_BYTE_ARRAY : lcr;
        this.mTimestamp = timestamp;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$getStatus() {
        return this.mStatus;
    }

    private final MacAddress $$robo$$android_net_wifi_rtt_RangingResult$getMacAddress() {
        return this.mMac;
    }

    private final PeerHandle $$robo$$android_net_wifi_rtt_RangingResult$getPeerHandle() {
        return this.mPeerHandle;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$getDistanceMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceMm;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$getDistanceStdDevMm() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getDistanceStdDevMm(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mDistanceStdDevMm;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$getRssi() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRssi(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mRssi;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$getNumAttemptedMeasurements() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getNumAttemptedMeasurements(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mNumAttemptedMeasurements;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$getNumSuccessfulMeasurements() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getNumSuccessfulMeasurements(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mNumSuccessfulMeasurements;
    }

    @SystemApi
    private final byte[] $$robo$$android_net_wifi_rtt_RangingResult$getLci() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getLci(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLci;
    }

    @SystemApi
    private final byte[] $$robo$$android_net_wifi_rtt_RangingResult$getLcr() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getReportedLocationCivic(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mLcr;
    }

    private final long $$robo$$android_net_wifi_rtt_RangingResult$getRangingTimestampMillis() {
        if (this.mStatus != 0) {
            throw new IllegalStateException("getRangingTimestampMillis(): invoked on an invalid result: getStatus()=" + this.mStatus);
        }
        return this.mTimestamp;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_rtt_RangingResult$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mStatus);
        if (this.mMac == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.mMac.writeToParcel(dest, flags);
        }
        if (this.mPeerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.mPeerHandle.peerId);
        }
        dest.writeInt(this.mDistanceMm);
        dest.writeInt(this.mDistanceStdDevMm);
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mNumAttemptedMeasurements);
        dest.writeInt(this.mNumSuccessfulMeasurements);
        dest.writeByteArray(this.mLci);
        dest.writeByteArray(this.mLcr);
        dest.writeLong(this.mTimestamp);
    }

    private final String $$robo$$android_net_wifi_rtt_RangingResult$toString() {
        return "RangingResult: [status=" + this.mStatus + ", mac=" + this.mMac + ", peerHandle=" + (this.mPeerHandle == null ? "<null>" : Integer.valueOf(this.mPeerHandle.peerId)) + ", distanceMm=" + this.mDistanceMm + ", distanceStdDevMm=" + this.mDistanceStdDevMm + ", rssi=" + this.mRssi + ", numAttemptedMeasurements=" + this.mNumAttemptedMeasurements + ", numSuccessfulMeasurements=" + this.mNumSuccessfulMeasurements + ", lci=" + this.mLci + ", lcr=" + this.mLcr + ", timestamp=" + this.mTimestamp + "]";
    }

    private final boolean $$robo$$android_net_wifi_rtt_RangingResult$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangingResult)) {
            return false;
        }
        RangingResult lhs = (RangingResult)o;
        return this.mStatus == lhs.mStatus && Objects.equals(this.mMac, lhs.mMac) && Objects.equals(this.mPeerHandle, lhs.mPeerHandle) && this.mDistanceMm == lhs.mDistanceMm && this.mDistanceStdDevMm == lhs.mDistanceStdDevMm && this.mRssi == lhs.mRssi && this.mNumAttemptedMeasurements == lhs.mNumAttemptedMeasurements && this.mNumSuccessfulMeasurements == lhs.mNumSuccessfulMeasurements && Arrays.equals(this.mLci, lhs.mLci) && Arrays.equals(this.mLcr, lhs.mLcr) && this.mTimestamp == lhs.mTimestamp;
    }

    private final int $$robo$$android_net_wifi_rtt_RangingResult$hashCode() {
        return Objects.hash(this.mStatus, this.mMac, this.mPeerHandle, this.mDistanceMm, this.mDistanceStdDevMm, this.mRssi, this.mNumAttemptedMeasurements, this.mNumSuccessfulMeasurements, this.mLci, this.mLcr, this.mTimestamp);
    }

    static void __staticInitializer__() {
        EMPTY_BYTE_ARRAY = new byte[0];
        CREATOR = new Parcelable.Creator<RangingResult>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_rtt_RangingResult_1$__constructor__() {
            }

            private final RangingResult[] $$robo$$android_net_wifi_rtt_RangingResult_1$newArray(int size) {
                return new RangingResult[size];
            }

            private final RangingResult $$robo$$android_net_wifi_rtt_RangingResult_1$createFromParcel(Parcel in) {
                int status = in.readInt();
                boolean macAddressPresent = in.readBoolean();
                MacAddress mac = null;
                if (macAddressPresent) {
                    mac = MacAddress.CREATOR.createFromParcel(in);
                }
                boolean peerHandlePresent = in.readBoolean();
                PeerHandle peerHandle = null;
                if (peerHandlePresent) {
                    peerHandle = new PeerHandle(in.readInt());
                }
                int distanceMm = in.readInt();
                int distanceStdDevMm = in.readInt();
                int rssi = in.readInt();
                int numAttemptedMeasurements = in.readInt();
                int numSuccessfulMeasurements = in.readInt();
                byte[] lci = in.createByteArray();
                byte[] lcr = in.createByteArray();
                long timestamp = in.readLong();
                if (peerHandlePresent) {
                    return new RangingResult(status, peerHandle, distanceMm, distanceStdDevMm, rssi, numAttemptedMeasurements, numSuccessfulMeasurements, lci, lcr, timestamp);
                }
                return new RangingResult(status, mac, distanceMm, distanceStdDevMm, rssi, numAttemptedMeasurements, numSuccessfulMeasurements, lci, lcr, timestamp);
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_rtt_RangingResult_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_RangingResult_1$__constructor__(), this);
            }

            public RangingResult[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_rtt_RangingResult_1$newArray(int ), this, n);
            }

            @Override
            public RangingResult createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_rtt_RangingResult_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, MacAddress macAddress, int n2, int n3, int n4, int n5, int n6, byte[] byArray, byte[] byArray2, long l) {
        this.$$robo$$android_net_wifi_rtt_RangingResult$__constructor__(n, macAddress, n2, n3, n4, n5, n6, byArray, byArray2, l);
    }

    public RangingResult(int n, MacAddress macAddress, int n2, int n3, int n4, int n5, int n6, byte[] byArray, byte[] byArray2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_RangingResult$__constructor__(int android.net.MacAddress int int int int int byte[] byte[] long ), this, n, macAddress, n2, n3, n4, n5, n6, byArray, byArray2, l);
    }

    private void __constructor__(int n, PeerHandle peerHandle, int n2, int n3, int n4, int n5, int n6, byte[] byArray, byte[] byArray2, long l) {
        this.$$robo$$android_net_wifi_rtt_RangingResult$__constructor__(n, peerHandle, n2, n3, n4, n5, n6, byArray, byArray2, l);
    }

    public RangingResult(int n, PeerHandle peerHandle, int n2, int n3, int n4, int n5, int n6, byte[] byArray, byte[] byArray2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_RangingResult$__constructor__(int android.net.wifi.aware.PeerHandle int int int int int byte[] byte[] long ), this, n, peerHandle, n2, n3, n4, n5, n6, byArray, byArray2, l);
    }

    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_net_wifi_rtt_RangingResult$getStatus(), this);
    }

    public MacAddress getMacAddress() {
        return InvokeDynamicSupport.bootstrap("getMacAddress", $$robo$$android_net_wifi_rtt_RangingResult$getMacAddress(), this);
    }

    public PeerHandle getPeerHandle() {
        return InvokeDynamicSupport.bootstrap("getPeerHandle", $$robo$$android_net_wifi_rtt_RangingResult$getPeerHandle(), this);
    }

    public int getDistanceMm() {
        return (int)InvokeDynamicSupport.bootstrap("getDistanceMm", $$robo$$android_net_wifi_rtt_RangingResult$getDistanceMm(), this);
    }

    public int getDistanceStdDevMm() {
        return (int)InvokeDynamicSupport.bootstrap("getDistanceStdDevMm", $$robo$$android_net_wifi_rtt_RangingResult$getDistanceStdDevMm(), this);
    }

    public int getRssi() {
        return (int)InvokeDynamicSupport.bootstrap("getRssi", $$robo$$android_net_wifi_rtt_RangingResult$getRssi(), this);
    }

    public int getNumAttemptedMeasurements() {
        return (int)InvokeDynamicSupport.bootstrap("getNumAttemptedMeasurements", $$robo$$android_net_wifi_rtt_RangingResult$getNumAttemptedMeasurements(), this);
    }

    public int getNumSuccessfulMeasurements() {
        return (int)InvokeDynamicSupport.bootstrap("getNumSuccessfulMeasurements", $$robo$$android_net_wifi_rtt_RangingResult$getNumSuccessfulMeasurements(), this);
    }

    @SystemApi
    public byte[] getLci() {
        return InvokeDynamicSupport.bootstrap("getLci", $$robo$$android_net_wifi_rtt_RangingResult$getLci(), this);
    }

    @SystemApi
    public byte[] getLcr() {
        return InvokeDynamicSupport.bootstrap("getLcr", $$robo$$android_net_wifi_rtt_RangingResult$getLcr(), this);
    }

    public long getRangingTimestampMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getRangingTimestampMillis", $$robo$$android_net_wifi_rtt_RangingResult$getRangingTimestampMillis(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_rtt_RangingResult$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_rtt_RangingResult$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_rtt_RangingResult$toString(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_rtt_RangingResult$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_rtt_RangingResult$hashCode(), this);
    }

    static {
        RobolectricInternals.classInitializing(RangingResult.class);
    }

    public /* synthetic */ RangingResult() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RangingResult)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RangeResultStatus {
    }
}

