/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.ScanResult;
import android.net.wifi.aware.PeerHandle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ResponderConfig
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ResponderConfig";
    private static int AWARE_BAND_2_DISCOVERY_CHANNEL = 2437;
    public static int RESPONDER_AP = 0;
    public static int RESPONDER_STA = 1;
    public static int RESPONDER_P2P_GO = 2;
    public static int RESPONDER_P2P_CLIENT = 3;
    public static int RESPONDER_AWARE = 4;
    public static int CHANNEL_WIDTH_20MHZ = 0;
    public static int CHANNEL_WIDTH_40MHZ = 1;
    public static int CHANNEL_WIDTH_80MHZ = 2;
    public static int CHANNEL_WIDTH_160MHZ = 3;
    public static int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4;
    public static int PREAMBLE_LEGACY = 0;
    public static int PREAMBLE_HT = 1;
    public static int PREAMBLE_VHT = 2;
    public MacAddress macAddress;
    public PeerHandle peerHandle;
    public int responderType;
    public boolean supports80211mc;
    public int channelWidth;
    public int frequency;
    public int centerFreq0;
    public int centerFreq1;
    public int preamble;
    public static Parcelable.Creator<ResponderConfig> CREATOR;

    private void $$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(MacAddress macAddress, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        if (macAddress == null) {
            throw new IllegalArgumentException("Invalid ResponderConfig - must specify a MAC address");
        }
        this.macAddress = macAddress;
        this.peerHandle = null;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
    }

    private void $$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        this.macAddress = null;
        this.peerHandle = peerHandle;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
    }

    private void $$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(MacAddress macAddress, PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        this.macAddress = macAddress;
        this.peerHandle = peerHandle;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
    }

    private static final ResponderConfig $$robo$$android_net_wifi_rtt_ResponderConfig$fromScanResult(ScanResult scanResult) {
        int preamble;
        MacAddress macAddress = MacAddress.fromString(scanResult.BSSID);
        int responderType = 0;
        boolean supports80211mc = scanResult.is80211mcResponder();
        int channelWidth = ResponderConfig.translateScanResultChannelWidth(scanResult.channelWidth);
        int frequency = scanResult.frequency;
        int centerFreq0 = scanResult.centerFreq0;
        int centerFreq1 = scanResult.centerFreq1;
        if (scanResult.informationElements != null && scanResult.informationElements.length != 0) {
            boolean htCapabilitiesPresent = false;
            boolean vhtCapabilitiesPresent = false;
            for (ScanResult.InformationElement ie : scanResult.informationElements) {
                if (ie.id == 45) {
                    htCapabilitiesPresent = true;
                    continue;
                }
                if (ie.id != 191) continue;
                vhtCapabilitiesPresent = true;
            }
            preamble = vhtCapabilitiesPresent ? 2 : (htCapabilitiesPresent ? 1 : 0);
        } else {
            Log.e("ResponderConfig", "Scan Results do not contain IEs - using backup method to select preamble");
            preamble = channelWidth == 2 || channelWidth == 3 ? 2 : 1;
        }
        return new ResponderConfig(macAddress, responderType, supports80211mc, channelWidth, frequency, centerFreq0, centerFreq1, preamble);
    }

    private static final ResponderConfig $$robo$$android_net_wifi_rtt_ResponderConfig$fromWifiAwarePeerMacAddressWithDefaults(MacAddress macAddress) {
        return new ResponderConfig(macAddress, 4, true, 0, 2437, 0, 0, 1);
    }

    private static final ResponderConfig $$robo$$android_net_wifi_rtt_ResponderConfig$fromWifiAwarePeerHandleWithDefaults(PeerHandle peerHandle) {
        return new ResponderConfig(peerHandle, 4, true, 0, 2437, 0, 0, 1);
    }

    private final boolean $$robo$$android_net_wifi_rtt_ResponderConfig$isValid(boolean awareSupported) {
        if (this.macAddress == null && this.peerHandle == null || this.macAddress != null && this.peerHandle != null) {
            return false;
        }
        return awareSupported || this.responderType != 4;
    }

    private final int $$robo$$android_net_wifi_rtt_ResponderConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_rtt_ResponderConfig$writeToParcel(Parcel dest, int flags) {
        if (this.macAddress == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.macAddress.writeToParcel(dest, flags);
        }
        if (this.peerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.peerHandle.peerId);
        }
        dest.writeInt(this.responderType);
        dest.writeInt(this.supports80211mc ? 1 : 0);
        dest.writeInt(this.channelWidth);
        dest.writeInt(this.frequency);
        dest.writeInt(this.centerFreq0);
        dest.writeInt(this.centerFreq1);
        dest.writeInt(this.preamble);
    }

    private final boolean $$robo$$android_net_wifi_rtt_ResponderConfig$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponderConfig)) {
            return false;
        }
        ResponderConfig lhs = (ResponderConfig)o;
        return Objects.equals(this.macAddress, lhs.macAddress) && Objects.equals(this.peerHandle, lhs.peerHandle) && this.responderType == lhs.responderType && this.supports80211mc == lhs.supports80211mc && this.channelWidth == lhs.channelWidth && this.frequency == lhs.frequency && this.centerFreq0 == lhs.centerFreq0 && this.centerFreq1 == lhs.centerFreq1 && this.preamble == lhs.preamble;
    }

    private final int $$robo$$android_net_wifi_rtt_ResponderConfig$hashCode() {
        return Objects.hash(this.macAddress, this.peerHandle, this.responderType, this.supports80211mc, this.channelWidth, this.frequency, this.centerFreq0, this.centerFreq1, this.preamble);
    }

    private final String $$robo$$android_net_wifi_rtt_ResponderConfig$toString() {
        return new StringBuffer("ResponderConfig: macAddress=").append(this.macAddress).append(", peerHandle=").append(this.peerHandle == null ? "<null>" : Integer.valueOf(this.peerHandle.peerId)).append(", responderType=").append(this.responderType).append(", supports80211mc=").append(this.supports80211mc).append(", channelWidth=").append(this.channelWidth).append(", frequency=").append(this.frequency).append(", centerFreq0=").append(this.centerFreq0).append(", centerFreq1=").append(this.centerFreq1).append(", preamble=").append(this.preamble).toString();
    }

    private static final int $$robo$$android_net_wifi_rtt_ResponderConfig$translateScanResultChannelWidth(int scanResultChannelWidth) {
        switch (scanResultChannelWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("translateScanResultChannelWidth: bad " + scanResultChannelWidth);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ResponderConfig>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_rtt_ResponderConfig_1$__constructor__() {
            }

            private final ResponderConfig[] $$robo$$android_net_wifi_rtt_ResponderConfig_1$newArray(int size) {
                return new ResponderConfig[size];
            }

            private final ResponderConfig $$robo$$android_net_wifi_rtt_ResponderConfig_1$createFromParcel(Parcel in) {
                boolean macAddressPresent = in.readBoolean();
                MacAddress macAddress = null;
                if (macAddressPresent) {
                    macAddress = MacAddress.CREATOR.createFromParcel(in);
                }
                boolean peerHandlePresent = in.readBoolean();
                PeerHandle peerHandle = null;
                if (peerHandlePresent) {
                    peerHandle = new PeerHandle(in.readInt());
                }
                int responderType = in.readInt();
                boolean supports80211mc = in.readInt() == 1;
                int channelWidth = in.readInt();
                int frequency = in.readInt();
                int centerFreq0 = in.readInt();
                int centerFreq1 = in.readInt();
                int preamble = in.readInt();
                if (peerHandle == null) {
                    return new ResponderConfig(macAddress, responderType, supports80211mc, channelWidth, frequency, centerFreq0, centerFreq1, preamble);
                }
                return new ResponderConfig(peerHandle, responderType, supports80211mc, channelWidth, frequency, centerFreq0, centerFreq1, preamble);
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_rtt_ResponderConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_ResponderConfig_1$__constructor__(), this);
            }

            public ResponderConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_rtt_ResponderConfig_1$newArray(int ), this, n);
            }

            @Override
            public ResponderConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_rtt_ResponderConfig_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(MacAddress macAddress, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(macAddress, n, bl, n2, n3, n4, n5, n6);
    }

    public ResponderConfig(MacAddress macAddress, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(android.net.MacAddress int boolean int int int int int ), this, macAddress, n, bl, n2, n3, n4, n5, n6);
    }

    private void __constructor__(PeerHandle peerHandle, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(peerHandle, n, bl, n2, n3, n4, n5, n6);
    }

    public ResponderConfig(PeerHandle peerHandle, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(android.net.wifi.aware.PeerHandle int boolean int int int int int ), this, peerHandle, n, bl, n2, n3, n4, n5, n6);
    }

    private void __constructor__(MacAddress macAddress, PeerHandle peerHandle, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(macAddress, peerHandle, n, bl, n2, n3, n4, n5, n6);
    }

    public ResponderConfig(MacAddress macAddress, PeerHandle peerHandle, int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_rtt_ResponderConfig$__constructor__(android.net.MacAddress android.net.wifi.aware.PeerHandle int boolean int int int int int ), this, macAddress, peerHandle, n, bl, n2, n3, n4, n5, n6);
    }

    public static ResponderConfig fromScanResult(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrapStatic("fromScanResult", $$robo$$android_net_wifi_rtt_ResponderConfig$fromScanResult(android.net.wifi.ScanResult ), (ScanResult)scanResult);
    }

    public static ResponderConfig fromWifiAwarePeerMacAddressWithDefaults(MacAddress macAddress) {
        return InvokeDynamicSupport.bootstrapStatic("fromWifiAwarePeerMacAddressWithDefaults", $$robo$$android_net_wifi_rtt_ResponderConfig$fromWifiAwarePeerMacAddressWithDefaults(android.net.MacAddress ), (MacAddress)macAddress);
    }

    public static ResponderConfig fromWifiAwarePeerHandleWithDefaults(PeerHandle peerHandle) {
        return InvokeDynamicSupport.bootstrapStatic("fromWifiAwarePeerHandleWithDefaults", $$robo$$android_net_wifi_rtt_ResponderConfig$fromWifiAwarePeerHandleWithDefaults(android.net.wifi.aware.PeerHandle ), (PeerHandle)peerHandle);
    }

    public boolean isValid(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_net_wifi_rtt_ResponderConfig$isValid(boolean ), this, bl);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_rtt_ResponderConfig$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_rtt_ResponderConfig$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_rtt_ResponderConfig$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_rtt_ResponderConfig$hashCode(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_rtt_ResponderConfig$toString(), this);
    }

    static int translateScanResultChannelWidth(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("translateScanResultChannelWidth", $$robo$$android_net_wifi_rtt_ResponderConfig$translateScanResultChannelWidth(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(ResponderConfig.class);
    }

    public /* synthetic */ ResponderConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResponderConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreambleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelWidth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResponderType {
    }
}

