/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.app.Activity;
import android.app.ActivityThread;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.nfc.INfcCardEmulation;
import android.nfc.NfcAdapter;
import android.nfc.cardemulation.AidGroup;
import android.nfc.cardemulation.ApduServiceInfo;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CardEmulation
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "CardEmulation";
    public static String ACTION_CHANGE_DEFAULT = "android.nfc.cardemulation.action.ACTION_CHANGE_DEFAULT";
    public static String EXTRA_CATEGORY = "category";
    public static String EXTRA_SERVICE_COMPONENT = "component";
    public static String CATEGORY_PAYMENT = "payment";
    public static String CATEGORY_OTHER = "other";
    public static int SELECTION_MODE_PREFER_DEFAULT = 0;
    public static int SELECTION_MODE_ALWAYS_ASK = 1;
    public static int SELECTION_MODE_ASK_IF_CONFLICT = 2;
    static boolean sIsInitialized;
    static HashMap<Context, CardEmulation> sCardEmus;
    static INfcCardEmulation sService;
    Context mContext;

    private void $$robo$$android_nfc_cardemulation_CardEmulation$__constructor__(Context context, INfcCardEmulation service) {
        this.mContext = context.getApplicationContext();
        sService = service;
    }

    private static final synchronized CardEmulation $$robo$$android_nfc_cardemulation_CardEmulation$getInstance(NfcAdapter adapter) {
        CardEmulation manager;
        if (adapter == null) {
            throw new NullPointerException("NfcAdapter is null");
        }
        Context context = adapter.getContext();
        if (context == null) {
            Log.e("CardEmulation", "NfcAdapter context is null.");
            throw new UnsupportedOperationException();
        }
        if (!sIsInitialized) {
            IPackageManager pm = ActivityThread.getPackageManager();
            if (pm == null) {
                Log.e("CardEmulation", "Cannot get PackageManager");
                throw new UnsupportedOperationException();
            }
            try {
                if (!pm.hasSystemFeature("android.hardware.nfc.hce", 0)) {
                    Log.e("CardEmulation", "This device does not support card emulation");
                    throw new UnsupportedOperationException();
                }
            }
            catch (RemoteException e) {
                Log.e("CardEmulation", "PackageManager query failed.");
                throw new UnsupportedOperationException();
            }
            sIsInitialized = true;
        }
        if ((manager = sCardEmus.get(context)) == null) {
            INfcCardEmulation service = adapter.getCardEmulationService();
            if (service == null) {
                Log.e("CardEmulation", "This device does not implement the INfcCardEmulation interface.");
                throw new UnsupportedOperationException();
            }
            manager = new CardEmulation(context, service);
            sCardEmus.put(context, manager);
        }
        return manager;
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$isDefaultServiceForCategory(ComponentName service, String category) {
        try {
            return sService.isDefaultServiceForCategory(this.mContext.getUserId(), service, category);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.isDefaultServiceForCategory(this.mContext.getUserId(), service, category);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$isDefaultServiceForAid(ComponentName service, String aid) {
        try {
            return sService.isDefaultServiceForAid(this.mContext.getUserId(), service, aid);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.isDefaultServiceForAid(this.mContext.getUserId(), service, aid);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$categoryAllowsForegroundPreference(String category) {
        if ("payment".equals(category)) {
            boolean preferForeground = false;
            try {
                preferForeground = Settings.Secure.getInt(this.mContext.getContentResolver(), "nfc_payment_foreground") != 0;
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                // empty catch block
            }
            return preferForeground;
        }
        return true;
    }

    private final int $$robo$$android_nfc_cardemulation_CardEmulation$getSelectionModeForCategory(String category) {
        if ("payment".equals(category)) {
            String defaultComponent = Settings.Secure.getString(this.mContext.getContentResolver(), "nfc_payment_default_component");
            if (defaultComponent != null) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$registerAidsForService(ComponentName service, String category, List<String> aids) {
        AidGroup aidGroup = new AidGroup(aids, category);
        try {
            return sService.registerAidGroupForService(this.mContext.getUserId(), service, aidGroup);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.registerAidGroupForService(this.mContext.getUserId(), service, aidGroup);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final List<String> $$robo$$android_nfc_cardemulation_CardEmulation$getAidsForService(ComponentName service, String category) {
        try {
            AidGroup group = sService.getAidGroupForService(this.mContext.getUserId(), service, category);
            return group != null ? group.getAids() : null;
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                AidGroup group = sService.getAidGroupForService(this.mContext.getUserId(), service, category);
                return group != null ? group.getAids() : null;
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return null;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$removeAidsForService(ComponentName service, String category) {
        try {
            return sService.removeAidGroupForService(this.mContext.getUserId(), service, category);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.removeAidGroupForService(this.mContext.getUserId(), service, category);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$setPreferredService(Activity activity, ComponentName service) {
        if (activity == null || service == null) {
            throw new NullPointerException("activity or service or category is null");
        }
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        try {
            return sService.setPreferredService(service);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.setPreferredService(service);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$unsetPreferredService(Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity is null");
        }
        if (!activity.isResumed()) {
            throw new IllegalArgumentException("Activity must be resumed.");
        }
        try {
            return sService.unsetPreferredService();
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.unsetPreferredService();
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$supportsAidPrefixRegistration() {
        try {
            return sService.supportsAidPrefixRegistration();
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.supportsAidPrefixRegistration();
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$setDefaultServiceForCategory(ComponentName service, String category) {
        try {
            return sService.setDefaultServiceForCategory(this.mContext.getUserId(), service, category);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.setDefaultServiceForCategory(this.mContext.getUserId(), service, category);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final boolean $$robo$$android_nfc_cardemulation_CardEmulation$setDefaultForNextTap(ComponentName service) {
        try {
            return sService.setDefaultForNextTap(this.mContext.getUserId(), service);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return false;
            }
            try {
                return sService.setDefaultForNextTap(this.mContext.getUserId(), service);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return false;
            }
        }
    }

    private final List<ApduServiceInfo> $$robo$$android_nfc_cardemulation_CardEmulation$getServices(String category) {
        try {
            return sService.getServices(this.mContext.getUserId(), category);
        }
        catch (RemoteException e) {
            this.recoverService();
            if (sService == null) {
                Log.e("CardEmulation", "Failed to recover CardEmulationService.");
                return null;
            }
            try {
                return sService.getServices(this.mContext.getUserId(), category);
            }
            catch (RemoteException ee) {
                Log.e("CardEmulation", "Failed to reach CardEmulationService.");
                return null;
            }
        }
    }

    private static final boolean $$robo$$android_nfc_cardemulation_CardEmulation$isValidAid(String aid) {
        if (aid == null) {
            return false;
        }
        if ((aid.endsWith("*") || aid.endsWith("#")) && aid.length() % 2 == 0) {
            Log.e("CardEmulation", "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!aid.endsWith("*") && !aid.endsWith("#") && aid.length() % 2 != 0) {
            Log.e("CardEmulation", "AID " + aid + " is not a valid AID.");
            return false;
        }
        if (!aid.matches("[0-9A-Fa-f]{10,32}\\*?\\#?")) {
            Log.e("CardEmulation", "AID " + aid + " is not a valid AID.");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_nfc_cardemulation_CardEmulation$recoverService() {
        NfcAdapter adapter = NfcAdapter.getDefaultAdapter(this.mContext);
        sService = adapter.getCardEmulationService();
    }

    static void __staticInitializer__() {
        sIsInitialized = false;
        sCardEmus = new HashMap();
    }

    private void __constructor__(Context context, INfcCardEmulation iNfcCardEmulation) {
        this.$$robo$$android_nfc_cardemulation_CardEmulation$__constructor__(context, iNfcCardEmulation);
    }

    public CardEmulation(Context context, INfcCardEmulation iNfcCardEmulation) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_CardEmulation$__constructor__(android.content.Context android.nfc.INfcCardEmulation ), this, context, iNfcCardEmulation);
    }

    public static synchronized CardEmulation getInstance(NfcAdapter nfcAdapter) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_nfc_cardemulation_CardEmulation$getInstance(android.nfc.NfcAdapter ), (NfcAdapter)nfcAdapter);
    }

    public boolean isDefaultServiceForCategory(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultServiceForCategory", $$robo$$android_nfc_cardemulation_CardEmulation$isDefaultServiceForCategory(android.content.ComponentName java.lang.String ), this, componentName, string2);
    }

    public boolean isDefaultServiceForAid(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDefaultServiceForAid", $$robo$$android_nfc_cardemulation_CardEmulation$isDefaultServiceForAid(android.content.ComponentName java.lang.String ), this, componentName, string2);
    }

    public boolean categoryAllowsForegroundPreference(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("categoryAllowsForegroundPreference", $$robo$$android_nfc_cardemulation_CardEmulation$categoryAllowsForegroundPreference(java.lang.String ), this, string2);
    }

    public int getSelectionModeForCategory(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionModeForCategory", $$robo$$android_nfc_cardemulation_CardEmulation$getSelectionModeForCategory(java.lang.String ), this, string2);
    }

    public boolean registerAidsForService(ComponentName componentName, String string2, List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerAidsForService", $$robo$$android_nfc_cardemulation_CardEmulation$registerAidsForService(android.content.ComponentName java.lang.String java.util.List<java.lang.String> ), this, componentName, string2, list);
    }

    public List<String> getAidsForService(ComponentName componentName, String string2) {
        return InvokeDynamicSupport.bootstrap("getAidsForService", $$robo$$android_nfc_cardemulation_CardEmulation$getAidsForService(android.content.ComponentName java.lang.String ), this, componentName, string2);
    }

    public boolean removeAidsForService(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAidsForService", $$robo$$android_nfc_cardemulation_CardEmulation$removeAidsForService(android.content.ComponentName java.lang.String ), this, componentName, string2);
    }

    public boolean setPreferredService(Activity activity, ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredService", $$robo$$android_nfc_cardemulation_CardEmulation$setPreferredService(android.app.Activity android.content.ComponentName ), this, activity, componentName);
    }

    public boolean unsetPreferredService(Activity activity) {
        return (boolean)InvokeDynamicSupport.bootstrap("unsetPreferredService", $$robo$$android_nfc_cardemulation_CardEmulation$unsetPreferredService(android.app.Activity ), this, activity);
    }

    public boolean supportsAidPrefixRegistration() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsAidPrefixRegistration", $$robo$$android_nfc_cardemulation_CardEmulation$supportsAidPrefixRegistration(), this);
    }

    public boolean setDefaultServiceForCategory(ComponentName componentName, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDefaultServiceForCategory", $$robo$$android_nfc_cardemulation_CardEmulation$setDefaultServiceForCategory(android.content.ComponentName java.lang.String ), this, componentName, string2);
    }

    public boolean setDefaultForNextTap(ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrap("setDefaultForNextTap", $$robo$$android_nfc_cardemulation_CardEmulation$setDefaultForNextTap(android.content.ComponentName ), this, componentName);
    }

    public List<ApduServiceInfo> getServices(String string2) {
        return InvokeDynamicSupport.bootstrap("getServices", $$robo$$android_nfc_cardemulation_CardEmulation$getServices(java.lang.String ), this, string2);
    }

    public static boolean isValidAid(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidAid", $$robo$$android_nfc_cardemulation_CardEmulation$isValidAid(java.lang.String ), (String)string2);
    }

    void recoverService() {
        InvokeDynamicSupport.bootstrap("recoverService", $$robo$$android_nfc_cardemulation_CardEmulation$recoverService(), this);
    }

    static {
        RobolectricInternals.classInitializing(CardEmulation.class);
    }

    public /* synthetic */ CardEmulation() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CardEmulation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

