/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class HostApduService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.nfc.cardemulation.action.HOST_APDU_SERVICE";
    public static String SERVICE_META_DATA = "android.nfc.cardemulation.host_apdu_service";
    public static int DEACTIVATION_LINK_LOSS = 0;
    public static int DEACTIVATION_DESELECTED = 1;
    static String TAG = "ApduService";
    public static int MSG_COMMAND_APDU = 0;
    public static int MSG_RESPONSE_APDU = 1;
    public static int MSG_DEACTIVATED = 2;
    public static int MSG_UNHANDLED = 3;
    public static String KEY_DATA = "data";
    Messenger mNfcService;
    Messenger mMessenger;

    private void $$robo$$android_nfc_cardemulation_HostApduService$__constructor__() {
        this.mNfcService = null;
        this.mMessenger = new Messenger(new MsgHandler(this));
    }

    private final IBinder $$robo$$android_nfc_cardemulation_HostApduService$onBind(Intent intent) {
        return this.mMessenger.getBinder();
    }

    private final void $$robo$$android_nfc_cardemulation_HostApduService$sendResponseApdu(byte[] responseApdu) {
        Message responseMsg = Message.obtain(null, 1);
        Bundle dataBundle = new Bundle();
        dataBundle.putByteArray("data", responseApdu);
        responseMsg.setData(dataBundle);
        try {
            this.mMessenger.send(responseMsg);
        }
        catch (RemoteException e) {
            Log.e("TAG", "Local messenger has died.");
        }
    }

    private final void $$robo$$android_nfc_cardemulation_HostApduService$notifyUnhandled() {
        Message unhandledMsg = Message.obtain(null, 3);
        try {
            this.mMessenger.send(unhandledMsg);
        }
        catch (RemoteException e) {
            Log.e("TAG", "Local messenger has died.");
        }
    }

    public abstract byte[] processCommandApdu(byte[] var1, Bundle var2);

    public abstract void onDeactivated(int var1);

    private void __constructor__() {
        this.$$robo$$android_nfc_cardemulation_HostApduService$__constructor__();
    }

    public HostApduService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_HostApduService$__constructor__(), this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_nfc_cardemulation_HostApduService$onBind(android.content.Intent ), this, intent);
    }

    public void sendResponseApdu(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("sendResponseApdu", $$robo$$android_nfc_cardemulation_HostApduService$sendResponseApdu(byte[] ), this, byArray);
    }

    public void notifyUnhandled() {
        InvokeDynamicSupport.bootstrap("notifyUnhandled", $$robo$$android_nfc_cardemulation_HostApduService$notifyUnhandled(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HostApduService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class MsgHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ HostApduService this$0;

        private void $$robo$$android_nfc_cardemulation_HostApduService_MsgHandler$__constructor__(HostApduService this$0) {
            this.this$0 = this$0;
        }

        private final void $$robo$$android_nfc_cardemulation_HostApduService_MsgHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    byte[] apdu;
                    Bundle dataBundle = msg.getData();
                    if (dataBundle == null) {
                        return;
                    }
                    if (this.this$0.mNfcService == null) {
                        this.this$0.mNfcService = msg.replyTo;
                    }
                    if ((apdu = dataBundle.getByteArray("data")) != null) {
                        byte[] responseApdu = this.this$0.processCommandApdu(apdu, null);
                        if (responseApdu == null) break;
                        if (this.this$0.mNfcService == null) {
                            Log.e("ApduService", "Response not sent; service was deactivated.");
                            return;
                        }
                        Message responseMsg = Message.obtain(null, 1);
                        Bundle responseBundle = new Bundle();
                        responseBundle.putByteArray("data", responseApdu);
                        responseMsg.setData(responseBundle);
                        responseMsg.replyTo = this.this$0.mMessenger;
                        try {
                            this.this$0.mNfcService.send(responseMsg);
                        }
                        catch (RemoteException e) {
                            Log.e("TAG", "Response not sent; RemoteException calling into NfcService.");
                        }
                        break;
                    }
                    Log.e("ApduService", "Received MSG_COMMAND_APDU without data.");
                    break;
                }
                case 1: {
                    if (this.this$0.mNfcService == null) {
                        Log.e("ApduService", "Response not sent; service was deactivated.");
                        return;
                    }
                    try {
                        msg.replyTo = this.this$0.mMessenger;
                        this.this$0.mNfcService.send(msg);
                    }
                    catch (RemoteException e) {
                        Log.e("ApduService", "RemoteException calling into NfcService.");
                    }
                    break;
                }
                case 2: {
                    this.this$0.mNfcService = null;
                    this.this$0.onDeactivated(msg.arg1);
                    break;
                }
                case 3: {
                    if (this.this$0.mNfcService == null) {
                        Log.e("ApduService", "notifyUnhandled not sent; service was deactivated.");
                        return;
                    }
                    try {
                        msg.replyTo = this.this$0.mMessenger;
                        this.this$0.mNfcService.send(msg);
                    }
                    catch (RemoteException e) {
                        Log.e("ApduService", "RemoteException calling into NfcService.");
                    }
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private void __constructor__(HostApduService hostApduService) {
            this.$$robo$$android_nfc_cardemulation_HostApduService_MsgHandler$__constructor__(hostApduService);
        }

        public MsgHandler(HostApduService hostApduService) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_HostApduService_MsgHandler$__constructor__(android.nfc.cardemulation.HostApduService ), this, hostApduService);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_nfc_cardemulation_HostApduService_MsgHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ MsgHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MsgHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

