/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AsyncTask<Params, Progress, Result> {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "AsyncTask";
    private static int CPU_COUNT;
    private static int CORE_POOL_SIZE;
    private static int MAXIMUM_POOL_SIZE;
    private static int KEEP_ALIVE_SECONDS = 30;
    private static ThreadFactory sThreadFactory;
    private static BlockingQueue<Runnable> sPoolWorkQueue;
    public static Executor THREAD_POOL_EXECUTOR;
    public static Executor SERIAL_EXECUTOR;
    private static int MESSAGE_POST_RESULT = 1;
    private static int MESSAGE_POST_PROGRESS = 2;
    private static volatile Executor sDefaultExecutor;
    private static InternalHandler sHandler;
    private WorkerRunnable<Params, Result> mWorker;
    private FutureTask<Result> mFuture;
    private volatile Status mStatus;
    private AtomicBoolean mCancelled;
    private AtomicBoolean mTaskInvoked;
    private Handler mHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Handler $$robo$$android_os_AsyncTask$getMainHandler() {
        Class<AsyncTask> clazz = AsyncTask.class;
        synchronized (AsyncTask.class) {
            if (sHandler == null) {
                sHandler = new InternalHandler(Looper.getMainLooper());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    private final Handler $$robo$$android_os_AsyncTask$getHandler() {
        return this.mHandler;
    }

    private static final void $$robo$$android_os_AsyncTask$setDefaultExecutor(Executor exec) {
        sDefaultExecutor = exec;
    }

    private void $$robo$$android_os_AsyncTask$__constructor__() {
    }

    private void $$robo$$android_os_AsyncTask$__constructor__(Handler handler) {
    }

    private void $$robo$$android_os_AsyncTask$__constructor__(Looper callbackLooper) {
        this.mStatus = Status.PENDING;
        this.mCancelled = new AtomicBoolean();
        this.mTaskInvoked = new AtomicBoolean();
        this.mHandler = callbackLooper == null || callbackLooper == Looper.getMainLooper() ? AsyncTask.getMainHandler() : new Handler(callbackLooper);
        this.mWorker = new WorkerRunnable<Params, Result>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AsyncTask this$0;

            private void $$robo$$android_os_AsyncTask_2$__constructor__(AsyncTask this$0) {
                this.this$0 = this$0;
            }

            private final Result $$robo$$android_os_AsyncTask_2$call() throws Exception {
                this.this$0.mTaskInvoked.set(true);
                Object result = null;
                try {
                    Process.setThreadPriority(10);
                    result = this.this$0.doInBackground(this.mParams);
                    Binder.flushPendingCommands();
                }
                catch (Throwable tr) {
                    this.this$0.mCancelled.set(true);
                    throw tr;
                }
                finally {
                    this.this$0.postResult(result);
                }
                return result;
            }

            private void __constructor__(AsyncTask asyncTask) {
                this.$$robo$$android_os_AsyncTask_2$__constructor__(asyncTask);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_2$__constructor__(android.os.AsyncTask ), this, asyncTask);
            }

            @Override
            public Result call() throws Exception {
                return InvokeDynamicSupport.bootstrap("call", $$robo$$android_os_AsyncTask_2$call(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFuture = new FutureTask<Result>(this, this.mWorker){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AsyncTask this$0;

            private void $$robo$$android_os_AsyncTask_3$__constructor__(AsyncTask this$0, Callable x0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_os_AsyncTask_3$done() {
                try {
                    this.this$0.postResultIfNotInvoked(this.get());
                }
                catch (InterruptedException e) {
                    Log.w("AsyncTask", e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    this.this$0.postResultIfNotInvoked(null);
                }
            }

            private void __constructor__(AsyncTask asyncTask, Callable callable) {
                this.$$robo$$android_os_AsyncTask_3$__constructor__(asyncTask, callable);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_3$__constructor__(android.os.AsyncTask java.util.concurrent.Callable ), this, asyncTask, callable);
            }

            @Override
            protected void done() {
                InvokeDynamicSupport.bootstrap("done", $$robo$$android_os_AsyncTask_3$done(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_os_AsyncTask$postResultIfNotInvoked(Result result) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result);
        }
    }

    private final Result $$robo$$android_os_AsyncTask$postResult(Result result) {
        Message message = this.getHandler().obtainMessage(1, new AsyncTaskResult<Object>(this, result));
        message.sendToTarget();
        return result;
    }

    private final Status $$robo$$android_os_AsyncTask$getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    private final void $$robo$$android_os_AsyncTask$onPreExecute() {
    }

    private final void $$robo$$android_os_AsyncTask$onPostExecute(Result result) {
    }

    private final void $$robo$$android_os_AsyncTask$onProgressUpdate(Progress ... values) {
    }

    private final void $$robo$$android_os_AsyncTask$onCancelled(Result result) {
        this.onCancelled();
    }

    private final void $$robo$$android_os_AsyncTask$onCancelled() {
    }

    private final boolean $$robo$$android_os_AsyncTask$isCancelled() {
        return this.mCancelled.get();
    }

    private final boolean $$robo$$android_os_AsyncTask$cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    private final Result $$robo$$android_os_AsyncTask$get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    private final Result $$robo$$android_os_AsyncTask$get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    private final AsyncTask<Params, Progress, Result> $$robo$$android_os_AsyncTask$execute(Params ... params) {
        return this.executeOnExecutor(sDefaultExecutor, params);
    }

    private final AsyncTask<Params, Progress, Result> $$robo$$android_os_AsyncTask$executeOnExecutor(Executor exec, Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (4.$SwitchMap$android$os$AsyncTask$Status[this.mStatus.ordinal()]) {
                case 1: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case 2: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        exec.execute(this.mFuture);
        return this;
    }

    private static final void $$robo$$android_os_AsyncTask$execute(Runnable runnable) {
        sDefaultExecutor.execute(runnable);
    }

    private final void $$robo$$android_os_AsyncTask$publishProgress(Progress ... values) {
        if (!this.isCancelled()) {
            this.getHandler().obtainMessage(2, new AsyncTaskResult<Progress>(this, values)).sendToTarget();
        }
    }

    private final void $$robo$$android_os_AsyncTask$finish(Result result) {
        if (this.isCancelled()) {
            this.onCancelled(result);
        } else {
            this.onPostExecute(result);
        }
        this.mStatus = Status.FINISHED;
    }

    static void __staticInitializer__() {
        CPU_COUNT = Runtime.getRuntime().availableProcessors();
        CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
        MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
        sThreadFactory = new ThreadFactory(){
            public /* synthetic */ Object __robo_data__;
            private AtomicInteger mCount;

            private void $$robo$$android_os_AsyncTask_1$__constructor__() {
                this.mCount = new AtomicInteger(1);
            }

            private final Thread $$robo$$android_os_AsyncTask_1$newThread(Runnable r) {
                return new Thread(r, "AsyncTask #" + this.mCount.getAndIncrement());
            }

            private void __constructor__() {
                this.$$robo$$android_os_AsyncTask_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_1$__constructor__(), this);
            }

            @Override
            public Thread newThread(Runnable runnable) {
                return InvokeDynamicSupport.bootstrap("newThread", $$robo$$android_os_AsyncTask_1$newThread(java.lang.Runnable ), this, runnable);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(128);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 30L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        THREAD_POOL_EXECUTOR = threadPoolExecutor;
        sDefaultExecutor = SERIAL_EXECUTOR = new SerialExecutor(null);
    }

    private static Handler getMainHandler() {
        return InvokeDynamicSupport.bootstrapStatic("getMainHandler", $$robo$$android_os_AsyncTask$getMainHandler());
    }

    private Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$android_os_AsyncTask$getHandler(), this);
    }

    public static void setDefaultExecutor(Executor executor) {
        InvokeDynamicSupport.bootstrapStatic("setDefaultExecutor", $$robo$$android_os_AsyncTask$setDefaultExecutor(java.util.concurrent.Executor ), (Executor)executor);
    }

    private void __constructor__() {
        this.$$robo$$android_os_AsyncTask$__constructor__();
    }

    public AsyncTask() {
        this((Looper)null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask$__constructor__(), this);
    }

    private void __constructor__(Handler handler) {
        this.$$robo$$android_os_AsyncTask$__constructor__(handler);
    }

    public AsyncTask(Handler handler) {
        this(handler != null ? handler.getLooper() : null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask$__constructor__(android.os.Handler ), this, handler);
    }

    private void __constructor__(Looper looper) {
        this.$$robo$$android_os_AsyncTask$__constructor__(looper);
    }

    public AsyncTask(Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask$__constructor__(android.os.Looper ), this, looper);
    }

    private void postResultIfNotInvoked(Result Result2) {
        InvokeDynamicSupport.bootstrap("postResultIfNotInvoked", $$robo$$android_os_AsyncTask$postResultIfNotInvoked(Result ), this, Result2);
    }

    private Result postResult(Result Result2) {
        return (Result)InvokeDynamicSupport.bootstrap("postResult", $$robo$$android_os_AsyncTask$postResult(Result ), this, Result2);
    }

    public Status getStatus() {
        return InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_os_AsyncTask$getStatus(), this);
    }

    protected void onPreExecute() {
        InvokeDynamicSupport.bootstrap("onPreExecute", $$robo$$android_os_AsyncTask$onPreExecute(), this);
    }

    protected void onPostExecute(Result Result2) {
        InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$android_os_AsyncTask$onPostExecute(Result ), this, Result2);
    }

    protected void onProgressUpdate(Progress ... ProgressArray) {
        InvokeDynamicSupport.bootstrap("onProgressUpdate", $$robo$$android_os_AsyncTask$onProgressUpdate(Progress[] ), this, ProgressArray);
    }

    protected void onCancelled(Result Result2) {
        InvokeDynamicSupport.bootstrap("onCancelled", $$robo$$android_os_AsyncTask$onCancelled(Result ), this, Result2);
    }

    protected void onCancelled() {
        InvokeDynamicSupport.bootstrap("onCancelled", $$robo$$android_os_AsyncTask$onCancelled(), this);
    }

    public boolean isCancelled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCancelled", $$robo$$android_os_AsyncTask$isCancelled(), this);
    }

    public boolean cancel(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_os_AsyncTask$cancel(boolean ), this, bl);
    }

    public Result get() throws InterruptedException, ExecutionException {
        return (Result)InvokeDynamicSupport.bootstrap("get", $$robo$$android_os_AsyncTask$get(), this);
    }

    public Result get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (Result)InvokeDynamicSupport.bootstrap("get", $$robo$$android_os_AsyncTask$get(long java.util.concurrent.TimeUnit ), this, l, timeUnit);
    }

    public AsyncTask<Params, Progress, Result> execute(Params ... ParamsArray) {
        return InvokeDynamicSupport.bootstrap("execute", $$robo$$android_os_AsyncTask$execute(Params[] ), this, ParamsArray);
    }

    public AsyncTask<Params, Progress, Result> executeOnExecutor(Executor executor, Params ... ParamsArray) {
        return InvokeDynamicSupport.bootstrap("executeOnExecutor", $$robo$$android_os_AsyncTask$executeOnExecutor(java.util.concurrent.Executor Params[] ), this, executor, ParamsArray);
    }

    public static void execute(Runnable runnable) {
        InvokeDynamicSupport.bootstrapStatic("execute", $$robo$$android_os_AsyncTask$execute(java.lang.Runnable ), (Runnable)runnable);
    }

    protected void publishProgress(Progress ... ProgressArray) {
        InvokeDynamicSupport.bootstrap("publishProgress", $$robo$$android_os_AsyncTask$publishProgress(Progress[] ), this, ProgressArray);
    }

    private void finish(Result Result2) {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_os_AsyncTask$finish(Result ), this, Result2);
    }

    static {
        RobolectricInternals.classInitializing(AsyncTask.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncTask)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class AsyncTaskResult<Data> {
        public /* synthetic */ Object __robo_data__;
        AsyncTask mTask;
        Data[] mData;

        private void $$robo$$android_os_AsyncTask_AsyncTaskResult$__constructor__(AsyncTask task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }

        private void __constructor__(AsyncTask asyncTask, Data ... DataArray) {
            this.$$robo$$android_os_AsyncTask_AsyncTaskResult$__constructor__(asyncTask, DataArray);
        }

        public AsyncTaskResult(AsyncTask asyncTask, Data ... DataArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_AsyncTaskResult$__constructor__(android.os.AsyncTask Data[] ), this, asyncTask, DataArray);
        }

        public /* synthetic */ AsyncTaskResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AsyncTaskResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        public /* synthetic */ Object __robo_data__;
        Params[] mParams;

        private void $$robo$$android_os_AsyncTask_WorkerRunnable$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_os_AsyncTask_WorkerRunnable$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_AsyncTask_WorkerRunnable$__constructor__();
        }

        public WorkerRunnable() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_WorkerRunnable$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_AsyncTask_WorkerRunnable$__constructor__(var1_1);
        }

        public /* synthetic */ WorkerRunnable(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_WorkerRunnable$__constructor__(android.os.AsyncTask$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WorkerRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class InternalHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_os_AsyncTask_InternalHandler$__constructor__(Looper looper) {
        }

        private final void $$robo$$android_os_AsyncTask_InternalHandler$handleMessage(Message msg) {
            AsyncTaskResult result = (AsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result.mTask.finish(result.mData[0]);
                    break;
                }
                case 2: {
                    result.mTask.onProgressUpdate(result.mData);
                }
            }
        }

        private void __constructor__(Looper looper) {
            this.$$robo$$android_os_AsyncTask_InternalHandler$__constructor__(looper);
        }

        public InternalHandler(Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_InternalHandler$__constructor__(android.os.Looper ), this, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_os_AsyncTask_InternalHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ InternalHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InternalHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Status
    extends Enum<Status> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Status PENDING;
        public static /* enum */ Status RUNNING;
        public static /* enum */ Status FINISHED;
        private static /* synthetic */ Status[] $VALUES;

        private static final Status[] $$robo$$android_os_AsyncTask_Status$values() {
            return (Status[])$VALUES.clone();
        }

        private static final Status $$robo$$android_os_AsyncTask_Status$valueOf(String name) {
            return Enum.valueOf(Status.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_os_AsyncTask_Status$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            PENDING = new Status();
            RUNNING = new Status();
            FINISHED = new Status();
            $VALUES = new Status[]{PENDING, RUNNING, FINISHED};
        }

        public static Status[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_os_AsyncTask_Status$values());
        }

        public static Status valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_os_AsyncTask_Status$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_os_AsyncTask_Status$__constructor__(string2, n);
        }

        public Status() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_Status$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Status.class);
        }

        public /* synthetic */ Status() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Status)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SerialExecutor
    implements Executor,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        ArrayDeque<Runnable> mTasks;
        Runnable mActive;

        private void $$robo$$android_os_AsyncTask_SerialExecutor$__constructor__() {
            this.mTasks = new ArrayDeque();
        }

        private final synchronized void $$robo$$android_os_AsyncTask_SerialExecutor$execute(Runnable r) {
            this.mTasks.offer(new Runnable(this, r){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Runnable val$r;
                /* synthetic */ SerialExecutor this$0;

                private void $$robo$$android_os_AsyncTask_SerialExecutor_1$__constructor__(SerialExecutor this$0, Runnable runnable) {
                    this.this$0 = this$0;
                    this.val$r = runnable;
                }

                private final void $$robo$$android_os_AsyncTask_SerialExecutor_1$run() {
                    try {
                        this.val$r.run();
                    }
                    finally {
                        this.this$0.scheduleNext();
                    }
                }

                private void __constructor__(SerialExecutor serialExecutor, Runnable runnable) {
                    this.$$robo$$android_os_AsyncTask_SerialExecutor_1$__constructor__(serialExecutor, runnable);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_SerialExecutor_1$__constructor__(android.os.AsyncTask$SerialExecutor java.lang.Runnable ), this, serialExecutor, runnable);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_AsyncTask_SerialExecutor_1$run(), this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }

        private final synchronized void $$robo$$android_os_AsyncTask_SerialExecutor$scheduleNext() {
            this.mActive = this.mTasks.poll();
            if (this.mActive != null) {
                THREAD_POOL_EXECUTOR.execute(this.mActive);
            }
        }

        private /* synthetic */ void $$robo$$android_os_AsyncTask_SerialExecutor$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_AsyncTask_SerialExecutor$__constructor__();
        }

        public SerialExecutor() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_SerialExecutor$__constructor__(), this);
        }

        @Override
        public synchronized void execute(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("execute", $$robo$$android_os_AsyncTask_SerialExecutor$execute(java.lang.Runnable ), this, runnable);
        }

        protected synchronized void scheduleNext() {
            InvokeDynamicSupport.bootstrap("scheduleNext", $$robo$$android_os_AsyncTask_SerialExecutor$scheduleNext(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_AsyncTask_SerialExecutor$__constructor__(var1_1);
        }

        public /* synthetic */ SerialExecutor(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_AsyncTask_SerialExecutor$__constructor__(android.os.AsyncTask$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SerialExecutor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

