/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.Printer;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Looper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "Looper";
    static ThreadLocal<Looper> sThreadLocal;
    private static Looper sMainLooper;
    MessageQueue mQueue;
    Thread mThread;
    private Printer mLogging;
    private long mTraceTag;
    private long mSlowDispatchThresholdMs;
    private long mSlowDeliveryThresholdMs;

    private static final void $$robo$$android_os_Looper$prepare() {
        Looper.prepare(true);
    }

    private static final void $$robo$$android_os_Looper$prepare(boolean quitAllowed) {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper(quitAllowed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_Looper$prepareMainLooper() {
        Looper.prepare(false);
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            if (sMainLooper != null) {
                throw new IllegalStateException("The main Looper has already been prepared.");
            }
            sMainLooper = Looper.myLooper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Looper $$robo$$android_os_Looper$getMainLooper() {
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainLooper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_Looper$loop() {
        Looper me = Looper.myLooper();
        if (me == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        MessageQueue queue = me.mQueue;
        Binder.clearCallingIdentity();
        long ident = Binder.clearCallingIdentity();
        int thresholdOverride = SystemProperties.getInt("log.looper." + Process.myUid() + "." + Thread.currentThread().getName() + ".slow", 0);
        boolean slowDeliveryDetected = false;
        Message msg;
        while ((msg = queue.next()) != null) {
            long newIdent;
            long dispatchEnd;
            Printer logging = me.mLogging;
            if (logging != null) {
                logging.println(">>>>> Dispatching to " + msg.target + " " + msg.callback + ": " + msg.what);
            }
            long traceTag = me.mTraceTag;
            long slowDispatchThresholdMs = me.mSlowDispatchThresholdMs;
            long slowDeliveryThresholdMs = me.mSlowDeliveryThresholdMs;
            if (thresholdOverride > 0) {
                slowDispatchThresholdMs = thresholdOverride;
                slowDeliveryThresholdMs = thresholdOverride;
            }
            boolean logSlowDelivery = slowDeliveryThresholdMs > 0L && msg.when > 0L;
            boolean logSlowDispatch = slowDispatchThresholdMs > 0L;
            boolean needStartTime = logSlowDelivery || logSlowDispatch;
            boolean needEndTime = logSlowDispatch;
            if (traceTag != 0L && Trace.isTagEnabled(traceTag)) {
                Trace.traceBegin(traceTag, msg.target.getTraceName(msg));
            }
            long dispatchStart = needStartTime ? SystemClock.uptimeMillis() : 0L;
            try {
                msg.target.dispatchMessage(msg);
                dispatchEnd = needEndTime ? SystemClock.uptimeMillis() : 0L;
            }
            finally {
                if (traceTag != 0L) {
                    Trace.traceEnd(traceTag);
                }
            }
            if (logSlowDelivery) {
                if (slowDeliveryDetected) {
                    if (dispatchStart - msg.when <= 10L) {
                        Slog.w("Looper", "Drained");
                        slowDeliveryDetected = false;
                    }
                } else if (Looper.showSlowLog(slowDeliveryThresholdMs, msg.when, dispatchStart, "delivery", msg)) {
                    slowDeliveryDetected = true;
                }
            }
            if (logSlowDispatch) {
                Looper.showSlowLog(slowDispatchThresholdMs, dispatchStart, dispatchEnd, "dispatch", msg);
            }
            if (logging != null) {
                logging.println("<<<<< Finished to " + msg.target + " " + msg.callback);
            }
            if (ident != (newIdent = Binder.clearCallingIdentity())) {
                Log.wtf("Looper", "Thread identity changed from 0x" + Long.toHexString(ident) + " to 0x" + Long.toHexString(newIdent) + " while dispatching to " + msg.target.getClass().getName() + " " + msg.callback + " what=" + msg.what);
            }
            msg.recycleUnchecked();
        }
        return;
    }

    private static final boolean $$robo$$android_os_Looper$showSlowLog(long threshold, long measureStart, long measureEnd, String what, Message msg) {
        long actualTime = measureEnd - measureStart;
        if (actualTime < threshold) {
            return false;
        }
        Slog.w("Looper", "Slow " + what + " took " + actualTime + "ms " + Thread.currentThread().getName() + " h=" + msg.target.getClass().getName() + " c=" + msg.callback + " m=" + msg.what);
        return true;
    }

    private static final Looper $$robo$$android_os_Looper$myLooper() {
        return sThreadLocal.get();
    }

    private static final MessageQueue $$robo$$android_os_Looper$myQueue() {
        return Looper.myLooper().mQueue;
    }

    private void $$robo$$android_os_Looper$__constructor__(boolean quitAllowed) {
        this.mQueue = new MessageQueue(quitAllowed);
        this.mThread = Thread.currentThread();
    }

    private final boolean $$robo$$android_os_Looper$isCurrentThread() {
        return Thread.currentThread() == this.mThread;
    }

    private final void $$robo$$android_os_Looper$setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    private final void $$robo$$android_os_Looper$setTraceTag(long traceTag) {
        this.mTraceTag = traceTag;
    }

    private final void $$robo$$android_os_Looper$setSlowLogThresholdMs(long slowDispatchThresholdMs, long slowDeliveryThresholdMs) {
        this.mSlowDispatchThresholdMs = slowDispatchThresholdMs;
        this.mSlowDeliveryThresholdMs = slowDeliveryThresholdMs;
    }

    private final void $$robo$$android_os_Looper$quit() {
        this.mQueue.quit(false);
    }

    private final void $$robo$$android_os_Looper$quitSafely() {
        this.mQueue.quit(true);
    }

    private final Thread $$robo$$android_os_Looper$getThread() {
        return this.mThread;
    }

    private final MessageQueue $$robo$$android_os_Looper$getQueue() {
        return this.mQueue;
    }

    private final void $$robo$$android_os_Looper$dump(Printer pw, String prefix) {
        pw.println(prefix + this.toString());
        this.mQueue.dump(pw, prefix + "  ", null);
    }

    private final void $$robo$$android_os_Looper$dump(Printer pw, String prefix, Handler handler) {
        pw.println(prefix + this.toString());
        this.mQueue.dump(pw, prefix + "  ", handler);
    }

    private final void $$robo$$android_os_Looper$writeToProto(ProtoOutputStream proto, long fieldId) {
        long looperToken = proto.start(fieldId);
        proto.write(0x10900000001L, this.mThread.getName());
        proto.write(1112396529666L, this.mThread.getId());
        this.mQueue.writeToProto(proto, 1146756268035L);
        proto.end(looperToken);
    }

    private final String $$robo$$android_os_Looper$toString() {
        return "Looper (" + this.mThread.getName() + ", tid " + this.mThread.getId() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    static void __staticInitializer__() {
        sThreadLocal = new ThreadLocal();
    }

    public static void prepare() {
        InvokeDynamicSupport.bootstrapStatic("prepare", $$robo$$android_os_Looper$prepare());
    }

    private static void prepare(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("prepare", $$robo$$android_os_Looper$prepare(boolean ), (boolean)bl);
    }

    public static void prepareMainLooper() {
        InvokeDynamicSupport.bootstrapStatic("prepareMainLooper", $$robo$$android_os_Looper$prepareMainLooper());
    }

    public static Looper getMainLooper() {
        return InvokeDynamicSupport.bootstrapStatic("getMainLooper", $$robo$$android_os_Looper$getMainLooper());
    }

    public static void loop() {
        InvokeDynamicSupport.bootstrapStatic("loop", $$robo$$android_os_Looper$loop());
    }

    private static boolean showSlowLog(long l, long l2, long l3, String string2, Message message) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("showSlowLog", $$robo$$android_os_Looper$showSlowLog(long long long java.lang.String android.os.Message ), (long)l, (long)l2, (long)l3, (String)string2, (Message)message);
    }

    public static Looper myLooper() {
        return InvokeDynamicSupport.bootstrapStatic("myLooper", $$robo$$android_os_Looper$myLooper());
    }

    public static MessageQueue myQueue() {
        return InvokeDynamicSupport.bootstrapStatic("myQueue", $$robo$$android_os_Looper$myQueue());
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_os_Looper$__constructor__(bl);
    }

    public Looper(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Looper$__constructor__(boolean ), this, bl);
    }

    public boolean isCurrentThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrentThread", $$robo$$android_os_Looper$isCurrentThread(), this);
    }

    public void setMessageLogging(Printer printer) {
        InvokeDynamicSupport.bootstrap("setMessageLogging", $$robo$$android_os_Looper$setMessageLogging(android.util.Printer ), this, printer);
    }

    public void setTraceTag(long l) {
        InvokeDynamicSupport.bootstrap("setTraceTag", $$robo$$android_os_Looper$setTraceTag(long ), this, l);
    }

    public void setSlowLogThresholdMs(long l, long l2) {
        InvokeDynamicSupport.bootstrap("setSlowLogThresholdMs", $$robo$$android_os_Looper$setSlowLogThresholdMs(long long ), this, l, l2);
    }

    public void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_os_Looper$quit(), this);
    }

    public void quitSafely() {
        InvokeDynamicSupport.bootstrap("quitSafely", $$robo$$android_os_Looper$quitSafely(), this);
    }

    public Thread getThread() {
        return InvokeDynamicSupport.bootstrap("getThread", $$robo$$android_os_Looper$getThread(), this);
    }

    public MessageQueue getQueue() {
        return InvokeDynamicSupport.bootstrap("getQueue", $$robo$$android_os_Looper$getQueue(), this);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_Looper$dump(android.util.Printer java.lang.String ), this, printer, string2);
    }

    public void dump(Printer printer, String string2, Handler handler) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_Looper$dump(android.util.Printer java.lang.String android.os.Handler ), this, printer, string2, handler);
    }

    public void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_os_Looper$writeToProto(android.util.proto.ProtoOutputStream long ), this, protoOutputStream, l);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_Looper$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(Looper.class);
    }

    public /* synthetic */ Looper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Looper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

