/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.IAlarmManager;
import android.os.DeadSystemException;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.annotation.optimization.CriticalNative;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SystemClock
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "SystemClock";

    private void $$robo$$android_os_SystemClock$__constructor__() {
    }

    private static final void $$robo$$android_os_SystemClock$sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private static final boolean $$robo$$android_os_SystemClock$setCurrentTimeMillis(long millis) {
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (mgr == null) {
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e("SystemClock", "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e("SystemClock", "Unable to set RTC", e);
        }
        return false;
    }

    @CriticalNative
    private static final long $$robo$$android_os_SystemClock$uptimeMillis() {
        return 0L;
    }

    @Deprecated
    private static final Clock $$robo$$android_os_SystemClock$uptimeMillisClock() {
        return SystemClock.uptimeClock();
    }

    private static final Clock $$robo$$android_os_SystemClock$uptimeClock() {
        return new ShadowedObject(ZoneOffset.UTC){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_SystemClock_1$__constructor__(ZoneId zone) {
            }

            private final long $$robo$$android_os_SystemClock_1$millis() {
                return SystemClock.uptimeMillis();
            }

            private void __constructor__(ZoneId zoneId) {
                this.$$robo$$android_os_SystemClock_1$__constructor__(zoneId);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemClock_1$__constructor__(java.time.ZoneId ), this, zoneId);
            }

            @Override
            public long millis() {
                return (long)InvokeDynamicSupport.bootstrap("millis", $$robo$$android_os_SystemClock_1$millis(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    @CriticalNative
    private static final long $$robo$$android_os_SystemClock$elapsedRealtime() {
        return 0L;
    }

    private static final Clock $$robo$$android_os_SystemClock$elapsedRealtimeClock() {
        return new ShadowedObject(ZoneOffset.UTC){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_SystemClock_2$__constructor__(ZoneId zone) {
            }

            private final long $$robo$$android_os_SystemClock_2$millis() {
                return SystemClock.elapsedRealtime();
            }

            private void __constructor__(ZoneId zoneId) {
                this.$$robo$$android_os_SystemClock_2$__constructor__(zoneId);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemClock_2$__constructor__(java.time.ZoneId ), this, zoneId);
            }

            @Override
            public long millis() {
                return (long)InvokeDynamicSupport.bootstrap("millis", $$robo$$android_os_SystemClock_2$millis(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    @CriticalNative
    private static final long $$robo$$android_os_SystemClock$elapsedRealtimeNanos() {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_os_SystemClock$currentThreadTimeMillis() {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_os_SystemClock$currentThreadTimeMicro() {
        return 0L;
    }

    @CriticalNative
    private static final long $$robo$$android_os_SystemClock$currentTimeMicro() {
        return 0L;
    }

    private static final long $$robo$$android_os_SystemClock$currentNetworkTimeMillis() {
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (mgr != null) {
            try {
                return mgr.currentNetworkTimeMillis();
            }
            catch (ParcelableException e) {
                e.maybeRethrow(DateTimeException.class);
                throw new RuntimeException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        throw new RuntimeException(new DeadSystemException());
    }

    private static final Clock $$robo$$android_os_SystemClock$currentNetworkTimeClock() {
        return new ShadowedObject(ZoneOffset.UTC){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_SystemClock_3$__constructor__(ZoneId zone) {
            }

            private final long $$robo$$android_os_SystemClock_3$millis() {
                return SystemClock.currentNetworkTimeMillis();
            }

            private void __constructor__(ZoneId zoneId) {
                this.$$robo$$android_os_SystemClock_3$__constructor__(zoneId);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemClock_3$__constructor__(java.time.ZoneId ), this, zoneId);
            }

            @Override
            public long millis() {
                return (long)InvokeDynamicSupport.bootstrap("millis", $$robo$$android_os_SystemClock_3$millis(), this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_os_SystemClock$__constructor__();
    }

    public SystemClock() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_SystemClock$__constructor__(), this);
    }

    public static void sleep(long l) {
        InvokeDynamicSupport.bootstrapStatic("sleep", $$robo$$android_os_SystemClock$sleep(long ), (long)l);
    }

    public static boolean setCurrentTimeMillis(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setCurrentTimeMillis", $$robo$$android_os_SystemClock$setCurrentTimeMillis(long ), (long)l);
    }

    public static long uptimeMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("uptimeMillis", $$robo$$android_os_SystemClock$uptimeMillis());
    }

    @Deprecated
    public static Clock uptimeMillisClock() {
        return InvokeDynamicSupport.bootstrapStatic("uptimeMillisClock", $$robo$$android_os_SystemClock$uptimeMillisClock());
    }

    public static Clock uptimeClock() {
        return InvokeDynamicSupport.bootstrapStatic("uptimeClock", $$robo$$android_os_SystemClock$uptimeClock());
    }

    public static long elapsedRealtime() {
        return (long)InvokeDynamicSupport.bootstrapStatic("elapsedRealtime", $$robo$$android_os_SystemClock$elapsedRealtime());
    }

    public static Clock elapsedRealtimeClock() {
        return InvokeDynamicSupport.bootstrapStatic("elapsedRealtimeClock", $$robo$$android_os_SystemClock$elapsedRealtimeClock());
    }

    public static long elapsedRealtimeNanos() {
        return (long)InvokeDynamicSupport.bootstrapStatic("elapsedRealtimeNanos", $$robo$$android_os_SystemClock$elapsedRealtimeNanos());
    }

    public static long currentThreadTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("currentThreadTimeMillis", $$robo$$android_os_SystemClock$currentThreadTimeMillis());
    }

    public static long currentThreadTimeMicro() {
        return (long)InvokeDynamicSupport.bootstrapStatic("currentThreadTimeMicro", $$robo$$android_os_SystemClock$currentThreadTimeMicro());
    }

    public static long currentTimeMicro() {
        return (long)InvokeDynamicSupport.bootstrapStatic("currentTimeMicro", $$robo$$android_os_SystemClock$currentTimeMicro());
    }

    public static long currentNetworkTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrapStatic("currentNetworkTimeMillis", $$robo$$android_os_SystemClock$currentNetworkTimeMillis());
    }

    public static Clock currentNetworkTimeClock() {
        return InvokeDynamicSupport.bootstrapStatic("currentNetworkTimeClock", $$robo$$android_os_SystemClock$currentNetworkTimeClock());
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemClock)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

