/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.ChildZygoteProcess;
import android.os.Process;
import android.os.ZygoteStartFailedEx;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteProcess
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ZygoteProcess";
    private LocalSocketAddress mSocket;
    private LocalSocketAddress mSecondarySocket;
    private Object mLock;
    private List<String> mApiBlacklistExemptions;
    private int mHiddenApiAccessLogSampleRate;
    private ZygoteState primaryZygoteState;
    private ZygoteState secondaryZygoteState;
    static int ZYGOTE_RETRY_MILLIS = 500;

    private void $$robo$$android_os_ZygoteProcess$__constructor__(String primarySocket, String secondarySocket) {
    }

    private void $$robo$$android_os_ZygoteProcess$__constructor__(LocalSocketAddress primarySocket, LocalSocketAddress secondarySocket) {
        this.mLock = new Object();
        this.mApiBlacklistExemptions = Collections.emptyList();
        this.mSocket = primarySocket;
        this.mSecondarySocket = secondarySocket;
    }

    private final LocalSocketAddress $$robo$$android_os_ZygoteProcess$getPrimarySocketAddress() {
        return this.mSocket;
    }

    private final Process.ProcessStartResult $$robo$$android_os_ZygoteProcess$start(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, String[] zygoteArgs) {
        try {
            return this.startViaZygote(processClass, niceName, uid, gid, gids, runtimeFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, invokeWith, false, zygoteArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            Log.e("ZygoteProcess", "Starting VM process through Zygote failed");
            throw new RuntimeException("Starting VM process through Zygote failed", ex);
        }
    }

    @GuardedBy(value="mLock")
    private static final String $$robo$$android_os_ZygoteProcess$getAbiList(BufferedWriter writer, DataInputStream inputStream) throws IOException {
        writer.write("1");
        writer.newLine();
        writer.write("--query-abi-list");
        writer.newLine();
        writer.flush();
        int numBytes = inputStream.readInt();
        byte[] bytes = new byte[numBytes];
        inputStream.readFully(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    @GuardedBy(value="mLock")
    private static final Process.ProcessStartResult $$robo$$android_os_ZygoteProcess$zygoteSendArgsAndGetResult(ZygoteState zygoteState, ArrayList<String> args) throws ZygoteStartFailedEx {
        try {
            int sz = args.size();
            for (int i = 0; i < sz; ++i) {
                if (args.get(i).indexOf(10) < 0) continue;
                throw new ZygoteStartFailedEx("embedded newlines not allowed");
            }
            BufferedWriter writer = zygoteState.writer;
            DataInputStream inputStream = zygoteState.inputStream;
            writer.write(Integer.toString(args.size()));
            writer.newLine();
            for (int i = 0; i < sz; ++i) {
                String arg = args.get(i);
                writer.write(arg);
                writer.newLine();
            }
            writer.flush();
            Process.ProcessStartResult result = new Process.ProcessStartResult();
            result.pid = inputStream.readInt();
            result.usingWrapper = inputStream.readBoolean();
            if (result.pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
            return result;
        }
        catch (IOException ex) {
            zygoteState.close();
            throw new ZygoteStartFailedEx(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Process.ProcessStartResult $$robo$$android_os_ZygoteProcess$startViaZygote(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String invokeWith, boolean startChildZygote, String[] extraArgs) throws ZygoteStartFailedEx {
        ArrayList<String> argsForZygote = new ArrayList<String>();
        argsForZygote.add("--runtime-args");
        argsForZygote.add("--setuid=" + uid);
        argsForZygote.add("--setgid=" + gid);
        argsForZygote.add("--runtime-flags=" + runtimeFlags);
        if (mountExternal == 1) {
            argsForZygote.add("--mount-external-default");
        } else if (mountExternal == 2) {
            argsForZygote.add("--mount-external-read");
        } else if (mountExternal == 3) {
            argsForZygote.add("--mount-external-write");
        }
        argsForZygote.add("--target-sdk-version=" + targetSdkVersion);
        if (gids != null && gids.length > 0) {
            StringBuilder object = new StringBuilder();
            object.append("--setgroups=");
            int sz = gids.length;
            for (int i = 0; i < sz; ++i) {
                if (i != 0) {
                    object.append(',');
                }
                object.append(gids[i]);
            }
            argsForZygote.add(object.toString());
        }
        if (niceName != null) {
            argsForZygote.add("--nice-name=" + niceName);
        }
        if (seInfo != null) {
            argsForZygote.add("--seinfo=" + seInfo);
        }
        if (instructionSet != null) {
            argsForZygote.add("--instruction-set=" + instructionSet);
        }
        if (appDataDir != null) {
            argsForZygote.add("--app-data-dir=" + appDataDir);
        }
        if (invokeWith != null) {
            argsForZygote.add("--invoke-with");
            argsForZygote.add(invokeWith);
        }
        if (startChildZygote) {
            argsForZygote.add("--start-child-zygote");
        }
        argsForZygote.add(processClass);
        if (extraArgs != null) {
            for (String arg : extraArgs) {
                argsForZygote.add(arg);
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            return ZygoteProcess.zygoteSendArgsAndGetResult(this.openZygoteSocketIfNeeded(abi), argsForZygote);
        }
    }

    private final void $$robo$$android_os_ZygoteProcess$close() {
        if (this.primaryZygoteState != null) {
            this.primaryZygoteState.close();
        }
        if (this.secondaryZygoteState != null) {
            this.secondaryZygoteState.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_ZygoteProcess$establishZygoteConnectionForAbi(String abi) {
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.openZygoteSocketIfNeeded(abi);
            }
        }
        catch (ZygoteStartFailedEx ex) {
            throw new RuntimeException("Unable to connect to zygote for abi: " + abi, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_ZygoteProcess$setApiBlacklistExemptions(List<String> exemptions) {
        Object object = this.mLock;
        synchronized (object) {
            this.mApiBlacklistExemptions = exemptions;
            boolean ok = this.maybeSetApiBlacklistExemptions(this.primaryZygoteState, true);
            if (ok) {
                ok = this.maybeSetApiBlacklistExemptions(this.secondaryZygoteState, true);
            }
            return ok;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_ZygoteProcess$setHiddenApiAccessLogSampleRate(int rate) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHiddenApiAccessLogSampleRate = rate;
            this.maybeSetHiddenApiAccessLogSampleRate(this.primaryZygoteState);
            this.maybeSetHiddenApiAccessLogSampleRate(this.secondaryZygoteState);
        }
    }

    @GuardedBy(value="mLock")
    private final boolean $$robo$$android_os_ZygoteProcess$maybeSetApiBlacklistExemptions(ZygoteState state, boolean sendIfEmpty) {
        if (state == null || state.isClosed()) {
            Slog.e("ZygoteProcess", "Can't set API blacklist exemptions: no zygote connection");
            return false;
        }
        if (!sendIfEmpty && this.mApiBlacklistExemptions.isEmpty()) {
            return true;
        }
        try {
            state.writer.write(Integer.toString(this.mApiBlacklistExemptions.size() + 1));
            state.writer.newLine();
            state.writer.write("--set-api-blacklist-exemptions");
            state.writer.newLine();
            for (int i = 0; i < this.mApiBlacklistExemptions.size(); ++i) {
                state.writer.write(this.mApiBlacklistExemptions.get(i));
                state.writer.newLine();
            }
            state.writer.flush();
            int status = state.inputStream.readInt();
            if (status != 0) {
                Slog.e("ZygoteProcess", "Failed to set API blacklist exemptions; status " + status);
            }
            return true;
        }
        catch (IOException ioe) {
            Slog.e("ZygoteProcess", "Failed to set API blacklist exemptions", ioe);
            this.mApiBlacklistExemptions = Collections.emptyList();
            return false;
        }
    }

    private final void $$robo$$android_os_ZygoteProcess$maybeSetHiddenApiAccessLogSampleRate(ZygoteState state) {
        if (state == null || state.isClosed()) {
            return;
        }
        if (this.mHiddenApiAccessLogSampleRate == -1) {
            return;
        }
        try {
            state.writer.write(Integer.toString(1));
            state.writer.newLine();
            state.writer.write("--hidden-api-log-sampling-rate=" + Integer.toString(this.mHiddenApiAccessLogSampleRate));
            state.writer.newLine();
            state.writer.flush();
            int status = state.inputStream.readInt();
            if (status != 0) {
                Slog.e("ZygoteProcess", "Failed to set hidden API log sampling rate; status " + status);
            }
        }
        catch (IOException ioe) {
            Slog.e("ZygoteProcess", "Failed to set hidden API log sampling rate", ioe);
        }
    }

    @GuardedBy(value="mLock")
    private final ZygoteState $$robo$$android_os_ZygoteProcess$openZygoteSocketIfNeeded(String abi) throws ZygoteStartFailedEx {
        Preconditions.checkState(Thread.holdsLock(this.mLock), "ZygoteProcess lock not held");
        if (this.primaryZygoteState == null || this.primaryZygoteState.isClosed()) {
            try {
                this.primaryZygoteState = ZygoteState.connect(this.mSocket);
            }
            catch (IOException ioe) {
                throw new ZygoteStartFailedEx("Error connecting to primary zygote", ioe);
            }
            this.maybeSetApiBlacklistExemptions(this.primaryZygoteState, false);
            this.maybeSetHiddenApiAccessLogSampleRate(this.primaryZygoteState);
        }
        if (this.primaryZygoteState.matches(abi)) {
            return this.primaryZygoteState;
        }
        if (this.secondaryZygoteState == null || this.secondaryZygoteState.isClosed()) {
            try {
                this.secondaryZygoteState = ZygoteState.connect(this.mSecondarySocket);
            }
            catch (IOException ioe) {
                throw new ZygoteStartFailedEx("Error connecting to secondary zygote", ioe);
            }
            this.maybeSetApiBlacklistExemptions(this.secondaryZygoteState, false);
            this.maybeSetHiddenApiAccessLogSampleRate(this.secondaryZygoteState);
        }
        if (this.secondaryZygoteState.matches(abi)) {
            return this.secondaryZygoteState;
        }
        throw new ZygoteStartFailedEx("Unsupported zygote ABI: " + abi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_ZygoteProcess$preloadPackageForAbi(String packagePath, String libsPath, String libFileName, String cacheKey, String abi) throws ZygoteStartFailedEx, IOException {
        Object object = this.mLock;
        synchronized (object) {
            ZygoteState state = this.openZygoteSocketIfNeeded(abi);
            state.writer.write("5");
            state.writer.newLine();
            state.writer.write("--preload-package");
            state.writer.newLine();
            state.writer.write(packagePath);
            state.writer.newLine();
            state.writer.write(libsPath);
            state.writer.newLine();
            state.writer.write(libFileName);
            state.writer.newLine();
            state.writer.write(cacheKey);
            state.writer.newLine();
            state.writer.flush();
            return state.inputStream.readInt() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_ZygoteProcess$preloadDefault(String abi) throws ZygoteStartFailedEx, IOException {
        Object object = this.mLock;
        synchronized (object) {
            ZygoteState state = this.openZygoteSocketIfNeeded(abi);
            state.writer.write("1");
            state.writer.newLine();
            state.writer.write("--preload-default");
            state.writer.newLine();
            state.writer.flush();
            return state.inputStream.readInt() == 0;
        }
    }

    private static final void $$robo$$android_os_ZygoteProcess$waitForConnectionToZygote(String socketName) {
        LocalSocketAddress address = new LocalSocketAddress(socketName, LocalSocketAddress.Namespace.RESERVED);
        ZygoteProcess.waitForConnectionToZygote(address);
    }

    private static final void $$robo$$android_os_ZygoteProcess$waitForConnectionToZygote(LocalSocketAddress address) {
        for (int n = 20; n >= 0; --n) {
            try {
                ZygoteState zs = ZygoteState.connect(address);
                zs.close();
                return;
            }
            catch (IOException ioe) {
                Log.w("ZygoteProcess", "Got error connecting to zygote, retrying. msg= " + ioe.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        Slog.wtf("ZygoteProcess", "Failed to connect to Zygote through socket " + address.getName());
    }

    private final ChildZygoteProcess $$robo$$android_os_ZygoteProcess$startChildZygote(String processClass, String niceName, int uid, int gid, int[] gids, int runtimeFlags, String seInfo, String abi, String instructionSet) {
        Process.ProcessStartResult result;
        LocalSocketAddress serverAddress = new LocalSocketAddress(processClass + "/" + UUID.randomUUID().toString());
        String[] extraArgs = new String[]{"--zygote-socket=" + serverAddress.getName()};
        try {
            result = this.startViaZygote(processClass, niceName, uid, gid, gids, runtimeFlags, 0, 0, seInfo, abi, instructionSet, null, null, true, extraArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            throw new RuntimeException("Starting child-zygote through Zygote failed", ex);
        }
        return new ChildZygoteProcess(serverAddress, result.pid);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_os_ZygoteProcess$__constructor__(string2, string3);
    }

    public ZygoteProcess(String string2, String string3) {
        this(new LocalSocketAddress(string2, LocalSocketAddress.Namespace.RESERVED), new LocalSocketAddress(string3, LocalSocketAddress.Namespace.RESERVED));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ZygoteProcess$__constructor__(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void __constructor__(LocalSocketAddress localSocketAddress, LocalSocketAddress localSocketAddress2) {
        this.$$robo$$android_os_ZygoteProcess$__constructor__(localSocketAddress, localSocketAddress2);
    }

    public ZygoteProcess(LocalSocketAddress localSocketAddress, LocalSocketAddress localSocketAddress2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ZygoteProcess$__constructor__(android.net.LocalSocketAddress android.net.LocalSocketAddress ), this, localSocketAddress, localSocketAddress2);
    }

    public LocalSocketAddress getPrimarySocketAddress() {
        return InvokeDynamicSupport.bootstrap("getPrimarySocketAddress", $$robo$$android_os_ZygoteProcess$getPrimarySocketAddress(), this);
    }

    public Process.ProcessStartResult start(String string2, String string3, int n, int n2, int[] nArray, int n3, int n4, int n5, String string4, String string5, String string6, String string7, String string8, String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("start", $$robo$$android_os_ZygoteProcess$start(java.lang.String java.lang.String int int int[] int int int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String[] ), this, string2, string3, n, n2, nArray, n3, n4, n5, string4, string5, string6, string7, string8, stringArray);
    }

    private static String getAbiList(BufferedWriter bufferedWriter, DataInputStream dataInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getAbiList", $$robo$$android_os_ZygoteProcess$getAbiList(java.io.BufferedWriter java.io.DataInputStream ), (BufferedWriter)bufferedWriter, (DataInputStream)dataInputStream);
    }

    private static Process.ProcessStartResult zygoteSendArgsAndGetResult(ZygoteState zygoteState, ArrayList<String> arrayList) throws ZygoteStartFailedEx {
        return InvokeDynamicSupport.bootstrapStatic("zygoteSendArgsAndGetResult", $$robo$$android_os_ZygoteProcess$zygoteSendArgsAndGetResult(android.os.ZygoteProcess$ZygoteState java.util.ArrayList<java.lang.String> ), (ZygoteState)zygoteState, arrayList);
    }

    private Process.ProcessStartResult startViaZygote(String string2, String string3, int n, int n2, int[] nArray, int n3, int n4, int n5, String string4, String string5, String string6, String string7, String string8, boolean bl, String[] stringArray) throws ZygoteStartFailedEx {
        return InvokeDynamicSupport.bootstrap("startViaZygote", $$robo$$android_os_ZygoteProcess$startViaZygote(java.lang.String java.lang.String int int int[] int int int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String boolean java.lang.String[] ), this, string2, string3, n, n2, nArray, n3, n4, n5, string4, string5, string6, string7, string8, bl, stringArray);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_ZygoteProcess$close(), this);
    }

    public void establishZygoteConnectionForAbi(String string2) {
        InvokeDynamicSupport.bootstrap("establishZygoteConnectionForAbi", $$robo$$android_os_ZygoteProcess$establishZygoteConnectionForAbi(java.lang.String ), this, string2);
    }

    public boolean setApiBlacklistExemptions(List<String> list) {
        return (boolean)InvokeDynamicSupport.bootstrap("setApiBlacklistExemptions", $$robo$$android_os_ZygoteProcess$setApiBlacklistExemptions(java.util.List<java.lang.String> ), this, list);
    }

    public void setHiddenApiAccessLogSampleRate(int n) {
        InvokeDynamicSupport.bootstrap("setHiddenApiAccessLogSampleRate", $$robo$$android_os_ZygoteProcess$setHiddenApiAccessLogSampleRate(int ), this, n);
    }

    private boolean maybeSetApiBlacklistExemptions(ZygoteState zygoteState, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("maybeSetApiBlacklistExemptions", $$robo$$android_os_ZygoteProcess$maybeSetApiBlacklistExemptions(android.os.ZygoteProcess$ZygoteState boolean ), this, zygoteState, bl);
    }

    private void maybeSetHiddenApiAccessLogSampleRate(ZygoteState zygoteState) {
        InvokeDynamicSupport.bootstrap("maybeSetHiddenApiAccessLogSampleRate", $$robo$$android_os_ZygoteProcess$maybeSetHiddenApiAccessLogSampleRate(android.os.ZygoteProcess$ZygoteState ), this, zygoteState);
    }

    private ZygoteState openZygoteSocketIfNeeded(String string2) throws ZygoteStartFailedEx {
        return InvokeDynamicSupport.bootstrap("openZygoteSocketIfNeeded", $$robo$$android_os_ZygoteProcess$openZygoteSocketIfNeeded(java.lang.String ), this, string2);
    }

    public boolean preloadPackageForAbi(String string2, String string3, String string4, String string5, String string6) throws ZygoteStartFailedEx, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("preloadPackageForAbi", $$robo$$android_os_ZygoteProcess$preloadPackageForAbi(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4, string5, string6);
    }

    public boolean preloadDefault(String string2) throws ZygoteStartFailedEx, IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("preloadDefault", $$robo$$android_os_ZygoteProcess$preloadDefault(java.lang.String ), this, string2);
    }

    public static void waitForConnectionToZygote(String string2) {
        InvokeDynamicSupport.bootstrapStatic("waitForConnectionToZygote", $$robo$$android_os_ZygoteProcess$waitForConnectionToZygote(java.lang.String ), (String)string2);
    }

    public static void waitForConnectionToZygote(LocalSocketAddress localSocketAddress) {
        InvokeDynamicSupport.bootstrapStatic("waitForConnectionToZygote", $$robo$$android_os_ZygoteProcess$waitForConnectionToZygote(android.net.LocalSocketAddress ), (LocalSocketAddress)localSocketAddress);
    }

    public ChildZygoteProcess startChildZygote(String string2, String string3, int n, int n2, int[] nArray, int n3, String string4, String string5, String string6) {
        return InvokeDynamicSupport.bootstrap("startChildZygote", $$robo$$android_os_ZygoteProcess$startChildZygote(java.lang.String java.lang.String int int int[] int java.lang.String java.lang.String java.lang.String ), this, string2, string3, n, n2, nArray, n3, string4, string5, string6);
    }

    public /* synthetic */ ZygoteProcess() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteProcess)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ZygoteState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        LocalSocket socket;
        DataInputStream inputStream;
        BufferedWriter writer;
        List<String> abiList;
        boolean mClosed;

        private void $$robo$$android_os_ZygoteProcess_ZygoteState$__constructor__(LocalSocket socket, DataInputStream inputStream, BufferedWriter writer, List<String> abiList) {
            this.socket = socket;
            this.inputStream = inputStream;
            this.writer = writer;
            this.abiList = abiList;
        }

        private static final ZygoteState $$robo$$android_os_ZygoteProcess_ZygoteState$connect(LocalSocketAddress address) throws IOException {
            DataInputStream zygoteInputStream = null;
            BufferedWriter zygoteWriter = null;
            LocalSocket zygoteSocket = new LocalSocket();
            try {
                zygoteSocket.connect(address);
                zygoteInputStream = new DataInputStream(zygoteSocket.getInputStream());
                zygoteWriter = new BufferedWriter(new OutputStreamWriter(zygoteSocket.getOutputStream()), 256);
            }
            catch (IOException ex) {
                try {
                    zygoteSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ex;
            }
            String abiListString = ZygoteProcess.getAbiList(zygoteWriter, zygoteInputStream);
            Log.i("Zygote", "Process: zygote socket " + (Object)((Object)address.getNamespace()) + "/" + address.getName() + " opened, supported ABIS: " + abiListString);
            return new ZygoteState(zygoteSocket, zygoteInputStream, zygoteWriter, Arrays.asList(abiListString.split(",")));
        }

        private final boolean $$robo$$android_os_ZygoteProcess_ZygoteState$matches(String abi) {
            return this.abiList.contains(abi);
        }

        private final void $$robo$$android_os_ZygoteProcess_ZygoteState$close() {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                Log.e("ZygoteProcess", "I/O exception on routine close", ex);
            }
            this.mClosed = true;
        }

        private final boolean $$robo$$android_os_ZygoteProcess_ZygoteState$isClosed() {
            return this.mClosed;
        }

        private void __constructor__(LocalSocket localSocket, DataInputStream dataInputStream, BufferedWriter bufferedWriter, List<String> list) {
            this.$$robo$$android_os_ZygoteProcess_ZygoteState$__constructor__(localSocket, dataInputStream, bufferedWriter, list);
        }

        public ZygoteState(LocalSocket localSocket, DataInputStream dataInputStream, BufferedWriter bufferedWriter, List<String> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_ZygoteProcess_ZygoteState$__constructor__(android.net.LocalSocket java.io.DataInputStream java.io.BufferedWriter java.util.List<java.lang.String> ), this, localSocket, dataInputStream, bufferedWriter, list);
        }

        public static ZygoteState connect(LocalSocketAddress localSocketAddress) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$android_os_ZygoteProcess_ZygoteState$connect(android.net.LocalSocketAddress ), (LocalSocketAddress)localSocketAddress);
        }

        boolean matches(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_os_ZygoteProcess_ZygoteState$matches(java.lang.String ), this, string2);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_ZygoteProcess_ZygoteState$close(), this);
        }

        boolean isClosed() {
            return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_os_ZygoteProcess_ZygoteState$isClosed(), this);
        }

        public /* synthetic */ ZygoteState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

