/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.content.pm.ParceledListSlice;
import android.os.CancellationSignal;
import android.os.RemoteException;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.printservice.CustomPrinterIconCallback;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintService;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class PrinterDiscoverySession
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PrinterDiscoverySession";
    private static int sIdCounter;
    private int mId;
    private ArrayMap<PrinterId, PrinterInfo> mPrinters;
    private List<PrinterId> mTrackedPrinters;
    private ArrayMap<PrinterId, PrinterInfo> mLastSentPrinters;
    private IPrintServiceClient mObserver;
    private boolean mIsDestroyed;
    private boolean mIsDiscoveryStarted;

    private void $$robo$$android_printservice_PrinterDiscoverySession$__constructor__() {
        this.mPrinters = new ArrayMap();
        this.mTrackedPrinters = new ArrayList<PrinterId>();
        this.mId = sIdCounter++;
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$setObserver(IPrintServiceClient observer) {
        this.mObserver = observer;
        if (!this.mPrinters.isEmpty()) {
            try {
                this.mObserver.onPrintersAdded(new ParceledListSlice<PrinterInfo>(this.getPrinters()));
            }
            catch (RemoteException re) {
                Log.e("PrinterDiscoverySession", "Error sending added printers", re);
            }
        }
    }

    private final int $$robo$$android_printservice_PrinterDiscoverySession$getId() {
        return this.mId;
    }

    private final List<PrinterInfo> $$robo$$android_printservice_PrinterDiscoverySession$getPrinters() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            return Collections.emptyList();
        }
        return new ArrayList<PrinterInfo>(this.mPrinters.values());
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$addPrinters(List<PrinterInfo> printers) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            Log.w("PrinterDiscoverySession", "Not adding printers - session destroyed.");
            return;
        }
        if (this.mIsDiscoveryStarted) {
            ArrayList<PrinterInfo> addedPrinters = null;
            int addedPrinterCount = printers.size();
            for (int i = 0; i < addedPrinterCount; ++i) {
                PrinterInfo addedPrinter = printers.get(i);
                PrinterInfo oldPrinter = this.mPrinters.put(addedPrinter.getId(), addedPrinter);
                if (oldPrinter != null && oldPrinter.equals(addedPrinter)) continue;
                if (addedPrinters == null) {
                    addedPrinters = new ArrayList<PrinterInfo>();
                }
                addedPrinters.add(addedPrinter);
            }
            if (addedPrinters != null) {
                try {
                    this.mObserver.onPrintersAdded(new ParceledListSlice(addedPrinters));
                }
                catch (RemoteException re) {
                    Log.e("PrinterDiscoverySession", "Error sending added printers", re);
                }
            }
        } else {
            if (this.mLastSentPrinters == null) {
                this.mLastSentPrinters = new ArrayMap<PrinterId, PrinterInfo>(this.mPrinters);
            }
            int addedPrinterCount = printers.size();
            for (int i = 0; i < addedPrinterCount; ++i) {
                PrinterInfo addedPrinter = printers.get(i);
                if (this.mPrinters.get(addedPrinter.getId()) != null) continue;
                this.mPrinters.put(addedPrinter.getId(), addedPrinter);
            }
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$removePrinters(List<PrinterId> printerIds) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            Log.w("PrinterDiscoverySession", "Not removing printers - session destroyed.");
            return;
        }
        if (this.mIsDiscoveryStarted) {
            ArrayList<PrinterId> removedPrinterIds = new ArrayList<PrinterId>();
            int removedPrinterIdCount = printerIds.size();
            for (int i = 0; i < removedPrinterIdCount; ++i) {
                PrinterId removedPrinterId = printerIds.get(i);
                if (this.mPrinters.remove(removedPrinterId) == null) continue;
                removedPrinterIds.add(removedPrinterId);
            }
            if (!removedPrinterIds.isEmpty()) {
                try {
                    this.mObserver.onPrintersRemoved(new ParceledListSlice(removedPrinterIds));
                }
                catch (RemoteException re) {
                    Log.e("PrinterDiscoverySession", "Error sending removed printers", re);
                }
            }
        } else {
            if (this.mLastSentPrinters == null) {
                this.mLastSentPrinters = new ArrayMap<PrinterId, PrinterInfo>(this.mPrinters);
            }
            int removedPrinterIdCount = printerIds.size();
            for (int i = 0; i < removedPrinterIdCount; ++i) {
                PrinterId removedPrinterId = printerIds.get(i);
                this.mPrinters.remove(removedPrinterId);
            }
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$sendOutOfDiscoveryPeriodPrinterChanges() {
        if (this.mLastSentPrinters == null || this.mLastSentPrinters.isEmpty()) {
            this.mLastSentPrinters = null;
            return;
        }
        ArrayList<PrinterInfo> addedPrinters = null;
        for (PrinterInfo printerInfo : this.mPrinters.values()) {
            PrinterInfo sentPrinter = this.mLastSentPrinters.get(printerInfo.getId());
            if (sentPrinter != null && sentPrinter.equals(printerInfo)) continue;
            if (addedPrinters == null) {
                addedPrinters = new ArrayList<PrinterInfo>();
            }
            addedPrinters.add(printerInfo);
        }
        if (addedPrinters != null) {
            try {
                this.mObserver.onPrintersAdded(new ParceledListSlice(addedPrinters));
            }
            catch (RemoteException re) {
                Log.e("PrinterDiscoverySession", "Error sending added printers", re);
            }
        }
        ArrayList<PrinterId> removedPrinterIds = null;
        for (PrinterInfo sentPrinter : this.mLastSentPrinters.values()) {
            if (this.mPrinters.containsKey(sentPrinter.getId())) continue;
            if (removedPrinterIds == null) {
                removedPrinterIds = new ArrayList<PrinterId>();
            }
            removedPrinterIds.add(sentPrinter.getId());
        }
        if (removedPrinterIds != null) {
            try {
                this.mObserver.onPrintersRemoved(new ParceledListSlice(removedPrinterIds));
            }
            catch (RemoteException remoteException) {
                Log.e("PrinterDiscoverySession", "Error sending removed printers", remoteException);
            }
        }
        this.mLastSentPrinters = null;
    }

    public abstract void onStartPrinterDiscovery(List<PrinterId> var1);

    public abstract void onStopPrinterDiscovery();

    public abstract void onValidatePrinters(List<PrinterId> var1);

    public abstract void onStartPrinterStateTracking(PrinterId var1);

    private final void $$robo$$android_printservice_PrinterDiscoverySession$onRequestCustomPrinterIcon(PrinterId printerId, CancellationSignal cancellationSignal, CustomPrinterIconCallback callback) {
    }

    public abstract void onStopPrinterStateTracking(PrinterId var1);

    private final List<PrinterId> $$robo$$android_printservice_PrinterDiscoverySession$getTrackedPrinters() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mIsDestroyed) {
            return Collections.emptyList();
        }
        return new ArrayList<PrinterId>(this.mTrackedPrinters);
    }

    public abstract void onDestroy();

    private final boolean $$robo$$android_printservice_PrinterDiscoverySession$isDestroyed() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mIsDestroyed;
    }

    private final boolean $$robo$$android_printservice_PrinterDiscoverySession$isPrinterDiscoveryStarted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mIsDiscoveryStarted;
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$startPrinterDiscovery(List<PrinterId> priorityList) {
        if (!this.mIsDestroyed) {
            this.mIsDiscoveryStarted = true;
            this.sendOutOfDiscoveryPeriodPrinterChanges();
            if (priorityList == null) {
                priorityList = Collections.emptyList();
            }
            this.onStartPrinterDiscovery(priorityList);
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$stopPrinterDiscovery() {
        if (!this.mIsDestroyed) {
            this.mIsDiscoveryStarted = false;
            this.onStopPrinterDiscovery();
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$validatePrinters(List<PrinterId> printerIds) {
        if (!this.mIsDestroyed && this.mObserver != null) {
            this.onValidatePrinters(printerIds);
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$startPrinterStateTracking(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null && !this.mTrackedPrinters.contains(printerId)) {
            this.mTrackedPrinters.add(printerId);
            this.onStartPrinterStateTracking(printerId);
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$requestCustomPrinterIcon(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null) {
            CustomPrinterIconCallback callback = new CustomPrinterIconCallback(printerId, this.mObserver);
            this.onRequestCustomPrinterIcon(printerId, new CancellationSignal(), callback);
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$stopPrinterStateTracking(PrinterId printerId) {
        if (!this.mIsDestroyed && this.mObserver != null && this.mTrackedPrinters.remove(printerId)) {
            this.onStopPrinterStateTracking(printerId);
        }
    }

    private final void $$robo$$android_printservice_PrinterDiscoverySession$destroy() {
        if (!this.mIsDestroyed) {
            this.mIsDestroyed = true;
            this.mIsDiscoveryStarted = false;
            this.mPrinters.clear();
            this.mLastSentPrinters = null;
            this.mObserver = null;
            this.onDestroy();
        }
    }

    static void __staticInitializer__() {
        sIdCounter = 0;
    }

    private void __constructor__() {
        this.$$robo$$android_printservice_PrinterDiscoverySession$__constructor__();
    }

    public PrinterDiscoverySession() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_printservice_PrinterDiscoverySession$__constructor__(), this);
    }

    void setObserver(IPrintServiceClient iPrintServiceClient) {
        InvokeDynamicSupport.bootstrap("setObserver", $$robo$$android_printservice_PrinterDiscoverySession$setObserver(android.printservice.IPrintServiceClient ), this, iPrintServiceClient);
    }

    int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_printservice_PrinterDiscoverySession$getId(), this);
    }

    public List<PrinterInfo> getPrinters() {
        return InvokeDynamicSupport.bootstrap("getPrinters", $$robo$$android_printservice_PrinterDiscoverySession$getPrinters(), this);
    }

    public void addPrinters(List<PrinterInfo> list) {
        InvokeDynamicSupport.bootstrap("addPrinters", $$robo$$android_printservice_PrinterDiscoverySession$addPrinters(java.util.List<android.print.PrinterInfo> ), this, list);
    }

    public void removePrinters(List<PrinterId> list) {
        InvokeDynamicSupport.bootstrap("removePrinters", $$robo$$android_printservice_PrinterDiscoverySession$removePrinters(java.util.List<android.print.PrinterId> ), this, list);
    }

    private void sendOutOfDiscoveryPeriodPrinterChanges() {
        InvokeDynamicSupport.bootstrap("sendOutOfDiscoveryPeriodPrinterChanges", $$robo$$android_printservice_PrinterDiscoverySession$sendOutOfDiscoveryPeriodPrinterChanges(), this);
    }

    public void onRequestCustomPrinterIcon(PrinterId printerId, CancellationSignal cancellationSignal, CustomPrinterIconCallback customPrinterIconCallback) {
        InvokeDynamicSupport.bootstrap("onRequestCustomPrinterIcon", $$robo$$android_printservice_PrinterDiscoverySession$onRequestCustomPrinterIcon(android.print.PrinterId android.os.CancellationSignal android.printservice.CustomPrinterIconCallback ), this, printerId, cancellationSignal, customPrinterIconCallback);
    }

    public List<PrinterId> getTrackedPrinters() {
        return InvokeDynamicSupport.bootstrap("getTrackedPrinters", $$robo$$android_printservice_PrinterDiscoverySession$getTrackedPrinters(), this);
    }

    public boolean isDestroyed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyed", $$robo$$android_printservice_PrinterDiscoverySession$isDestroyed(), this);
    }

    public boolean isPrinterDiscoveryStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrinterDiscoveryStarted", $$robo$$android_printservice_PrinterDiscoverySession$isPrinterDiscoveryStarted(), this);
    }

    void startPrinterDiscovery(List<PrinterId> list) {
        InvokeDynamicSupport.bootstrap("startPrinterDiscovery", $$robo$$android_printservice_PrinterDiscoverySession$startPrinterDiscovery(java.util.List<android.print.PrinterId> ), this, list);
    }

    void stopPrinterDiscovery() {
        InvokeDynamicSupport.bootstrap("stopPrinterDiscovery", $$robo$$android_printservice_PrinterDiscoverySession$stopPrinterDiscovery(), this);
    }

    void validatePrinters(List<PrinterId> list) {
        InvokeDynamicSupport.bootstrap("validatePrinters", $$robo$$android_printservice_PrinterDiscoverySession$validatePrinters(java.util.List<android.print.PrinterId> ), this, list);
    }

    void startPrinterStateTracking(PrinterId printerId) {
        InvokeDynamicSupport.bootstrap("startPrinterStateTracking", $$robo$$android_printservice_PrinterDiscoverySession$startPrinterStateTracking(android.print.PrinterId ), this, printerId);
    }

    void requestCustomPrinterIcon(PrinterId printerId) {
        InvokeDynamicSupport.bootstrap("requestCustomPrinterIcon", $$robo$$android_printservice_PrinterDiscoverySession$requestCustomPrinterIcon(android.print.PrinterId ), this, printerId);
    }

    void stopPrinterStateTracking(PrinterId printerId) {
        InvokeDynamicSupport.bootstrap("stopPrinterStateTracking", $$robo$$android_printservice_PrinterDiscoverySession$stopPrinterStateTracking(android.print.PrinterId ), this, printerId);
    }

    void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_printservice_PrinterDiscoverySession$destroy(), this);
    }

    static {
        RobolectricInternals.classInitializing(PrinterDiscoverySession.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrinterDiscoverySession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

