/*
 * Decompiled with CFR 0.152.
 */
package android.se.omapi;

import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.se.omapi.ISecureElementChannel;
import android.se.omapi.SEService;
import android.se.omapi.Session;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Channel
implements java.nio.channels.Channel,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "OMAPI.Channel";
    private Session mSession;
    private ISecureElementChannel mChannel;
    private SEService mService;
    private Object mLock;

    private void $$robo$$android_se_omapi_Channel$__constructor__(SEService service, Session session, ISecureElementChannel channel) {
        this.mLock = new Object();
        if (service == null || session == null || channel == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.mService = service;
        this.mSession = session;
        this.mChannel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_se_omapi_Channel$close() {
        if (this.isOpen()) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.mChannel.close();
                }
                catch (Exception e) {
                    Log.e("OMAPI.Channel", "Error closing channel", e);
                }
            }
        }
    }

    private final boolean $$robo$$android_se_omapi_Channel$isOpen() {
        if (!this.mService.isConnected()) {
            Log.e("OMAPI.Channel", "service not connected to system");
            return false;
        }
        try {
            return !this.mChannel.isClosed();
        }
        catch (RemoteException e) {
            Log.e("OMAPI.Channel", "Exception in isClosed()");
            return false;
        }
    }

    private final boolean $$robo$$android_se_omapi_Channel$isBasicChannel() {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            return this.mChannel.isBasicChannel();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private final byte[] $$robo$$android_se_omapi_Channel$transmit(byte[] command) throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                byte[] response = this.mChannel.transmit(command);
                if (response == null) {
                    throw new IOException("Error in communicating with Secure Element");
                }
                return response;
            }
            catch (ServiceSpecificException e) {
                throw new IOException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    private final Session $$robo$$android_se_omapi_Channel$getSession() {
        return this.mSession;
    }

    private final byte[] $$robo$$android_se_omapi_Channel$getSelectResponse() {
        byte[] response;
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            response = this.mChannel.getSelectResponse();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
        if (response != null && response.length == 0) {
            response = null;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_se_omapi_Channel$selectNext() throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            Object object = this.mLock;
            synchronized (object) {
                return this.mChannel.selectNext();
            }
        }
        catch (ServiceSpecificException e) {
            throw new IOException(e.getMessage());
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private void __constructor__(SEService sEService, Session session, ISecureElementChannel iSecureElementChannel) {
        this.$$robo$$android_se_omapi_Channel$__constructor__(sEService, session, iSecureElementChannel);
    }

    public Channel(SEService sEService, Session session, ISecureElementChannel iSecureElementChannel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_se_omapi_Channel$__constructor__(android.se.omapi.SEService android.se.omapi.Session android.se.omapi.ISecureElementChannel ), this, sEService, session, iSecureElementChannel);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_se_omapi_Channel$close(), this);
    }

    @Override
    public boolean isOpen() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpen", $$robo$$android_se_omapi_Channel$isOpen(), this);
    }

    public boolean isBasicChannel() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBasicChannel", $$robo$$android_se_omapi_Channel$isBasicChannel(), this);
    }

    public byte[] transmit(byte[] byArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("transmit", $$robo$$android_se_omapi_Channel$transmit(byte[] ), this, byArray);
    }

    public Session getSession() {
        return InvokeDynamicSupport.bootstrap("getSession", $$robo$$android_se_omapi_Channel$getSession(), this);
    }

    public byte[] getSelectResponse() {
        return InvokeDynamicSupport.bootstrap("getSelectResponse", $$robo$$android_se_omapi_Channel$getSelectResponse(), this);
    }

    public boolean selectNext() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("selectNext", $$robo$$android_se_omapi_Channel$selectNext(), this);
    }

    public /* synthetic */ Channel() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Channel)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

