/*
 * Decompiled with CFR 0.152.
 */
package android.se.omapi;

import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.se.omapi.Channel;
import android.se.omapi.ISecureElementChannel;
import android.se.omapi.ISecureElementSession;
import android.se.omapi.Reader;
import android.se.omapi.SEService;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Session
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Object mLock;
    private SEService mService;
    private Reader mReader;
    private ISecureElementSession mSession;
    private static String TAG = "OMAPI.Session";

    private void $$robo$$android_se_omapi_Session$__constructor__(SEService service, ISecureElementSession session, Reader reader) {
        this.mLock = new Object();
        if (service == null || reader == null || session == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.mService = service;
        this.mReader = reader;
        this.mSession = session;
    }

    private final Reader $$robo$$android_se_omapi_Session$getReader() {
        return this.mReader;
    }

    private final byte[] $$robo$$android_se_omapi_Session$getATR() {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            return this.mSession.getAtr();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_se_omapi_Session$close() {
        if (!this.mService.isConnected()) {
            Log.e("OMAPI.Session", "service not connected to system");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mSession.close();
            }
            catch (RemoteException e) {
                Log.e("OMAPI.Session", "Error closing session", e);
            }
        }
    }

    private final boolean $$robo$$android_se_omapi_Session$isClosed() {
        try {
            return this.mSession.isClosed();
        }
        catch (RemoteException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_se_omapi_Session$closeChannels() {
        if (!this.mService.isConnected()) {
            Log.e("OMAPI.Session", "service not connected to system");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mSession.closeChannels();
            }
            catch (RemoteException e) {
                Log.e("OMAPI.Session", "Error closing channels", e);
            }
        }
    }

    private final Channel $$robo$$android_se_omapi_Session$openBasicChannel(byte[] aid, byte p2) throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                ISecureElementChannel channel = this.mSession.openBasicChannel(aid, p2, this.mReader.getSEService().getListener());
                if (channel == null) {
                    return null;
                }
                return new Channel(this.mService, this, channel);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == 1) {
                    throw new IOException(e.getMessage());
                }
                if (e.errorCode == 2) {
                    throw new NoSuchElementException(e.getMessage());
                }
                throw new IllegalStateException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    private final Channel $$robo$$android_se_omapi_Session$openBasicChannel(byte[] aid) throws IOException {
        return this.openBasicChannel(aid, (byte)0);
    }

    private final Channel $$robo$$android_se_omapi_Session$openLogicalChannel(byte[] aid, byte p2) throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                ISecureElementChannel channel = this.mSession.openLogicalChannel(aid, p2, this.mReader.getSEService().getListener());
                if (channel == null) {
                    return null;
                }
                return new Channel(this.mService, this, channel);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == 1) {
                    throw new IOException(e.getMessage());
                }
                if (e.errorCode == 2) {
                    throw new NoSuchElementException(e.getMessage());
                }
                throw new IllegalStateException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    private final Channel $$robo$$android_se_omapi_Session$openLogicalChannel(byte[] aid) throws IOException {
        return this.openLogicalChannel(aid, (byte)0);
    }

    private void __constructor__(SEService sEService, ISecureElementSession iSecureElementSession, Reader reader) {
        this.$$robo$$android_se_omapi_Session$__constructor__(sEService, iSecureElementSession, reader);
    }

    public Session(SEService sEService, ISecureElementSession iSecureElementSession, Reader reader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_se_omapi_Session$__constructor__(android.se.omapi.SEService android.se.omapi.ISecureElementSession android.se.omapi.Reader ), this, sEService, iSecureElementSession, reader);
    }

    public Reader getReader() {
        return InvokeDynamicSupport.bootstrap("getReader", $$robo$$android_se_omapi_Session$getReader(), this);
    }

    public byte[] getATR() {
        return InvokeDynamicSupport.bootstrap("getATR", $$robo$$android_se_omapi_Session$getATR(), this);
    }

    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_se_omapi_Session$close(), this);
    }

    public boolean isClosed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_se_omapi_Session$isClosed(), this);
    }

    public void closeChannels() {
        InvokeDynamicSupport.bootstrap("closeChannels", $$robo$$android_se_omapi_Session$closeChannels(), this);
    }

    public Channel openBasicChannel(byte[] byArray, byte by) throws IOException {
        return InvokeDynamicSupport.bootstrap("openBasicChannel", $$robo$$android_se_omapi_Session$openBasicChannel(byte[] byte ), this, byArray, by);
    }

    public Channel openBasicChannel(byte[] byArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("openBasicChannel", $$robo$$android_se_omapi_Session$openBasicChannel(byte[] ), this, byArray);
    }

    public Channel openLogicalChannel(byte[] byArray, byte by) throws IOException {
        return InvokeDynamicSupport.bootstrap("openLogicalChannel", $$robo$$android_se_omapi_Session$openLogicalChannel(byte[] byte ), this, byArray, by);
    }

    public Channel openLogicalChannel(byte[] byArray) throws IOException {
        return InvokeDynamicSupport.bootstrap("openLogicalChannel", $$robo$$android_se_omapi_Session$openLogicalChannel(byte[] ), this, byArray);
    }

    public /* synthetic */ Session() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Session)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

