/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.OperationResult;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.KeyStoreConnectException;
import android.security.keystore.KeyStoreCryptoOperation;
import android.security.keystore.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore.KeyStoreCryptoOperationUtils;
import android.security.keystore.KeymasterUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AndroidKeyStoreHmacSpi
extends MacSpi
implements KeyStoreCryptoOperation,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private KeyStore mKeyStore;
    private int mKeymasterDigest;
    private int mMacSizeBits;
    private AndroidKeyStoreSecretKey mKey;
    private KeyStoreCryptoOperationChunkedStreamer mChunkedStreamer;
    private IBinder mOperationToken;
    private long mOperationHandle;

    private void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$__constructor__(int keymasterDigest) {
        this.mKeyStore = KeyStore.getInstance();
        this.mKeymasterDigest = keymasterDigest;
        this.mMacSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineGetMacLength() {
        return (this.mMacSizeBits + 7) / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.resetAll();
        boolean success = false;
        try {
            this.init(key, params);
            this.ensureKeystoreOperationInitialized();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("Only Android KeyStore secret keys supported. Key: " + key);
        }
        this.mKey = (AndroidKeyStoreSecretKey)key;
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Unsupported algorithm parameters: " + params);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$resetAll() {
        this.mKey = null;
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mKeyStore.abort(operationToken);
        }
        this.mOperationToken = null;
        this.mOperationHandle = 0L;
        this.mChunkedStreamer = null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$resetWhilePreservingInitState() {
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mKeyStore.abort(operationToken);
        }
        this.mOperationToken = null;
        this.mOperationHandle = 0L;
        this.mChunkedStreamer = null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineReset() {
        this.resetWhilePreservingInitState();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$ensureKeystoreOperationInitialized() throws InvalidKeyException {
        if (this.mChunkedStreamer != null) {
            return;
        }
        if (this.mKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        KeymasterArguments keymasterArgs = new KeymasterArguments();
        keymasterArgs.addEnum(0x10000002, 128);
        keymasterArgs.addEnum(0x20000005, this.mKeymasterDigest);
        keymasterArgs.addUnsignedInt(805307371, this.mMacSizeBits);
        OperationResult opResult = this.mKeyStore.begin(this.mKey.getAlias(), 2, true, keymasterArgs, null, this.mKey.getUid());
        if (opResult == null) {
            throw new KeyStoreConnectException();
        }
        this.mOperationToken = opResult.token;
        this.mOperationHandle = opResult.operationHandle;
        InvalidKeyException e = KeyStoreCryptoOperationUtils.getInvalidKeyExceptionForInit(this.mKeyStore, this.mKey, opResult.resultCode);
        if (e != null) {
            throw e;
        }
        if (this.mOperationToken == null) {
            throw new ProviderException("Keystore returned null operation token");
        }
        if (this.mOperationHandle == 0L) {
            throw new ProviderException("Keystore returned invalid operation handle");
        }
        this.mChunkedStreamer = new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(this.mKeyStore, this.mOperationToken));
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineUpdate(byte input) {
        this.engineUpdate(new byte[]{input}, 0, 1);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineUpdate(byte[] input, int offset, int len) {
        byte[] output;
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new ProviderException("Failed to reinitialize MAC", e);
        }
        try {
            output = this.mChunkedStreamer.update(input, offset, len);
        }
        catch (KeyStoreException e) {
            throw new ProviderException("Keystore operation failed", e);
        }
        if (output != null && output.length != 0) {
            throw new ProviderException("Update operation unexpectedly produced output");
        }
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineDoFinal() {
        byte[] result;
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new ProviderException("Failed to reinitialize MAC", e);
        }
        try {
            result = this.mChunkedStreamer.doFinal(null, 0, 0, null, null);
        }
        catch (KeyStoreException e) {
            throw new ProviderException("Keystore operation failed", e);
        }
        this.resetWhilePreservingInitState();
        return result;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$finalize() throws Throwable {
        try {
            IBinder operationToken = this.mOperationToken;
            if (operationToken != null) {
                this.mKeyStore.abort(operationToken);
            }
        }
        finally {
            super.finalize();
        }
    }

    private final long $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$getOperationHandle() {
        return this.mOperationHandle;
    }

    private void __constructor__(int n) {
        this.$$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$__constructor__(n);
    }

    public AndroidKeyStoreHmacSpi(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$__constructor__(int ), this, n);
    }

    @Override
    protected int engineGetMacLength() {
        return (int)InvokeDynamicSupport.bootstrap("engineGetMacLength", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineGetMacLength(), this);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("engineInit", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineInit(java.security.Key java.security.spec.AlgorithmParameterSpec ), this, key, algorithmParameterSpec);
    }

    private void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$init(java.security.Key java.security.spec.AlgorithmParameterSpec ), this, key, algorithmParameterSpec);
    }

    private void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$resetAll(), this);
    }

    private void resetWhilePreservingInitState() {
        InvokeDynamicSupport.bootstrap("resetWhilePreservingInitState", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$resetWhilePreservingInitState(), this);
    }

    @Override
    protected void engineReset() {
        InvokeDynamicSupport.bootstrap("engineReset", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineReset(), this);
    }

    private void ensureKeystoreOperationInitialized() throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("ensureKeystoreOperationInitialized", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$ensureKeystoreOperationInitialized(), this);
    }

    @Override
    protected void engineUpdate(byte by) {
        InvokeDynamicSupport.bootstrap("engineUpdate", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineUpdate(byte ), this, by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("engineUpdate", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineUpdate(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    protected byte[] engineDoFinal() {
        return InvokeDynamicSupport.bootstrap("engineDoFinal", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$engineDoFinal(), this);
    }

    public void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$finalize(), this);
    }

    @Override
    public long getOperationHandle() {
        return (long)InvokeDynamicSupport.bootstrap("getOperationHandle", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi$getOperationHandle(), this);
    }

    public /* synthetic */ AndroidKeyStoreHmacSpi() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreHmacSpi)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class HmacSHA512
    extends AndroidKeyStoreHmacSpi
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA512$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA512$__constructor__();
        }

        public HmacSHA512() {
            super(6);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA512$__constructor__(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HmacSHA512)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class HmacSHA384
    extends AndroidKeyStoreHmacSpi
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA384$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA384$__constructor__();
        }

        public HmacSHA384() {
            super(5);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA384$__constructor__(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HmacSHA384)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class HmacSHA256
    extends AndroidKeyStoreHmacSpi
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA256$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA256$__constructor__();
        }

        public HmacSHA256() {
            super(4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA256$__constructor__(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HmacSHA256)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class HmacSHA224
    extends AndroidKeyStoreHmacSpi
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA224$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA224$__constructor__();
        }

        public HmacSHA224() {
            super(3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA224$__constructor__(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HmacSHA224)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class HmacSHA1
    extends AndroidKeyStoreHmacSpi
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA1$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA1$__constructor__();
        }

        public HmacSHA1() {
            super(2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreHmacSpi_HmacSHA1$__constructor__(), this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HmacSHA1)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

