/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.GateKeeper;
import android.security.KeyStore;
import android.security.keymaster.KeyCharacteristics;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import android.security.keystore.KeyProperties;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidKeyStoreSecretKeyFactorySpi
extends SecretKeyFactorySpi
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private KeyStore mKeyStore;

    private void $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$__constructor__() {
        this.mKeyStore = KeyStore.getInstance();
    }

    private final KeySpec $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$engineGetKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
        String entryAlias;
        if (keySpecClass == null) {
            throw new InvalidKeySpecException("keySpecClass == null");
        }
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeySpecException("Only Android KeyStore secret keys supported: " + (key != null ? key.getClass().getName() : "null"));
        }
        if (SecretKeySpec.class.isAssignableFrom(keySpecClass)) {
            throw new InvalidKeySpecException("Key material export of Android KeyStore keys is not supported");
        }
        if (!KeyInfo.class.equals((Object)keySpecClass)) {
            throw new InvalidKeySpecException("Unsupported key spec: " + keySpecClass.getName());
        }
        AndroidKeyStoreKey keystoreKey = (AndroidKeyStoreKey)((Object)key);
        String keyAliasInKeystore = keystoreKey.getAlias();
        if (keyAliasInKeystore.startsWith("USRPKEY_")) {
            entryAlias = keyAliasInKeystore.substring("USRPKEY_".length());
        } else if (keyAliasInKeystore.startsWith("USRSKEY_")) {
            entryAlias = keyAliasInKeystore.substring("USRSKEY_".length());
        } else {
            throw new InvalidKeySpecException("Invalid key alias: " + keyAliasInKeystore);
        }
        return AndroidKeyStoreSecretKeyFactorySpi.getKeyInfo(this.mKeyStore, entryAlias, keyAliasInKeystore, keystoreKey.getUid());
    }

    private static final KeyInfo $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$getKeyInfo(KeyStore keyStore, String entryAlias, String keyAliasInKeystore, int keyUid) {
        List<BigInteger> keymasterSecureUserIds;
        int keymasterHwEnforcedUserAuthenticators;
        int keymasterSwEnforcedUserAuthenticators;
        String[] blockModes;
        String[] digests;
        String[] signaturePaddings;
        String[] encryptionPaddings;
        int purposes;
        int keySize;
        int origin;
        boolean insideSecureHardware;
        KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
        int errorCode = keyStore.getKeyCharacteristics(keyAliasInKeystore, null, null, keyUid, keyCharacteristics);
        if (errorCode != 1) {
            throw new ProviderException("Failed to obtain information about key. Keystore error: " + errorCode);
        }
        try {
            if (keyCharacteristics.hwEnforced.containsTag(268436158)) {
                insideSecureHardware = true;
                origin = KeyProperties.Origin.fromKeymaster(keyCharacteristics.hwEnforced.getEnum(268436158, -1));
            } else if (keyCharacteristics.swEnforced.containsTag(268436158)) {
                insideSecureHardware = false;
                origin = KeyProperties.Origin.fromKeymaster(keyCharacteristics.swEnforced.getEnum(268436158, -1));
            } else {
                throw new ProviderException("Key origin not available");
            }
            long keySizeUnsigned = keyCharacteristics.getUnsignedInt(0x30000003, -1L);
            if (keySizeUnsigned == -1L) {
                throw new ProviderException("Key size not available");
            }
            if (keySizeUnsigned > Integer.MAX_VALUE) {
                throw new ProviderException("Key too large: " + keySizeUnsigned + " bits");
            }
            keySize = (int)keySizeUnsigned;
            purposes = KeyProperties.Purpose.allFromKeymaster(keyCharacteristics.getEnums(0x20000001));
            ArrayList<String> encryptionPaddingsList = new ArrayList<String>();
            ArrayList<String> signaturePaddingsList = new ArrayList<String>();
            for (int keymasterPadding : keyCharacteristics.getEnums(0x20000006)) {
                try {
                    String jcaPadding = KeyProperties.EncryptionPadding.fromKeymaster(keymasterPadding);
                    encryptionPaddingsList.add(jcaPadding);
                }
                catch (IllegalArgumentException e) {
                    try {
                        String padding = KeyProperties.SignaturePadding.fromKeymaster(keymasterPadding);
                        signaturePaddingsList.add(padding);
                    }
                    catch (IllegalArgumentException e2) {
                        throw new ProviderException("Unsupported encryption padding: " + keymasterPadding);
                    }
                }
            }
            encryptionPaddings = encryptionPaddingsList.toArray(new String[encryptionPaddingsList.size()]);
            signaturePaddings = signaturePaddingsList.toArray(new String[signaturePaddingsList.size()]);
            digests = KeyProperties.Digest.allFromKeymaster(keyCharacteristics.getEnums(0x20000005));
            blockModes = KeyProperties.BlockMode.allFromKeymaster(keyCharacteristics.getEnums(0x20000004));
            keymasterSwEnforcedUserAuthenticators = keyCharacteristics.swEnforced.getEnum(268435960, 0);
            keymasterHwEnforcedUserAuthenticators = keyCharacteristics.hwEnforced.getEnum(268435960, 0);
            keymasterSecureUserIds = keyCharacteristics.getUnsignedLongs(-1610612234);
        }
        catch (IllegalArgumentException e) {
            throw new ProviderException("Unsupported key characteristic", e);
        }
        Date keyValidityStart = keyCharacteristics.getDate(1610613136);
        Date keyValidityForOriginationEnd = keyCharacteristics.getDate(1610613137);
        Date keyValidityForConsumptionEnd = keyCharacteristics.getDate(1610613138);
        boolean userAuthenticationRequired = !keyCharacteristics.getBoolean(1879048695);
        long userAuthenticationValidityDurationSeconds = keyCharacteristics.getUnsignedInt(805306873, -1L);
        if (userAuthenticationValidityDurationSeconds > Integer.MAX_VALUE) {
            throw new ProviderException("User authentication timeout validity too long: " + userAuthenticationValidityDurationSeconds + " seconds");
        }
        boolean userAuthenticationRequirementEnforcedBySecureHardware = userAuthenticationRequired && keymasterHwEnforcedUserAuthenticators != 0 && keymasterSwEnforcedUserAuthenticators == 0;
        boolean userAuthenticationValidWhileOnBody = keyCharacteristics.hwEnforced.getBoolean(1879048698);
        boolean trustedUserPresenceRequred = keyCharacteristics.hwEnforced.getBoolean(1879048699);
        boolean invalidatedByBiometricEnrollment = false;
        if (keymasterSwEnforcedUserAuthenticators == 2 || keymasterHwEnforcedUserAuthenticators == 2) {
            invalidatedByBiometricEnrollment = keymasterSecureUserIds != null && !keymasterSecureUserIds.isEmpty() && !keymasterSecureUserIds.contains(AndroidKeyStoreSecretKeyFactorySpi.getGateKeeperSecureUserId());
        }
        boolean userConfirmationRequired = keyCharacteristics.hwEnforced.getBoolean(1879048700);
        return new KeyInfo(entryAlias, insideSecureHardware, origin, keySize, keyValidityStart, keyValidityForOriginationEnd, keyValidityForConsumptionEnd, purposes, encryptionPaddings, signaturePaddings, digests, blockModes, userAuthenticationRequired, (int)userAuthenticationValidityDurationSeconds, userAuthenticationRequirementEnforcedBySecureHardware, userAuthenticationValidWhileOnBody, trustedUserPresenceRequred, invalidatedByBiometricEnrollment, userConfirmationRequired);
    }

    private static final BigInteger $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$getGateKeeperSecureUserId() throws ProviderException {
        try {
            return BigInteger.valueOf(GateKeeper.getSecureUserId());
        }
        catch (IllegalStateException e) {
            throw new ProviderException("Failed to get GateKeeper secure user ID", e);
        }
    }

    private final SecretKey $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("To generate secret key in Android Keystore, use KeyGenerator initialized with " + KeyGenParameterSpec.class.getName());
    }

    private final SecretKey $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("To import a secret key into Android Keystore, use KeyStore.setEntry");
        }
        return key;
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$__constructor__();
    }

    public AndroidKeyStoreSecretKeyFactorySpi() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$__constructor__(), this);
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        return InvokeDynamicSupport.bootstrap("engineGetKeySpec", $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$engineGetKeySpec(javax.crypto.SecretKey java.lang.Class ), this, secretKey, clazz);
    }

    static KeyInfo getKeyInfo(KeyStore keyStore, String string2, String string3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getKeyInfo", $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$getKeyInfo(android.security.KeyStore java.lang.String java.lang.String int ), (KeyStore)keyStore, (String)string2, (String)string3, (int)n);
    }

    private static BigInteger getGateKeeperSecureUserId() throws ProviderException {
        return InvokeDynamicSupport.bootstrapStatic("getGateKeeperSecureUserId", $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$getGateKeeperSecureUserId());
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        return InvokeDynamicSupport.bootstrap("engineGenerateSecret", $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$engineGenerateSecret(java.security.spec.KeySpec ), this, keySpec);
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        return InvokeDynamicSupport.bootstrap("engineTranslateKey", $$robo$$android_security_keystore_AndroidKeyStoreSecretKeyFactorySpi$engineTranslateKey(javax.crypto.SecretKey ), this, secretKey);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreSecretKeyFactorySpi)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

