/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.annotation.SystemApi;
import android.content.Context;
import android.os.Build;
import android.security.KeyStore;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.DeviceIdAttestationException;
import android.security.keystore.KeyAttestationException;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public abstract class AttestationUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int ID_TYPE_SERIAL = 1;
    public static int ID_TYPE_IMEI = 2;
    public static int ID_TYPE_MEID = 3;

    private void $$robo$$android_security_keystore_AttestationUtils$__constructor__() {
    }

    private static final X509Certificate[] $$robo$$android_security_keystore_AttestationUtils$parseCertificateChain(KeymasterCertificateChain kmChain) throws KeyAttestationException {
        List<byte[]> rawChain = kmChain.getCertificates();
        if (rawChain.size() < 2) {
            throw new KeyAttestationException("Attestation certificate chain contained " + rawChain.size() + " entries. At least two are required.");
        }
        ByteArrayOutputStream concatenatedRawChain = new ByteArrayOutputStream();
        try {
            for (byte[] cert : rawChain) {
                concatenatedRawChain.write(cert);
            }
            return CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(concatenatedRawChain.toByteArray())).toArray(new X509Certificate[0]);
        }
        catch (Exception e) {
            throw new KeyAttestationException("Unable to construct certificate chain", e);
        }
    }

    private static final KeymasterArguments $$robo$$android_security_keystore_AttestationUtils$prepareAttestationArgumentsForDeviceId(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        if (idTypes == null) {
            throw new NullPointerException("Missing id types");
        }
        return AttestationUtils.prepareAttestationArguments(context, idTypes, attestationChallenge);
    }

    private static final KeymasterArguments $$robo$$android_security_keystore_AttestationUtils$prepareAttestationArguments(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        if (attestationChallenge == null) {
            throw new NullPointerException("Missing attestation challenge");
        }
        KeymasterArguments attestArgs = new KeymasterArguments();
        attestArgs.addBytes(-1879047484, attestationChallenge);
        if (idTypes == null) {
            return attestArgs;
        }
        ArraySet<Integer> idTypesSet = new ArraySet<Integer>(idTypes.length);
        for (int idType : idTypes) {
            idTypesSet.add(idType);
        }
        TelephonyManager telephonyService = null;
        if ((idTypesSet.contains(2) || idTypesSet.contains(3)) && (telephonyService = (TelephonyManager)context.getSystemService("phone")) == null) {
            throw new DeviceIdAttestationException("Unable to access telephony service");
        }
        block6: for (Integer idType : idTypesSet) {
            switch (idType) {
                case 1: {
                    attestArgs.addBytes(-1879047479, Build.getSerial().getBytes(StandardCharsets.UTF_8));
                    continue block6;
                }
                case 2: {
                    String imei = telephonyService.getImei(0);
                    if (imei == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve IMEI");
                    }
                    attestArgs.addBytes(-1879047478, imei.getBytes(StandardCharsets.UTF_8));
                    continue block6;
                }
                case 3: {
                    String meid = telephonyService.getMeid(0);
                    if (meid == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve MEID");
                    }
                    attestArgs.addBytes(-1879047477, meid.getBytes(StandardCharsets.UTF_8));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown device ID type " + idType);
        }
        attestArgs.addBytes(-1879047482, Build.BRAND.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047481, Build.DEVICE.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047480, Build.PRODUCT.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047476, Build.MANUFACTURER.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047475, Build.MODEL.getBytes(StandardCharsets.UTF_8));
        return attestArgs;
    }

    private static final X509Certificate[] $$robo$$android_security_keystore_AttestationUtils$attestDeviceIds(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        KeymasterArguments attestArgs = AttestationUtils.prepareAttestationArgumentsForDeviceId(context, idTypes, attestationChallenge);
        KeymasterCertificateChain outChain = new KeymasterCertificateChain();
        int errorCode = KeyStore.getInstance().attestDeviceIds(attestArgs, outChain);
        if (errorCode != 1) {
            throw new DeviceIdAttestationException("Unable to perform attestation", KeyStore.getKeyStoreException(errorCode));
        }
        try {
            return AttestationUtils.parseCertificateChain(outChain);
        }
        catch (KeyAttestationException e) {
            throw new DeviceIdAttestationException(e.getMessage(), e);
        }
    }

    private static final boolean $$robo$$android_security_keystore_AttestationUtils$isChainValid(KeymasterCertificateChain chain) {
        return chain != null && chain.getCertificates().size() >= 2;
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_AttestationUtils$__constructor__();
    }

    public AttestationUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AttestationUtils$__constructor__(), this);
    }

    public static X509Certificate[] parseCertificateChain(KeymasterCertificateChain keymasterCertificateChain) throws KeyAttestationException {
        return InvokeDynamicSupport.bootstrapStatic("parseCertificateChain", $$robo$$android_security_keystore_AttestationUtils$parseCertificateChain(android.security.keymaster.KeymasterCertificateChain ), (KeymasterCertificateChain)keymasterCertificateChain);
    }

    private static KeymasterArguments prepareAttestationArgumentsForDeviceId(Context context, int[] nArray, byte[] byArray) throws DeviceIdAttestationException {
        return InvokeDynamicSupport.bootstrapStatic("prepareAttestationArgumentsForDeviceId", $$robo$$android_security_keystore_AttestationUtils$prepareAttestationArgumentsForDeviceId(android.content.Context int[] byte[] ), (Context)context, (int[])nArray, (byte[])byArray);
    }

    public static KeymasterArguments prepareAttestationArguments(Context context, int[] nArray, byte[] byArray) throws DeviceIdAttestationException {
        return InvokeDynamicSupport.bootstrapStatic("prepareAttestationArguments", $$robo$$android_security_keystore_AttestationUtils$prepareAttestationArguments(android.content.Context int[] byte[] ), (Context)context, (int[])nArray, (byte[])byArray);
    }

    public static X509Certificate[] attestDeviceIds(Context context, int[] nArray, byte[] byArray) throws DeviceIdAttestationException {
        return InvokeDynamicSupport.bootstrapStatic("attestDeviceIds", $$robo$$android_security_keystore_AttestationUtils$attestDeviceIds(android.content.Context int[] byte[] ), (Context)context, (int[])nArray, (byte[])byArray);
    }

    public static boolean isChainValid(KeymasterCertificateChain keymasterCertificateChain) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChainValid", $$robo$$android_security_keystore_AttestationUtils$isChainValid(android.security.keymaster.KeymasterCertificateChain ), (KeymasterCertificateChain)keymasterCertificateChain);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AttestationUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

