/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.ArrayUtils;
import android.security.keystore.UserAuthArgs;
import android.security.keystore.Utils;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class KeyGenParameterSpec
implements AlgorithmParameterSpec,
UserAuthArgs,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static X500Principal DEFAULT_CERT_SUBJECT;
    private static BigInteger DEFAULT_CERT_SERIAL_NUMBER;
    private static Date DEFAULT_CERT_NOT_BEFORE;
    private static Date DEFAULT_CERT_NOT_AFTER;
    private String mKeystoreAlias;
    private int mUid;
    private int mKeySize;
    private AlgorithmParameterSpec mSpec;
    private X500Principal mCertificateSubject;
    private BigInteger mCertificateSerialNumber;
    private Date mCertificateNotBefore;
    private Date mCertificateNotAfter;
    private Date mKeyValidityStart;
    private Date mKeyValidityForOriginationEnd;
    private Date mKeyValidityForConsumptionEnd;
    private int mPurposes;
    private String[] mDigests;
    private String[] mEncryptionPaddings;
    private String[] mSignaturePaddings;
    private String[] mBlockModes;
    private boolean mRandomizedEncryptionRequired;
    private boolean mUserAuthenticationRequired;
    private int mUserAuthenticationValidityDurationSeconds;
    private boolean mUserPresenceRequired;
    private byte[] mAttestationChallenge;
    private boolean mUniqueIdIncluded;
    private boolean mUserAuthenticationValidWhileOnBody;
    private boolean mInvalidatedByBiometricEnrollment;
    private boolean mIsStrongBoxBacked;
    private boolean mUserConfirmationRequired;
    private boolean mUnlockedDeviceRequired;

    private void $$robo$$android_security_keystore_KeyGenParameterSpec$__constructor__(String keyStoreAlias, int uid, int keySize, AlgorithmParameterSpec spec, X500Principal certificateSubject, BigInteger certificateSerialNumber, Date certificateNotBefore, Date certificateNotAfter, Date keyValidityStart, Date keyValidityForOriginationEnd, Date keyValidityForConsumptionEnd, int purposes, String[] digests, String[] encryptionPaddings, String[] signaturePaddings, String[] blockModes, boolean randomizedEncryptionRequired, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds, boolean userPresenceRequired, byte[] attestationChallenge, boolean uniqueIdIncluded, boolean userAuthenticationValidWhileOnBody, boolean invalidatedByBiometricEnrollment, boolean isStrongBoxBacked, boolean userConfirmationRequired, boolean unlockedDeviceRequired) {
        if (TextUtils.isEmpty(keyStoreAlias)) {
            throw new IllegalArgumentException("keyStoreAlias must not be empty");
        }
        if (certificateSubject == null) {
            certificateSubject = DEFAULT_CERT_SUBJECT;
        }
        if (certificateNotBefore == null) {
            certificateNotBefore = DEFAULT_CERT_NOT_BEFORE;
        }
        if (certificateNotAfter == null) {
            certificateNotAfter = DEFAULT_CERT_NOT_AFTER;
        }
        if (certificateSerialNumber == null) {
            certificateSerialNumber = DEFAULT_CERT_SERIAL_NUMBER;
        }
        if (certificateNotAfter.before(certificateNotBefore)) {
            throw new IllegalArgumentException("certificateNotAfter < certificateNotBefore");
        }
        this.mKeystoreAlias = keyStoreAlias;
        this.mUid = uid;
        this.mKeySize = keySize;
        this.mSpec = spec;
        this.mCertificateSubject = certificateSubject;
        this.mCertificateSerialNumber = certificateSerialNumber;
        this.mCertificateNotBefore = Utils.cloneIfNotNull(certificateNotBefore);
        this.mCertificateNotAfter = Utils.cloneIfNotNull(certificateNotAfter);
        this.mKeyValidityStart = Utils.cloneIfNotNull(keyValidityStart);
        this.mKeyValidityForOriginationEnd = Utils.cloneIfNotNull(keyValidityForOriginationEnd);
        this.mKeyValidityForConsumptionEnd = Utils.cloneIfNotNull(keyValidityForConsumptionEnd);
        this.mPurposes = purposes;
        this.mDigests = ArrayUtils.cloneIfNotEmpty(digests);
        this.mEncryptionPaddings = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(encryptionPaddings));
        this.mSignaturePaddings = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(signaturePaddings));
        this.mBlockModes = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(blockModes));
        this.mRandomizedEncryptionRequired = randomizedEncryptionRequired;
        this.mUserAuthenticationRequired = userAuthenticationRequired;
        this.mUserPresenceRequired = userPresenceRequired;
        this.mUserAuthenticationValidityDurationSeconds = userAuthenticationValidityDurationSeconds;
        this.mAttestationChallenge = Utils.cloneIfNotNull(attestationChallenge);
        this.mUniqueIdIncluded = uniqueIdIncluded;
        this.mUserAuthenticationValidWhileOnBody = userAuthenticationValidWhileOnBody;
        this.mInvalidatedByBiometricEnrollment = invalidatedByBiometricEnrollment;
        this.mIsStrongBoxBacked = isStrongBoxBacked;
        this.mUserConfirmationRequired = userConfirmationRequired;
        this.mUnlockedDeviceRequired = unlockedDeviceRequired;
    }

    private final String $$robo$$android_security_keystore_KeyGenParameterSpec$getKeystoreAlias() {
        return this.mKeystoreAlias;
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getUid() {
        return this.mUid;
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getKeySize() {
        return this.mKeySize;
    }

    private final AlgorithmParameterSpec $$robo$$android_security_keystore_KeyGenParameterSpec$getAlgorithmParameterSpec() {
        return this.mSpec;
    }

    private final X500Principal $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSubject() {
        return this.mCertificateSubject;
    }

    private final BigInteger $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSerialNumber() {
        return this.mCertificateSerialNumber;
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotBefore() {
        return Utils.cloneIfNotNull(this.mCertificateNotBefore);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotAfter() {
        return Utils.cloneIfNotNull(this.mCertificateNotAfter);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityStart() {
        return Utils.cloneIfNotNull(this.mKeyValidityStart);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForConsumptionEnd() {
        return Utils.cloneIfNotNull(this.mKeyValidityForConsumptionEnd);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForOriginationEnd() {
        return Utils.cloneIfNotNull(this.mKeyValidityForOriginationEnd);
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getPurposes() {
        return this.mPurposes;
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getDigests() {
        if (this.mDigests == null) {
            throw new IllegalStateException("Digests not specified");
        }
        return ArrayUtils.cloneIfNotEmpty(this.mDigests);
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isDigestsSpecified() {
        return this.mDigests != null;
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getEncryptionPaddings() {
        return ArrayUtils.cloneIfNotEmpty(this.mEncryptionPaddings);
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getSignaturePaddings() {
        return ArrayUtils.cloneIfNotEmpty(this.mSignaturePaddings);
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getBlockModes() {
        return ArrayUtils.cloneIfNotEmpty(this.mBlockModes);
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isRandomizedEncryptionRequired() {
        return this.mRandomizedEncryptionRequired;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationRequired() {
        return this.mUserAuthenticationRequired;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUserConfirmationRequired() {
        return this.mUserConfirmationRequired;
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getUserAuthenticationValidityDurationSeconds() {
        return this.mUserAuthenticationValidityDurationSeconds;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUserPresenceRequired() {
        return this.mUserPresenceRequired;
    }

    private final byte[] $$robo$$android_security_keystore_KeyGenParameterSpec$getAttestationChallenge() {
        return Utils.cloneIfNotNull(this.mAttestationChallenge);
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUniqueIdIncluded() {
        return this.mUniqueIdIncluded;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationValidWhileOnBody() {
        return this.mUserAuthenticationValidWhileOnBody;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isInvalidatedByBiometricEnrollment() {
        return this.mInvalidatedByBiometricEnrollment;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isStrongBoxBacked() {
        return this.mIsStrongBoxBacked;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUnlockedDeviceRequired() {
        return this.mUnlockedDeviceRequired;
    }

    private final long $$robo$$android_security_keystore_KeyGenParameterSpec$getBoundToSpecificSecureUserId() {
        return 0L;
    }

    static void __staticInitializer__() {
        DEFAULT_CERT_SUBJECT = new X500Principal("CN=fake");
        DEFAULT_CERT_SERIAL_NUMBER = new BigInteger("1");
        DEFAULT_CERT_NOT_BEFORE = new Date(0L);
        DEFAULT_CERT_NOT_AFTER = new Date(2461449600000L);
    }

    private void __constructor__(String string2, int n, int n2, AlgorithmParameterSpec algorithmParameterSpec, X500Principal x500Principal, BigInteger bigInteger, Date date, Date date2, Date date3, Date date4, Date date5, int n3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n4, boolean bl3, byte[] byArray, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.$$robo$$android_security_keystore_KeyGenParameterSpec$__constructor__(string2, n, n2, algorithmParameterSpec, x500Principal, bigInteger, date, date2, date3, date4, date5, n3, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n4, bl3, byArray, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    public KeyGenParameterSpec(String string2, int n, int n2, AlgorithmParameterSpec algorithmParameterSpec, X500Principal x500Principal, BigInteger bigInteger, Date date, Date date2, Date date3, Date date4, Date date5, int n3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n4, boolean bl3, byte[] byArray, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyGenParameterSpec$__constructor__(java.lang.String int int java.security.spec.AlgorithmParameterSpec javax.security.auth.x500.X500Principal java.math.BigInteger java.util.Date java.util.Date java.util.Date java.util.Date java.util.Date int java.lang.String[] java.lang.String[] java.lang.String[] java.lang.String[] boolean boolean int boolean byte[] boolean boolean boolean boolean boolean boolean ), this, string2, n, n2, algorithmParameterSpec, x500Principal, bigInteger, date, date2, date3, date4, date5, n3, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n4, bl3, byArray, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    public String getKeystoreAlias() {
        return InvokeDynamicSupport.bootstrap("getKeystoreAlias", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeystoreAlias(), this);
    }

    public int getUid() {
        return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_security_keystore_KeyGenParameterSpec$getUid(), this);
    }

    public int getKeySize() {
        return (int)InvokeDynamicSupport.bootstrap("getKeySize", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeySize(), this);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return InvokeDynamicSupport.bootstrap("getAlgorithmParameterSpec", $$robo$$android_security_keystore_KeyGenParameterSpec$getAlgorithmParameterSpec(), this);
    }

    public X500Principal getCertificateSubject() {
        return InvokeDynamicSupport.bootstrap("getCertificateSubject", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSubject(), this);
    }

    public BigInteger getCertificateSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getCertificateSerialNumber", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSerialNumber(), this);
    }

    public Date getCertificateNotBefore() {
        return InvokeDynamicSupport.bootstrap("getCertificateNotBefore", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotBefore(), this);
    }

    public Date getCertificateNotAfter() {
        return InvokeDynamicSupport.bootstrap("getCertificateNotAfter", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotAfter(), this);
    }

    public Date getKeyValidityStart() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityStart", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityStart(), this);
    }

    public Date getKeyValidityForConsumptionEnd() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityForConsumptionEnd", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForConsumptionEnd(), this);
    }

    public Date getKeyValidityForOriginationEnd() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityForOriginationEnd", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForOriginationEnd(), this);
    }

    public int getPurposes() {
        return (int)InvokeDynamicSupport.bootstrap("getPurposes", $$robo$$android_security_keystore_KeyGenParameterSpec$getPurposes(), this);
    }

    public String[] getDigests() {
        return InvokeDynamicSupport.bootstrap("getDigests", $$robo$$android_security_keystore_KeyGenParameterSpec$getDigests(), this);
    }

    public boolean isDigestsSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDigestsSpecified", $$robo$$android_security_keystore_KeyGenParameterSpec$isDigestsSpecified(), this);
    }

    public String[] getEncryptionPaddings() {
        return InvokeDynamicSupport.bootstrap("getEncryptionPaddings", $$robo$$android_security_keystore_KeyGenParameterSpec$getEncryptionPaddings(), this);
    }

    public String[] getSignaturePaddings() {
        return InvokeDynamicSupport.bootstrap("getSignaturePaddings", $$robo$$android_security_keystore_KeyGenParameterSpec$getSignaturePaddings(), this);
    }

    public String[] getBlockModes() {
        return InvokeDynamicSupport.bootstrap("getBlockModes", $$robo$$android_security_keystore_KeyGenParameterSpec$getBlockModes(), this);
    }

    public boolean isRandomizedEncryptionRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRandomizedEncryptionRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isRandomizedEncryptionRequired(), this);
    }

    @Override
    public boolean isUserAuthenticationRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAuthenticationRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationRequired(), this);
    }

    @Override
    public boolean isUserConfirmationRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserConfirmationRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isUserConfirmationRequired(), this);
    }

    @Override
    public int getUserAuthenticationValidityDurationSeconds() {
        return (int)InvokeDynamicSupport.bootstrap("getUserAuthenticationValidityDurationSeconds", $$robo$$android_security_keystore_KeyGenParameterSpec$getUserAuthenticationValidityDurationSeconds(), this);
    }

    @Override
    public boolean isUserPresenceRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserPresenceRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isUserPresenceRequired(), this);
    }

    public byte[] getAttestationChallenge() {
        return InvokeDynamicSupport.bootstrap("getAttestationChallenge", $$robo$$android_security_keystore_KeyGenParameterSpec$getAttestationChallenge(), this);
    }

    public boolean isUniqueIdIncluded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUniqueIdIncluded", $$robo$$android_security_keystore_KeyGenParameterSpec$isUniqueIdIncluded(), this);
    }

    @Override
    public boolean isUserAuthenticationValidWhileOnBody() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAuthenticationValidWhileOnBody", $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationValidWhileOnBody(), this);
    }

    @Override
    public boolean isInvalidatedByBiometricEnrollment() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInvalidatedByBiometricEnrollment", $$robo$$android_security_keystore_KeyGenParameterSpec$isInvalidatedByBiometricEnrollment(), this);
    }

    public boolean isStrongBoxBacked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStrongBoxBacked", $$robo$$android_security_keystore_KeyGenParameterSpec$isStrongBoxBacked(), this);
    }

    @Override
    public boolean isUnlockedDeviceRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnlockedDeviceRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isUnlockedDeviceRequired(), this);
    }

    @Override
    public long getBoundToSpecificSecureUserId() {
        return (long)InvokeDynamicSupport.bootstrap("getBoundToSpecificSecureUserId", $$robo$$android_security_keystore_KeyGenParameterSpec$getBoundToSpecificSecureUserId(), this);
    }

    static {
        RobolectricInternals.classInitializing(KeyGenParameterSpec.class);
    }

    public /* synthetic */ KeyGenParameterSpec() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyGenParameterSpec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private String mKeystoreAlias;
        private int mPurposes;
        private int mUid;
        private int mKeySize;
        private AlgorithmParameterSpec mSpec;
        private X500Principal mCertificateSubject;
        private BigInteger mCertificateSerialNumber;
        private Date mCertificateNotBefore;
        private Date mCertificateNotAfter;
        private Date mKeyValidityStart;
        private Date mKeyValidityForOriginationEnd;
        private Date mKeyValidityForConsumptionEnd;
        private String[] mDigests;
        private String[] mEncryptionPaddings;
        private String[] mSignaturePaddings;
        private String[] mBlockModes;
        private boolean mRandomizedEncryptionRequired;
        private boolean mUserAuthenticationRequired;
        private int mUserAuthenticationValidityDurationSeconds;
        private boolean mUserPresenceRequired;
        private byte[] mAttestationChallenge;
        private boolean mUniqueIdIncluded;
        private boolean mUserAuthenticationValidWhileOnBody;
        private boolean mInvalidatedByBiometricEnrollment;
        private boolean mIsStrongBoxBacked;
        private boolean mUserConfirmationRequired;
        private boolean mUnlockedDeviceRequired;

        private void $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(String keystoreAlias, int purposes) {
            this.mUid = -1;
            this.mKeySize = -1;
            this.mRandomizedEncryptionRequired = true;
            this.mUserAuthenticationValidityDurationSeconds = -1;
            this.mUserPresenceRequired = false;
            this.mAttestationChallenge = null;
            this.mUniqueIdIncluded = false;
            this.mInvalidatedByBiometricEnrollment = true;
            this.mIsStrongBoxBacked = false;
            this.mUnlockedDeviceRequired = false;
            if (keystoreAlias == null) {
                throw new NullPointerException("keystoreAlias == null");
            }
            if (keystoreAlias.isEmpty()) {
                throw new IllegalArgumentException("keystoreAlias must not be empty");
            }
            this.mKeystoreAlias = keystoreAlias;
            this.mPurposes = purposes;
        }

        private void $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(KeyGenParameterSpec sourceSpec) {
            this.mUid = sourceSpec.getUid();
            this.mKeySize = sourceSpec.getKeySize();
            this.mSpec = sourceSpec.getAlgorithmParameterSpec();
            this.mCertificateSubject = sourceSpec.getCertificateSubject();
            this.mCertificateSerialNumber = sourceSpec.getCertificateSerialNumber();
            this.mCertificateNotBefore = sourceSpec.getCertificateNotBefore();
            this.mCertificateNotAfter = sourceSpec.getCertificateNotAfter();
            this.mKeyValidityStart = sourceSpec.getKeyValidityStart();
            this.mKeyValidityForOriginationEnd = sourceSpec.getKeyValidityForOriginationEnd();
            this.mKeyValidityForConsumptionEnd = sourceSpec.getKeyValidityForConsumptionEnd();
            this.mPurposes = sourceSpec.getPurposes();
            if (sourceSpec.isDigestsSpecified()) {
                this.mDigests = sourceSpec.getDigests();
            }
            this.mEncryptionPaddings = sourceSpec.getEncryptionPaddings();
            this.mSignaturePaddings = sourceSpec.getSignaturePaddings();
            this.mBlockModes = sourceSpec.getBlockModes();
            this.mRandomizedEncryptionRequired = sourceSpec.isRandomizedEncryptionRequired();
            this.mUserAuthenticationRequired = sourceSpec.isUserAuthenticationRequired();
            this.mUserAuthenticationValidityDurationSeconds = sourceSpec.getUserAuthenticationValidityDurationSeconds();
            this.mUserPresenceRequired = sourceSpec.isUserPresenceRequired();
            this.mAttestationChallenge = sourceSpec.getAttestationChallenge();
            this.mUniqueIdIncluded = sourceSpec.isUniqueIdIncluded();
            this.mUserAuthenticationValidWhileOnBody = sourceSpec.isUserAuthenticationValidWhileOnBody();
            this.mInvalidatedByBiometricEnrollment = sourceSpec.isInvalidatedByBiometricEnrollment();
            this.mIsStrongBoxBacked = sourceSpec.isStrongBoxBacked();
            this.mUserConfirmationRequired = sourceSpec.isUserConfirmationRequired();
            this.mUnlockedDeviceRequired = sourceSpec.isUnlockedDeviceRequired();
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUid(int uid) {
            this.mUid = uid;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeySize(int keySize) {
            if (keySize < 0) {
                throw new IllegalArgumentException("keySize < 0");
            }
            this.mKeySize = keySize;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAlgorithmParameterSpec(AlgorithmParameterSpec spec) {
            if (spec == null) {
                throw new NullPointerException("spec == null");
            }
            this.mSpec = spec;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSubject(X500Principal subject) {
            if (subject == null) {
                throw new NullPointerException("subject == null");
            }
            this.mCertificateSubject = subject;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSerialNumber(BigInteger serialNumber) {
            if (serialNumber == null) {
                throw new NullPointerException("serialNumber == null");
            }
            this.mCertificateSerialNumber = serialNumber;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotBefore(Date date) {
            if (date == null) {
                throw new NullPointerException("date == null");
            }
            this.mCertificateNotBefore = Utils.cloneIfNotNull(date);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotAfter(Date date) {
            if (date == null) {
                throw new NullPointerException("date == null");
            }
            this.mCertificateNotAfter = Utils.cloneIfNotNull(date);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityStart(Date startDate) {
            this.mKeyValidityStart = Utils.cloneIfNotNull(startDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityEnd(Date endDate) {
            this.setKeyValidityForOriginationEnd(endDate);
            this.setKeyValidityForConsumptionEnd(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForOriginationEnd(Date endDate) {
            this.mKeyValidityForOriginationEnd = Utils.cloneIfNotNull(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForConsumptionEnd(Date endDate) {
            this.mKeyValidityForConsumptionEnd = Utils.cloneIfNotNull(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setDigests(String ... digests) {
            this.mDigests = ArrayUtils.cloneIfNotEmpty(digests);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setEncryptionPaddings(String ... paddings) {
            this.mEncryptionPaddings = ArrayUtils.cloneIfNotEmpty(paddings);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setSignaturePaddings(String ... paddings) {
            this.mSignaturePaddings = ArrayUtils.cloneIfNotEmpty(paddings);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setBlockModes(String ... blockModes) {
            this.mBlockModes = ArrayUtils.cloneIfNotEmpty(blockModes);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setRandomizedEncryptionRequired(boolean required) {
            this.mRandomizedEncryptionRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationRequired(boolean required) {
            this.mUserAuthenticationRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserConfirmationRequired(boolean required) {
            this.mUserConfirmationRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidityDurationSeconds(int seconds) {
            if (seconds < -1) {
                throw new IllegalArgumentException("seconds must be -1 or larger");
            }
            this.mUserAuthenticationValidityDurationSeconds = seconds;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserPresenceRequired(boolean required) {
            this.mUserPresenceRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAttestationChallenge(byte[] attestationChallenge) {
            this.mAttestationChallenge = attestationChallenge;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUniqueIdIncluded(boolean uniqueIdIncluded) {
            this.mUniqueIdIncluded = uniqueIdIncluded;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidWhileOnBody(boolean remainsValid) {
            this.mUserAuthenticationValidWhileOnBody = remainsValid;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setInvalidatedByBiometricEnrollment(boolean invalidateKey) {
            this.mInvalidatedByBiometricEnrollment = invalidateKey;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setIsStrongBoxBacked(boolean isStrongBoxBacked) {
            this.mIsStrongBoxBacked = isStrongBoxBacked;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUnlockedDeviceRequired(boolean unlockedDeviceRequired) {
            this.mUnlockedDeviceRequired = unlockedDeviceRequired;
            return this;
        }

        private final KeyGenParameterSpec $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$build() {
            return new KeyGenParameterSpec(this.mKeystoreAlias, this.mUid, this.mKeySize, this.mSpec, this.mCertificateSubject, this.mCertificateSerialNumber, this.mCertificateNotBefore, this.mCertificateNotAfter, this.mKeyValidityStart, this.mKeyValidityForOriginationEnd, this.mKeyValidityForConsumptionEnd, this.mPurposes, this.mDigests, this.mEncryptionPaddings, this.mSignaturePaddings, this.mBlockModes, this.mRandomizedEncryptionRequired, this.mUserAuthenticationRequired, this.mUserAuthenticationValidityDurationSeconds, this.mUserPresenceRequired, this.mAttestationChallenge, this.mUniqueIdIncluded, this.mUserAuthenticationValidWhileOnBody, this.mInvalidatedByBiometricEnrollment, this.mIsStrongBoxBacked, this.mUserConfirmationRequired, this.mUnlockedDeviceRequired);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(string2, n);
        }

        public Builder(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(java.lang.String int ), this, string2, n);
        }

        private void __constructor__(KeyGenParameterSpec keyGenParameterSpec) {
            this.$$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(keyGenParameterSpec);
        }

        public Builder(KeyGenParameterSpec keyGenParameterSpec) {
            this(keyGenParameterSpec.getKeystoreAlias(), keyGenParameterSpec.getPurposes());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(android.security.keystore.KeyGenParameterSpec ), this, keyGenParameterSpec);
        }

        public Builder setUid(int n) {
            return InvokeDynamicSupport.bootstrap("setUid", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUid(int ), this, n);
        }

        public Builder setKeySize(int n) {
            return InvokeDynamicSupport.bootstrap("setKeySize", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeySize(int ), this, n);
        }

        public Builder setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            return InvokeDynamicSupport.bootstrap("setAlgorithmParameterSpec", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAlgorithmParameterSpec(java.security.spec.AlgorithmParameterSpec ), this, algorithmParameterSpec);
        }

        public Builder setCertificateSubject(X500Principal x500Principal) {
            return InvokeDynamicSupport.bootstrap("setCertificateSubject", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSubject(javax.security.auth.x500.X500Principal ), this, x500Principal);
        }

        public Builder setCertificateSerialNumber(BigInteger bigInteger) {
            return InvokeDynamicSupport.bootstrap("setCertificateSerialNumber", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSerialNumber(java.math.BigInteger ), this, bigInteger);
        }

        public Builder setCertificateNotBefore(Date date) {
            return InvokeDynamicSupport.bootstrap("setCertificateNotBefore", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotBefore(java.util.Date ), this, date);
        }

        public Builder setCertificateNotAfter(Date date) {
            return InvokeDynamicSupport.bootstrap("setCertificateNotAfter", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotAfter(java.util.Date ), this, date);
        }

        public Builder setKeyValidityStart(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityStart", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityStart(java.util.Date ), this, date);
        }

        public Builder setKeyValidityEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityEnd", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityEnd(java.util.Date ), this, date);
        }

        public Builder setKeyValidityForOriginationEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityForOriginationEnd", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForOriginationEnd(java.util.Date ), this, date);
        }

        public Builder setKeyValidityForConsumptionEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityForConsumptionEnd", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForConsumptionEnd(java.util.Date ), this, date);
        }

        public Builder setDigests(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setDigests", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setDigests(java.lang.String[] ), this, stringArray);
        }

        public Builder setEncryptionPaddings(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setEncryptionPaddings", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setEncryptionPaddings(java.lang.String[] ), this, stringArray);
        }

        public Builder setSignaturePaddings(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setSignaturePaddings", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setSignaturePaddings(java.lang.String[] ), this, stringArray);
        }

        public Builder setBlockModes(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setBlockModes", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setBlockModes(java.lang.String[] ), this, stringArray);
        }

        public Builder setRandomizedEncryptionRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRandomizedEncryptionRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setRandomizedEncryptionRequired(boolean ), this, bl);
        }

        public Builder setUserAuthenticationRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationRequired(boolean ), this, bl);
        }

        public Builder setUserConfirmationRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserConfirmationRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserConfirmationRequired(boolean ), this, bl);
        }

        public Builder setUserAuthenticationValidityDurationSeconds(int n) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationValidityDurationSeconds", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidityDurationSeconds(int ), this, n);
        }

        public Builder setUserPresenceRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserPresenceRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserPresenceRequired(boolean ), this, bl);
        }

        public Builder setAttestationChallenge(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setAttestationChallenge", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAttestationChallenge(byte[] ), this, byArray);
        }

        public Builder setUniqueIdIncluded(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUniqueIdIncluded", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUniqueIdIncluded(boolean ), this, bl);
        }

        public Builder setUserAuthenticationValidWhileOnBody(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationValidWhileOnBody", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidWhileOnBody(boolean ), this, bl);
        }

        public Builder setInvalidatedByBiometricEnrollment(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setInvalidatedByBiometricEnrollment", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setInvalidatedByBiometricEnrollment(boolean ), this, bl);
        }

        public Builder setIsStrongBoxBacked(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIsStrongBoxBacked", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setIsStrongBoxBacked(boolean ), this, bl);
        }

        public Builder setUnlockedDeviceRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUnlockedDeviceRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUnlockedDeviceRequired(boolean ), this, bl);
        }

        public KeyGenParameterSpec build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

