/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.OperationResult;
import android.security.keystore.ArrayUtils;
import android.security.keystore.KeyStoreConnectException;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.ProviderException;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyStoreCryptoOperationChunkedStreamer
implements KeyStoreCryptoOperationStreamer,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int DEFAULT_MAX_CHUNK_SIZE = 65536;
    private Stream mKeyStoreStream;
    private int mMaxChunkSize;
    private byte[] mBuffered;
    private int mBufferedOffset;
    private int mBufferedLength;
    private long mConsumedInputSizeBytes;
    private long mProducedOutputSizeBytes;

    private void $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$__constructor__(Stream operation) {
    }

    private void $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$__constructor__(Stream operation, int maxChunkSize) {
        this.mBuffered = EmptyArray.BYTE;
        this.mKeyStoreStream = operation;
        this.mMaxChunkSize = maxChunkSize;
    }

    private final byte[] $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$update(byte[] input, int inputOffset, int inputLength) throws KeyStoreException {
        if (inputLength == 0) {
            return EmptyArray.BYTE;
        }
        ByteArrayOutputStream bufferedOutput = null;
        while (inputLength > 0) {
            byte[] result;
            byte[] chunk;
            int inputBytesInChunk;
            if (this.mBufferedLength + inputLength > this.mMaxChunkSize) {
                inputBytesInChunk = this.mMaxChunkSize - this.mBufferedLength;
                chunk = ArrayUtils.concat(this.mBuffered, this.mBufferedOffset, this.mBufferedLength, input, inputOffset, inputBytesInChunk);
            } else if (this.mBufferedLength == 0 && inputOffset == 0 && inputLength == input.length) {
                chunk = input;
                inputBytesInChunk = input.length;
            } else {
                inputBytesInChunk = inputLength;
                chunk = ArrayUtils.concat(this.mBuffered, this.mBufferedOffset, this.mBufferedLength, input, inputOffset, inputBytesInChunk);
            }
            inputOffset += inputBytesInChunk;
            inputLength -= inputBytesInChunk;
            this.mConsumedInputSizeBytes += (long)inputBytesInChunk;
            OperationResult opResult = this.mKeyStoreStream.update(chunk);
            if (opResult == null) {
                throw new KeyStoreConnectException();
            }
            if (opResult.resultCode != 1) {
                throw KeyStore.getKeyStoreException(opResult.resultCode);
            }
            if (opResult.inputConsumed == chunk.length) {
                this.mBuffered = EmptyArray.BYTE;
                this.mBufferedOffset = 0;
                this.mBufferedLength = 0;
            } else if (opResult.inputConsumed <= 0) {
                if (inputLength > 0) {
                    throw new KeyStoreException(-1000, "Keystore consumed nothing from max-sized chunk: " + chunk.length + " bytes");
                }
                this.mBuffered = chunk;
                this.mBufferedOffset = 0;
                this.mBufferedLength = chunk.length;
            } else if (opResult.inputConsumed < chunk.length) {
                this.mBuffered = chunk;
                this.mBufferedOffset = opResult.inputConsumed;
                this.mBufferedLength = chunk.length - opResult.inputConsumed;
            } else {
                throw new KeyStoreException(-1000, "Keystore consumed more input than provided. Provided: " + chunk.length + ", consumed: " + opResult.inputConsumed);
            }
            if (opResult.output == null || opResult.output.length <= 0) continue;
            if (inputLength > 0) {
                if (bufferedOutput != null) continue;
                bufferedOutput = new ByteArrayOutputStream();
                try {
                    bufferedOutput.write(opResult.output);
                    continue;
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
            }
            if (bufferedOutput == null) {
                result = opResult.output;
            } else {
                try {
                    bufferedOutput.write(opResult.output);
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
                result = bufferedOutput.toByteArray();
            }
            this.mProducedOutputSizeBytes += (long)result.length;
            return result;
        }
        byte[] result = bufferedOutput == null ? EmptyArray.BYTE : bufferedOutput.toByteArray();
        this.mProducedOutputSizeBytes += (long)result.length;
        return result;
    }

    private final byte[] $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$doFinal(byte[] input, int inputOffset, int inputLength, byte[] signature, byte[] additionalEntropy) throws KeyStoreException {
        if (inputLength == 0) {
            input = EmptyArray.BYTE;
            inputOffset = 0;
        }
        byte[] output = this.update(input, inputOffset, inputLength);
        output = ArrayUtils.concat(output, this.flush());
        OperationResult opResult = this.mKeyStoreStream.finish(signature, additionalEntropy);
        if (opResult == null) {
            throw new KeyStoreConnectException();
        }
        if (opResult.resultCode != 1) {
            throw KeyStore.getKeyStoreException(opResult.resultCode);
        }
        this.mProducedOutputSizeBytes += (long)opResult.output.length;
        return ArrayUtils.concat(output, opResult.output);
    }

    private final byte[] $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$flush() throws KeyStoreException {
        if (this.mBufferedLength <= 0) {
            return EmptyArray.BYTE;
        }
        ByteArrayOutputStream bufferedOutput = null;
        while (this.mBufferedLength > 0) {
            byte[] chunk = ArrayUtils.subarray(this.mBuffered, this.mBufferedOffset, this.mBufferedLength);
            OperationResult opResult = this.mKeyStoreStream.update(chunk);
            if (opResult == null) {
                throw new KeyStoreConnectException();
            }
            if (opResult.resultCode != 1) {
                throw KeyStore.getKeyStoreException(opResult.resultCode);
            }
            if (opResult.inputConsumed <= 0) break;
            if (opResult.inputConsumed >= chunk.length) {
                this.mBuffered = EmptyArray.BYTE;
                this.mBufferedOffset = 0;
                this.mBufferedLength = 0;
            } else {
                this.mBuffered = chunk;
                this.mBufferedOffset = opResult.inputConsumed;
                this.mBufferedLength = chunk.length - opResult.inputConsumed;
            }
            if (opResult.inputConsumed > chunk.length) {
                throw new KeyStoreException(-1000, "Keystore consumed more input than provided. Provided: " + chunk.length + ", consumed: " + opResult.inputConsumed);
            }
            if (opResult.output == null || opResult.output.length <= 0) continue;
            if (bufferedOutput == null) {
                if (this.mBufferedLength == 0) {
                    this.mProducedOutputSizeBytes += (long)opResult.output.length;
                    return opResult.output;
                }
                bufferedOutput = new ByteArrayOutputStream();
            }
            try {
                bufferedOutput.write(opResult.output);
            }
            catch (IOException e) {
                throw new ProviderException("Failed to buffer output", e);
            }
        }
        if (this.mBufferedLength > 0) {
            throw new KeyStoreException(-21, "Keystore failed to consume last " + (this.mBufferedLength != 1 ? this.mBufferedLength + " bytes" : "byte") + " of input");
        }
        byte[] result = bufferedOutput != null ? bufferedOutput.toByteArray() : EmptyArray.BYTE;
        this.mProducedOutputSizeBytes += (long)result.length;
        return result;
    }

    private final long $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$getConsumedInputSizeBytes() {
        return this.mConsumedInputSizeBytes;
    }

    private final long $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$getProducedOutputSizeBytes() {
        return this.mProducedOutputSizeBytes;
    }

    private void __constructor__(Stream stream) {
        this.$$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$__constructor__(stream);
    }

    public KeyStoreCryptoOperationChunkedStreamer(Stream stream) {
        this(stream, 65536);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$__constructor__(android.security.keystore.KeyStoreCryptoOperationChunkedStreamer$Stream ), this, stream);
    }

    private void __constructor__(Stream stream, int n) {
        this.$$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$__constructor__(stream, n);
    }

    public KeyStoreCryptoOperationChunkedStreamer(Stream stream, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$__constructor__(android.security.keystore.KeyStoreCryptoOperationChunkedStreamer$Stream int ), this, stream, n);
    }

    @Override
    public byte[] update(byte[] byArray, int n, int n2) throws KeyStoreException {
        return InvokeDynamicSupport.bootstrap("update", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$update(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    public byte[] doFinal(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3) throws KeyStoreException {
        return InvokeDynamicSupport.bootstrap("doFinal", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$doFinal(byte[] int int byte[] byte[] ), this, byArray, n, n2, byArray2, byArray3);
    }

    public byte[] flush() throws KeyStoreException {
        return InvokeDynamicSupport.bootstrap("flush", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$flush(), this);
    }

    @Override
    public long getConsumedInputSizeBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getConsumedInputSizeBytes", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$getConsumedInputSizeBytes(), this);
    }

    @Override
    public long getProducedOutputSizeBytes() {
        return (long)InvokeDynamicSupport.bootstrap("getProducedOutputSizeBytes", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer$getProducedOutputSizeBytes(), this);
    }

    public /* synthetic */ KeyStoreCryptoOperationChunkedStreamer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStoreCryptoOperationChunkedStreamer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MainDataStream
    implements Stream,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private KeyStore mKeyStore;
        private IBinder mOperationToken;

        private void $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$__constructor__(KeyStore keyStore, IBinder operationToken) {
            this.mKeyStore = keyStore;
            this.mOperationToken = operationToken;
        }

        private final OperationResult $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$update(byte[] input) {
            return this.mKeyStore.update(this.mOperationToken, null, input);
        }

        private final OperationResult $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$finish(byte[] signature, byte[] additionalEntropy) {
            return this.mKeyStore.finish(this.mOperationToken, null, signature, additionalEntropy);
        }

        private void __constructor__(KeyStore keyStore, IBinder iBinder) {
            this.$$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$__constructor__(keyStore, iBinder);
        }

        public MainDataStream(KeyStore keyStore, IBinder iBinder) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$__constructor__(android.security.KeyStore android.os.IBinder ), this, keyStore, iBinder);
        }

        @Override
        public OperationResult update(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("update", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$update(byte[] ), this, byArray);
        }

        @Override
        public OperationResult finish(byte[] byArray, byte[] byArray2) {
            return InvokeDynamicSupport.bootstrap("finish", $$robo$$android_security_keystore_KeyStoreCryptoOperationChunkedStreamer_MainDataStream$finish(byte[] byte[] ), this, byArray, byArray2);
        }

        public /* synthetic */ MainDataStream() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MainDataStream)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface Stream {
        public OperationResult update(byte[] var1);

        public OperationResult finish(byte[] var1, byte[] var2);
    }
}

