/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.BadParcelableException;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.WrappedApplicationKey;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class KeyChainSnapshot
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int DEFAULT_MAX_ATTEMPTS = 10;
    private static long DEFAULT_COUNTER_ID = 1L;
    private int mSnapshotVersion;
    private int mMaxAttempts;
    private long mCounterId;
    private byte[] mServerParams;
    private RecoveryCertPath mCertPath;
    private List<KeyChainProtectionParams> mKeyChainProtectionParams;
    private List<WrappedApplicationKey> mEntryRecoveryData;
    private byte[] mEncryptedRecoveryKeyBlob;
    public static Parcelable.Creator<KeyChainSnapshot> CREATOR;

    private void $$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__() {
        this.mMaxAttempts = 10;
        this.mCounterId = 1L;
    }

    private final int $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getSnapshotVersion() {
        return this.mSnapshotVersion;
    }

    private final int $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getMaxAttempts() {
        return this.mMaxAttempts;
    }

    private final long $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getCounterId() {
        return this.mCounterId;
    }

    private final byte[] $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getServerParams() {
        return this.mServerParams;
    }

    @Deprecated
    private final byte[] $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getTrustedHardwarePublicKey() {
        throw new UnsupportedOperationException();
    }

    private final CertPath $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getTrustedHardwareCertPath() {
        try {
            return this.mCertPath.getCertPath();
        }
        catch (CertificateException e) {
            throw new BadParcelableException(e);
        }
    }

    private final List<KeyChainProtectionParams> $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getKeyChainProtectionParams() {
        return this.mKeyChainProtectionParams;
    }

    private final List<WrappedApplicationKey> $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getWrappedApplicationKeys() {
        return this.mEntryRecoveryData;
    }

    private final byte[] $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getEncryptedRecoveryKeyBlob() {
        return this.mEncryptedRecoveryKeyBlob;
    }

    private final void $$robo$$android_security_keystore_recovery_KeyChainSnapshot$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mSnapshotVersion);
        out.writeTypedList(this.mKeyChainProtectionParams);
        out.writeByteArray(this.mEncryptedRecoveryKeyBlob);
        out.writeTypedList(this.mEntryRecoveryData);
        out.writeInt(this.mMaxAttempts);
        out.writeLong(this.mCounterId);
        out.writeByteArray(this.mServerParams);
        out.writeTypedObject(this.mCertPath, 0);
    }

    private void $$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(Parcel in) {
        this.mMaxAttempts = 10;
        this.mCounterId = 1L;
        this.mSnapshotVersion = in.readInt();
        this.mKeyChainProtectionParams = in.createTypedArrayList(KeyChainProtectionParams.CREATOR);
        this.mEncryptedRecoveryKeyBlob = in.createByteArray();
        this.mEntryRecoveryData = in.createTypedArrayList(WrappedApplicationKey.CREATOR);
        this.mMaxAttempts = in.readInt();
        this.mCounterId = in.readLong();
        this.mServerParams = in.createByteArray();
        this.mCertPath = in.readTypedObject(RecoveryCertPath.CREATOR);
    }

    private final int $$robo$$android_security_keystore_recovery_KeyChainSnapshot$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(1 x0) {
    }

    static /* synthetic */ byte[] access$402(KeyChainSnapshot x0, byte[] x1) {
        x0.mServerParams = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$802(KeyChainSnapshot x0, byte[] x1) {
        x0.mEncryptedRecoveryKeyBlob = x1;
        return x1;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<KeyChainSnapshot>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$__constructor__() {
            }

            private final KeyChainSnapshot $$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$createFromParcel(Parcel in) {
                return new KeyChainSnapshot(in);
            }

            private final KeyChainSnapshot[] $$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$newArray(int length) {
                return new KeyChainSnapshot[length];
            }

            private void __constructor__() {
                this.$$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$__constructor__(), this);
            }

            @Override
            public KeyChainSnapshot createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public KeyChainSnapshot[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__();
    }

    public KeyChainSnapshot() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(), this);
    }

    public int getSnapshotVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getSnapshotVersion", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getSnapshotVersion(), this);
    }

    public int getMaxAttempts() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAttempts", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getMaxAttempts(), this);
    }

    public long getCounterId() {
        return (long)InvokeDynamicSupport.bootstrap("getCounterId", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getCounterId(), this);
    }

    public byte[] getServerParams() {
        return InvokeDynamicSupport.bootstrap("getServerParams", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getServerParams(), this);
    }

    @Deprecated
    public byte[] getTrustedHardwarePublicKey() {
        return InvokeDynamicSupport.bootstrap("getTrustedHardwarePublicKey", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getTrustedHardwarePublicKey(), this);
    }

    public CertPath getTrustedHardwareCertPath() {
        return InvokeDynamicSupport.bootstrap("getTrustedHardwareCertPath", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getTrustedHardwareCertPath(), this);
    }

    public List<KeyChainProtectionParams> getKeyChainProtectionParams() {
        return InvokeDynamicSupport.bootstrap("getKeyChainProtectionParams", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getKeyChainProtectionParams(), this);
    }

    public List<WrappedApplicationKey> getWrappedApplicationKeys() {
        return InvokeDynamicSupport.bootstrap("getWrappedApplicationKeys", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getWrappedApplicationKeys(), this);
    }

    public byte[] getEncryptedRecoveryKeyBlob() {
        return InvokeDynamicSupport.bootstrap("getEncryptedRecoveryKeyBlob", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$getEncryptedRecoveryKeyBlob(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(parcel);
    }

    public KeyChainSnapshot(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$describeContents(), this);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(var1_1);
    }

    public /* synthetic */ KeyChainSnapshot(1 var1_1) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_KeyChainSnapshot$__constructor__(android.security.keystore.recovery.KeyChainSnapshot$1 ), this, var1_1);
    }

    static {
        RobolectricInternals.classInitializing(KeyChainSnapshot.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyChainSnapshot)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private KeyChainSnapshot mInstance;

        private void $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$__constructor__() {
            this.mInstance = new KeyChainSnapshot(null);
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setSnapshotVersion(int snapshotVersion) {
            this.mInstance.mSnapshotVersion = snapshotVersion;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setMaxAttempts(int maxAttempts) {
            this.mInstance.mMaxAttempts = maxAttempts;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setCounterId(long counterId) {
            this.mInstance.mCounterId = counterId;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setServerParams(byte[] serverParams) {
            KeyChainSnapshot.access$402(this.mInstance, serverParams);
            return this;
        }

        @Deprecated
        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setTrustedHardwarePublicKey(byte[] publicKey) {
            throw new UnsupportedOperationException();
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setTrustedHardwareCertPath(CertPath certPath) throws CertificateException {
            this.mInstance.mCertPath = RecoveryCertPath.createRecoveryCertPath(certPath);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setKeyChainProtectionParams(List<KeyChainProtectionParams> keyChainProtectionParams) {
            this.mInstance.mKeyChainProtectionParams = keyChainProtectionParams;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setWrappedApplicationKeys(List<WrappedApplicationKey> entryRecoveryData) {
            this.mInstance.mEntryRecoveryData = entryRecoveryData;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setEncryptedRecoveryKeyBlob(byte[] encryptedRecoveryKeyBlob) {
            KeyChainSnapshot.access$802(this.mInstance, encryptedRecoveryKeyBlob);
            return this;
        }

        private final KeyChainSnapshot $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$build() {
            Preconditions.checkCollectionElementsNotNull(this.mInstance.mKeyChainProtectionParams, "keyChainProtectionParams");
            Preconditions.checkCollectionElementsNotNull(this.mInstance.mEntryRecoveryData, "entryRecoveryData");
            Preconditions.checkNotNull(this.mInstance.mEncryptedRecoveryKeyBlob);
            Preconditions.checkNotNull(this.mInstance.mServerParams);
            Preconditions.checkNotNull(this.mInstance.mCertPath);
            return this.mInstance;
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$__constructor__(), this);
        }

        public Builder setSnapshotVersion(int n) {
            return InvokeDynamicSupport.bootstrap("setSnapshotVersion", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setSnapshotVersion(int ), this, n);
        }

        public Builder setMaxAttempts(int n) {
            return InvokeDynamicSupport.bootstrap("setMaxAttempts", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setMaxAttempts(int ), this, n);
        }

        public Builder setCounterId(long l) {
            return InvokeDynamicSupport.bootstrap("setCounterId", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setCounterId(long ), this, l);
        }

        public Builder setServerParams(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setServerParams", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setServerParams(byte[] ), this, byArray);
        }

        @Deprecated
        public Builder setTrustedHardwarePublicKey(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setTrustedHardwarePublicKey", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setTrustedHardwarePublicKey(byte[] ), this, byArray);
        }

        public Builder setTrustedHardwareCertPath(CertPath certPath) throws CertificateException {
            return InvokeDynamicSupport.bootstrap("setTrustedHardwareCertPath", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setTrustedHardwareCertPath(java.security.cert.CertPath ), this, certPath);
        }

        public Builder setKeyChainProtectionParams(List<KeyChainProtectionParams> list) {
            return InvokeDynamicSupport.bootstrap("setKeyChainProtectionParams", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setKeyChainProtectionParams(java.util.List<android.security.keystore.recovery.KeyChainProtectionParams> ), this, list);
        }

        public Builder setWrappedApplicationKeys(List<WrappedApplicationKey> list) {
            return InvokeDynamicSupport.bootstrap("setWrappedApplicationKeys", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setWrappedApplicationKeys(java.util.List<android.security.keystore.recovery.WrappedApplicationKey> ), this, list);
        }

        public Builder setEncryptedRecoveryKeyBlob(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setEncryptedRecoveryKeyBlob", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$setEncryptedRecoveryKeyBlob(byte[] ), this, byArray);
        }

        public KeyChainSnapshot build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_security_keystore_recovery_KeyChainSnapshot_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

