/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.security.KeyStore;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.recovery.InternalRecoveryServiceException;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.LockScreenRequiredException;
import android.security.keystore.recovery.RecoverySession;
import android.security.keystore.recovery.TrustedRootCertificates;
import com.android.internal.widget.ILockSettings;
import java.security.Key;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class RecoveryController
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "RecoveryController";
    public static int RECOVERY_STATUS_SYNCED = 0;
    public static int RECOVERY_STATUS_SYNC_IN_PROGRESS = 1;
    public static int RECOVERY_STATUS_PERMANENT_FAILURE = 3;
    public static int ERROR_NO_SNAPSHOT_PENDING = 21;
    public static int ERROR_SERVICE_INTERNAL_ERROR = 22;
    public static int ERROR_INSECURE_USER = 23;
    public static int ERROR_SESSION_EXPIRED = 24;
    public static int ERROR_BAD_CERTIFICATE_FORMAT = 25;
    public static int ERROR_DECRYPTION_FAILED = 26;
    public static int ERROR_INVALID_KEY_FORMAT = 27;
    public static int ERROR_INVALID_CERTIFICATE = 28;
    public static int ERROR_DOWNGRADE_CERTIFICATE = 29;
    private ILockSettings mBinder;
    private KeyStore mKeyStore;

    private void $$robo$$android_security_keystore_recovery_RecoveryController$__constructor__(ILockSettings binder, KeyStore keystore) {
        this.mBinder = binder;
        this.mKeyStore = keystore;
    }

    private final ILockSettings $$robo$$android_security_keystore_recovery_RecoveryController$getBinder() {
        return this.mBinder;
    }

    private static final RecoveryController $$robo$$android_security_keystore_recovery_RecoveryController$getInstance(Context context) {
        ILockSettings lockSettings = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        return new RecoveryController(lockSettings, KeyStore.getInstance());
    }

    private static final boolean $$robo$$android_security_keystore_recovery_RecoveryController$isRecoverableKeyStoreEnabled(Context context) {
        KeyguardManager keyguardManager = context.getSystemService(KeyguardManager.class);
        return keyguardManager != null && keyguardManager.isDeviceSecure();
    }

    @Deprecated
    private final void $$robo$$android_security_keystore_recovery_RecoveryController$initRecoveryService(String rootCertificateAlias, byte[] signedPublicKeyList) throws CertificateException, InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$android_security_keystore_recovery_RecoveryController$initRecoveryService(String rootCertificateAlias, byte[] certificateFile, byte[] signatureFile) throws CertificateException, InternalRecoveryServiceException {
        try {
            this.mBinder.initRecoveryServiceWithSigFile(rootCertificateAlias, certificateFile, signatureFile);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25 || e.errorCode == 28) {
                throw new CertificateException("Invalid certificate for recovery service", e);
            }
            if (e.errorCode == 29) {
                throw new CertificateException("Downgrading certificate serial version isn't supported.", e);
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    @Deprecated
    private final KeyChainSnapshot $$robo$$android_security_keystore_recovery_RecoveryController$getRecoveryData() throws InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final KeyChainSnapshot $$robo$$android_security_keystore_recovery_RecoveryController$getKeyChainSnapshot() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getKeyChainSnapshot();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 21) {
                return null;
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final void $$robo$$android_security_keystore_recovery_RecoveryController$setSnapshotCreatedPendingIntent(PendingIntent intent) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setSnapshotCreatedPendingIntent(intent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final void $$robo$$android_security_keystore_recovery_RecoveryController$setServerParams(byte[] serverParams) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setServerParams(serverParams);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    @Deprecated
    private final List<String> $$robo$$android_security_keystore_recovery_RecoveryController$getAliases(String packageName) throws InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final List<String> $$robo$$android_security_keystore_recovery_RecoveryController$getAliases() throws InternalRecoveryServiceException {
        try {
            Map allStatuses = this.mBinder.getRecoveryStatus();
            return new ArrayList<String>(allStatuses.keySet());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    @Deprecated
    private final void $$robo$$android_security_keystore_recovery_RecoveryController$setRecoveryStatus(String packageName, String alias, int status) throws PackageManager.NameNotFoundException, InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final void $$robo$$android_security_keystore_recovery_RecoveryController$setRecoveryStatus(String alias, int status) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setRecoveryStatus(alias, status);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    @Deprecated
    private final int $$robo$$android_security_keystore_recovery_RecoveryController$getRecoveryStatus(String packageName, String alias) throws InternalRecoveryServiceException {
        throw new UnsupportedOperationException();
    }

    private final int $$robo$$android_security_keystore_recovery_RecoveryController$getRecoveryStatus(String alias) throws InternalRecoveryServiceException {
        try {
            Map allStatuses = this.mBinder.getRecoveryStatus();
            Integer status = (Integer)allStatuses.get(alias);
            if (status == null) {
                return 3;
            }
            return status;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final void $$robo$$android_security_keystore_recovery_RecoveryController$setRecoverySecretTypes(int[] secretTypes) throws InternalRecoveryServiceException {
        try {
            this.mBinder.setRecoverySecretTypes(secretTypes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final int[] $$robo$$android_security_keystore_recovery_RecoveryController$getRecoverySecretTypes() throws InternalRecoveryServiceException {
        try {
            return this.mBinder.getRecoverySecretTypes();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    @Deprecated
    private final byte[] $$robo$$android_security_keystore_recovery_RecoveryController$generateAndStoreKey(String alias, byte[] account) throws InternalRecoveryServiceException, LockScreenRequiredException {
        throw new UnsupportedOperationException("Operation is not supported, use generateKey");
    }

    @Deprecated
    private final Key $$robo$$android_security_keystore_recovery_RecoveryController$generateKey(String alias, byte[] account) throws InternalRecoveryServiceException, LockScreenRequiredException {
        throw new UnsupportedOperationException();
    }

    private final Key $$robo$$android_security_keystore_recovery_RecoveryController$generateKey(String alias) throws InternalRecoveryServiceException, LockScreenRequiredException {
        try {
            String grantAlias = this.mBinder.generateKey(alias);
            if (grantAlias == null) {
                throw new InternalRecoveryServiceException("null grant alias");
            }
            return this.getKeyFromGrant(grantAlias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (UnrecoverableKeyException e) {
            throw new InternalRecoveryServiceException("Failed to get key from keystore", e);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 23) {
                throw new LockScreenRequiredException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final Key $$robo$$android_security_keystore_recovery_RecoveryController$importKey(String alias, byte[] keyBytes) throws InternalRecoveryServiceException, LockScreenRequiredException {
        try {
            String grantAlias = this.mBinder.importKey(alias, keyBytes);
            if (grantAlias == null) {
                throw new InternalRecoveryServiceException("Null grant alias");
            }
            return this.getKeyFromGrant(grantAlias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (UnrecoverableKeyException e) {
            throw new InternalRecoveryServiceException("Failed to get key from keystore", e);
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 23) {
                throw new LockScreenRequiredException(e.getMessage());
            }
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final Key $$robo$$android_security_keystore_recovery_RecoveryController$getKey(String alias) throws InternalRecoveryServiceException, UnrecoverableKeyException {
        try {
            String grantAlias = this.mBinder.getKey(alias);
            if (grantAlias == null || "".equals(grantAlias)) {
                return null;
            }
            return this.getKeyFromGrant(grantAlias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final Key $$robo$$android_security_keystore_recovery_RecoveryController$getKeyFromGrant(String grantAlias) throws UnrecoverableKeyException {
        return AndroidKeyStoreProvider.loadAndroidKeyStoreKeyFromKeystore(this.mKeyStore, grantAlias, -1);
    }

    private final void $$robo$$android_security_keystore_recovery_RecoveryController$removeKey(String alias) throws InternalRecoveryServiceException {
        try {
            this.mBinder.removeKey(alias);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            throw this.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private final RecoverySession $$robo$$android_security_keystore_recovery_RecoveryController$createRecoverySession() {
        return RecoverySession.newInstance(this);
    }

    private final Map<String, X509Certificate> $$robo$$android_security_keystore_recovery_RecoveryController$getRootCertificates() {
        return TrustedRootCertificates.getRootCertificates();
    }

    private final InternalRecoveryServiceException $$robo$$android_security_keystore_recovery_RecoveryController$wrapUnexpectedServiceSpecificException(ServiceSpecificException e) {
        if (e.errorCode == 22) {
            return new InternalRecoveryServiceException(e.getMessage());
        }
        return new InternalRecoveryServiceException("Unexpected error code for method: " + e.errorCode, e);
    }

    private void __constructor__(ILockSettings iLockSettings, KeyStore keyStore) {
        this.$$robo$$android_security_keystore_recovery_RecoveryController$__constructor__(iLockSettings, keyStore);
    }

    public RecoveryController(ILockSettings iLockSettings, KeyStore keyStore) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_recovery_RecoveryController$__constructor__(com.android.internal.widget.ILockSettings android.security.KeyStore ), this, iLockSettings, keyStore);
    }

    ILockSettings getBinder() {
        return InvokeDynamicSupport.bootstrap("getBinder", $$robo$$android_security_keystore_recovery_RecoveryController$getBinder(), this);
    }

    public static RecoveryController getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_security_keystore_recovery_RecoveryController$getInstance(android.content.Context ), (Context)context);
    }

    public static boolean isRecoverableKeyStoreEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRecoverableKeyStoreEnabled", $$robo$$android_security_keystore_recovery_RecoveryController$isRecoverableKeyStoreEnabled(android.content.Context ), (Context)context);
    }

    @Deprecated
    public void initRecoveryService(String string2, byte[] byArray) throws CertificateException, InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("initRecoveryService", $$robo$$android_security_keystore_recovery_RecoveryController$initRecoveryService(java.lang.String byte[] ), this, string2, byArray);
    }

    public void initRecoveryService(String string2, byte[] byArray, byte[] byArray2) throws CertificateException, InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("initRecoveryService", $$robo$$android_security_keystore_recovery_RecoveryController$initRecoveryService(java.lang.String byte[] byte[] ), this, string2, byArray, byArray2);
    }

    @Deprecated
    public KeyChainSnapshot getRecoveryData() throws InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("getRecoveryData", $$robo$$android_security_keystore_recovery_RecoveryController$getRecoveryData(), this);
    }

    public KeyChainSnapshot getKeyChainSnapshot() throws InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("getKeyChainSnapshot", $$robo$$android_security_keystore_recovery_RecoveryController$getKeyChainSnapshot(), this);
    }

    public void setSnapshotCreatedPendingIntent(PendingIntent pendingIntent) throws InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("setSnapshotCreatedPendingIntent", $$robo$$android_security_keystore_recovery_RecoveryController$setSnapshotCreatedPendingIntent(android.app.PendingIntent ), this, pendingIntent);
    }

    public void setServerParams(byte[] byArray) throws InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("setServerParams", $$robo$$android_security_keystore_recovery_RecoveryController$setServerParams(byte[] ), this, byArray);
    }

    @Deprecated
    public List<String> getAliases(String string2) throws InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("getAliases", $$robo$$android_security_keystore_recovery_RecoveryController$getAliases(java.lang.String ), this, string2);
    }

    public List<String> getAliases() throws InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("getAliases", $$robo$$android_security_keystore_recovery_RecoveryController$getAliases(), this);
    }

    @Deprecated
    public void setRecoveryStatus(String string2, String string3, int n) throws PackageManager.NameNotFoundException, InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("setRecoveryStatus", $$robo$$android_security_keystore_recovery_RecoveryController$setRecoveryStatus(java.lang.String java.lang.String int ), this, string2, string3, n);
    }

    public void setRecoveryStatus(String string2, int n) throws InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("setRecoveryStatus", $$robo$$android_security_keystore_recovery_RecoveryController$setRecoveryStatus(java.lang.String int ), this, string2, n);
    }

    @Deprecated
    public int getRecoveryStatus(String string2, String string3) throws InternalRecoveryServiceException {
        return (int)InvokeDynamicSupport.bootstrap("getRecoveryStatus", $$robo$$android_security_keystore_recovery_RecoveryController$getRecoveryStatus(java.lang.String java.lang.String ), this, string2, string3);
    }

    public int getRecoveryStatus(String string2) throws InternalRecoveryServiceException {
        return (int)InvokeDynamicSupport.bootstrap("getRecoveryStatus", $$robo$$android_security_keystore_recovery_RecoveryController$getRecoveryStatus(java.lang.String ), this, string2);
    }

    public void setRecoverySecretTypes(int[] nArray) throws InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("setRecoverySecretTypes", $$robo$$android_security_keystore_recovery_RecoveryController$setRecoverySecretTypes(int[] ), this, nArray);
    }

    public int[] getRecoverySecretTypes() throws InternalRecoveryServiceException {
        return InvokeDynamicSupport.bootstrap("getRecoverySecretTypes", $$robo$$android_security_keystore_recovery_RecoveryController$getRecoverySecretTypes(), this);
    }

    @Deprecated
    public byte[] generateAndStoreKey(String string2, byte[] byArray) throws InternalRecoveryServiceException, LockScreenRequiredException {
        return InvokeDynamicSupport.bootstrap("generateAndStoreKey", $$robo$$android_security_keystore_recovery_RecoveryController$generateAndStoreKey(java.lang.String byte[] ), this, string2, byArray);
    }

    @Deprecated
    public Key generateKey(String string2, byte[] byArray) throws InternalRecoveryServiceException, LockScreenRequiredException {
        return InvokeDynamicSupport.bootstrap("generateKey", $$robo$$android_security_keystore_recovery_RecoveryController$generateKey(java.lang.String byte[] ), this, string2, byArray);
    }

    public Key generateKey(String string2) throws InternalRecoveryServiceException, LockScreenRequiredException {
        return InvokeDynamicSupport.bootstrap("generateKey", $$robo$$android_security_keystore_recovery_RecoveryController$generateKey(java.lang.String ), this, string2);
    }

    public Key importKey(String string2, byte[] byArray) throws InternalRecoveryServiceException, LockScreenRequiredException {
        return InvokeDynamicSupport.bootstrap("importKey", $$robo$$android_security_keystore_recovery_RecoveryController$importKey(java.lang.String byte[] ), this, string2, byArray);
    }

    public Key getKey(String string2) throws InternalRecoveryServiceException, UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_security_keystore_recovery_RecoveryController$getKey(java.lang.String ), this, string2);
    }

    Key getKeyFromGrant(String string2) throws UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrap("getKeyFromGrant", $$robo$$android_security_keystore_recovery_RecoveryController$getKeyFromGrant(java.lang.String ), this, string2);
    }

    public void removeKey(String string2) throws InternalRecoveryServiceException {
        InvokeDynamicSupport.bootstrap("removeKey", $$robo$$android_security_keystore_recovery_RecoveryController$removeKey(java.lang.String ), this, string2);
    }

    public RecoverySession createRecoverySession() {
        return InvokeDynamicSupport.bootstrap("createRecoverySession", $$robo$$android_security_keystore_recovery_RecoveryController$createRecoverySession(), this);
    }

    public Map<String, X509Certificate> getRootCertificates() {
        return InvokeDynamicSupport.bootstrap("getRootCertificates", $$robo$$android_security_keystore_recovery_RecoveryController$getRootCertificates(), this);
    }

    InternalRecoveryServiceException wrapUnexpectedServiceSpecificException(ServiceSpecificException serviceSpecificException) {
        return InvokeDynamicSupport.bootstrap("wrapUnexpectedServiceSpecificException", $$robo$$android_security_keystore_recovery_RecoveryController$wrapUnexpectedServiceSpecificException(android.os.ServiceSpecificException ), this, serviceSpecificException);
    }

    public /* synthetic */ RecoveryController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecoveryController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

