/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.content.Context;
import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import com.android.org.conscrypt.TrustedCertificateIndex;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResourceCertificateSource
implements CertificateSource,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Object mLock;
    private int mResourceId;
    private Set<X509Certificate> mCertificates;
    private Context mContext;
    private TrustedCertificateIndex mIndex;

    private void $$robo$$android_security_net_config_ResourceCertificateSource$__constructor__(int resourceId, Context context) {
        this.mLock = new Object();
        this.mResourceId = resourceId;
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_ResourceCertificateSource$ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            Collection<? extends Certificate> certs;
            if (this.mCertificates != null) {
                return;
            }
            ArraySet<X509Certificate> certificates = new ArraySet<X509Certificate>();
            InputStream in = null;
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                in = this.mContext.getResources().openRawResource(this.mResourceId);
                certs = factory.generateCertificates(in);
            }
            catch (CertificateException e) {
                try {
                    throw new RuntimeException("Failed to load trust anchors from id " + this.mResourceId, e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(in);
            TrustedCertificateIndex indexLocal = new TrustedCertificateIndex();
            for (Certificate certificate : certs) {
                certificates.add((X509Certificate)certificate);
                indexLocal.index((X509Certificate)certificate);
            }
            this.mCertificates = certificates;
            this.mIndex = indexLocal;
            this.mContext = null;
        }
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_ResourceCertificateSource$getCertificates() {
        this.ensureInitialized();
        return this.mCertificates;
    }

    private final X509Certificate $$robo$$android_security_net_config_ResourceCertificateSource$findBySubjectAndPublicKey(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findBySubjectAndPublicKey(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    private final X509Certificate $$robo$$android_security_net_config_ResourceCertificateSource$findByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        TrustAnchor anchor = this.mIndex.findByIssuerAndSignature(cert);
        if (anchor == null) {
            return null;
        }
        return anchor.getTrustedCert();
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_ResourceCertificateSource$findAllByIssuerAndSignature(X509Certificate cert) {
        this.ensureInitialized();
        Set<TrustAnchor> anchors = this.mIndex.findAllByIssuerAndSignature(cert);
        if (anchors.isEmpty()) {
            return Collections.emptySet();
        }
        ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>(anchors.size());
        for (TrustAnchor anchor : anchors) {
            certs.add(anchor.getTrustedCert());
        }
        return certs;
    }

    private final void $$robo$$android_security_net_config_ResourceCertificateSource$handleTrustStorageUpdate() {
    }

    private void __constructor__(int n, Context context) {
        this.$$robo$$android_security_net_config_ResourceCertificateSource$__constructor__(n, context);
    }

    public ResourceCertificateSource(int n, Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_ResourceCertificateSource$__constructor__(int android.content.Context ), this, n, context);
    }

    private void ensureInitialized() {
        InvokeDynamicSupport.bootstrap("ensureInitialized", $$robo$$android_security_net_config_ResourceCertificateSource$ensureInitialized(), this);
    }

    @Override
    public Set<X509Certificate> getCertificates() {
        return InvokeDynamicSupport.bootstrap("getCertificates", $$robo$$android_security_net_config_ResourceCertificateSource$getCertificates(), this);
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findBySubjectAndPublicKey", $$robo$$android_security_net_config_ResourceCertificateSource$findBySubjectAndPublicKey(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    @Override
    public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findByIssuerAndSignature", $$robo$$android_security_net_config_ResourceCertificateSource$findByIssuerAndSignature(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findAllByIssuerAndSignature", $$robo$$android_security_net_config_ResourceCertificateSource$findAllByIssuerAndSignature(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    @Override
    public void handleTrustStorageUpdate() {
        InvokeDynamicSupport.bootstrap("handleTrustStorageUpdate", $$robo$$android_security_net_config_ResourceCertificateSource$handleTrustStorageUpdate(), this);
    }

    public /* synthetic */ ResourceCertificateSource() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResourceCertificateSource)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

