/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.security.net.config.CertificateSource;
import android.security.net.config.CertificatesEntryRef;
import android.security.net.config.ConfigSource;
import android.security.net.config.Domain;
import android.security.net.config.NetworkSecurityConfig;
import android.security.net.config.Pin;
import android.security.net.config.PinSet;
import android.security.net.config.ResourceCertificateSource;
import android.security.net.config.SystemCertificateSource;
import android.security.net.config.UserCertificateSource;
import android.util.ArraySet;
import android.util.Base64;
import android.util.Pair;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlConfigSource
implements ConfigSource,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int CONFIG_BASE = 0;
    private static int CONFIG_DOMAIN = 1;
    private static int CONFIG_DEBUG = 2;
    private Object mLock;
    private int mResourceId;
    private boolean mDebugBuild;
    private ApplicationInfo mApplicationInfo;
    private boolean mInitialized;
    private NetworkSecurityConfig mDefaultConfig;
    private Set<Pair<Domain, NetworkSecurityConfig>> mDomainMap;
    private Context mContext;

    private void $$robo$$android_security_net_config_XmlConfigSource$__constructor__(Context context, int resourceId, ApplicationInfo info) {
        this.mLock = new Object();
        this.mContext = context;
        this.mResourceId = resourceId;
        this.mApplicationInfo = new ApplicationInfo(info);
        this.mDebugBuild = (this.mApplicationInfo.flags & 2) != 0;
    }

    private final Set<Pair<Domain, NetworkSecurityConfig>> $$robo$$android_security_net_config_XmlConfigSource$getPerDomainConfigs() {
        this.ensureInitialized();
        return this.mDomainMap;
    }

    private final NetworkSecurityConfig $$robo$$android_security_net_config_XmlConfigSource$getDefaultConfig() {
        this.ensureInitialized();
        return this.mDefaultConfig;
    }

    private static final String $$robo$$android_security_net_config_XmlConfigSource$getConfigString(int configType) {
        switch (configType) {
            case 0: {
                return "base-config";
            }
            case 1: {
                return "domain-config";
            }
            case 2: {
                return "debug-overrides";
            }
        }
        throw new IllegalArgumentException("Unknown config type: " + configType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_XmlConfigSource$ensureInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInitialized) {
                return;
            }
            try (XmlResourceParser parser = this.mContext.getResources().getXml(this.mResourceId);){
                this.parseNetworkSecurityConfig(parser);
                this.mContext = null;
                this.mInitialized = true;
            }
            catch (Resources.NotFoundException | ParserException | IOException | XmlPullParserException e) {
                throw new RuntimeException("Failed to parse XML configuration from " + this.mContext.getResources().getResourceEntryName(this.mResourceId), e);
            }
        }
    }

    private final Pin $$robo$$android_security_net_config_XmlConfigSource$parsePin(XmlResourceParser parser) throws IOException, XmlPullParserException, ParserException {
        String digestAlgorithm = parser.getAttributeValue(null, "digest");
        if (!Pin.isSupportedDigestAlgorithm(digestAlgorithm)) {
            throw new ParserException(parser, "Unsupported pin digest algorithm: " + digestAlgorithm);
        }
        if (parser.next() != 4) {
            throw new ParserException(parser, "Missing pin digest");
        }
        String digest = parser.getText().trim();
        byte[] decodedDigest = null;
        try {
            decodedDigest = Base64.decode(digest, 0);
        }
        catch (IllegalArgumentException e) {
            throw new ParserException(parser, "Invalid pin digest", e);
        }
        int expectedLength = Pin.getDigestLength(digestAlgorithm);
        if (decodedDigest.length != expectedLength) {
            throw new ParserException(parser, "digest length " + decodedDigest.length + " does not match expected length for " + digestAlgorithm + " of " + expectedLength);
        }
        if (parser.next() != 3) {
            throw new ParserException(parser, "pin contains additional elements");
        }
        return new Pin(digestAlgorithm, decodedDigest);
    }

    private final PinSet $$robo$$android_security_net_config_XmlConfigSource$parsePinSet(XmlResourceParser parser) throws IOException, XmlPullParserException, ParserException {
        String expirationDate = parser.getAttributeValue(null, "expiration");
        long expirationTimestampMilis = Long.MAX_VALUE;
        if (expirationDate != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                sdf.setLenient(false);
                Date date = sdf.parse(expirationDate);
                if (date == null) {
                    throw new ParserException(parser, "Invalid expiration date in pin-set");
                }
                expirationTimestampMilis = date.getTime();
            }
            catch (ParseException e) {
                throw new ParserException(parser, "Invalid expiration date in pin-set", e);
            }
        }
        int outerDepth = parser.getDepth();
        ArraySet<Pin> pins = new ArraySet<Pin>();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            String tagName = parser.getName();
            if (tagName.equals("pin")) {
                pins.add(this.parsePin(parser));
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return new PinSet(pins, expirationTimestampMilis);
    }

    private final Domain $$robo$$android_security_net_config_XmlConfigSource$parseDomain(XmlResourceParser parser, Set<String> seenDomains) throws IOException, XmlPullParserException, ParserException {
        boolean includeSubdomains = parser.getAttributeBooleanValue(null, "includeSubdomains", false);
        if (parser.next() != 4) {
            throw new ParserException(parser, "Domain name missing");
        }
        String domain = parser.getText().trim().toLowerCase(Locale.US);
        if (parser.next() != 3) {
            throw new ParserException(parser, "domain contains additional elements");
        }
        if (!seenDomains.add(domain)) {
            throw new ParserException(parser, domain + " has already been specified");
        }
        return new Domain(domain, includeSubdomains);
    }

    private final CertificatesEntryRef $$robo$$android_security_net_config_XmlConfigSource$parseCertificatesEntry(XmlResourceParser parser, boolean defaultOverridePins) throws IOException, XmlPullParserException, ParserException {
        boolean overridePins = parser.getAttributeBooleanValue(null, "overridePins", defaultOverridePins);
        int sourceId = parser.getAttributeResourceValue(null, "src", -1);
        String sourceString = parser.getAttributeValue(null, "src");
        ShadowedObject source = null;
        if (sourceString == null) {
            throw new ParserException(parser, "certificates element missing src attribute");
        }
        if (sourceId != -1) {
            source = new ResourceCertificateSource(sourceId, this.mContext);
        } else if ("system".equals(sourceString)) {
            source = SystemCertificateSource.getInstance();
        } else if ("user".equals(sourceString)) {
            source = UserCertificateSource.getInstance();
        } else {
            throw new ParserException(parser, "Unknown certificates src. Should be one of system|user|@resourceVal");
        }
        XmlUtils.skipCurrentTag(parser);
        return new CertificatesEntryRef((CertificateSource)source, overridePins);
    }

    private final Collection<CertificatesEntryRef> $$robo$$android_security_net_config_XmlConfigSource$parseTrustAnchors(XmlResourceParser parser, boolean defaultOverridePins) throws IOException, XmlPullParserException, ParserException {
        int outerDepth = parser.getDepth();
        ArrayList<CertificatesEntryRef> anchors = new ArrayList<CertificatesEntryRef>();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            String tagName = parser.getName();
            if (tagName.equals("certificates")) {
                anchors.add(this.parseCertificatesEntry(parser, defaultOverridePins));
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return anchors;
    }

    private final List<Pair<NetworkSecurityConfig.Builder, Set<Domain>>> $$robo$$android_security_net_config_XmlConfigSource$parseConfigEntry(XmlResourceParser parser, Set<String> seenDomains, NetworkSecurityConfig.Builder parentBuilder, int configType) throws IOException, XmlPullParserException, ParserException {
        ArrayList<Pair<NetworkSecurityConfig.Builder, Set<Domain>>> builders = new ArrayList<Pair<NetworkSecurityConfig.Builder, Set<Domain>>>();
        NetworkSecurityConfig.Builder builder = new NetworkSecurityConfig.Builder();
        builder.setParent(parentBuilder);
        ArraySet<Domain> domains = new ArraySet<Domain>();
        boolean seenPinSet = false;
        boolean seenTrustAnchors = false;
        boolean defaultOverridePins = configType == 2;
        String configName = parser.getName();
        int outerDepth = parser.getDepth();
        builders.add(new Pair(builder, domains));
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String name = parser.getAttributeName(i);
            if ("hstsEnforced".equals(name)) {
                builder.setHstsEnforced(parser.getAttributeBooleanValue(i, false));
                continue;
            }
            if (!"cleartextTrafficPermitted".equals(name)) continue;
            builder.setCleartextTrafficPermitted(parser.getAttributeBooleanValue(i, true));
        }
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            String tagName = parser.getName();
            if ("domain".equals(tagName)) {
                if (configType != 1) {
                    throw new ParserException(parser, "domain element not allowed in " + XmlConfigSource.getConfigString(configType));
                }
                Domain domain = this.parseDomain(parser, seenDomains);
                domains.add(domain);
                continue;
            }
            if ("trust-anchors".equals(tagName)) {
                if (seenTrustAnchors) {
                    throw new ParserException(parser, "Multiple trust-anchor elements not allowed");
                }
                builder.addCertificatesEntryRefs(this.parseTrustAnchors(parser, defaultOverridePins));
                seenTrustAnchors = true;
                continue;
            }
            if ("pin-set".equals(tagName)) {
                if (configType != 1) {
                    throw new ParserException(parser, "pin-set element not allowed in " + XmlConfigSource.getConfigString(configType));
                }
                if (seenPinSet) {
                    throw new ParserException(parser, "Multiple pin-set elements not allowed");
                }
                builder.setPinSet(this.parsePinSet(parser));
                seenPinSet = true;
                continue;
            }
            if ("domain-config".equals(tagName)) {
                if (configType != 1) {
                    throw new ParserException(parser, "Nested domain-config not allowed in " + XmlConfigSource.getConfigString(configType));
                }
                builders.addAll(this.parseConfigEntry(parser, seenDomains, builder, configType));
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (configType == 1 && domains.isEmpty()) {
            throw new ParserException(parser, "No domain elements in domain-config");
        }
        return builders;
    }

    private final void $$robo$$android_security_net_config_XmlConfigSource$addDebugAnchorsIfNeeded(NetworkSecurityConfig.Builder debugConfigBuilder, NetworkSecurityConfig.Builder builder) {
        if (debugConfigBuilder == null || !debugConfigBuilder.hasCertificatesEntryRefs()) {
            return;
        }
        if (!builder.hasCertificatesEntryRefs()) {
            return;
        }
        builder.addCertificatesEntryRefs(debugConfigBuilder.getCertificatesEntryRefs());
    }

    private final void $$robo$$android_security_net_config_XmlConfigSource$parseNetworkSecurityConfig(XmlResourceParser parser) throws IOException, XmlPullParserException, ParserException {
        ArraySet<String> seenDomains = new ArraySet<String>();
        ArrayList<Pair<NetworkSecurityConfig.Builder, Set<Domain>>> builders = new ArrayList<Pair<NetworkSecurityConfig.Builder, Set<Domain>>>();
        NetworkSecurityConfig.Builder baseConfigBuilder = null;
        NetworkSecurityConfig.Builder debugConfigBuilder = null;
        boolean seenDebugOverrides = false;
        boolean seenBaseConfig = false;
        XmlUtils.beginDocument(parser, "network-security-config");
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if ("base-config".equals(parser.getName())) {
                if (seenBaseConfig) {
                    throw new ParserException(parser, "Only one base-config allowed");
                }
                seenBaseConfig = true;
                baseConfigBuilder = (NetworkSecurityConfig.Builder)this.parseConfigEntry((XmlResourceParser)parser, seenDomains, null, (int)0).get((int)0).first;
                continue;
            }
            if ("domain-config".equals(parser.getName())) {
                builders.addAll(this.parseConfigEntry(parser, seenDomains, baseConfigBuilder, 1));
                continue;
            }
            if ("debug-overrides".equals(parser.getName())) {
                if (seenDebugOverrides) {
                    throw new ParserException(parser, "Only one debug-overrides allowed");
                }
                if (this.mDebugBuild) {
                    debugConfigBuilder = (NetworkSecurityConfig.Builder)this.parseConfigEntry((XmlResourceParser)parser, null, null, (int)2).get((int)0).first;
                } else {
                    XmlUtils.skipCurrentTag(parser);
                }
                seenDebugOverrides = true;
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        if (this.mDebugBuild && debugConfigBuilder == null) {
            debugConfigBuilder = this.parseDebugOverridesResource();
        }
        NetworkSecurityConfig.Builder platformDefaultBuilder = NetworkSecurityConfig.getDefaultBuilder(this.mApplicationInfo);
        this.addDebugAnchorsIfNeeded(debugConfigBuilder, platformDefaultBuilder);
        if (baseConfigBuilder != null) {
            baseConfigBuilder.setParent(platformDefaultBuilder);
            this.addDebugAnchorsIfNeeded(debugConfigBuilder, baseConfigBuilder);
        } else {
            baseConfigBuilder = platformDefaultBuilder;
        }
        ArraySet<Pair<Domain, NetworkSecurityConfig>> configs = new ArraySet<Pair<Domain, NetworkSecurityConfig>>();
        for (Pair pair : builders) {
            NetworkSecurityConfig.Builder builder = (NetworkSecurityConfig.Builder)pair.first;
            Set domains = (Set)pair.second;
            if (builder.getParent() == null) {
                builder.setParent(baseConfigBuilder);
            }
            this.addDebugAnchorsIfNeeded(debugConfigBuilder, builder);
            NetworkSecurityConfig config = builder.build();
            for (Domain domain : domains) {
                configs.add(new Pair<Domain, NetworkSecurityConfig>(domain, config));
            }
        }
        this.mDefaultConfig = baseConfigBuilder.build();
        this.mDomainMap = configs;
    }

    private final NetworkSecurityConfig.Builder $$robo$$android_security_net_config_XmlConfigSource$parseDebugOverridesResource() throws IOException, XmlPullParserException, ParserException {
        Resources resources = this.mContext.getResources();
        String packageName = resources.getResourcePackageName(this.mResourceId);
        String entryName = resources.getResourceEntryName(this.mResourceId);
        int resId = resources.getIdentifier(entryName + "_debug", "xml", packageName);
        if (resId == 0) {
            return null;
        }
        NetworkSecurityConfig.Builder debugConfigBuilder = null;
        try (XmlResourceParser parser = resources.getXml(resId);){
            XmlUtils.beginDocument(parser, "network-security-config");
            int outerDepth = parser.getDepth();
            boolean seenDebugOverrides = false;
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                if ("debug-overrides".equals(parser.getName())) {
                    if (seenDebugOverrides) {
                        throw new ParserException(parser, "Only one debug-overrides allowed");
                    }
                    if (this.mDebugBuild) {
                        debugConfigBuilder = (NetworkSecurityConfig.Builder)this.parseConfigEntry((XmlResourceParser)parser, null, null, (int)2).get((int)0).first;
                    } else {
                        XmlUtils.skipCurrentTag(parser);
                    }
                    seenDebugOverrides = true;
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
        }
        return debugConfigBuilder;
    }

    private void __constructor__(Context context, int n, ApplicationInfo applicationInfo) {
        this.$$robo$$android_security_net_config_XmlConfigSource$__constructor__(context, n, applicationInfo);
    }

    public XmlConfigSource(Context context, int n, ApplicationInfo applicationInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_XmlConfigSource$__constructor__(android.content.Context int android.content.pm.ApplicationInfo ), this, context, n, applicationInfo);
    }

    @Override
    public Set<Pair<Domain, NetworkSecurityConfig>> getPerDomainConfigs() {
        return InvokeDynamicSupport.bootstrap("getPerDomainConfigs", $$robo$$android_security_net_config_XmlConfigSource$getPerDomainConfigs(), this);
    }

    @Override
    public NetworkSecurityConfig getDefaultConfig() {
        return InvokeDynamicSupport.bootstrap("getDefaultConfig", $$robo$$android_security_net_config_XmlConfigSource$getDefaultConfig(), this);
    }

    private static String getConfigString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getConfigString", $$robo$$android_security_net_config_XmlConfigSource$getConfigString(int ), (int)n);
    }

    private void ensureInitialized() {
        InvokeDynamicSupport.bootstrap("ensureInitialized", $$robo$$android_security_net_config_XmlConfigSource$ensureInitialized(), this);
    }

    private Pin parsePin(XmlResourceParser xmlResourceParser) throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parsePin", $$robo$$android_security_net_config_XmlConfigSource$parsePin(android.content.res.XmlResourceParser ), this, xmlResourceParser);
    }

    private PinSet parsePinSet(XmlResourceParser xmlResourceParser) throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parsePinSet", $$robo$$android_security_net_config_XmlConfigSource$parsePinSet(android.content.res.XmlResourceParser ), this, xmlResourceParser);
    }

    private Domain parseDomain(XmlResourceParser xmlResourceParser, Set<String> set) throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parseDomain", $$robo$$android_security_net_config_XmlConfigSource$parseDomain(android.content.res.XmlResourceParser java.util.Set<java.lang.String> ), this, xmlResourceParser, set);
    }

    private CertificatesEntryRef parseCertificatesEntry(XmlResourceParser xmlResourceParser, boolean bl) throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parseCertificatesEntry", $$robo$$android_security_net_config_XmlConfigSource$parseCertificatesEntry(android.content.res.XmlResourceParser boolean ), this, xmlResourceParser, bl);
    }

    private Collection<CertificatesEntryRef> parseTrustAnchors(XmlResourceParser xmlResourceParser, boolean bl) throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parseTrustAnchors", $$robo$$android_security_net_config_XmlConfigSource$parseTrustAnchors(android.content.res.XmlResourceParser boolean ), this, xmlResourceParser, bl);
    }

    private List<Pair<NetworkSecurityConfig.Builder, Set<Domain>>> parseConfigEntry(XmlResourceParser xmlResourceParser, Set<String> set, NetworkSecurityConfig.Builder builder, int n) throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parseConfigEntry", $$robo$$android_security_net_config_XmlConfigSource$parseConfigEntry(android.content.res.XmlResourceParser java.util.Set<java.lang.String> android.security.net.config.NetworkSecurityConfig$Builder int ), this, xmlResourceParser, set, builder, n);
    }

    private void addDebugAnchorsIfNeeded(NetworkSecurityConfig.Builder builder, NetworkSecurityConfig.Builder builder2) {
        InvokeDynamicSupport.bootstrap("addDebugAnchorsIfNeeded", $$robo$$android_security_net_config_XmlConfigSource$addDebugAnchorsIfNeeded(android.security.net.config.NetworkSecurityConfig$Builder android.security.net.config.NetworkSecurityConfig$Builder ), this, builder, builder2);
    }

    private void parseNetworkSecurityConfig(XmlResourceParser xmlResourceParser) throws IOException, XmlPullParserException, ParserException {
        InvokeDynamicSupport.bootstrap("parseNetworkSecurityConfig", $$robo$$android_security_net_config_XmlConfigSource$parseNetworkSecurityConfig(android.content.res.XmlResourceParser ), this, xmlResourceParser);
    }

    private NetworkSecurityConfig.Builder parseDebugOverridesResource() throws IOException, XmlPullParserException, ParserException {
        return InvokeDynamicSupport.bootstrap("parseDebugOverridesResource", $$robo$$android_security_net_config_XmlConfigSource$parseDebugOverridesResource(), this);
    }

    public /* synthetic */ XmlConfigSource() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (XmlConfigSource)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ParserException
    extends Exception
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_net_config_XmlConfigSource_ParserException$__constructor__(XmlPullParser parser, String message, Throwable cause) {
        }

        private void $$robo$$android_security_net_config_XmlConfigSource_ParserException$__constructor__(XmlPullParser parser, String message) {
        }

        private void __constructor__(XmlPullParser xmlPullParser, String string2, Throwable throwable) {
            this.$$robo$$android_security_net_config_XmlConfigSource_ParserException$__constructor__(xmlPullParser, string2, throwable);
        }

        public ParserException(XmlPullParser xmlPullParser, String string2, Throwable throwable) {
            super(string2 + " at: " + xmlPullParser.getPositionDescription(), throwable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_XmlConfigSource_ParserException$__constructor__(org.xmlpull.v1.XmlPullParser java.lang.String java.lang.Throwable ), this, xmlPullParser, string2, throwable);
        }

        private void __constructor__(XmlPullParser xmlPullParser, String string2) {
            this.$$robo$$android_security_net_config_XmlConfigSource_ParserException$__constructor__(xmlPullParser, string2);
        }

        public ParserException(XmlPullParser xmlPullParser, String string2) {
            this(xmlPullParser, string2, null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_XmlConfigSource_ParserException$__constructor__(org.xmlpull.v1.XmlPullParser java.lang.String ), this, xmlPullParser, string2);
        }

        public /* synthetic */ ParserException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParserException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

