/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.util.Pair;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CharSequenceTransformation
extends InternalTransformation
implements Transformation,
Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "CharSequenceTransformation";
    private LinkedHashMap<AutofillId, Pair<Pattern, String>> mFields;
    public static Parcelable.Creator<CharSequenceTransformation> CREATOR;

    private void $$robo$$android_service_autofill_CharSequenceTransformation$__constructor__(Builder builder) {
        this.mFields = builder.mFields;
    }

    private final void $$robo$$android_service_autofill_CharSequenceTransformation$apply(ValueFinder finder, RemoteViews parentTemplate, int childViewId) throws Exception {
        StringBuilder converted = new StringBuilder();
        int size = this.mFields.size();
        if (Helper.sDebug) {
            Log.d("CharSequenceTransformation", size + " multiple fields on id " + childViewId);
        }
        for (Map.Entry<AutofillId, Pair<Pattern, String>> entry : this.mFields.entrySet()) {
            AutofillId id2 = entry.getKey();
            Pair<Pattern, String> field = entry.getValue();
            String value = finder.findByAutofillId(id2);
            if (value == null) {
                Log.w("CharSequenceTransformation", "No value for id " + id2);
                return;
            }
            try {
                Matcher matcher = ((Pattern)field.first).matcher(value);
                if (!matcher.find()) {
                    if (Helper.sDebug) {
                        Log.d("CharSequenceTransformation", "match for " + field.first + " failed on id " + id2);
                    }
                    return;
                }
                String convertedValue = matcher.replaceAll((String)field.second);
                converted.append(convertedValue);
            }
            catch (Exception e) {
                Log.w("CharSequenceTransformation", "Cannot apply " + ((Pattern)field.first).pattern() + "->" + (String)field.second + " to field with autofill id" + id2 + ": " + e.getClass());
                throw e;
            }
        }
        parentTemplate.setCharSequence(childViewId, "setText", converted);
    }

    private final String $$robo$$android_service_autofill_CharSequenceTransformation$toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "MultipleViewsCharSequenceTransformation: [fields=" + this.mFields + "]";
    }

    private final int $$robo$$android_service_autofill_CharSequenceTransformation$describeContents() {
        return 0;
    }

    private final void $$robo$$android_service_autofill_CharSequenceTransformation$writeToParcel(Parcel parcel, int flags) {
        int size = this.mFields.size();
        Parcelable[] ids = new AutofillId[size];
        Pattern[] regexs = new Pattern[size];
        String[] substs = new String[size];
        int i = 0;
        for (Map.Entry<AutofillId, Pair<Pattern, String>> entry : this.mFields.entrySet()) {
            ids[i] = entry.getKey();
            Pair<Pattern, String> pair = entry.getValue();
            regexs[i] = (Pattern)pair.first;
            substs[i] = (String)pair.second;
            ++i;
        }
        parcel.writeParcelableArray(ids, flags);
        parcel.writeSerializable((Serializable)regexs);
        parcel.writeStringArray(substs);
    }

    private /* synthetic */ void $$robo$$android_service_autofill_CharSequenceTransformation$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<CharSequenceTransformation>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_autofill_CharSequenceTransformation_1$__constructor__() {
            }

            private final CharSequenceTransformation $$robo$$android_service_autofill_CharSequenceTransformation_1$createFromParcel(Parcel parcel) {
                AutofillId[] ids = (AutofillId[])parcel.readParcelableArray(null, AutofillId.class);
                Pattern[] regexs = (Pattern[])parcel.readSerializable();
                String[] substs = parcel.createStringArray();
                Builder builder = new Builder(ids[0], regexs[0], substs[0]);
                int size = ids.length;
                for (int i = 1; i < size; ++i) {
                    builder.addField(ids[i], regexs[i], substs[i]);
                }
                return builder.build();
            }

            private final CharSequenceTransformation[] $$robo$$android_service_autofill_CharSequenceTransformation_1$newArray(int size) {
                return new CharSequenceTransformation[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_autofill_CharSequenceTransformation_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_CharSequenceTransformation_1$__constructor__(), this);
            }

            @Override
            public CharSequenceTransformation createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_autofill_CharSequenceTransformation_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public CharSequenceTransformation[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_autofill_CharSequenceTransformation_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_service_autofill_CharSequenceTransformation$__constructor__(builder);
    }

    public CharSequenceTransformation(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_CharSequenceTransformation$__constructor__(android.service.autofill.CharSequenceTransformation$Builder ), this, builder);
    }

    @Override
    public void apply(ValueFinder valueFinder, RemoteViews remoteViews, int n) throws Exception {
        InvokeDynamicSupport.bootstrap("apply", $$robo$$android_service_autofill_CharSequenceTransformation$apply(android.service.autofill.ValueFinder android.widget.RemoteViews int ), this, valueFinder, remoteViews, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_CharSequenceTransformation$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_autofill_CharSequenceTransformation$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_autofill_CharSequenceTransformation$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_service_autofill_CharSequenceTransformation$__constructor__(builder, var2_2);
    }

    public /* synthetic */ CharSequenceTransformation(Builder builder, 1 var2_2) {
        this(builder);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_CharSequenceTransformation$__constructor__(android.service.autofill.CharSequenceTransformation$Builder android.service.autofill.CharSequenceTransformation$1 ), this, builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(CharSequenceTransformation.class);
    }

    public /* synthetic */ CharSequenceTransformation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CharSequenceTransformation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private LinkedHashMap<AutofillId, Pair<Pattern, String>> mFields;
        private boolean mDestroyed;

        private void $$robo$$android_service_autofill_CharSequenceTransformation_Builder$__constructor__(AutofillId id2, Pattern regex, String subst) {
            this.mFields = new LinkedHashMap();
            this.addField(id2, regex, subst);
        }

        private final Builder $$robo$$android_service_autofill_CharSequenceTransformation_Builder$addField(AutofillId id2, Pattern regex, String subst) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(id2);
            Preconditions.checkNotNull(regex);
            Preconditions.checkNotNull(subst);
            this.mFields.put(id2, new Pair<Pattern, String>(regex, subst));
            return this;
        }

        private final CharSequenceTransformation $$robo$$android_service_autofill_CharSequenceTransformation_Builder$build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new CharSequenceTransformation(this, null);
        }

        private final void $$robo$$android_service_autofill_CharSequenceTransformation_Builder$throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already called build()");
        }

        private void __constructor__(AutofillId autofillId, Pattern pattern, String string2) {
            this.$$robo$$android_service_autofill_CharSequenceTransformation_Builder$__constructor__(autofillId, pattern, string2);
        }

        public Builder(AutofillId autofillId, Pattern pattern, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_CharSequenceTransformation_Builder$__constructor__(android.view.autofill.AutofillId java.util.regex.Pattern java.lang.String ), this, autofillId, pattern, string2);
        }

        public Builder addField(AutofillId autofillId, Pattern pattern, String string2) {
            return InvokeDynamicSupport.bootstrap("addField", $$robo$$android_service_autofill_CharSequenceTransformation_Builder$addField(android.view.autofill.AutofillId java.util.regex.Pattern java.lang.String ), this, autofillId, pattern, string2);
        }

        public CharSequenceTransformation build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_service_autofill_CharSequenceTransformation_Builder$build(), this);
        }

        private void throwIfDestroyed() {
            InvokeDynamicSupport.bootstrap("throwIfDestroyed", $$robo$$android_service_autofill_CharSequenceTransformation_Builder$throwIfDestroyed(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

