/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalSanitizer;
import android.service.autofill.Sanitizer;
import android.util.Slog;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextValueSanitizer
extends InternalSanitizer
implements Sanitizer,
Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "TextValueSanitizer";
    private Pattern mRegex;
    private String mSubst;
    public static Parcelable.Creator<TextValueSanitizer> CREATOR;

    private void $$robo$$android_service_autofill_TextValueSanitizer$__constructor__(Pattern regex, String subst) {
        this.mRegex = Preconditions.checkNotNull(regex);
        this.mSubst = Preconditions.checkNotNull(subst);
    }

    private final AutofillValue $$robo$$android_service_autofill_TextValueSanitizer$sanitize(AutofillValue value) {
        if (value == null) {
            Slog.w("TextValueSanitizer", "sanitize() called with null value");
            return null;
        }
        if (!value.isText()) {
            if (Helper.sDebug) {
                Slog.d("TextValueSanitizer", "sanitize() called with non-text value: " + value);
            }
            return null;
        }
        CharSequence text = value.getTextValue();
        try {
            Matcher matcher = this.mRegex.matcher(text);
            if (!matcher.matches()) {
                if (Helper.sDebug) {
                    Slog.d("TextValueSanitizer", "sanitize(): " + this.mRegex + " failed for " + value);
                }
                return null;
            }
            String sanitized = matcher.replaceAll(this.mSubst);
            return AutofillValue.forText(sanitized);
        }
        catch (Exception e) {
            Slog.w("TextValueSanitizer", "Exception evaluating " + this.mRegex + "/" + this.mSubst + ": " + e);
            return null;
        }
    }

    private final String $$robo$$android_service_autofill_TextValueSanitizer$toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "TextValueSanitizer: [regex=" + this.mRegex + ", subst=" + this.mSubst + "]";
    }

    private final int $$robo$$android_service_autofill_TextValueSanitizer$describeContents() {
        return 0;
    }

    private final void $$robo$$android_service_autofill_TextValueSanitizer$writeToParcel(Parcel parcel, int flags) {
        parcel.writeSerializable(this.mRegex);
        parcel.writeString(this.mSubst);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<TextValueSanitizer>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_autofill_TextValueSanitizer_1$__constructor__() {
            }

            private final TextValueSanitizer $$robo$$android_service_autofill_TextValueSanitizer_1$createFromParcel(Parcel parcel) {
                return new TextValueSanitizer((Pattern)parcel.readSerializable(), parcel.readString());
            }

            private final TextValueSanitizer[] $$robo$$android_service_autofill_TextValueSanitizer_1$newArray(int size) {
                return new TextValueSanitizer[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_autofill_TextValueSanitizer_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_TextValueSanitizer_1$__constructor__(), this);
            }

            @Override
            public TextValueSanitizer createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_autofill_TextValueSanitizer_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public TextValueSanitizer[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_autofill_TextValueSanitizer_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Pattern pattern, String string2) {
        this.$$robo$$android_service_autofill_TextValueSanitizer$__constructor__(pattern, string2);
    }

    public TextValueSanitizer(Pattern pattern, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_TextValueSanitizer$__constructor__(java.util.regex.Pattern java.lang.String ), this, pattern, string2);
    }

    @Override
    public AutofillValue sanitize(AutofillValue autofillValue) {
        return InvokeDynamicSupport.bootstrap("sanitize", $$robo$$android_service_autofill_TextValueSanitizer$sanitize(android.view.autofill.AutofillValue ), this, autofillValue);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_autofill_TextValueSanitizer$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_autofill_TextValueSanitizer$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_autofill_TextValueSanitizer$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(TextValueSanitizer.class);
    }

    public /* synthetic */ TextValueSanitizer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextValueSanitizer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

