/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.os.SystemClock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbstractEventLogger
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    protected String mServiceApp;
    protected int mCallerUid;
    protected int mCallerPid;
    protected long mReceivedTime;
    protected long mPlaybackStartTime;
    private volatile long mRequestProcessingStartTime;
    private volatile long mEngineStartTime;
    private volatile long mEngineCompleteTime;
    private boolean mLogWritten;

    private void $$robo$$android_speech_tts_AbstractEventLogger$__constructor__(int callerUid, int callerPid, String serviceApp) {
        this.mPlaybackStartTime = -1L;
        this.mRequestProcessingStartTime = -1L;
        this.mEngineStartTime = -1L;
        this.mEngineCompleteTime = -1L;
        this.mLogWritten = false;
        this.mCallerUid = callerUid;
        this.mCallerPid = callerPid;
        this.mServiceApp = serviceApp;
        this.mReceivedTime = SystemClock.elapsedRealtime();
    }

    private final void $$robo$$android_speech_tts_AbstractEventLogger$onRequestProcessingStart() {
        this.mRequestProcessingStartTime = SystemClock.elapsedRealtime();
    }

    private final void $$robo$$android_speech_tts_AbstractEventLogger$onEngineDataReceived() {
        if (this.mEngineStartTime == -1L) {
            this.mEngineStartTime = SystemClock.elapsedRealtime();
        }
    }

    private final void $$robo$$android_speech_tts_AbstractEventLogger$onEngineComplete() {
        this.mEngineCompleteTime = SystemClock.elapsedRealtime();
    }

    private final void $$robo$$android_speech_tts_AbstractEventLogger$onAudioDataWritten() {
        if (this.mPlaybackStartTime == -1L) {
            this.mPlaybackStartTime = SystemClock.elapsedRealtime();
        }
    }

    private final void $$robo$$android_speech_tts_AbstractEventLogger$onCompleted(int statusCode) {
        if (this.mLogWritten) {
            return;
        }
        this.mLogWritten = true;
        long completionTime = SystemClock.elapsedRealtime();
        if (statusCode != 0 || this.mPlaybackStartTime == -1L || this.mEngineCompleteTime == -1L) {
            this.logFailure(statusCode);
            return;
        }
        long audioLatency = this.mPlaybackStartTime - this.mReceivedTime;
        long engineLatency = this.mEngineStartTime - this.mRequestProcessingStartTime;
        long engineTotal = this.mEngineCompleteTime - this.mRequestProcessingStartTime;
        this.logSuccess(audioLatency, engineLatency, engineTotal);
    }

    protected abstract void logFailure(int var1);

    protected abstract void logSuccess(long var1, long var3, long var5);

    private void __constructor__(int n, int n2, String string2) {
        this.$$robo$$android_speech_tts_AbstractEventLogger$__constructor__(n, n2, string2);
    }

    public AbstractEventLogger(int n, int n2, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_AbstractEventLogger$__constructor__(int int java.lang.String ), this, n, n2, string2);
    }

    public void onRequestProcessingStart() {
        InvokeDynamicSupport.bootstrap("onRequestProcessingStart", $$robo$$android_speech_tts_AbstractEventLogger$onRequestProcessingStart(), this);
    }

    public void onEngineDataReceived() {
        InvokeDynamicSupport.bootstrap("onEngineDataReceived", $$robo$$android_speech_tts_AbstractEventLogger$onEngineDataReceived(), this);
    }

    public void onEngineComplete() {
        InvokeDynamicSupport.bootstrap("onEngineComplete", $$robo$$android_speech_tts_AbstractEventLogger$onEngineComplete(), this);
    }

    public void onAudioDataWritten() {
        InvokeDynamicSupport.bootstrap("onAudioDataWritten", $$robo$$android_speech_tts_AbstractEventLogger$onAudioDataWritten(), this);
    }

    public void onCompleted(int n) {
        InvokeDynamicSupport.bootstrap("onCompleted", $$robo$$android_speech_tts_AbstractEventLogger$onCompleted(int ), this, n);
    }

    public /* synthetic */ AbstractEventLogger() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractEventLogger)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

