/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TtsEngines
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "TtsEngines";
    private static boolean DBG = false;
    private static String LOCALE_DELIMITER_OLD = "-";
    private static String LOCALE_DELIMITER_NEW = "_";
    private Context mContext;
    private static Map<String, String> sNormalizeLanguage;
    private static Map<String, String> sNormalizeCountry;
    private static String XML_TAG_NAME = "tts-engine";

    private void $$robo$$android_speech_tts_TtsEngines$__constructor__(Context ctx) {
        this.mContext = ctx;
    }

    private final String $$robo$$android_speech_tts_TtsEngines$getDefaultEngine() {
        String engine = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_synth");
        return this.isEngineInstalled(engine) ? engine : this.getHighestRankedEngineName();
    }

    private final String $$robo$$android_speech_tts_TtsEngines$getHighestRankedEngineName() {
        List<TextToSpeech.EngineInfo> engines = this.getEngines();
        if (engines.size() > 0 && engines.get((int)0).system) {
            return engines.get((int)0).name;
        }
        return null;
    }

    private final TextToSpeech.EngineInfo $$robo$$android_speech_tts_TtsEngines$getEngineInfo(String packageName) {
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(packageName);
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent, 65536);
        if (resolveInfos != null && resolveInfos.size() == 1) {
            return this.getEngineInfo(resolveInfos.get(0), pm);
        }
        return null;
    }

    private final List<TextToSpeech.EngineInfo> $$robo$$android_speech_tts_TtsEngines$getEngines() {
        Intent intent;
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent = new Intent("android.intent.action.TTS_SERVICE"), 65536);
        if (resolveInfos == null) {
            return Collections.emptyList();
        }
        ArrayList<TextToSpeech.EngineInfo> engines = new ArrayList<TextToSpeech.EngineInfo>(resolveInfos.size());
        for (ResolveInfo resolveInfo : resolveInfos) {
            TextToSpeech.EngineInfo engine = this.getEngineInfo(resolveInfo, pm);
            if (engine == null) continue;
            engines.add(engine);
        }
        Collections.sort(engines, EngineInfoComparator.INSTANCE);
        return engines;
    }

    private final boolean $$robo$$android_speech_tts_TtsEngines$isSystemEngine(ServiceInfo info) {
        ApplicationInfo appInfo = info.applicationInfo;
        return appInfo != null && (appInfo.flags & 1) != 0;
    }

    private final boolean $$robo$$android_speech_tts_TtsEngines$isEngineInstalled(String engine) {
        if (engine == null) {
            return false;
        }
        return this.getEngineInfo(engine) != null;
    }

    private final Intent $$robo$$android_speech_tts_TtsEngines$getSettingsIntent(String engine) {
        String settings;
        ServiceInfo service;
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(engine);
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(intent, 65664);
        if (resolveInfos != null && resolveInfos.size() == 1 && (service = resolveInfos.get((int)0).serviceInfo) != null && (settings = this.settingsActivityFromServiceInfo(service, pm)) != null) {
            Intent i = new Intent();
            i.setClassName(engine, settings);
            return i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_speech_tts_TtsEngines$settingsActivityFromServiceInfo(ServiceInfo si, PackageManager pm) {
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.speech.tts");
            if (parser == null) {
                Log.w("TtsEngines", "No meta-data found for :" + si);
                String string2 = null;
                return string2;
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                if (!"tts-engine".equals(parser.getName())) {
                    Log.w("TtsEngines", "Package " + si + " uses unknown tag :" + parser.getName());
                    String string3 = null;
                    return string3;
                }
                AttributeSet attrs = Xml.asAttributeSet(parser);
                TypedArray array2 = res.obtainAttributes(attrs, R.styleable.TextToSpeechEngine);
                String settings = array2.getString(0);
                array2.recycle();
                String string4 = settings;
                return string4;
            }
            String string5 = null;
            return string5;
        }
    }

    private final TextToSpeech.EngineInfo $$robo$$android_speech_tts_TtsEngines$getEngineInfo(ResolveInfo resolve, PackageManager pm) {
        ServiceInfo service = resolve.serviceInfo;
        if (service != null) {
            TextToSpeech.EngineInfo engine = new TextToSpeech.EngineInfo();
            engine.name = service.packageName;
            CharSequence label = service.loadLabel(pm);
            engine.label = TextUtils.isEmpty(label) ? engine.name : label.toString();
            engine.icon = service.getIconResource();
            engine.priority = resolve.priority;
            engine.system = this.isSystemEngine(service);
            return engine;
        }
        return null;
    }

    private final Locale $$robo$$android_speech_tts_TtsEngines$getLocalePrefForEngine(String engineName) {
        return this.getLocalePrefForEngine(engineName, Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"));
    }

    private final Locale $$robo$$android_speech_tts_TtsEngines$getLocalePrefForEngine(String engineName, String prefValue) {
        String localeString = TtsEngines.parseEnginePrefFromList(prefValue, engineName);
        if (TextUtils.isEmpty(localeString)) {
            return Locale.getDefault();
        }
        Locale result = this.parseLocaleString(localeString);
        if (result == null) {
            Log.w("TtsEngines", "Failed to parse locale " + localeString + ", returning en_US instead");
            result = Locale.US;
        }
        return result;
    }

    private final boolean $$robo$$android_speech_tts_TtsEngines$isLocaleSetToDefaultForEngine(String engineName) {
        return TextUtils.isEmpty(TtsEngines.parseEnginePrefFromList(Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale"), engineName));
    }

    private final Locale $$robo$$android_speech_tts_TtsEngines$parseLocaleString(String localeString) {
        String normalizedCountry;
        String normalizedLanguage;
        String language = "";
        String country = "";
        String variant = "";
        if (!TextUtils.isEmpty(localeString)) {
            String[] split = localeString.split("[-_]");
            language = split[0].toLowerCase();
            if (split.length == 0) {
                Log.w("TtsEngines", "Failed to convert " + localeString + " to a valid Locale object. Only separators");
                return null;
            }
            if (split.length > 3) {
                Log.w("TtsEngines", "Failed to convert " + localeString + " to a valid Locale object. Too many separators");
                return null;
            }
            if (split.length >= 2) {
                country = split[1].toUpperCase();
            }
            if (split.length >= 3) {
                variant = split[2];
            }
        }
        if ((normalizedLanguage = sNormalizeLanguage.get(language)) != null) {
            language = normalizedLanguage;
        }
        if ((normalizedCountry = sNormalizeCountry.get(country)) != null) {
            country = normalizedCountry;
        }
        Locale result = new Locale(language, country, variant);
        try {
            result.getISO3Language();
            result.getISO3Country();
            return result;
        }
        catch (MissingResourceException e) {
            Log.w("TtsEngines", "Failed to convert " + localeString + " to a valid Locale object.");
            return null;
        }
    }

    private static final Locale $$robo$$android_speech_tts_TtsEngines$normalizeTTSLocale(Locale ttsLocale) {
        String normalizedCountry;
        String country;
        String normalizedLanguage;
        String language = ttsLocale.getLanguage();
        if (!TextUtils.isEmpty(language) && (normalizedLanguage = sNormalizeLanguage.get(language)) != null) {
            language = normalizedLanguage;
        }
        if (!TextUtils.isEmpty(country = ttsLocale.getCountry()) && (normalizedCountry = sNormalizeCountry.get(country)) != null) {
            country = normalizedCountry;
        }
        return new Locale(language, country, ttsLocale.getVariant());
    }

    private static final String[] $$robo$$android_speech_tts_TtsEngines$toOldLocaleStringFormat(Locale locale) {
        String[] ret = new String[]{"", "", ""};
        try {
            ret[0] = locale.getISO3Language();
            ret[1] = locale.getISO3Country();
            ret[2] = locale.getVariant();
            return ret;
        }
        catch (MissingResourceException e) {
            return new String[]{"eng", "USA", ""};
        }
    }

    private static final String $$robo$$android_speech_tts_TtsEngines$parseEnginePrefFromList(String prefValue, String engineName) {
        String[] prefValues;
        if (TextUtils.isEmpty(prefValue)) {
            return null;
        }
        for (String value : prefValues = prefValue.split(",")) {
            int delimiter = value.indexOf(58);
            if (delimiter <= 0 || !engineName.equals(value.substring(0, delimiter))) continue;
            return value.substring(delimiter + 1);
        }
        return null;
    }

    private final synchronized void $$robo$$android_speech_tts_TtsEngines$updateLocalePrefForEngine(String engineName, Locale newLocale) {
        String prefList = Settings.Secure.getString(this.mContext.getContentResolver(), "tts_default_locale");
        String newPrefList = this.updateValueInCommaSeparatedList(prefList, engineName, newLocale != null ? newLocale.toString() : "");
        Settings.Secure.putString(this.mContext.getContentResolver(), "tts_default_locale", newPrefList.toString());
    }

    private final String $$robo$$android_speech_tts_TtsEngines$updateValueInCommaSeparatedList(String list, String key, String newValue) {
        StringBuilder newPrefList = new StringBuilder();
        if (TextUtils.isEmpty(list)) {
            newPrefList.append(key).append(':').append(newValue);
        } else {
            String[] prefValues = list.split(",");
            boolean first = true;
            boolean found = false;
            for (String value : prefValues) {
                int delimiter = value.indexOf(58);
                if (delimiter <= 0) continue;
                if (key.equals(value.substring(0, delimiter))) {
                    if (first) {
                        first = false;
                    } else {
                        newPrefList.append(',');
                    }
                    found = true;
                    newPrefList.append(key).append(':').append(newValue);
                    continue;
                }
                if (first) {
                    first = false;
                } else {
                    newPrefList.append(',');
                }
                newPrefList.append(value);
            }
            if (!found) {
                newPrefList.append(',');
                newPrefList.append(key).append(':').append(newValue);
            }
        }
        return newPrefList.toString();
    }

    static void __staticInitializer__() {
        HashMap<String, String> normalizeLanguage = new HashMap<String, String>();
        for (String language : Locale.getISOLanguages()) {
            try {
                normalizeLanguage.put(new Locale(language).getISO3Language(), language);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        sNormalizeLanguage = Collections.unmodifiableMap(normalizeLanguage);
        HashMap<String, String> normalizeCountry = new HashMap<String, String>();
        for (String country : Locale.getISOCountries()) {
            try {
                normalizeCountry.put(new Locale("", country).getISO3Country(), country);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        sNormalizeCountry = Collections.unmodifiableMap(normalizeCountry);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_speech_tts_TtsEngines$__constructor__(context);
    }

    public TtsEngines(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TtsEngines$__constructor__(android.content.Context ), this, context);
    }

    public String getDefaultEngine() {
        return InvokeDynamicSupport.bootstrap("getDefaultEngine", $$robo$$android_speech_tts_TtsEngines$getDefaultEngine(), this);
    }

    public String getHighestRankedEngineName() {
        return InvokeDynamicSupport.bootstrap("getHighestRankedEngineName", $$robo$$android_speech_tts_TtsEngines$getHighestRankedEngineName(), this);
    }

    public TextToSpeech.EngineInfo getEngineInfo(String string2) {
        return InvokeDynamicSupport.bootstrap("getEngineInfo", $$robo$$android_speech_tts_TtsEngines$getEngineInfo(java.lang.String ), this, string2);
    }

    public List<TextToSpeech.EngineInfo> getEngines() {
        return InvokeDynamicSupport.bootstrap("getEngines", $$robo$$android_speech_tts_TtsEngines$getEngines(), this);
    }

    private boolean isSystemEngine(ServiceInfo serviceInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSystemEngine", $$robo$$android_speech_tts_TtsEngines$isSystemEngine(android.content.pm.ServiceInfo ), this, serviceInfo);
    }

    public boolean isEngineInstalled(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isEngineInstalled", $$robo$$android_speech_tts_TtsEngines$isEngineInstalled(java.lang.String ), this, string2);
    }

    public Intent getSettingsIntent(String string2) {
        return InvokeDynamicSupport.bootstrap("getSettingsIntent", $$robo$$android_speech_tts_TtsEngines$getSettingsIntent(java.lang.String ), this, string2);
    }

    private String settingsActivityFromServiceInfo(ServiceInfo serviceInfo, PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("settingsActivityFromServiceInfo", $$robo$$android_speech_tts_TtsEngines$settingsActivityFromServiceInfo(android.content.pm.ServiceInfo android.content.pm.PackageManager ), this, serviceInfo, packageManager);
    }

    private TextToSpeech.EngineInfo getEngineInfo(ResolveInfo resolveInfo, PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("getEngineInfo", $$robo$$android_speech_tts_TtsEngines$getEngineInfo(android.content.pm.ResolveInfo android.content.pm.PackageManager ), this, resolveInfo, packageManager);
    }

    public Locale getLocalePrefForEngine(String string2) {
        return InvokeDynamicSupport.bootstrap("getLocalePrefForEngine", $$robo$$android_speech_tts_TtsEngines$getLocalePrefForEngine(java.lang.String ), this, string2);
    }

    public Locale getLocalePrefForEngine(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getLocalePrefForEngine", $$robo$$android_speech_tts_TtsEngines$getLocalePrefForEngine(java.lang.String java.lang.String ), this, string2, string3);
    }

    public boolean isLocaleSetToDefaultForEngine(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLocaleSetToDefaultForEngine", $$robo$$android_speech_tts_TtsEngines$isLocaleSetToDefaultForEngine(java.lang.String ), this, string2);
    }

    public Locale parseLocaleString(String string2) {
        return InvokeDynamicSupport.bootstrap("parseLocaleString", $$robo$$android_speech_tts_TtsEngines$parseLocaleString(java.lang.String ), this, string2);
    }

    public static Locale normalizeTTSLocale(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("normalizeTTSLocale", $$robo$$android_speech_tts_TtsEngines$normalizeTTSLocale(java.util.Locale ), (Locale)locale);
    }

    public static String[] toOldLocaleStringFormat(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("toOldLocaleStringFormat", $$robo$$android_speech_tts_TtsEngines$toOldLocaleStringFormat(java.util.Locale ), (Locale)locale);
    }

    private static String parseEnginePrefFromList(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("parseEnginePrefFromList", $$robo$$android_speech_tts_TtsEngines$parseEnginePrefFromList(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    public synchronized void updateLocalePrefForEngine(String string2, Locale locale) {
        InvokeDynamicSupport.bootstrap("updateLocalePrefForEngine", $$robo$$android_speech_tts_TtsEngines$updateLocalePrefForEngine(java.lang.String java.util.Locale ), this, string2, locale);
    }

    private String updateValueInCommaSeparatedList(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("updateValueInCommaSeparatedList", $$robo$$android_speech_tts_TtsEngines$updateValueInCommaSeparatedList(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    static {
        RobolectricInternals.classInitializing(TtsEngines.class);
    }

    public /* synthetic */ TtsEngines() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TtsEngines)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class EngineInfoComparator
    implements Comparator<TextToSpeech.EngineInfo> {
        public /* synthetic */ Object __robo_data__;
        static EngineInfoComparator INSTANCE;

        private void $$robo$$android_speech_tts_TtsEngines_EngineInfoComparator$__constructor__() {
        }

        private final int $$robo$$android_speech_tts_TtsEngines_EngineInfoComparator$compare(TextToSpeech.EngineInfo lhs, TextToSpeech.EngineInfo rhs) {
            if (lhs.system && !rhs.system) {
                return -1;
            }
            if (rhs.system && !lhs.system) {
                return 1;
            }
            return rhs.priority - lhs.priority;
        }

        static void __staticInitializer__() {
            INSTANCE = new EngineInfoComparator();
        }

        private void __constructor__() {
            this.$$robo$$android_speech_tts_TtsEngines_EngineInfoComparator$__constructor__();
        }

        public EngineInfoComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TtsEngines_EngineInfoComparator$__constructor__(), this);
        }

        @Override
        public int compare(TextToSpeech.EngineInfo engineInfo, TextToSpeech.EngineInfo engineInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_speech_tts_TtsEngines_EngineInfoComparator$compare(android.speech.tts.TextToSpeech$EngineInfo android.speech.tts.TextToSpeech$EngineInfo ), this, engineInfo, engineInfo2);
        }

        static {
            RobolectricInternals.classInitializing(EngineInfoComparator.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EngineInfoComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

