/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.SystemApi;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.AudioState;
import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IInCallAdapter;
import com.android.internal.telecom.IInCallService;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class InCallService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.telecom.InCallService";
    private static int MSG_SET_IN_CALL_ADAPTER = 1;
    private static int MSG_ADD_CALL = 2;
    private static int MSG_UPDATE_CALL = 3;
    private static int MSG_SET_POST_DIAL_WAIT = 4;
    private static int MSG_ON_CALL_AUDIO_STATE_CHANGED = 5;
    private static int MSG_BRING_TO_FOREGROUND = 6;
    private static int MSG_ON_CAN_ADD_CALL_CHANGED = 7;
    private static int MSG_SILENCE_RINGER = 8;
    private static int MSG_ON_CONNECTION_EVENT = 9;
    private static int MSG_ON_RTT_UPGRADE_REQUEST = 10;
    private static int MSG_ON_RTT_INITIATION_FAILURE = 11;
    private static int MSG_ON_HANDOVER_FAILED = 12;
    private static int MSG_ON_HANDOVER_COMPLETE = 13;
    private Handler mHandler;
    private Phone.Listener mPhoneListener;
    private Phone mPhone;

    private void $$robo$$android_telecom_InCallService$__constructor__() {
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ InCallService this$0;

            private void $$robo$$android_telecom_InCallService_1$__constructor__(InCallService this$0, Looper x0) {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telecom_InCallService_1$handleMessage(Message msg) {
                if (this.this$0.mPhone == null && msg.what != 1) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        String callingPackage = this.this$0.getApplicationContext().getOpPackageName();
                        this.this$0.mPhone = new Phone(new InCallAdapter((IInCallAdapter)msg.obj), callingPackage, this.this$0.getApplicationContext().getApplicationInfo().targetSdkVersion);
                        this.this$0.mPhone.addListener(this.this$0.mPhoneListener);
                        this.this$0.onPhoneCreated(this.this$0.mPhone);
                        break;
                    }
                    case 2: {
                        this.this$0.mPhone.internalAddCall((ParcelableCall)msg.obj);
                        break;
                    }
                    case 3: {
                        this.this$0.mPhone.internalUpdateCall((ParcelableCall)msg.obj);
                        break;
                    }
                    case 4: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            String callId = (String)args.arg1;
                            String remaining = (String)args.arg2;
                            this.this$0.mPhone.internalSetPostDialWait(callId, remaining);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 5: {
                        this.this$0.mPhone.internalCallAudioStateChanged((CallAudioState)msg.obj);
                        break;
                    }
                    case 6: {
                        this.this$0.mPhone.internalBringToForeground(msg.arg1 == 1);
                        break;
                    }
                    case 7: {
                        this.this$0.mPhone.internalSetCanAddCall(msg.arg1 == 1);
                        break;
                    }
                    case 8: {
                        this.this$0.mPhone.internalSilenceRinger();
                        break;
                    }
                    case 9: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            String callId = (String)args.arg1;
                            String event = (String)args.arg2;
                            Bundle extras = (Bundle)args.arg3;
                            this.this$0.mPhone.internalOnConnectionEvent(callId, event, extras);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 10: {
                        String callId = (String)msg.obj;
                        int requestId = msg.arg1;
                        this.this$0.mPhone.internalOnRttUpgradeRequest(callId, requestId);
                        break;
                    }
                    case 11: {
                        String callId = (String)msg.obj;
                        int reason = msg.arg1;
                        this.this$0.mPhone.internalOnRttInitiationFailure(callId, reason);
                        break;
                    }
                    case 12: {
                        String callId = (String)msg.obj;
                        int error = msg.arg1;
                        this.this$0.mPhone.internalOnHandoverFailed(callId, error);
                        break;
                    }
                    case 13: {
                        String callId = (String)msg.obj;
                        this.this$0.mPhone.internalOnHandoverComplete(callId);
                        break;
                    }
                }
            }

            private void __constructor__(InCallService inCallService, Looper looper) {
                this.$$robo$$android_telecom_InCallService_1$__constructor__(inCallService, looper);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService_1$__constructor__(android.telecom.InCallService android.os.Looper ), this, inCallService, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telecom_InCallService_1$handleMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhoneListener = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ InCallService this$0;

            private void $$robo$$android_telecom_InCallService_2$__constructor__(InCallService this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_telecom_InCallService_2$onAudioStateChanged(Phone phone, AudioState audioState) {
                this.this$0.onAudioStateChanged(audioState);
            }

            private final void $$robo$$android_telecom_InCallService_2$onCallAudioStateChanged(Phone phone, CallAudioState callAudioState) {
                this.this$0.onCallAudioStateChanged(callAudioState);
            }

            private final void $$robo$$android_telecom_InCallService_2$onBringToForeground(Phone phone, boolean showDialpad) {
                this.this$0.onBringToForeground(showDialpad);
            }

            private final void $$robo$$android_telecom_InCallService_2$onCallAdded(Phone phone, Call call) {
                this.this$0.onCallAdded(call);
            }

            private final void $$robo$$android_telecom_InCallService_2$onCallRemoved(Phone phone, Call call) {
                this.this$0.onCallRemoved(call);
            }

            private final void $$robo$$android_telecom_InCallService_2$onCanAddCallChanged(Phone phone, boolean canAddCall) {
                this.this$0.onCanAddCallChanged(canAddCall);
            }

            private final void $$robo$$android_telecom_InCallService_2$onSilenceRinger(Phone phone) {
                this.this$0.onSilenceRinger();
            }

            private void __constructor__(InCallService inCallService) {
                this.$$robo$$android_telecom_InCallService_2$__constructor__(inCallService);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService_2$__constructor__(android.telecom.InCallService ), this, inCallService);
            }

            @Override
            public void onAudioStateChanged(Phone phone, AudioState audioState) {
                InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_InCallService_2$onAudioStateChanged(android.telecom.Phone android.telecom.AudioState ), this, phone, audioState);
            }

            @Override
            public void onCallAudioStateChanged(Phone phone, CallAudioState callAudioState) {
                InvokeDynamicSupport.bootstrap("onCallAudioStateChanged", $$robo$$android_telecom_InCallService_2$onCallAudioStateChanged(android.telecom.Phone android.telecom.CallAudioState ), this, phone, callAudioState);
            }

            @Override
            public void onBringToForeground(Phone phone, boolean bl) {
                InvokeDynamicSupport.bootstrap("onBringToForeground", $$robo$$android_telecom_InCallService_2$onBringToForeground(android.telecom.Phone boolean ), this, phone, bl);
            }

            @Override
            public void onCallAdded(Phone phone, Call call) {
                InvokeDynamicSupport.bootstrap("onCallAdded", $$robo$$android_telecom_InCallService_2$onCallAdded(android.telecom.Phone android.telecom.Call ), this, phone, call);
            }

            @Override
            public void onCallRemoved(Phone phone, Call call) {
                InvokeDynamicSupport.bootstrap("onCallRemoved", $$robo$$android_telecom_InCallService_2$onCallRemoved(android.telecom.Phone android.telecom.Call ), this, phone, call);
            }

            @Override
            public void onCanAddCallChanged(Phone phone, boolean bl) {
                InvokeDynamicSupport.bootstrap("onCanAddCallChanged", $$robo$$android_telecom_InCallService_2$onCanAddCallChanged(android.telecom.Phone boolean ), this, phone, bl);
            }

            @Override
            public void onSilenceRinger(Phone phone) {
                InvokeDynamicSupport.bootstrap("onSilenceRinger", $$robo$$android_telecom_InCallService_2$onSilenceRinger(android.telecom.Phone ), this, phone);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final IBinder $$robo$$android_telecom_InCallService$onBind(Intent intent) {
        return new InCallServiceBinder(this, null);
    }

    private final boolean $$robo$$android_telecom_InCallService$onUnbind(Intent intent) {
        if (this.mPhone != null) {
            Phone oldPhone = this.mPhone;
            this.mPhone = null;
            oldPhone.destroy();
            oldPhone.removeListener(this.mPhoneListener);
            this.onPhoneDestroyed(oldPhone);
        }
        return false;
    }

    @SystemApi
    @Deprecated
    private final Phone $$robo$$android_telecom_InCallService$getPhone() {
        return this.mPhone;
    }

    private final List<Call> $$robo$$android_telecom_InCallService$getCalls() {
        return this.mPhone == null ? Collections.emptyList() : this.mPhone.getCalls();
    }

    private final boolean $$robo$$android_telecom_InCallService$canAddCall() {
        return this.mPhone == null ? false : this.mPhone.canAddCall();
    }

    @Deprecated
    private final AudioState $$robo$$android_telecom_InCallService$getAudioState() {
        return this.mPhone == null ? null : this.mPhone.getAudioState();
    }

    private final CallAudioState $$robo$$android_telecom_InCallService$getCallAudioState() {
        return this.mPhone == null ? null : this.mPhone.getCallAudioState();
    }

    private final void $$robo$$android_telecom_InCallService$setMuted(boolean state) {
        if (this.mPhone != null) {
            this.mPhone.setMuted(state);
        }
    }

    private final void $$robo$$android_telecom_InCallService$setAudioRoute(int route) {
        if (this.mPhone != null) {
            this.mPhone.setAudioRoute(route);
        }
    }

    private final void $$robo$$android_telecom_InCallService$requestBluetoothAudio(BluetoothDevice bluetoothDevice) {
        if (this.mPhone != null) {
            this.mPhone.requestBluetoothAudio(bluetoothDevice.getAddress());
        }
    }

    @SystemApi
    @Deprecated
    private final void $$robo$$android_telecom_InCallService$onPhoneCreated(Phone phone) {
    }

    @SystemApi
    @Deprecated
    private final void $$robo$$android_telecom_InCallService$onPhoneDestroyed(Phone phone) {
    }

    @Deprecated
    private final void $$robo$$android_telecom_InCallService$onAudioStateChanged(AudioState audioState) {
    }

    private final void $$robo$$android_telecom_InCallService$onCallAudioStateChanged(CallAudioState audioState) {
    }

    private final void $$robo$$android_telecom_InCallService$onBringToForeground(boolean showDialpad) {
    }

    private final void $$robo$$android_telecom_InCallService$onCallAdded(Call call) {
    }

    private final void $$robo$$android_telecom_InCallService$onCallRemoved(Call call) {
    }

    private final void $$robo$$android_telecom_InCallService$onCanAddCallChanged(boolean canAddCall) {
    }

    private final void $$robo$$android_telecom_InCallService$onSilenceRinger() {
    }

    private final void $$robo$$android_telecom_InCallService$onConnectionEvent(Call call, String event, Bundle extras) {
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_InCallService$__constructor__();
    }

    public InCallService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService$__constructor__(), this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_telecom_InCallService$onBind(android.content.Intent ), this, intent);
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUnbind", $$robo$$android_telecom_InCallService$onUnbind(android.content.Intent ), this, intent);
    }

    @SystemApi
    @Deprecated
    public Phone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$android_telecom_InCallService$getPhone(), this);
    }

    public List<Call> getCalls() {
        return InvokeDynamicSupport.bootstrap("getCalls", $$robo$$android_telecom_InCallService$getCalls(), this);
    }

    public boolean canAddCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAddCall", $$robo$$android_telecom_InCallService$canAddCall(), this);
    }

    @Deprecated
    public AudioState getAudioState() {
        return InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_telecom_InCallService$getAudioState(), this);
    }

    public CallAudioState getCallAudioState() {
        return InvokeDynamicSupport.bootstrap("getCallAudioState", $$robo$$android_telecom_InCallService$getCallAudioState(), this);
    }

    public void setMuted(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMuted", $$robo$$android_telecom_InCallService$setMuted(boolean ), this, bl);
    }

    public void setAudioRoute(int n) {
        InvokeDynamicSupport.bootstrap("setAudioRoute", $$robo$$android_telecom_InCallService$setAudioRoute(int ), this, n);
    }

    public void requestBluetoothAudio(BluetoothDevice bluetoothDevice) {
        InvokeDynamicSupport.bootstrap("requestBluetoothAudio", $$robo$$android_telecom_InCallService$requestBluetoothAudio(android.bluetooth.BluetoothDevice ), this, bluetoothDevice);
    }

    @SystemApi
    @Deprecated
    public void onPhoneCreated(Phone phone) {
        InvokeDynamicSupport.bootstrap("onPhoneCreated", $$robo$$android_telecom_InCallService$onPhoneCreated(android.telecom.Phone ), this, phone);
    }

    @SystemApi
    @Deprecated
    public void onPhoneDestroyed(Phone phone) {
        InvokeDynamicSupport.bootstrap("onPhoneDestroyed", $$robo$$android_telecom_InCallService$onPhoneDestroyed(android.telecom.Phone ), this, phone);
    }

    @Deprecated
    public void onAudioStateChanged(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_InCallService$onAudioStateChanged(android.telecom.AudioState ), this, audioState);
    }

    public void onCallAudioStateChanged(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("onCallAudioStateChanged", $$robo$$android_telecom_InCallService$onCallAudioStateChanged(android.telecom.CallAudioState ), this, callAudioState);
    }

    public void onBringToForeground(boolean bl) {
        InvokeDynamicSupport.bootstrap("onBringToForeground", $$robo$$android_telecom_InCallService$onBringToForeground(boolean ), this, bl);
    }

    public void onCallAdded(Call call) {
        InvokeDynamicSupport.bootstrap("onCallAdded", $$robo$$android_telecom_InCallService$onCallAdded(android.telecom.Call ), this, call);
    }

    public void onCallRemoved(Call call) {
        InvokeDynamicSupport.bootstrap("onCallRemoved", $$robo$$android_telecom_InCallService$onCallRemoved(android.telecom.Call ), this, call);
    }

    public void onCanAddCallChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onCanAddCallChanged", $$robo$$android_telecom_InCallService$onCanAddCallChanged(boolean ), this, bl);
    }

    public void onSilenceRinger() {
        InvokeDynamicSupport.bootstrap("onSilenceRinger", $$robo$$android_telecom_InCallService$onSilenceRinger(), this);
    }

    public void onConnectionEvent(Call call, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_InCallService$onConnectionEvent(android.telecom.Call java.lang.String android.os.Bundle ), this, call, string2, bundle);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InCallService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class VideoCall
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_InCallService_VideoCall$__constructor__() {
        }

        public abstract void destroy();

        public abstract void registerCallback(Callback var1);

        public abstract void registerCallback(Callback var1, Handler var2);

        public abstract void unregisterCallback(Callback var1);

        public abstract void setCamera(String var1);

        public abstract void setPreviewSurface(Surface var1);

        public abstract void setDisplaySurface(Surface var1);

        public abstract void setDeviceOrientation(int var1);

        public abstract void setZoom(float var1);

        public abstract void sendSessionModifyRequest(VideoProfile var1);

        public abstract void sendSessionModifyResponse(VideoProfile var1);

        public abstract void requestCameraCapabilities();

        public abstract void requestCallDataUsage();

        public abstract void setPauseImage(Uri var1);

        private void __constructor__() {
            this.$$robo$$android_telecom_InCallService_VideoCall$__constructor__();
        }

        public VideoCall() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService_VideoCall$__constructor__(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoCall)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static abstract class Callback
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telecom_InCallService_VideoCall_Callback$__constructor__() {
            }

            public abstract void onSessionModifyRequestReceived(VideoProfile var1);

            public abstract void onSessionModifyResponseReceived(int var1, VideoProfile var2, VideoProfile var3);

            public abstract void onCallSessionEvent(int var1);

            public abstract void onPeerDimensionsChanged(int var1, int var2);

            public abstract void onVideoQualityChanged(int var1);

            public abstract void onCallDataUsageChanged(long var1);

            public abstract void onCameraCapabilitiesChanged(VideoProfile.CameraCapabilities var1);

            private void __constructor__() {
                this.$$robo$$android_telecom_InCallService_VideoCall_Callback$__constructor__();
            }

            public Callback() {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService_VideoCall_Callback$__constructor__(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class InCallServiceBinder
    extends IInCallService.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ InCallService this$0;

        private void $$robo$$android_telecom_InCallService_InCallServiceBinder$__constructor__(InCallService inCallService) {
            this.this$0 = inCallService;
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$setInCallAdapter(IInCallAdapter inCallAdapter) {
            this.this$0.mHandler.obtainMessage(1, inCallAdapter).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$addCall(ParcelableCall call) {
            this.this$0.mHandler.obtainMessage(2, call).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$updateCall(ParcelableCall call) {
            this.this$0.mHandler.obtainMessage(3, call).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$setPostDial(String callId, String remaining) {
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$setPostDialWait(String callId, String remaining) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.arg2 = remaining;
            this.this$0.mHandler.obtainMessage(4, args).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onCallAudioStateChanged(CallAudioState callAudioState) {
            this.this$0.mHandler.obtainMessage(5, callAudioState).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$bringToForeground(boolean showDialpad) {
            this.this$0.mHandler.obtainMessage(6, showDialpad ? 1 : 0, 0).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onCanAddCallChanged(boolean canAddCall) {
            this.this$0.mHandler.obtainMessage(7, canAddCall ? 1 : 0, 0).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$silenceRinger() {
            this.this$0.mHandler.obtainMessage(8).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onConnectionEvent(String callId, String event, Bundle extras) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.arg2 = event;
            args.arg3 = extras;
            this.this$0.mHandler.obtainMessage(9, args).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onRttUpgradeRequest(String callId, int id2) {
            this.this$0.mHandler.obtainMessage(10, id2, 0, callId).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onRttInitiationFailure(String callId, int reason) {
            this.this$0.mHandler.obtainMessage(11, reason, 0, callId).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onHandoverFailed(String callId, int error) {
            this.this$0.mHandler.obtainMessage(12, error, 0, callId).sendToTarget();
        }

        private final void $$robo$$android_telecom_InCallService_InCallServiceBinder$onHandoverComplete(String callId) {
            this.this$0.mHandler.obtainMessage(13, callId).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_telecom_InCallService_InCallServiceBinder$__constructor__(InCallService x0, 1 x1) {
        }

        private void __constructor__(InCallService inCallService) {
            this.$$robo$$android_telecom_InCallService_InCallServiceBinder$__constructor__(inCallService);
        }

        public InCallServiceBinder(InCallService inCallService) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService_InCallServiceBinder$__constructor__(android.telecom.InCallService ), this, inCallService);
        }

        @Override
        public void setInCallAdapter(IInCallAdapter iInCallAdapter) {
            InvokeDynamicSupport.bootstrap("setInCallAdapter", $$robo$$android_telecom_InCallService_InCallServiceBinder$setInCallAdapter(com.android.internal.telecom.IInCallAdapter ), this, iInCallAdapter);
        }

        @Override
        public void addCall(ParcelableCall parcelableCall) {
            InvokeDynamicSupport.bootstrap("addCall", $$robo$$android_telecom_InCallService_InCallServiceBinder$addCall(android.telecom.ParcelableCall ), this, parcelableCall);
        }

        @Override
        public void updateCall(ParcelableCall parcelableCall) {
            InvokeDynamicSupport.bootstrap("updateCall", $$robo$$android_telecom_InCallService_InCallServiceBinder$updateCall(android.telecom.ParcelableCall ), this, parcelableCall);
        }

        @Override
        public void setPostDial(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("setPostDial", $$robo$$android_telecom_InCallService_InCallServiceBinder$setPostDial(java.lang.String java.lang.String ), this, string2, string3);
        }

        @Override
        public void setPostDialWait(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("setPostDialWait", $$robo$$android_telecom_InCallService_InCallServiceBinder$setPostDialWait(java.lang.String java.lang.String ), this, string2, string3);
        }

        @Override
        public void onCallAudioStateChanged(CallAudioState callAudioState) {
            InvokeDynamicSupport.bootstrap("onCallAudioStateChanged", $$robo$$android_telecom_InCallService_InCallServiceBinder$onCallAudioStateChanged(android.telecom.CallAudioState ), this, callAudioState);
        }

        @Override
        public void bringToForeground(boolean bl) {
            InvokeDynamicSupport.bootstrap("bringToForeground", $$robo$$android_telecom_InCallService_InCallServiceBinder$bringToForeground(boolean ), this, bl);
        }

        @Override
        public void onCanAddCallChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onCanAddCallChanged", $$robo$$android_telecom_InCallService_InCallServiceBinder$onCanAddCallChanged(boolean ), this, bl);
        }

        @Override
        public void silenceRinger() {
            InvokeDynamicSupport.bootstrap("silenceRinger", $$robo$$android_telecom_InCallService_InCallServiceBinder$silenceRinger(), this);
        }

        @Override
        public void onConnectionEvent(String string2, String string3, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_InCallService_InCallServiceBinder$onConnectionEvent(java.lang.String java.lang.String android.os.Bundle ), this, string2, string3, bundle);
        }

        @Override
        public void onRttUpgradeRequest(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onRttUpgradeRequest", $$robo$$android_telecom_InCallService_InCallServiceBinder$onRttUpgradeRequest(java.lang.String int ), this, string2, n);
        }

        @Override
        public void onRttInitiationFailure(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onRttInitiationFailure", $$robo$$android_telecom_InCallService_InCallServiceBinder$onRttInitiationFailure(java.lang.String int ), this, string2, n);
        }

        @Override
        public void onHandoverFailed(String string2, int n) {
            InvokeDynamicSupport.bootstrap("onHandoverFailed", $$robo$$android_telecom_InCallService_InCallServiceBinder$onHandoverFailed(java.lang.String int ), this, string2, n);
        }

        @Override
        public void onHandoverComplete(String string2) {
            InvokeDynamicSupport.bootstrap("onHandoverComplete", $$robo$$android_telecom_InCallService_InCallServiceBinder$onHandoverComplete(java.lang.String ), this, string2);
        }

        private /* synthetic */ void __constructor__(InCallService inCallService, 1 var2_2) {
            this.$$robo$$android_telecom_InCallService_InCallServiceBinder$__constructor__(inCallService, var2_2);
        }

        public /* synthetic */ InCallServiceBinder(InCallService inCallService, 1 var2_2) {
            this(inCallService);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_InCallService_InCallServiceBinder$__constructor__(android.telecom.InCallService android.telecom.InCallService$1 ), this, inCallService, var2_2);
        }

        public /* synthetic */ InCallServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InCallServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

