/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VideoCallImpl
extends InCallService.VideoCall
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private IVideoProvider mVideoProvider;
    private VideoCallListenerBinder mBinder;
    private InCallService.VideoCall.Callback mCallback;
    private int mVideoQuality;
    private int mVideoState;
    private String mCallingPackageName;
    private int mTargetSdkVersion;
    private IBinder.DeathRecipient mDeathRecipient;
    private Handler mHandler;

    private void $$robo$$android_telecom_VideoCallImpl$__constructor__(IVideoProvider videoProvider, String callingPackageName, int targetSdkVersion) throws RemoteException {
        this.mVideoQuality = 0;
        this.mVideoState = 0;
        this.mDeathRecipient = new IBinder.DeathRecipient(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoCallImpl this$0;

            private void $$robo$$android_telecom_VideoCallImpl_1$__constructor__(VideoCallImpl this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_telecom_VideoCallImpl_1$binderDied() {
                this.this$0.mVideoProvider.asBinder().unlinkToDeath(this, 0);
            }

            private void __constructor__(VideoCallImpl videoCallImpl) {
                this.$$robo$$android_telecom_VideoCallImpl_1$__constructor__(videoCallImpl);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_VideoCallImpl_1$__constructor__(android.telecom.VideoCallImpl ), this, videoCallImpl);
            }

            @Override
            public void binderDied() {
                InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_telecom_VideoCallImpl_1$binderDied(), this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mVideoProvider = videoProvider;
        this.mVideoProvider.asBinder().linkToDeath(this.mDeathRecipient, 0);
        this.mBinder = new VideoCallListenerBinder(this, null);
        this.mVideoProvider.addVideoCallback(this.mBinder);
        this.mCallingPackageName = callingPackageName;
        this.setTargetSdkVersion(targetSdkVersion);
    }

    @VisibleForTesting
    private final void $$robo$$android_telecom_VideoCallImpl$setTargetSdkVersion(int sdkVersion) {
        this.mTargetSdkVersion = sdkVersion;
    }

    private final void $$robo$$android_telecom_VideoCallImpl$destroy() {
        this.unregisterCallback(this.mCallback);
    }

    private final void $$robo$$android_telecom_VideoCallImpl$registerCallback(InCallService.VideoCall.Callback callback) {
        this.registerCallback(callback, null);
    }

    private final void $$robo$$android_telecom_VideoCallImpl$registerCallback(InCallService.VideoCall.Callback callback, Handler handler) {
        this.mCallback = callback;
        this.mHandler = handler == null ? new MessageHandler(this, Looper.getMainLooper()) : new MessageHandler(this, handler.getLooper());
    }

    private final void $$robo$$android_telecom_VideoCallImpl$unregisterCallback(InCallService.VideoCall.Callback callback) {
        if (callback != this.mCallback) {
            return;
        }
        this.mCallback = null;
        try {
            this.mVideoProvider.removeVideoCallback(this.mBinder);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setCamera(String cameraId) {
        try {
            Log.w(this, "setCamera: cameraId=%s, calling=%s", cameraId, this.mCallingPackageName);
            this.mVideoProvider.setCamera(cameraId, this.mCallingPackageName, this.mTargetSdkVersion);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setPreviewSurface(Surface surface) {
        try {
            this.mVideoProvider.setPreviewSurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setDisplaySurface(Surface surface) {
        try {
            this.mVideoProvider.setDisplaySurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setDeviceOrientation(int rotation) {
        try {
            this.mVideoProvider.setDeviceOrientation(rotation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setZoom(float value) {
        try {
            this.mVideoProvider.setZoom(value);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$sendSessionModifyRequest(VideoProfile requestProfile) {
        try {
            VideoProfile originalProfile = new VideoProfile(this.mVideoState, this.mVideoQuality);
            this.mVideoProvider.sendSessionModifyRequest(originalProfile, requestProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$sendSessionModifyResponse(VideoProfile responseProfile) {
        try {
            this.mVideoProvider.sendSessionModifyResponse(responseProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$requestCameraCapabilities() {
        try {
            this.mVideoProvider.requestCameraCapabilities();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$requestCallDataUsage() {
        try {
            this.mVideoProvider.requestCallDataUsage();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setPauseImage(Uri uri) {
        try {
            this.mVideoProvider.setPauseImage(uri);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_VideoCallImpl$setVideoState(int videoState) {
        this.mVideoState = videoState;
    }

    private void __constructor__(IVideoProvider iVideoProvider, String string2, int n) throws RemoteException {
        this.$$robo$$android_telecom_VideoCallImpl$__constructor__(iVideoProvider, string2, n);
    }

    public VideoCallImpl(IVideoProvider iVideoProvider, String string2, int n) throws RemoteException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_VideoCallImpl$__constructor__(com.android.internal.telecom.IVideoProvider java.lang.String int ), this, iVideoProvider, string2, n);
    }

    public void setTargetSdkVersion(int n) {
        InvokeDynamicSupport.bootstrap("setTargetSdkVersion", $$robo$$android_telecom_VideoCallImpl$setTargetSdkVersion(int ), this, n);
    }

    @Override
    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_telecom_VideoCallImpl$destroy(), this);
    }

    @Override
    public void registerCallback(InCallService.VideoCall.Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_VideoCallImpl$registerCallback(android.telecom.InCallService$VideoCall$Callback ), this, callback);
    }

    @Override
    public void registerCallback(InCallService.VideoCall.Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_VideoCallImpl$registerCallback(android.telecom.InCallService$VideoCall$Callback android.os.Handler ), this, callback, handler);
    }

    @Override
    public void unregisterCallback(InCallService.VideoCall.Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_VideoCallImpl$unregisterCallback(android.telecom.InCallService$VideoCall$Callback ), this, callback);
    }

    @Override
    public void setCamera(String string2) {
        InvokeDynamicSupport.bootstrap("setCamera", $$robo$$android_telecom_VideoCallImpl$setCamera(java.lang.String ), this, string2);
    }

    @Override
    public void setPreviewSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setPreviewSurface", $$robo$$android_telecom_VideoCallImpl$setPreviewSurface(android.view.Surface ), this, surface);
    }

    @Override
    public void setDisplaySurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setDisplaySurface", $$robo$$android_telecom_VideoCallImpl$setDisplaySurface(android.view.Surface ), this, surface);
    }

    @Override
    public void setDeviceOrientation(int n) {
        InvokeDynamicSupport.bootstrap("setDeviceOrientation", $$robo$$android_telecom_VideoCallImpl$setDeviceOrientation(int ), this, n);
    }

    @Override
    public void setZoom(float f) {
        InvokeDynamicSupport.bootstrap("setZoom", $$robo$$android_telecom_VideoCallImpl$setZoom(float ), this, f);
    }

    @Override
    public void sendSessionModifyRequest(VideoProfile videoProfile) {
        InvokeDynamicSupport.bootstrap("sendSessionModifyRequest", $$robo$$android_telecom_VideoCallImpl$sendSessionModifyRequest(android.telecom.VideoProfile ), this, videoProfile);
    }

    @Override
    public void sendSessionModifyResponse(VideoProfile videoProfile) {
        InvokeDynamicSupport.bootstrap("sendSessionModifyResponse", $$robo$$android_telecom_VideoCallImpl$sendSessionModifyResponse(android.telecom.VideoProfile ), this, videoProfile);
    }

    @Override
    public void requestCameraCapabilities() {
        InvokeDynamicSupport.bootstrap("requestCameraCapabilities", $$robo$$android_telecom_VideoCallImpl$requestCameraCapabilities(), this);
    }

    @Override
    public void requestCallDataUsage() {
        InvokeDynamicSupport.bootstrap("requestCallDataUsage", $$robo$$android_telecom_VideoCallImpl$requestCallDataUsage(), this);
    }

    @Override
    public void setPauseImage(Uri uri) {
        InvokeDynamicSupport.bootstrap("setPauseImage", $$robo$$android_telecom_VideoCallImpl$setPauseImage(android.net.Uri ), this, uri);
    }

    public void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_VideoCallImpl$setVideoState(int ), this, n);
    }

    public /* synthetic */ VideoCallImpl() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoCallImpl)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MessageHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int MSG_RECEIVE_SESSION_MODIFY_REQUEST = 1;
        private static int MSG_RECEIVE_SESSION_MODIFY_RESPONSE = 2;
        private static int MSG_HANDLE_CALL_SESSION_EVENT = 3;
        private static int MSG_CHANGE_PEER_DIMENSIONS = 4;
        private static int MSG_CHANGE_CALL_DATA_USAGE = 5;
        private static int MSG_CHANGE_CAMERA_CAPABILITIES = 6;
        private static int MSG_CHANGE_VIDEO_QUALITY = 7;
        /* synthetic */ VideoCallImpl this$0;

        private void $$robo$$android_telecom_VideoCallImpl_MessageHandler$__constructor__(VideoCallImpl videoCallImpl, Looper looper) {
            this.this$0 = videoCallImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_telecom_VideoCallImpl_MessageHandler$handleMessage(Message msg) {
            if (this.this$0.mCallback == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    this.this$0.mCallback.onSessionModifyRequestReceived((VideoProfile)msg.obj);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int status = (Integer)args.arg1;
                        VideoProfile requestProfile = (VideoProfile)args.arg2;
                        VideoProfile responseProfile = (VideoProfile)args.arg3;
                        this.this$0.mCallback.onSessionModifyResponseReceived(status, requestProfile, responseProfile);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    this.this$0.mCallback.onCallSessionEvent((Integer)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int width = (Integer)args.arg1;
                        int height = (Integer)args.arg2;
                        this.this$0.mCallback.onPeerDimensionsChanged(width, height);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    this.this$0.mCallback.onCallDataUsageChanged((Long)msg.obj);
                    break;
                }
                case 6: {
                    this.this$0.mCallback.onCameraCapabilitiesChanged((VideoProfile.CameraCapabilities)msg.obj);
                    break;
                }
                case 7: {
                    this.this$0.mVideoQuality = msg.arg1;
                    this.this$0.mCallback.onVideoQualityChanged(msg.arg1);
                    break;
                }
            }
        }

        private void __constructor__(VideoCallImpl videoCallImpl, Looper looper) {
            this.$$robo$$android_telecom_VideoCallImpl_MessageHandler$__constructor__(videoCallImpl, looper);
        }

        public MessageHandler(VideoCallImpl videoCallImpl, Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_VideoCallImpl_MessageHandler$__constructor__(android.telecom.VideoCallImpl android.os.Looper ), this, videoCallImpl, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telecom_VideoCallImpl_MessageHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ MessageHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class VideoCallListenerBinder
    extends IVideoCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ VideoCallImpl this$0;

        private void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$__constructor__(VideoCallImpl videoCallImpl) {
            this.this$0 = videoCallImpl;
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$receiveSessionModifyRequest(VideoProfile videoProfile) {
            if (this.this$0.mHandler == null) {
                return;
            }
            this.this$0.mHandler.obtainMessage(1, videoProfile).sendToTarget();
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$receiveSessionModifyResponse(int status, VideoProfile requestProfile, VideoProfile responseProfile) {
            if (this.this$0.mHandler == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = status;
            args.arg2 = requestProfile;
            args.arg3 = responseProfile;
            this.this$0.mHandler.obtainMessage(2, args).sendToTarget();
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$handleCallSessionEvent(int event) {
            if (this.this$0.mHandler == null) {
                return;
            }
            this.this$0.mHandler.obtainMessage(3, event).sendToTarget();
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changePeerDimensions(int width, int height) {
            if (this.this$0.mHandler == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = width;
            args.arg2 = height;
            this.this$0.mHandler.obtainMessage(4, args).sendToTarget();
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changeVideoQuality(int videoQuality) {
            if (this.this$0.mHandler == null) {
                return;
            }
            this.this$0.mHandler.obtainMessage(7, videoQuality, 0).sendToTarget();
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changeCallDataUsage(long dataUsage) {
            if (this.this$0.mHandler == null) {
                return;
            }
            this.this$0.mHandler.obtainMessage(5, dataUsage).sendToTarget();
        }

        private final void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
            if (this.this$0.mHandler == null) {
                return;
            }
            this.this$0.mHandler.obtainMessage(6, cameraCapabilities).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$__constructor__(VideoCallImpl x0, 1 x1) {
        }

        private void __constructor__(VideoCallImpl videoCallImpl) {
            this.$$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$__constructor__(videoCallImpl);
        }

        public VideoCallListenerBinder(VideoCallImpl videoCallImpl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$__constructor__(android.telecom.VideoCallImpl ), this, videoCallImpl);
        }

        @Override
        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            InvokeDynamicSupport.bootstrap("receiveSessionModifyRequest", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$receiveSessionModifyRequest(android.telecom.VideoProfile ), this, videoProfile);
        }

        @Override
        public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
            InvokeDynamicSupport.bootstrap("receiveSessionModifyResponse", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$receiveSessionModifyResponse(int android.telecom.VideoProfile android.telecom.VideoProfile ), this, n, videoProfile, videoProfile2);
        }

        @Override
        public void handleCallSessionEvent(int n) {
            InvokeDynamicSupport.bootstrap("handleCallSessionEvent", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$handleCallSessionEvent(int ), this, n);
        }

        @Override
        public void changePeerDimensions(int n, int n2) {
            InvokeDynamicSupport.bootstrap("changePeerDimensions", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changePeerDimensions(int int ), this, n, n2);
        }

        @Override
        public void changeVideoQuality(int n) {
            InvokeDynamicSupport.bootstrap("changeVideoQuality", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changeVideoQuality(int ), this, n);
        }

        @Override
        public void changeCallDataUsage(long l) {
            InvokeDynamicSupport.bootstrap("changeCallDataUsage", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changeCallDataUsage(long ), this, l);
        }

        @Override
        public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
            InvokeDynamicSupport.bootstrap("changeCameraCapabilities", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$changeCameraCapabilities(android.telecom.VideoProfile$CameraCapabilities ), this, cameraCapabilities);
        }

        private /* synthetic */ void __constructor__(VideoCallImpl videoCallImpl, 1 var2_2) {
            this.$$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$__constructor__(videoCallImpl, var2_2);
        }

        public /* synthetic */ VideoCallListenerBinder(VideoCallImpl videoCallImpl, 1 var2_2) {
            this(videoCallImpl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_VideoCallImpl_VideoCallListenerBinder$__constructor__(android.telecom.VideoCallImpl android.telecom.VideoCallImpl$1 ), this, videoCallImpl, var2_2);
        }

        public /* synthetic */ VideoCallListenerBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoCallListenerBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

