/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsRcsFeature;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.IImsServiceControllerListener;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.MmTelFeature;
import android.telephony.ims.feature.RcsFeature;
import android.telephony.ims.stub.ImsConfigImplBase;
import android.telephony.ims.stub.ImsFeatureConfiguration;
import android.telephony.ims.stub.ImsRegistrationImplBase;
import android.util.Log;
import android.util.SparseArray;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.internal.annotations.VisibleForTesting;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public class ImsService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsService";
    public static String SERVICE_INTERFACE = "android.telephony.ims.ImsService";
    private SparseArray<SparseArray<ImsFeature>> mFeaturesBySlot;
    private IImsServiceControllerListener mListener;
    protected IBinder mImsServiceController;

    private void $$robo$$android_telephony_ims_ImsService$__constructor__() {
        this.mFeaturesBySlot = new SparseArray();
        this.mImsServiceController = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsService this$0;

            private void $$robo$$android_telephony_ims_ImsService_1$__constructor__(ImsService this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_telephony_ims_ImsService_1$setListener(IImsServiceControllerListener l) {
                this.this$0.mListener = l;
            }

            private final IImsMmTelFeature $$robo$$android_telephony_ims_ImsService_1$createMmTelFeature(int slotId, IImsFeatureStatusCallback c) {
                return this.this$0.createMmTelFeatureInternal(slotId, c);
            }

            private final IImsRcsFeature $$robo$$android_telephony_ims_ImsService_1$createRcsFeature(int slotId, IImsFeatureStatusCallback c) {
                return this.this$0.createRcsFeatureInternal(slotId, c);
            }

            private final void $$robo$$android_telephony_ims_ImsService_1$removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) {
                this.this$0.removeImsFeature(slotId, featureType, c);
            }

            private final ImsFeatureConfiguration $$robo$$android_telephony_ims_ImsService_1$querySupportedImsFeatures() {
                return this.this$0.querySupportedImsFeatures();
            }

            private final void $$robo$$android_telephony_ims_ImsService_1$notifyImsServiceReadyForFeatureCreation() {
                this.this$0.readyForFeatureCreation();
            }

            private final IImsConfig $$robo$$android_telephony_ims_ImsService_1$getConfig(int slotId) {
                ImsConfigImplBase c = this.this$0.getConfig(slotId);
                return c != null ? c.getIImsConfig() : null;
            }

            private final IImsRegistration $$robo$$android_telephony_ims_ImsService_1$getRegistration(int slotId) {
                ImsRegistrationImplBase r = this.this$0.getRegistration(slotId);
                return r != null ? r.getBinder() : null;
            }

            private final void $$robo$$android_telephony_ims_ImsService_1$enableIms(int slotId) {
                this.this$0.enableIms(slotId);
            }

            private final void $$robo$$android_telephony_ims_ImsService_1$disableIms(int slotId) {
                this.this$0.disableIms(slotId);
            }

            private void __constructor__(ImsService imsService) {
                this.$$robo$$android_telephony_ims_ImsService_1$__constructor__(imsService);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsService_1$__constructor__(android.telephony.ims.ImsService ), this, imsService);
            }

            @Override
            public void setListener(IImsServiceControllerListener iImsServiceControllerListener) {
                InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_telephony_ims_ImsService_1$setListener(android.telephony.ims.aidl.IImsServiceControllerListener ), this, iImsServiceControllerListener);
            }

            @Override
            public IImsMmTelFeature createMmTelFeature(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
                return InvokeDynamicSupport.bootstrap("createMmTelFeature", $$robo$$android_telephony_ims_ImsService_1$createMmTelFeature(int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, iImsFeatureStatusCallback);
            }

            @Override
            public IImsRcsFeature createRcsFeature(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
                return InvokeDynamicSupport.bootstrap("createRcsFeature", $$robo$$android_telephony_ims_ImsService_1$createRcsFeature(int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, iImsFeatureStatusCallback);
            }

            @Override
            public void removeImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
                InvokeDynamicSupport.bootstrap("removeImsFeature", $$robo$$android_telephony_ims_ImsService_1$removeImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, n2, iImsFeatureStatusCallback);
            }

            @Override
            public ImsFeatureConfiguration querySupportedImsFeatures() {
                return InvokeDynamicSupport.bootstrap("querySupportedImsFeatures", $$robo$$android_telephony_ims_ImsService_1$querySupportedImsFeatures(), this);
            }

            @Override
            public void notifyImsServiceReadyForFeatureCreation() {
                InvokeDynamicSupport.bootstrap("notifyImsServiceReadyForFeatureCreation", $$robo$$android_telephony_ims_ImsService_1$notifyImsServiceReadyForFeatureCreation(), this);
            }

            @Override
            public IImsConfig getConfig(int n) {
                return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_telephony_ims_ImsService_1$getConfig(int ), this, n);
            }

            @Override
            public IImsRegistration getRegistration(int n) {
                return InvokeDynamicSupport.bootstrap("getRegistration", $$robo$$android_telephony_ims_ImsService_1$getRegistration(int ), this, n);
            }

            @Override
            public void enableIms(int n) {
                InvokeDynamicSupport.bootstrap("enableIms", $$robo$$android_telephony_ims_ImsService_1$enableIms(int ), this, n);
            }

            @Override
            public void disableIms(int n) {
                InvokeDynamicSupport.bootstrap("disableIms", $$robo$$android_telephony_ims_ImsService_1$disableIms(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final IBinder $$robo$$android_telephony_ims_ImsService$onBind(Intent intent) {
        if ("android.telephony.ims.ImsService".equals(intent.getAction())) {
            Log.i("ImsService", "ImsService Bound.");
            return this.mImsServiceController;
        }
        return null;
    }

    @VisibleForTesting
    private final SparseArray<ImsFeature> $$robo$$android_telephony_ims_ImsService$getFeatures(int slotId) {
        return this.mFeaturesBySlot.get(slotId);
    }

    private final IImsMmTelFeature $$robo$$android_telephony_ims_ImsService$createMmTelFeatureInternal(int slotId, IImsFeatureStatusCallback c) {
        MmTelFeature f = this.createMmTelFeature(slotId);
        if (f != null) {
            this.setupFeature(f, slotId, 1, c);
            return f.getBinder();
        }
        Log.e("ImsService", "createMmTelFeatureInternal: null feature returned.");
        return null;
    }

    private final IImsRcsFeature $$robo$$android_telephony_ims_ImsService$createRcsFeatureInternal(int slotId, IImsFeatureStatusCallback c) {
        RcsFeature f = this.createRcsFeature(slotId);
        if (f != null) {
            this.setupFeature(f, slotId, 2, c);
            return f.getBinder();
        }
        Log.e("ImsService", "createRcsFeatureInternal: null feature returned.");
        return null;
    }

    private final void $$robo$$android_telephony_ims_ImsService$setupFeature(ImsFeature f, int slotId, int featureType, IImsFeatureStatusCallback c) {
        f.addImsFeatureStatusCallback(c);
        f.initialize(this, slotId);
        this.addImsFeature(slotId, featureType, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_ImsService$addImsFeature(int slotId, int featureType, ImsFeature f) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                features = new SparseArray();
                this.mFeaturesBySlot.put(slotId, features);
            }
            features.put(featureType, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_ImsService$removeImsFeature(int slotId, int featureType, IImsFeatureStatusCallback c) {
        SparseArray<SparseArray<ImsFeature>> sparseArray = this.mFeaturesBySlot;
        synchronized (sparseArray) {
            SparseArray<ImsFeature> features = this.mFeaturesBySlot.get(slotId);
            if (features == null) {
                Log.w("ImsService", "Can not remove ImsFeature. No ImsFeatures exist on slot " + slotId);
                return;
            }
            ImsFeature f = features.get(featureType);
            if (f == null) {
                Log.w("ImsService", "Can not remove ImsFeature. No feature with type " + featureType + " exists on slot " + slotId);
                return;
            }
            f.removeImsFeatureStatusCallback(c);
            f.onFeatureRemoved();
            features.remove(featureType);
        }
    }

    private final ImsFeatureConfiguration $$robo$$android_telephony_ims_ImsService$querySupportedImsFeatures() {
        return new ImsFeatureConfiguration();
    }

    private final void $$robo$$android_telephony_ims_ImsService$onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) throws RemoteException {
        if (this.mListener == null) {
            throw new IllegalStateException("Framework is not ready");
        }
        this.mListener.onUpdateSupportedImsFeatures(c);
    }

    private final void $$robo$$android_telephony_ims_ImsService$readyForFeatureCreation() {
    }

    private final void $$robo$$android_telephony_ims_ImsService$enableIms(int slotId) {
    }

    private final void $$robo$$android_telephony_ims_ImsService$disableIms(int slotId) {
    }

    private final MmTelFeature $$robo$$android_telephony_ims_ImsService$createMmTelFeature(int slotId) {
        return null;
    }

    private final RcsFeature $$robo$$android_telephony_ims_ImsService$createRcsFeature(int slotId) {
        return null;
    }

    private final ImsConfigImplBase $$robo$$android_telephony_ims_ImsService$getConfig(int slotId) {
        return new ImsConfigImplBase();
    }

    private final ImsRegistrationImplBase $$robo$$android_telephony_ims_ImsService$getRegistration(int slotId) {
        return new ImsRegistrationImplBase();
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_ims_ImsService$__constructor__();
    }

    public ImsService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsService$__constructor__(), this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_telephony_ims_ImsService$onBind(android.content.Intent ), this, intent);
    }

    public SparseArray<ImsFeature> getFeatures(int n) {
        return InvokeDynamicSupport.bootstrap("getFeatures", $$robo$$android_telephony_ims_ImsService$getFeatures(int ), this, n);
    }

    private IImsMmTelFeature createMmTelFeatureInternal(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        return InvokeDynamicSupport.bootstrap("createMmTelFeatureInternal", $$robo$$android_telephony_ims_ImsService$createMmTelFeatureInternal(int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, iImsFeatureStatusCallback);
    }

    private IImsRcsFeature createRcsFeatureInternal(int n, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        return InvokeDynamicSupport.bootstrap("createRcsFeatureInternal", $$robo$$android_telephony_ims_ImsService$createRcsFeatureInternal(int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, iImsFeatureStatusCallback);
    }

    private void setupFeature(ImsFeature imsFeature, int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("setupFeature", $$robo$$android_telephony_ims_ImsService$setupFeature(android.telephony.ims.feature.ImsFeature int int com.android.ims.internal.IImsFeatureStatusCallback ), this, imsFeature, n, n2, iImsFeatureStatusCallback);
    }

    private void addImsFeature(int n, int n2, ImsFeature imsFeature) {
        InvokeDynamicSupport.bootstrap("addImsFeature", $$robo$$android_telephony_ims_ImsService$addImsFeature(int int android.telephony.ims.feature.ImsFeature ), this, n, n2, imsFeature);
    }

    private void removeImsFeature(int n, int n2, IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("removeImsFeature", $$robo$$android_telephony_ims_ImsService$removeImsFeature(int int com.android.ims.internal.IImsFeatureStatusCallback ), this, n, n2, iImsFeatureStatusCallback);
    }

    public ImsFeatureConfiguration querySupportedImsFeatures() {
        return InvokeDynamicSupport.bootstrap("querySupportedImsFeatures", $$robo$$android_telephony_ims_ImsService$querySupportedImsFeatures(), this);
    }

    public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration imsFeatureConfiguration) throws RemoteException {
        InvokeDynamicSupport.bootstrap("onUpdateSupportedImsFeatures", $$robo$$android_telephony_ims_ImsService$onUpdateSupportedImsFeatures(android.telephony.ims.stub.ImsFeatureConfiguration ), this, imsFeatureConfiguration);
    }

    public void readyForFeatureCreation() {
        InvokeDynamicSupport.bootstrap("readyForFeatureCreation", $$robo$$android_telephony_ims_ImsService$readyForFeatureCreation(), this);
    }

    public void enableIms(int n) {
        InvokeDynamicSupport.bootstrap("enableIms", $$robo$$android_telephony_ims_ImsService$enableIms(int ), this, n);
    }

    public void disableIms(int n) {
        InvokeDynamicSupport.bootstrap("disableIms", $$robo$$android_telephony_ims_ImsService$disableIms(int ), this, n);
    }

    public MmTelFeature createMmTelFeature(int n) {
        return InvokeDynamicSupport.bootstrap("createMmTelFeature", $$robo$$android_telephony_ims_ImsService$createMmTelFeature(int ), this, n);
    }

    public RcsFeature createRcsFeature(int n) {
        return InvokeDynamicSupport.bootstrap("createRcsFeature", $$robo$$android_telephony_ims_ImsService$createRcsFeature(int ), this, n);
    }

    public ImsConfigImplBase getConfig(int n) {
        return InvokeDynamicSupport.bootstrap("getConfig", $$robo$$android_telephony_ims_ImsService$getConfig(int ), this, n);
    }

    public ImsRegistrationImplBase getRegistration(int n) {
        return InvokeDynamicSupport.bootstrap("getRegistration", $$robo$$android_telephony_ims_ImsService$getRegistration(int ), this, n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Listener
    extends IImsServiceControllerListener.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telephony_ims_ImsService_Listener$__constructor__() {
        }

        private final void $$robo$$android_telephony_ims_ImsService_Listener$onUpdateSupportedImsFeatures(ImsFeatureConfiguration c) {
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_ims_ImsService_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_ImsService_Listener$__constructor__(), this);
        }

        @Override
        public void onUpdateSupportedImsFeatures(ImsFeatureConfiguration imsFeatureConfiguration) {
            InvokeDynamicSupport.bootstrap("onUpdateSupportedImsFeatures", $$robo$$android_telephony_ims_ImsService_Listener$onUpdateSupportedImsFeatures(android.telephony.ims.stub.ImsFeatureConfiguration ), this, imsFeatureConfiguration);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

