/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.Intent;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.util.Log;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@SystemApi
public abstract class ImsFeature
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsFeature";
    public static String ACTION_IMS_SERVICE_UP = "com.android.ims.IMS_SERVICE_UP";
    public static String ACTION_IMS_SERVICE_DOWN = "com.android.ims.IMS_SERVICE_DOWN";
    public static String EXTRA_PHONE_ID = "android:phone_id";
    public static int FEATURE_INVALID = -1;
    public static int FEATURE_EMERGENCY_MMTEL = 0;
    public static int FEATURE_MMTEL = 1;
    public static int FEATURE_RCS = 2;
    public static int FEATURE_MAX = 3;
    public static int STATE_UNAVAILABLE = 0;
    public static int STATE_INITIALIZING = 1;
    public static int STATE_READY = 2;
    public static int CAPABILITY_ERROR_GENERIC = -1;
    public static int CAPABILITY_SUCCESS = 0;
    private Set<IImsFeatureStatusCallback> mStatusCallbacks;
    private int mState;
    private int mSlotId;
    protected Context mContext;
    private Object mLock;
    private RemoteCallbackList<IImsCapabilityCallback> mCapabilityCallbacks;
    private Capabilities mCapabilityStatus;

    private void $$robo$$android_telephony_ims_feature_ImsFeature$__constructor__() {
        this.mStatusCallbacks = Collections.newSetFromMap(new WeakHashMap());
        this.mState = 0;
        this.mSlotId = -1;
        this.mLock = new Object();
        this.mCapabilityCallbacks = new RemoteCallbackList();
        this.mCapabilityStatus = new Capabilities();
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$initialize(Context context, int slotId) {
        this.mContext = context;
        this.mSlotId = slotId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_telephony_ims_feature_ImsFeature$getFeatureState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$setFeatureState(int state) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != state) {
                this.mState = state;
                this.notifyFeatureState(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$addImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        try {
            c.notifyImsFeatureStatus(this.getFeatureState());
            Object object = this.mLock;
            synchronized (object) {
                this.mStatusCallbacks.add(c);
            }
        }
        catch (RemoteException e) {
            Log.w("ImsFeature", "Couldn't notify feature state: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$removeImsFeatureStatusCallback(IImsFeatureStatusCallback c) {
        Object object = this.mLock;
        synchronized (object) {
            this.mStatusCallbacks.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$notifyFeatureState(int state) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsFeatureStatusCallback> iter = this.mStatusCallbacks.iterator();
            while (iter.hasNext()) {
                IImsFeatureStatusCallback callback = iter.next();
                try {
                    Log.i("ImsFeature", "notifying ImsFeatureState=" + state);
                    callback.notifyImsFeatureStatus(state);
                }
                catch (RemoteException e) {
                    iter.remove();
                    Log.w("ImsFeature", "Couldn't notify feature state: " + e.getMessage());
                }
            }
        }
        this.sendImsServiceIntent(state);
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$sendImsServiceIntent(int state) {
        Intent intent;
        if (this.mContext == null || this.mSlotId == -1) {
            return;
        }
        switch (state) {
            case 0: 
            case 1: {
                intent = new Intent("com.android.ims.IMS_SERVICE_DOWN");
                break;
            }
            case 2: {
                intent = new Intent("com.android.ims.IMS_SERVICE_UP");
                break;
            }
            default: {
                intent = new Intent("com.android.ims.IMS_SERVICE_DOWN");
            }
        }
        intent.putExtra("android:phone_id", this.mSlotId);
        this.mContext.sendBroadcast(intent);
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$addCapabilityCallback(IImsCapabilityCallback c) {
        this.mCapabilityCallbacks.register(c);
    }

    private final void $$robo$$android_telephony_ims_feature_ImsFeature$removeCapabilityCallback(IImsCapabilityCallback c) {
        this.mCapabilityCallbacks.unregister(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final Capabilities $$robo$$android_telephony_ims_feature_ImsFeature$queryCapabilityStatus() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCapabilityStatus.copy();
        }
    }

    @VisibleForTesting
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$requestChangeEnabledCapabilities(CapabilityChangeRequest request, IImsCapabilityCallback c) {
        if (request == null) {
            throw new IllegalArgumentException("ImsFeature#requestChangeEnabledCapabilities called with invalid params.");
        }
        this.changeEnabledCapabilities(request, new CapabilityCallbackProxy(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ims_feature_ImsFeature$notifyCapabilitiesStatusChanged(Capabilities c) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCapabilityStatus = c.copy();
        }
        int count = this.mCapabilityCallbacks.beginBroadcast();
        try {
            for (int i = 0; i < count; ++i) {
                try {
                    this.mCapabilityCallbacks.getBroadcastItem(i).onCapabilitiesStatusChanged(c.mCapabilities);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w("ImsFeature", e + " notifyCapabilitiesStatusChanged() - Skipping callback.");
                }
            }
        }
        finally {
            this.mCapabilityCallbacks.finishBroadcast();
        }
    }

    public abstract void changeEnabledCapabilities(CapabilityChangeRequest var1, CapabilityCallbackProxy var2);

    public abstract void onFeatureRemoved();

    public abstract void onFeatureReady();

    protected abstract IInterface getBinder();

    private void __constructor__() {
        this.$$robo$$android_telephony_ims_feature_ImsFeature$__constructor__();
    }

    public ImsFeature() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_feature_ImsFeature$__constructor__(), this);
    }

    public void initialize(Context context, int n) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_telephony_ims_feature_ImsFeature$initialize(android.content.Context int ), this, context, n);
    }

    public int getFeatureState() {
        return (int)InvokeDynamicSupport.bootstrap("getFeatureState", $$robo$$android_telephony_ims_feature_ImsFeature$getFeatureState(), this);
    }

    public void setFeatureState(int n) {
        InvokeDynamicSupport.bootstrap("setFeatureState", $$robo$$android_telephony_ims_feature_ImsFeature$setFeatureState(int ), this, n);
    }

    public void addImsFeatureStatusCallback(IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("addImsFeatureStatusCallback", $$robo$$android_telephony_ims_feature_ImsFeature$addImsFeatureStatusCallback(com.android.ims.internal.IImsFeatureStatusCallback ), this, iImsFeatureStatusCallback);
    }

    public void removeImsFeatureStatusCallback(IImsFeatureStatusCallback iImsFeatureStatusCallback) {
        InvokeDynamicSupport.bootstrap("removeImsFeatureStatusCallback", $$robo$$android_telephony_ims_feature_ImsFeature$removeImsFeatureStatusCallback(com.android.ims.internal.IImsFeatureStatusCallback ), this, iImsFeatureStatusCallback);
    }

    private void notifyFeatureState(int n) {
        InvokeDynamicSupport.bootstrap("notifyFeatureState", $$robo$$android_telephony_ims_feature_ImsFeature$notifyFeatureState(int ), this, n);
    }

    private void sendImsServiceIntent(int n) {
        InvokeDynamicSupport.bootstrap("sendImsServiceIntent", $$robo$$android_telephony_ims_feature_ImsFeature$sendImsServiceIntent(int ), this, n);
    }

    public void addCapabilityCallback(IImsCapabilityCallback iImsCapabilityCallback) {
        InvokeDynamicSupport.bootstrap("addCapabilityCallback", $$robo$$android_telephony_ims_feature_ImsFeature$addCapabilityCallback(android.telephony.ims.aidl.IImsCapabilityCallback ), this, iImsCapabilityCallback);
    }

    public void removeCapabilityCallback(IImsCapabilityCallback iImsCapabilityCallback) {
        InvokeDynamicSupport.bootstrap("removeCapabilityCallback", $$robo$$android_telephony_ims_feature_ImsFeature$removeCapabilityCallback(android.telephony.ims.aidl.IImsCapabilityCallback ), this, iImsCapabilityCallback);
    }

    public Capabilities queryCapabilityStatus() {
        return InvokeDynamicSupport.bootstrap("queryCapabilityStatus", $$robo$$android_telephony_ims_feature_ImsFeature$queryCapabilityStatus(), this);
    }

    public void requestChangeEnabledCapabilities(CapabilityChangeRequest capabilityChangeRequest, IImsCapabilityCallback iImsCapabilityCallback) {
        InvokeDynamicSupport.bootstrap("requestChangeEnabledCapabilities", $$robo$$android_telephony_ims_feature_ImsFeature$requestChangeEnabledCapabilities(android.telephony.ims.feature.CapabilityChangeRequest android.telephony.ims.aidl.IImsCapabilityCallback ), this, capabilityChangeRequest, iImsCapabilityCallback);
    }

    protected void notifyCapabilitiesStatusChanged(Capabilities capabilities) {
        InvokeDynamicSupport.bootstrap("notifyCapabilitiesStatusChanged", $$robo$$android_telephony_ims_feature_ImsFeature$notifyCapabilitiesStatusChanged(android.telephony.ims.feature.ImsFeature$Capabilities ), this, capabilities);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsFeature)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Capabilities
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected int mCapabilities;

        private void $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$__constructor__() {
            this.mCapabilities = 0;
        }

        private void $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$__constructor__(int capabilities) {
            this.mCapabilities = 0;
            this.mCapabilities = capabilities;
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$addCapabilities(int capabilities) {
            this.mCapabilities |= capabilities;
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$removeCapabilities(int capabilities) {
            this.mCapabilities &= ~capabilities;
        }

        private final boolean $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$isCapable(int capabilities) {
            return (this.mCapabilities & capabilities) == capabilities;
        }

        private final Capabilities $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$copy() {
            return new Capabilities(this.mCapabilities);
        }

        private final int $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$getMask() {
            return this.mCapabilities;
        }

        private final boolean $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Capabilities)) {
                return false;
            }
            Capabilities that = (Capabilities)o;
            return this.mCapabilities == that.mCapabilities;
        }

        private final int $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$hashCode() {
            return this.mCapabilities;
        }

        private final String $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$toString() {
            return "Capabilities: " + Integer.toBinaryString(this.mCapabilities);
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$__constructor__();
        }

        public Capabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$__constructor__(), this);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$__constructor__(n);
        }

        public Capabilities(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$__constructor__(int ), this, n);
        }

        public void addCapabilities(int n) {
            InvokeDynamicSupport.bootstrap("addCapabilities", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$addCapabilities(int ), this, n);
        }

        public void removeCapabilities(int n) {
            InvokeDynamicSupport.bootstrap("removeCapabilities", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$removeCapabilities(int ), this, n);
        }

        public boolean isCapable(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isCapable", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$isCapable(int ), this, n);
        }

        public Capabilities copy() {
            return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$copy(), this);
        }

        public int getMask() {
            return (int)InvokeDynamicSupport.bootstrap("getMask", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$getMask(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_ims_feature_ImsFeature_Capabilities$toString(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Capabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    protected static class CapabilityCallbackProxy
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private IImsCapabilityCallback mCallback;

        private void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallbackProxy$__constructor__(IImsCapabilityCallback c) {
            this.mCallback = c;
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallbackProxy$onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
            if (this.mCallback == null) {
                return;
            }
            try {
                this.mCallback.onChangeCapabilityConfigurationError(capability, radioTech, reason);
            }
            catch (RemoteException e) {
                Log.e("ImsFeature", "onChangeCapabilityConfigurationError called on dead binder.");
            }
        }

        private void __constructor__(IImsCapabilityCallback iImsCapabilityCallback) {
            this.$$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallbackProxy$__constructor__(iImsCapabilityCallback);
        }

        public CapabilityCallbackProxy(IImsCapabilityCallback iImsCapabilityCallback) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallbackProxy$__constructor__(android.telephony.ims.aidl.IImsCapabilityCallback ), this, iImsCapabilityCallback);
        }

        public void onChangeCapabilityConfigurationError(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onChangeCapabilityConfigurationError", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallbackProxy$onChangeCapabilityConfigurationError(int int int ), this, n, n2, n3);
        }

        public /* synthetic */ CapabilityCallbackProxy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CapabilityCallbackProxy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class CapabilityCallback
    extends IImsCapabilityCallback.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$__constructor__() {
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onCapabilitiesStatusChanged(int config) throws RemoteException {
            this.onCapabilitiesStatusChanged(new Capabilities(config));
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onQueryCapabilityConfiguration(int capability, int radioTech, boolean isEnabled) {
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onChangeCapabilityConfigurationError(int capability, int radioTech, int reason) {
        }

        private final void $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onCapabilitiesStatusChanged(Capabilities config) {
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$__constructor__();
        }

        public CapabilityCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$__constructor__(), this);
        }

        @Override
        public void onCapabilitiesStatusChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onCapabilitiesStatusChanged", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onCapabilitiesStatusChanged(int ), this, n);
        }

        @Override
        public void onQueryCapabilityConfiguration(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("onQueryCapabilityConfiguration", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onQueryCapabilityConfiguration(int int boolean ), this, n, n2, bl);
        }

        @Override
        public void onChangeCapabilityConfigurationError(int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onChangeCapabilityConfigurationError", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onChangeCapabilityConfigurationError(int int int ), this, n, n2, n3);
        }

        public void onCapabilitiesStatusChanged(Capabilities capabilities) {
            InvokeDynamicSupport.bootstrap("onCapabilitiesStatusChanged", $$robo$$android_telephony_ims_feature_ImsFeature_CapabilityCallback$onCapabilitiesStatusChanged(android.telephony.ims.feature.ImsFeature$Capabilities ), this, capabilities);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CapabilityCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsCapabilityError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FeatureType {
    }
}

