/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.telephony.mbms.MbmsTempFileProvider;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MbmsUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "MbmsUtils";

    private void $$robo$$android_telephony_mbms_MbmsUtils$__constructor__() {
    }

    private static final boolean $$robo$$android_telephony_mbms_MbmsUtils$isContainedIn(File parent, File child) {
        try {
            String parentPath = parent.getCanonicalPath();
            String childPath = child.getCanonicalPath();
            return childPath.startsWith(parentPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve canonical paths: " + e);
        }
    }

    private static final ComponentName $$robo$$android_telephony_mbms_MbmsUtils$toComponentName(ComponentInfo ci) {
        return new ComponentName(ci.packageName, ci.name);
    }

    private static final ComponentName $$robo$$android_telephony_mbms_MbmsUtils$getOverrideServiceName(Context context, String serviceAction) {
        ApplicationInfo appInfo;
        String metaDataKey = null;
        switch (serviceAction) {
            case "android.telephony.action.EmbmsDownload": {
                metaDataKey = "mbms-download-service-override";
                break;
            }
            case "android.telephony.action.EmbmsStreaming": {
                metaDataKey = "mbms-streaming-service-override";
            }
        }
        if (metaDataKey == null) {
            return null;
        }
        try {
            appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        if (appInfo.metaData == null) {
            return null;
        }
        String serviceComponent = appInfo.metaData.getString(metaDataKey);
        if (serviceComponent == null) {
            return null;
        }
        return ComponentName.unflattenFromString(serviceComponent);
    }

    private static final ServiceInfo $$robo$$android_telephony_mbms_MbmsUtils$getMiddlewareServiceInfo(Context context, String serviceAction) {
        List<ResolveInfo> services;
        PackageManager packageManager = context.getPackageManager();
        Intent queryIntent = new Intent();
        queryIntent.setAction(serviceAction);
        ComponentName overrideService = MbmsUtils.getOverrideServiceName(context, serviceAction);
        if (overrideService == null) {
            services = packageManager.queryIntentServices(queryIntent, 0x100000);
        } else {
            queryIntent.setComponent(overrideService);
            services = packageManager.queryIntentServices(queryIntent, 131072);
        }
        if (services == null || services.size() == 0) {
            Log.w("MbmsUtils", "No MBMS services found, cannot get service info");
            return null;
        }
        if (services.size() > 1) {
            Log.w("MbmsUtils", "More than one MBMS service found, cannot get unique service");
            return null;
        }
        return services.get((int)0).serviceInfo;
    }

    private static final int $$robo$$android_telephony_mbms_MbmsUtils$startBinding(Context context, String serviceAction, ServiceConnection serviceConnection) {
        Intent bindIntent = new Intent();
        ServiceInfo mbmsServiceInfo = MbmsUtils.getMiddlewareServiceInfo(context, serviceAction);
        if (mbmsServiceInfo == null) {
            return 1;
        }
        bindIntent.setComponent(MbmsUtils.toComponentName(mbmsServiceInfo));
        context.bindService(bindIntent, serviceConnection, 1);
        return 0;
    }

    private static final File $$robo$$android_telephony_mbms_MbmsUtils$getEmbmsTempFileDirForService(Context context, String serviceId) {
        String sanitizedServiceId = serviceId.replaceAll("[^a-zA-Z0-9_]", "_");
        File embmsTempFileDir = MbmsTempFileProvider.getEmbmsTempFileDir(context);
        return new File(embmsTempFileDir, sanitizedServiceId);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_mbms_MbmsUtils$__constructor__();
    }

    public MbmsUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_mbms_MbmsUtils$__constructor__(), this);
    }

    public static boolean isContainedIn(File file, File file2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isContainedIn", $$robo$$android_telephony_mbms_MbmsUtils$isContainedIn(java.io.File java.io.File ), (File)file, (File)file2);
    }

    public static ComponentName toComponentName(ComponentInfo componentInfo) {
        return InvokeDynamicSupport.bootstrapStatic("toComponentName", $$robo$$android_telephony_mbms_MbmsUtils$toComponentName(android.content.pm.ComponentInfo ), (ComponentInfo)componentInfo);
    }

    public static ComponentName getOverrideServiceName(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getOverrideServiceName", $$robo$$android_telephony_mbms_MbmsUtils$getOverrideServiceName(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public static ServiceInfo getMiddlewareServiceInfo(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getMiddlewareServiceInfo", $$robo$$android_telephony_mbms_MbmsUtils$getMiddlewareServiceInfo(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public static int startBinding(Context context, String string2, ServiceConnection serviceConnection) {
        return (int)InvokeDynamicSupport.bootstrapStatic("startBinding", $$robo$$android_telephony_mbms_MbmsUtils$startBinding(android.content.Context java.lang.String android.content.ServiceConnection ), (Context)context, (String)string2, (ServiceConnection)serviceConnection);
    }

    public static File getEmbmsTempFileDirForService(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getEmbmsTempFileDirForService", $$robo$$android_telephony_mbms_MbmsUtils$getEmbmsTempFileDirForService(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MbmsUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

