/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.icu.lang.UCharacter;
import android.icu.text.Bidi;
import android.icu.text.BidiClassifier;
import android.text.Emoji;
import android.text.Layout;
import com.android.internal.annotations.VisibleForTesting;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class AndroidBidi
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static EmojiBidiOverride sEmojiBidiOverride;

    private void $$robo$$android_text_AndroidBidi$__constructor__() {
    }

    private static final int $$robo$$android_text_AndroidBidi$bidi(int dir, char[] chs, byte[] chInfo) {
        byte paraLevel;
        if (chs == null || chInfo == null) {
            throw new NullPointerException();
        }
        int length = chs.length;
        if (chInfo.length < length) {
            throw new IndexOutOfBoundsException();
        }
        switch (dir) {
            case 1: {
                paraLevel = 0;
                break;
            }
            case -1: {
                paraLevel = 1;
                break;
            }
            case 2: {
                paraLevel = 126;
                break;
            }
            case -2: {
                paraLevel = 127;
                break;
            }
            default: {
                paraLevel = 0;
            }
        }
        Bidi icuBidi = new Bidi(length, 0);
        icuBidi.setCustomClassifier(sEmojiBidiOverride);
        icuBidi.setPara(chs, paraLevel, null);
        for (int i = 0; i < length; ++i) {
            chInfo[i] = icuBidi.getLevelAt(i);
        }
        byte result = icuBidi.getParaLevel();
        return (result & 1) == 0 ? 1 : -1;
    }

    private static final Layout.Directions $$robo$$android_text_AndroidBidi$directions(int dir, byte[] levels, int lstart, char[] chars, int cstart, int len) {
        boolean swap;
        int i;
        int curLevel;
        if (len == 0) {
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        int baseLevel = dir == 1 ? 0 : 1;
        int minLevel = curLevel = levels[lstart];
        int runCount = 1;
        int e = lstart + len;
        for (int i2 = lstart + 1; i2 < e; ++i2) {
            int level = levels[i2];
            if (level == curLevel) continue;
            curLevel = level;
            ++runCount;
        }
        int visLen = len;
        if ((curLevel & 1) != (baseLevel & 1)) {
            while (--visLen >= 0) {
                char ch = chars[cstart + visLen];
                if (ch == '\n') {
                    --visLen;
                    break;
                }
                if (ch == ' ' || ch == '\t') continue;
                break;
            }
            if (++visLen != len) {
                ++runCount;
            }
        }
        if (runCount == 1 && minLevel == baseLevel) {
            if ((minLevel & 1) != 0) {
                return Layout.DIRS_ALL_RIGHT_TO_LEFT;
            }
            return Layout.DIRS_ALL_LEFT_TO_RIGHT;
        }
        int[] ld = new int[runCount * 2];
        int maxLevel = minLevel;
        int levelBits = minLevel << 26;
        int n = 1;
        int prev = lstart;
        curLevel = minLevel;
        int e2 = lstart + visLen;
        for (i = lstart; i < e2; ++i) {
            int level = levels[i];
            if (level == curLevel) continue;
            curLevel = level;
            if (level > maxLevel) {
                maxLevel = level;
            } else if (level < minLevel) {
                minLevel = level;
            }
            ld[n++] = i - prev | levelBits;
            ld[n++] = i - lstart;
            levelBits = curLevel << 26;
            prev = i;
        }
        ld[n] = lstart + visLen - prev | levelBits;
        if (visLen < len) {
            ld[++n] = visLen;
            ld[++n] = len - visLen | baseLevel << 26;
        }
        if ((minLevel & 1) == baseLevel) {
            swap = maxLevel > ++minLevel;
        } else {
            boolean bl = swap = runCount > 1;
        }
        if (swap) {
            for (int level = maxLevel - 1; level >= minLevel; --level) {
                for (i = 0; i < ld.length; i += 2) {
                    if (levels[ld[i]] < level) continue;
                    for (e2 = i + 2; e2 < ld.length && levels[ld[e2]] >= level; e2 += 2) {
                    }
                    int low = i;
                    for (int hi = e2 - 2; low < hi; low += 2, hi -= 2) {
                        int x = ld[low];
                        ld[low] = ld[hi];
                        ld[hi] = x;
                        x = ld[low + 1];
                        ld[low + 1] = ld[hi + 1];
                        ld[hi + 1] = x;
                    }
                    i = e2 + 2;
                }
            }
        }
        return new Layout.Directions(ld);
    }

    static void __staticInitializer__() {
        sEmojiBidiOverride = new EmojiBidiOverride();
    }

    private void __constructor__() {
        this.$$robo$$android_text_AndroidBidi$__constructor__();
    }

    public AndroidBidi() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_AndroidBidi$__constructor__(), this);
    }

    public static int bidi(int n, char[] cArray, byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("bidi", $$robo$$android_text_AndroidBidi$bidi(int char[] byte[] ), (int)n, (char[])cArray, (byte[])byArray);
    }

    public static Layout.Directions directions(int n, byte[] byArray, int n2, char[] cArray, int n3, int n4) {
        return InvokeDynamicSupport.bootstrapStatic("directions", $$robo$$android_text_AndroidBidi$directions(int byte[] int char[] int int ), (int)n, (byte[])byArray, (int)n2, (char[])cArray, (int)n3, (int)n4);
    }

    static {
        RobolectricInternals.classInitializing(AndroidBidi.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidBidi)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class EmojiBidiOverride
    extends BidiClassifier
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int NO_OVERRIDE;

        private void $$robo$$android_text_AndroidBidi_EmojiBidiOverride$__constructor__() {
        }

        private final int $$robo$$android_text_AndroidBidi_EmojiBidiOverride$classify(int c) {
            if (Emoji.isNewEmoji(c)) {
                return 10;
            }
            return NO_OVERRIDE;
        }

        static void __staticInitializer__() {
            NO_OVERRIDE = UCharacter.getIntPropertyMaxValue(4096) + 1;
        }

        private void __constructor__() {
            this.$$robo$$android_text_AndroidBidi_EmojiBidiOverride$__constructor__();
        }

        public EmojiBidiOverride() {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_AndroidBidi_EmojiBidiOverride$__constructor__(), this);
        }

        @Override
        public int classify(int n) {
            return (int)InvokeDynamicSupport.bootstrap("classify", $$robo$$android_text_AndroidBidi_EmojiBidiOverride$classify(int ), this, n);
        }

        static {
            RobolectricInternals.classInitializing(EmojiBidiOverride.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EmojiBidiOverride)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

