/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Layout;
import android.text.PackedIntVector;
import android.text.PackedObjectVector;
import android.text.PrecomputedText;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ReplacementSpan;
import android.text.style.UpdateLayout;
import android.text.style.WrapTogetherSpan;
import android.util.ArraySet;
import android.util.Pools;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DynamicLayout
extends Layout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int PRIORITY = 128;
    private static int BLOCK_MINIMUM_CHARACTER_LENGTH = 400;
    private CharSequence mBase;
    private CharSequence mDisplay;
    private ChangeWatcher mWatcher;
    private boolean mIncludePad;
    private boolean mFallbackLineSpacing;
    private boolean mEllipsize;
    private int mEllipsizedWidth;
    private TextUtils.TruncateAt mEllipsizeAt;
    private int mBreakStrategy;
    private int mHyphenationFrequency;
    private int mJustificationMode;
    private PackedIntVector mInts;
    private PackedObjectVector<Layout.Directions> mObjects;
    public static int INVALID_BLOCK_INDEX = -1;
    private int[] mBlockEndLines;
    private int[] mBlockIndices;
    private ArraySet<Integer> mBlocksAlwaysNeedToBeRedrawn;
    private int mNumberOfBlocks;
    private int mIndexFirstChangedBlock;
    private int mTopPadding;
    private int mBottomPadding;
    private Rect mTempRect;
    private static StaticLayout sStaticLayout;
    private static StaticLayout.Builder sBuilder;
    private static Object[] sLock;
    private static int START = 0;
    private static int DIR = 0;
    private static int TAB = 0;
    private static int TOP = 1;
    private static int DESCENT = 2;
    private static int EXTRA = 3;
    private static int HYPHEN = 4;
    private static int MAY_PROTRUDE_FROM_TOP_OR_BOTTOM = 4;
    private static int COLUMNS_NORMAL = 5;
    private static int ELLIPSIS_START = 5;
    private static int ELLIPSIS_COUNT = 6;
    private static int COLUMNS_ELLIPSIZE = 7;
    private static int START_MASK = 0x1FFFFFFF;
    private static int DIR_SHIFT = 30;
    private static int TAB_MASK = 0x20000000;
    private static int HYPHEN_MASK = 255;
    private static int MAY_PROTRUDE_FROM_TOP_OR_BOTTOM_MASK = 256;
    private static int ELLIPSIS_UNDEFINED = Integer.MIN_VALUE;

    @Deprecated
    private void $$robo$$android_text_DynamicLayout$__constructor__(CharSequence base, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
    }

    @Deprecated
    private void $$robo$$android_text_DynamicLayout$__constructor__(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
    }

    @Deprecated
    private void $$robo$$android_text_DynamicLayout$__constructor__(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
    }

    @Deprecated
    private void $$robo$$android_text_DynamicLayout$__constructor__(CharSequence base, CharSequence display, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad, int breakStrategy, int hyphenationFrequency, int justificationMode, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        this.mTempRect = new Rect();
        Builder b = Builder.obtain(base, paint, width).setAlignment(align).setTextDirection(textDir).setLineSpacing(spacingadd, spacingmult).setEllipsizedWidth(ellipsizedWidth).setEllipsize(ellipsize);
        this.mDisplay = display;
        this.mIncludePad = includepad;
        this.mBreakStrategy = breakStrategy;
        this.mJustificationMode = justificationMode;
        this.mHyphenationFrequency = hyphenationFrequency;
        this.generate(b);
        Builder.recycle(b);
    }

    private void $$robo$$android_text_DynamicLayout$__constructor__(Builder b) {
        this.mTempRect = new Rect();
        this.mDisplay = b.mDisplay;
        this.mIncludePad = b.mIncludePad;
        this.mBreakStrategy = b.mBreakStrategy;
        this.mJustificationMode = b.mJustificationMode;
        this.mHyphenationFrequency = b.mHyphenationFrequency;
        this.generate(b);
    }

    private static final CharSequence $$robo$$android_text_DynamicLayout$createEllipsizer(TextUtils.TruncateAt ellipsize, CharSequence display) {
        if (ellipsize == null) {
            return display;
        }
        if (display instanceof Spanned) {
            return new Layout.SpannedEllipsizer(display);
        }
        return new Layout.Ellipsizer(display);
    }

    private final void $$robo$$android_text_DynamicLayout$generate(Builder b) {
        int[] start;
        this.mBase = b.mBase;
        this.mFallbackLineSpacing = b.mFallbackLineSpacing;
        if (b.mEllipsize != null) {
            this.mInts = new PackedIntVector(7);
            this.mEllipsizedWidth = b.mEllipsizedWidth;
            this.mEllipsizeAt = b.mEllipsize;
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = b.mEllipsizedWidth;
            e.mMethod = b.mEllipsize;
            this.mEllipsize = true;
        } else {
            this.mInts = new PackedIntVector(5);
            this.mEllipsizedWidth = b.mWidth;
            this.mEllipsizeAt = null;
        }
        this.mObjects = new PackedObjectVector(1);
        if (b.mEllipsize != null) {
            start = new int[7];
            start[5] = Integer.MIN_VALUE;
        } else {
            start = new int[5];
        }
        Layout.Directions[] dirs = new Layout.Directions[]{DIRS_ALL_LEFT_TO_RIGHT};
        Paint.FontMetricsInt fm = b.mFontMetricsInt;
        b.mPaint.getFontMetricsInt(fm);
        int asc = fm.ascent;
        int desc = fm.descent;
        start[0] = 0x40000000;
        start[1] = 0;
        start[2] = desc;
        this.mInts.insertAt(0, start);
        start[1] = desc - asc;
        this.mInts.insertAt(1, start);
        this.mObjects.insertAt(0, (Layout.Directions[])dirs);
        int baseLength = this.mBase.length();
        this.reflow(this.mBase, 0, 0, baseLength);
        if (this.mBase instanceof Spannable) {
            if (this.mWatcher == null) {
                this.mWatcher = new ChangeWatcher(this);
            }
            Spannable sp = (Spannable)this.mBase;
            ChangeWatcher[] spans = sp.getSpans(0, baseLength, ChangeWatcher.class);
            for (int i = 0; i < spans.length; ++i) {
                sp.removeSpan(spans[i]);
            }
            sp.setSpan(this.mWatcher, 0, baseLength, 8388626);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$android_text_DynamicLayout$reflow(CharSequence s, int where, int before, int after) {
        if (s != this.mBase) {
            return;
        }
        CharSequence text = this.mDisplay;
        int len = text.length();
        int find = TextUtils.lastIndexOf(text, '\n', where - 1);
        find = find < 0 ? 0 : ++find;
        int diff = where - find;
        before += diff;
        int look = TextUtils.indexOf(text, '\n', (where -= diff) + (after += diff));
        look = look < 0 ? len : ++look;
        int change = look - (where + after);
        before += change;
        after += change;
        if (text instanceof Spanned) {
            boolean again;
            Spanned sp = (Spanned)text;
            do {
                again = false;
                WrapTogetherSpan[] force = sp.getSpans(where, where + after, WrapTogetherSpan.class);
                for (int i = 0; i < force.length; ++i) {
                    int diff2;
                    int st = sp.getSpanStart(force[i]);
                    int en = sp.getSpanEnd(force[i]);
                    if (st < where) {
                        again = true;
                        diff2 = where - st;
                        before += diff2;
                        after += diff2;
                        where -= diff2;
                    }
                    if (en <= where + after) continue;
                    again = true;
                    diff2 = en - (where + after);
                    before += diff2;
                    after += diff2;
                }
            } while (again);
        }
        int startline = this.getLineForOffset(where);
        int startv = this.getLineTop(startline);
        int endline = this.getLineForOffset(where + before);
        if (where + after == len) {
            endline = this.getLineCount();
        }
        int endv = this.getLineTop(endline);
        boolean islast = endline == this.getLineCount();
        Object[] objectArray = sLock;
        synchronized (sLock) {
            int[] ints;
            StaticLayout reflowed = sStaticLayout;
            StaticLayout.Builder b = sBuilder;
            sStaticLayout = null;
            sBuilder = null;
            // ** MonitorExit[var17_21] (shouldn't be in output)
            if (reflowed == null) {
                reflowed = new StaticLayout(null);
                b = StaticLayout.Builder.obtain(text, where, where + after, this.getPaint(), this.getWidth());
            }
            b.setText(text, where, where + after).setPaint(this.getPaint()).setWidth(this.getWidth()).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getSpacingAdd(), this.getSpacingMultiplier()).setUseLineSpacingFromFallbacks(this.mFallbackLineSpacing).setEllipsizedWidth(this.mEllipsizedWidth).setEllipsize(this.mEllipsizeAt).setBreakStrategy(this.mBreakStrategy).setHyphenationFrequency(this.mHyphenationFrequency).setJustificationMode(this.mJustificationMode).setAddLastLineLineSpacing(!islast);
            reflowed.generate(b, false, true);
            int n = reflowed.getLineCount();
            if (where + after != len && reflowed.getLineStart(n - 1) == where + after) {
                --n;
            }
            this.mInts.deleteAt(startline, endline - startline);
            this.mObjects.deleteAt(startline, endline - startline);
            int ht = reflowed.getLineTop(n);
            int toppad = 0;
            int botpad = 0;
            if (this.mIncludePad && startline == 0) {
                this.mTopPadding = toppad = reflowed.getTopPadding();
                ht -= toppad;
            }
            if (this.mIncludePad && islast) {
                this.mBottomPadding = botpad = reflowed.getBottomPadding();
                ht += botpad;
            }
            this.mInts.adjustValuesBelow(startline, 0, after - before);
            this.mInts.adjustValuesBelow(startline, 1, startv - endv + ht);
            if (this.mEllipsize) {
                ints = new int[7];
                ints[5] = Integer.MIN_VALUE;
            } else {
                ints = new int[5];
            }
            Layout.Directions[] objects = new Layout.Directions[1];
            for (int i = 0; i < n; ++i) {
                int start;
                ints[0] = start = reflowed.getLineStart(i);
                ints[0] = ints[0] | reflowed.getParagraphDirection(i) << 30;
                ints[0] = ints[0] | (reflowed.getLineContainsTab(i) ? 0x20000000 : 0);
                int top = reflowed.getLineTop(i) + startv;
                if (i > 0) {
                    top -= toppad;
                }
                ints[1] = top;
                int desc = reflowed.getLineDescent(i);
                if (i == n - 1) {
                    desc += botpad;
                }
                ints[2] = desc;
                ints[3] = reflowed.getLineExtra(i);
                objects[0] = reflowed.getLineDirections(i);
                int end = i == n - 1 ? where + after : reflowed.getLineStart(i + 1);
                ints[4] = reflowed.getHyphen(i) & 0xFF;
                ints[4] = ints[4] | (this.contentMayProtrudeFromLineTopOrBottom(text, start, end) ? 256 : 0);
                if (this.mEllipsize) {
                    ints[5] = reflowed.getEllipsisStart(i);
                    ints[6] = reflowed.getEllipsisCount(i);
                }
                this.mInts.insertAt(startline + i, ints);
                this.mObjects.insertAt(startline + i, (Layout.Directions[])objects);
            }
            this.updateBlocks(startline, endline - 1, n);
            b.finish();
            Object[] objectArray2 = sLock;
            synchronized (sLock) {
                sStaticLayout = reflowed;
                sBuilder = b;
                // ** MonitorExit[var23_30] (shouldn't be in output)
                return;
            }
        }
    }

    private final boolean $$robo$$android_text_DynamicLayout$contentMayProtrudeFromLineTopOrBottom(CharSequence text, int start, int end) {
        Spanned spanned;
        if (text instanceof Spanned && (spanned = (Spanned)text).getSpans(start, end, ReplacementSpan.class).length > 0) {
            return true;
        }
        TextPaint paint = this.getPaint();
        if (text instanceof PrecomputedText) {
            PrecomputedText precomputed = (PrecomputedText)text;
            precomputed.getBounds(start, end, this.mTempRect);
        } else {
            paint.getTextBounds(text, start, end, this.mTempRect);
        }
        Paint.FontMetricsInt fm = paint.getFontMetricsInt();
        return this.mTempRect.top < fm.top || this.mTempRect.bottom > fm.bottom;
    }

    private final void $$robo$$android_text_DynamicLayout$createBlocks() {
        int offset = 400;
        this.mNumberOfBlocks = 0;
        CharSequence text = this.mDisplay;
        while (true) {
            if ((offset = TextUtils.indexOf(text, '\n', offset)) < 0) break;
            this.addBlockAtOffset(offset);
            offset += 400;
        }
        this.addBlockAtOffset(text.length());
        this.mBlockIndices = new int[this.mBlockEndLines.length];
        for (int i = 0; i < this.mBlockEndLines.length; ++i) {
            this.mBlockIndices[i] = -1;
        }
    }

    private final ArraySet<Integer> $$robo$$android_text_DynamicLayout$getBlocksAlwaysNeedToBeRedrawn() {
        return this.mBlocksAlwaysNeedToBeRedrawn;
    }

    private final void $$robo$$android_text_DynamicLayout$updateAlwaysNeedsToBeRedrawn(int blockIndex) {
        int startLine = blockIndex == 0 ? 0 : this.mBlockEndLines[blockIndex - 1] + 1;
        int endLine = this.mBlockEndLines[blockIndex];
        for (int i = startLine; i <= endLine; ++i) {
            if (!this.getContentMayProtrudeFromTopOrBottom(i)) continue;
            if (this.mBlocksAlwaysNeedToBeRedrawn == null) {
                this.mBlocksAlwaysNeedToBeRedrawn = new ArraySet();
            }
            this.mBlocksAlwaysNeedToBeRedrawn.add(blockIndex);
            return;
        }
        if (this.mBlocksAlwaysNeedToBeRedrawn != null) {
            this.mBlocksAlwaysNeedToBeRedrawn.remove(blockIndex);
        }
    }

    private final void $$robo$$android_text_DynamicLayout$addBlockAtOffset(int offset) {
        int line = this.getLineForOffset(offset);
        if (this.mBlockEndLines == null) {
            this.mBlockEndLines = ArrayUtils.newUnpaddedIntArray(1);
            this.mBlockEndLines[this.mNumberOfBlocks] = line;
            this.updateAlwaysNeedsToBeRedrawn(this.mNumberOfBlocks);
            ++this.mNumberOfBlocks;
            return;
        }
        int previousBlockEndLine = this.mBlockEndLines[this.mNumberOfBlocks - 1];
        if (line > previousBlockEndLine) {
            this.mBlockEndLines = GrowingArrayUtils.append(this.mBlockEndLines, this.mNumberOfBlocks, line);
            this.updateAlwaysNeedsToBeRedrawn(this.mNumberOfBlocks);
            ++this.mNumberOfBlocks;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$android_text_DynamicLayout$updateBlocks(int startLine, int endLine, int newLineCount) {
        int newFirstChangedBlock;
        int i;
        int numRemovedBlocks;
        int newNumberOfBlocks;
        int i2;
        if (this.mBlockEndLines == null) {
            this.createBlocks();
            return;
        }
        int firstBlock = -1;
        int lastBlock = -1;
        for (i2 = 0; i2 < this.mNumberOfBlocks; ++i2) {
            if (this.mBlockEndLines[i2] < startLine) continue;
            firstBlock = i2;
            break;
        }
        for (i2 = firstBlock; i2 < this.mNumberOfBlocks; ++i2) {
            if (this.mBlockEndLines[i2] < endLine) continue;
            lastBlock = i2;
            break;
        }
        int lastBlockEndLine = this.mBlockEndLines[lastBlock];
        boolean createBlockBefore = startLine > (firstBlock == 0 ? 0 : this.mBlockEndLines[firstBlock - 1] + 1);
        boolean createBlock = newLineCount > 0;
        boolean createBlockAfter = endLine < this.mBlockEndLines[lastBlock];
        int numAddedBlocks = 0;
        if (createBlockBefore) {
            ++numAddedBlocks;
        }
        if (createBlock) {
            ++numAddedBlocks;
        }
        if (createBlockAfter) {
            ++numAddedBlocks;
        }
        if ((newNumberOfBlocks = this.mNumberOfBlocks + numAddedBlocks - (numRemovedBlocks = lastBlock - firstBlock + 1)) == 0) {
            this.mBlockEndLines[0] = 0;
            this.mBlockIndices[0] = -1;
            this.mNumberOfBlocks = 1;
            return;
        }
        if (newNumberOfBlocks > this.mBlockEndLines.length) {
            int[] blockEndLines = ArrayUtils.newUnpaddedIntArray(Math.max(this.mBlockEndLines.length * 2, newNumberOfBlocks));
            int[] blockIndices = new int[blockEndLines.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mBlockEndLines, (int)0, (Object)blockEndLines, (int)0, (int)firstBlock);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mBlockIndices, (int)0, (Object)blockIndices, (int)0, (int)firstBlock);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mBlockEndLines, (int)(lastBlock + 1), (Object)blockEndLines, (int)(firstBlock + numAddedBlocks), (int)(this.mNumberOfBlocks - lastBlock - 1));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mBlockIndices, (int)(lastBlock + 1), (Object)blockIndices, (int)(firstBlock + numAddedBlocks), (int)(this.mNumberOfBlocks - lastBlock - 1));
            this.mBlockEndLines = blockEndLines;
            this.mBlockIndices = blockIndices;
        } else if (numAddedBlocks + numRemovedBlocks != 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mBlockEndLines, (int)(lastBlock + 1), (Object)this.mBlockEndLines, (int)(firstBlock + numAddedBlocks), (int)(this.mNumberOfBlocks - lastBlock - 1));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mBlockIndices, (int)(lastBlock + 1), (Object)this.mBlockIndices, (int)(firstBlock + numAddedBlocks), (int)(this.mNumberOfBlocks - lastBlock - 1));
        }
        if (numAddedBlocks + numRemovedBlocks != 0 && this.mBlocksAlwaysNeedToBeRedrawn != null) {
            ArraySet<Integer> set = new ArraySet<Integer>();
            int changedBlockCount = numAddedBlocks - numRemovedBlocks;
            for (i = 0; i < this.mBlocksAlwaysNeedToBeRedrawn.size(); ++i) {
                Integer block = this.mBlocksAlwaysNeedToBeRedrawn.valueAt(i);
                if (block < firstBlock) {
                    set.add(block);
                }
                if (block <= lastBlock) continue;
                block = block + changedBlockCount;
                set.add(block);
            }
            this.mBlocksAlwaysNeedToBeRedrawn = set;
        }
        this.mNumberOfBlocks = newNumberOfBlocks;
        int deltaLines = newLineCount - (endLine - startLine + 1);
        if (deltaLines != 0) {
            i = newFirstChangedBlock = firstBlock + numAddedBlocks;
            while (i < this.mNumberOfBlocks) {
                int n = i++;
                this.mBlockEndLines[n] = this.mBlockEndLines[n] + deltaLines;
            }
        } else {
            newFirstChangedBlock = this.mNumberOfBlocks;
        }
        this.mIndexFirstChangedBlock = Math.min(this.mIndexFirstChangedBlock, newFirstChangedBlock);
        int blockIndex = firstBlock;
        if (createBlockBefore) {
            this.mBlockEndLines[blockIndex] = startLine - 1;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
            ++blockIndex;
        }
        if (createBlock) {
            this.mBlockEndLines[blockIndex] = startLine + newLineCount - 1;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
            ++blockIndex;
        }
        if (createBlockAfter) {
            this.mBlockEndLines[blockIndex] = lastBlockEndLine + deltaLines;
            this.updateAlwaysNeedsToBeRedrawn(blockIndex);
            this.mBlockIndices[blockIndex] = -1;
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    private final void $$robo$$android_text_DynamicLayout$setBlocksDataForTest(int[] blockEndLines, int[] blockIndices, int numberOfBlocks, int totalLines) {
        this.mBlockEndLines = new int[blockEndLines.length];
        this.mBlockIndices = new int[blockIndices.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)blockEndLines, (int)0, (Object)this.mBlockEndLines, (int)0, (int)blockEndLines.length);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)blockIndices, (int)0, (Object)this.mBlockIndices, (int)0, (int)blockIndices.length);
        this.mNumberOfBlocks = numberOfBlocks;
        while (this.mInts.size() < totalLines) {
            this.mInts.insertAt(this.mInts.size(), new int[5]);
        }
    }

    private final int[] $$robo$$android_text_DynamicLayout$getBlockEndLines() {
        return this.mBlockEndLines;
    }

    private final int[] $$robo$$android_text_DynamicLayout$getBlockIndices() {
        return this.mBlockIndices;
    }

    private final int $$robo$$android_text_DynamicLayout$getBlockIndex(int index) {
        return this.mBlockIndices[index];
    }

    private final void $$robo$$android_text_DynamicLayout$setBlockIndex(int index, int blockIndex) {
        this.mBlockIndices[index] = blockIndex;
    }

    private final int $$robo$$android_text_DynamicLayout$getNumberOfBlocks() {
        return this.mNumberOfBlocks;
    }

    private final int $$robo$$android_text_DynamicLayout$getIndexFirstChangedBlock() {
        return this.mIndexFirstChangedBlock;
    }

    private final void $$robo$$android_text_DynamicLayout$setIndexFirstChangedBlock(int i) {
        this.mIndexFirstChangedBlock = i;
    }

    private final int $$robo$$android_text_DynamicLayout$getLineCount() {
        return this.mInts.size() - 1;
    }

    private final int $$robo$$android_text_DynamicLayout$getLineTop(int line) {
        return this.mInts.getValue(line, 1);
    }

    private final int $$robo$$android_text_DynamicLayout$getLineDescent(int line) {
        return this.mInts.getValue(line, 2);
    }

    private final int $$robo$$android_text_DynamicLayout$getLineExtra(int line) {
        return this.mInts.getValue(line, 3);
    }

    private final int $$robo$$android_text_DynamicLayout$getLineStart(int line) {
        return this.mInts.getValue(line, 0) & 0x1FFFFFFF;
    }

    private final boolean $$robo$$android_text_DynamicLayout$getLineContainsTab(int line) {
        return (this.mInts.getValue(line, 0) & 0x20000000) != 0;
    }

    private final int $$robo$$android_text_DynamicLayout$getParagraphDirection(int line) {
        return this.mInts.getValue(line, 0) >> 30;
    }

    private final Layout.Directions $$robo$$android_text_DynamicLayout$getLineDirections(int line) {
        return this.mObjects.getValue(line, 0);
    }

    private final int $$robo$$android_text_DynamicLayout$getTopPadding() {
        return this.mTopPadding;
    }

    private final int $$robo$$android_text_DynamicLayout$getBottomPadding() {
        return this.mBottomPadding;
    }

    private final int $$robo$$android_text_DynamicLayout$getHyphen(int line) {
        return this.mInts.getValue(line, 4) & 0xFF;
    }

    private final boolean $$robo$$android_text_DynamicLayout$getContentMayProtrudeFromTopOrBottom(int line) {
        return (this.mInts.getValue(line, 4) & 0x100) != 0;
    }

    private final int $$robo$$android_text_DynamicLayout$getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    private final int $$robo$$android_text_DynamicLayout$getEllipsisStart(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 5);
    }

    private final int $$robo$$android_text_DynamicLayout$getEllipsisCount(int line) {
        if (this.mEllipsizeAt == null) {
            return 0;
        }
        return this.mInts.getValue(line, 6);
    }

    private /* synthetic */ void $$robo$$android_text_DynamicLayout$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sStaticLayout = null;
        sBuilder = null;
        sLock = new Object[0];
    }

    private void __constructor__(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this.$$robo$$android_text_DynamicLayout$__constructor__(charSequence, textPaint, n, alignment, f, f2, bl);
    }

    public DynamicLayout(CharSequence charSequence, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, charSequence, textPaint, n, alignment, f, f2, bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout$__constructor__(java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float boolean ), this, charSequence, textPaint, n, alignment, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this.$$robo$$android_text_DynamicLayout$__constructor__(charSequence, charSequence2, textPaint, n, alignment, f, f2, bl);
    }

    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl) {
        this(charSequence, charSequence2, textPaint, n, alignment, f, f2, bl, null, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout$__constructor__(java.lang.CharSequence java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float boolean ), this, charSequence, charSequence2, textPaint, n, alignment, f, f2, bl);
    }

    private void __constructor__(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        this.$$robo$$android_text_DynamicLayout$__constructor__(charSequence, charSequence2, textPaint, n, alignment, f, f2, bl, truncateAt, n2);
    }

    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, float f, float f2, boolean bl, TextUtils.TruncateAt truncateAt, int n2) {
        this(charSequence, charSequence2, textPaint, n, alignment, TextDirectionHeuristics.FIRSTSTRONG_LTR, f, f2, bl, 0, 0, 0, truncateAt, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout$__constructor__(java.lang.CharSequence java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment float float boolean android.text.TextUtils$TruncateAt int ), this, charSequence, charSequence2, textPaint, n, alignment, f, f2, bl, truncateAt, n2);
    }

    private void __constructor__(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, int n2, int n3, int n4, TextUtils.TruncateAt truncateAt, int n5) {
        this.$$robo$$android_text_DynamicLayout$__constructor__(charSequence, charSequence2, textPaint, n, alignment, textDirectionHeuristic, f, f2, bl, n2, n3, n4, truncateAt, n5);
    }

    public DynamicLayout(CharSequence charSequence, CharSequence charSequence2, TextPaint textPaint, int n, Layout.Alignment alignment, TextDirectionHeuristic textDirectionHeuristic, float f, float f2, boolean bl, int n2, int n3, int n4, TextUtils.TruncateAt truncateAt, int n5) {
        super(DynamicLayout.createEllipsizer(truncateAt, charSequence2), textPaint, n, alignment, textDirectionHeuristic, f, f2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout$__constructor__(java.lang.CharSequence java.lang.CharSequence android.text.TextPaint int android.text.Layout$Alignment android.text.TextDirectionHeuristic float float boolean int int int android.text.TextUtils$TruncateAt int ), this, charSequence, charSequence2, textPaint, n, alignment, textDirectionHeuristic, f, f2, bl, n2, n3, n4, truncateAt, n5);
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_text_DynamicLayout$__constructor__(builder);
    }

    public DynamicLayout(Builder builder) {
        super(DynamicLayout.createEllipsizer(builder.mEllipsize, builder.mDisplay), builder.mPaint, builder.mWidth, builder.mAlignment, builder.mTextDir, builder.mSpacingMult, builder.mSpacingAdd);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout$__constructor__(android.text.DynamicLayout$Builder ), this, builder);
    }

    private static CharSequence createEllipsizer(TextUtils.TruncateAt truncateAt, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("createEllipsizer", $$robo$$android_text_DynamicLayout$createEllipsizer(android.text.TextUtils$TruncateAt java.lang.CharSequence ), (TextUtils.TruncateAt)truncateAt, (CharSequence)charSequence);
    }

    private void generate(Builder builder) {
        InvokeDynamicSupport.bootstrap("generate", $$robo$$android_text_DynamicLayout$generate(android.text.DynamicLayout$Builder ), this, builder);
    }

    public void reflow(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("reflow", $$robo$$android_text_DynamicLayout$reflow(java.lang.CharSequence int int int ), this, charSequence, n, n2, n3);
    }

    private boolean contentMayProtrudeFromLineTopOrBottom(CharSequence charSequence, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("contentMayProtrudeFromLineTopOrBottom", $$robo$$android_text_DynamicLayout$contentMayProtrudeFromLineTopOrBottom(java.lang.CharSequence int int ), this, charSequence, n, n2);
    }

    private void createBlocks() {
        InvokeDynamicSupport.bootstrap("createBlocks", $$robo$$android_text_DynamicLayout$createBlocks(), this);
    }

    public ArraySet<Integer> getBlocksAlwaysNeedToBeRedrawn() {
        return InvokeDynamicSupport.bootstrap("getBlocksAlwaysNeedToBeRedrawn", $$robo$$android_text_DynamicLayout$getBlocksAlwaysNeedToBeRedrawn(), this);
    }

    private void updateAlwaysNeedsToBeRedrawn(int n) {
        InvokeDynamicSupport.bootstrap("updateAlwaysNeedsToBeRedrawn", $$robo$$android_text_DynamicLayout$updateAlwaysNeedsToBeRedrawn(int ), this, n);
    }

    private void addBlockAtOffset(int n) {
        InvokeDynamicSupport.bootstrap("addBlockAtOffset", $$robo$$android_text_DynamicLayout$addBlockAtOffset(int ), this, n);
    }

    public void updateBlocks(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("updateBlocks", $$robo$$android_text_DynamicLayout$updateBlocks(int int int ), this, n, n2, n3);
    }

    public void setBlocksDataForTest(int[] nArray, int[] nArray2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setBlocksDataForTest", $$robo$$android_text_DynamicLayout$setBlocksDataForTest(int[] int[] int int ), this, nArray, nArray2, n, n2);
    }

    public int[] getBlockEndLines() {
        return InvokeDynamicSupport.bootstrap("getBlockEndLines", $$robo$$android_text_DynamicLayout$getBlockEndLines(), this);
    }

    public int[] getBlockIndices() {
        return InvokeDynamicSupport.bootstrap("getBlockIndices", $$robo$$android_text_DynamicLayout$getBlockIndices(), this);
    }

    public int getBlockIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getBlockIndex", $$robo$$android_text_DynamicLayout$getBlockIndex(int ), this, n);
    }

    public void setBlockIndex(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setBlockIndex", $$robo$$android_text_DynamicLayout$setBlockIndex(int int ), this, n, n2);
    }

    public int getNumberOfBlocks() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfBlocks", $$robo$$android_text_DynamicLayout$getNumberOfBlocks(), this);
    }

    public int getIndexFirstChangedBlock() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexFirstChangedBlock", $$robo$$android_text_DynamicLayout$getIndexFirstChangedBlock(), this);
    }

    public void setIndexFirstChangedBlock(int n) {
        InvokeDynamicSupport.bootstrap("setIndexFirstChangedBlock", $$robo$$android_text_DynamicLayout$setIndexFirstChangedBlock(int ), this, n);
    }

    @Override
    public int getLineCount() {
        return (int)InvokeDynamicSupport.bootstrap("getLineCount", $$robo$$android_text_DynamicLayout$getLineCount(), this);
    }

    @Override
    public int getLineTop(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineTop", $$robo$$android_text_DynamicLayout$getLineTop(int ), this, n);
    }

    @Override
    public int getLineDescent(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineDescent", $$robo$$android_text_DynamicLayout$getLineDescent(int ), this, n);
    }

    @Override
    public int getLineExtra(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineExtra", $$robo$$android_text_DynamicLayout$getLineExtra(int ), this, n);
    }

    @Override
    public int getLineStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLineStart", $$robo$$android_text_DynamicLayout$getLineStart(int ), this, n);
    }

    @Override
    public boolean getLineContainsTab(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getLineContainsTab", $$robo$$android_text_DynamicLayout$getLineContainsTab(int ), this, n);
    }

    @Override
    public int getParagraphDirection(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getParagraphDirection", $$robo$$android_text_DynamicLayout$getParagraphDirection(int ), this, n);
    }

    @Override
    public Layout.Directions getLineDirections(int n) {
        return InvokeDynamicSupport.bootstrap("getLineDirections", $$robo$$android_text_DynamicLayout$getLineDirections(int ), this, n);
    }

    @Override
    public int getTopPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getTopPadding", $$robo$$android_text_DynamicLayout$getTopPadding(), this);
    }

    @Override
    public int getBottomPadding() {
        return (int)InvokeDynamicSupport.bootstrap("getBottomPadding", $$robo$$android_text_DynamicLayout$getBottomPadding(), this);
    }

    @Override
    public int getHyphen(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHyphen", $$robo$$android_text_DynamicLayout$getHyphen(int ), this, n);
    }

    private boolean getContentMayProtrudeFromTopOrBottom(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getContentMayProtrudeFromTopOrBottom", $$robo$$android_text_DynamicLayout$getContentMayProtrudeFromTopOrBottom(int ), this, n);
    }

    @Override
    public int getEllipsizedWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsizedWidth", $$robo$$android_text_DynamicLayout$getEllipsizedWidth(), this);
    }

    @Override
    public int getEllipsisStart(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisStart", $$robo$$android_text_DynamicLayout$getEllipsisStart(int ), this, n);
    }

    @Override
    public int getEllipsisCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEllipsisCount", $$robo$$android_text_DynamicLayout$getEllipsisCount(int ), this, n);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_text_DynamicLayout$__constructor__(builder, var2_2);
    }

    public /* synthetic */ DynamicLayout(Builder builder, 1 var2_2) {
        this(builder);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout$__constructor__(android.text.DynamicLayout$Builder android.text.DynamicLayout$1 ), this, builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(DynamicLayout.class);
    }

    public /* synthetic */ DynamicLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DynamicLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ChangeWatcher
    implements TextWatcher,
    SpanWatcher,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<DynamicLayout> mLayout;

        private void $$robo$$android_text_DynamicLayout_ChangeWatcher$__constructor__(DynamicLayout layout2) {
            this.mLayout = new WeakReference<DynamicLayout>(layout2);
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$reflow(CharSequence s, int where, int before, int after) {
            DynamicLayout ml = (DynamicLayout)this.mLayout.get();
            if (ml != null) {
                ml.reflow(s, where, before, after);
            } else if (s instanceof Spannable) {
                ((Spannable)s).removeSpan(this);
            }
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$beforeTextChanged(CharSequence s, int where, int before, int after) {
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$onTextChanged(CharSequence s, int where, int before, int after) {
            this.reflow(s, where, before, after);
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$afterTextChanged(Editable s) {
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$onSpanAdded(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$onSpanRemoved(Spannable s, Object o, int start, int end) {
            if (o instanceof UpdateLayout) {
                this.reflow(s, start, end - start, end - start);
            }
        }

        private final void $$robo$$android_text_DynamicLayout_ChangeWatcher$onSpanChanged(Spannable s, Object o, int start, int end, int nstart, int nend) {
            if (o instanceof UpdateLayout) {
                if (start > end) {
                    start = 0;
                }
                this.reflow(s, start, end - start, end - start);
                this.reflow(s, nstart, nend - nstart, nend - nstart);
            }
        }

        private void __constructor__(DynamicLayout dynamicLayout) {
            this.$$robo$$android_text_DynamicLayout_ChangeWatcher$__constructor__(dynamicLayout);
        }

        public ChangeWatcher(DynamicLayout dynamicLayout) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout_ChangeWatcher$__constructor__(android.text.DynamicLayout ), this, dynamicLayout);
        }

        private void reflow(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("reflow", $$robo$$android_text_DynamicLayout_ChangeWatcher$reflow(java.lang.CharSequence int int int ), this, charSequence, n, n2, n3);
        }

        @Override
        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_text_DynamicLayout_ChangeWatcher$beforeTextChanged(java.lang.CharSequence int int int ), this, charSequence, n, n2, n3);
        }

        @Override
        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_text_DynamicLayout_ChangeWatcher$onTextChanged(java.lang.CharSequence int int int ), this, charSequence, n, n2, n3);
        }

        @Override
        public void afterTextChanged(Editable editable) {
            InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_text_DynamicLayout_ChangeWatcher$afterTextChanged(android.text.Editable ), this, editable);
        }

        @Override
        public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSpanAdded", $$robo$$android_text_DynamicLayout_ChangeWatcher$onSpanAdded(android.text.Spannable java.lang.Object int int ), this, spannable, object, n, n2);
        }

        @Override
        public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onSpanRemoved", $$robo$$android_text_DynamicLayout_ChangeWatcher$onSpanRemoved(android.text.Spannable java.lang.Object int int ), this, spannable, object, n, n2);
        }

        @Override
        public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onSpanChanged", $$robo$$android_text_DynamicLayout_ChangeWatcher$onSpanChanged(android.text.Spannable java.lang.Object int int int int ), this, spannable, object, n, n2, n3, n4);
        }

        public /* synthetic */ ChangeWatcher() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChangeWatcher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CharSequence mBase;
        private CharSequence mDisplay;
        private TextPaint mPaint;
        private int mWidth;
        private Layout.Alignment mAlignment;
        private TextDirectionHeuristic mTextDir;
        private float mSpacingMult;
        private float mSpacingAdd;
        private boolean mIncludePad;
        private boolean mFallbackLineSpacing;
        private int mBreakStrategy;
        private int mHyphenationFrequency;
        private int mJustificationMode;
        private TextUtils.TruncateAt mEllipsize;
        private int mEllipsizedWidth;
        private Paint.FontMetricsInt mFontMetricsInt;
        private static Pools.SynchronizedPool<Builder> sPool;

        private void $$robo$$android_text_DynamicLayout_Builder$__constructor__() {
            this.mFontMetricsInt = new Paint.FontMetricsInt();
        }

        private static final Builder $$robo$$android_text_DynamicLayout_Builder$obtain(CharSequence base, TextPaint paint, int width) {
            Builder b = sPool.acquire();
            if (b == null) {
                b = new Builder();
            }
            b.mBase = base;
            b.mDisplay = base;
            b.mPaint = paint;
            b.mWidth = width;
            b.mAlignment = Layout.Alignment.ALIGN_NORMAL;
            b.mTextDir = TextDirectionHeuristics.FIRSTSTRONG_LTR;
            b.mSpacingMult = 1.0f;
            b.mSpacingAdd = 0.0f;
            b.mIncludePad = true;
            b.mFallbackLineSpacing = false;
            b.mEllipsizedWidth = width;
            b.mEllipsize = null;
            b.mBreakStrategy = 0;
            b.mHyphenationFrequency = 0;
            b.mJustificationMode = 0;
            return b;
        }

        private static final void $$robo$$android_text_DynamicLayout_Builder$recycle(Builder b) {
            b.mBase = null;
            b.mDisplay = null;
            b.mPaint = null;
            sPool.release(b);
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setDisplayText(CharSequence display) {
            this.mDisplay = display;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setAlignment(Layout.Alignment alignment) {
            this.mAlignment = alignment;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setTextDirection(TextDirectionHeuristic textDir) {
            this.mTextDir = textDir;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setLineSpacing(float spacingAdd, float spacingMult) {
            this.mSpacingAdd = spacingAdd;
            this.mSpacingMult = spacingMult;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setIncludePad(boolean includePad) {
            this.mIncludePad = includePad;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setUseLineSpacingFromFallbacks(boolean useLineSpacingFromFallbacks) {
            this.mFallbackLineSpacing = useLineSpacingFromFallbacks;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setEllipsizedWidth(int ellipsizedWidth) {
            this.mEllipsizedWidth = ellipsizedWidth;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setEllipsize(TextUtils.TruncateAt ellipsize) {
            this.mEllipsize = ellipsize;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setBreakStrategy(int breakStrategy) {
            this.mBreakStrategy = breakStrategy;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setHyphenationFrequency(int hyphenationFrequency) {
            this.mHyphenationFrequency = hyphenationFrequency;
            return this;
        }

        private final Builder $$robo$$android_text_DynamicLayout_Builder$setJustificationMode(int justificationMode) {
            this.mJustificationMode = justificationMode;
            return this;
        }

        private final DynamicLayout $$robo$$android_text_DynamicLayout_Builder$build() {
            DynamicLayout result = new DynamicLayout(this, null);
            Builder.recycle(this);
            return result;
        }

        static void __staticInitializer__() {
            sPool = new Pools.SynchronizedPool(3);
        }

        private void __constructor__() {
            this.$$robo$$android_text_DynamicLayout_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_DynamicLayout_Builder$__constructor__(), this);
        }

        public static Builder obtain(CharSequence charSequence, TextPaint textPaint, int n) {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_text_DynamicLayout_Builder$obtain(java.lang.CharSequence android.text.TextPaint int ), (CharSequence)charSequence, (TextPaint)textPaint, (int)n);
        }

        private static void recycle(Builder builder) {
            InvokeDynamicSupport.bootstrapStatic("recycle", $$robo$$android_text_DynamicLayout_Builder$recycle(android.text.DynamicLayout$Builder ), (Builder)builder);
        }

        public Builder setDisplayText(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setDisplayText", $$robo$$android_text_DynamicLayout_Builder$setDisplayText(java.lang.CharSequence ), this, charSequence);
        }

        public Builder setAlignment(Layout.Alignment alignment) {
            return InvokeDynamicSupport.bootstrap("setAlignment", $$robo$$android_text_DynamicLayout_Builder$setAlignment(android.text.Layout$Alignment ), this, alignment);
        }

        public Builder setTextDirection(TextDirectionHeuristic textDirectionHeuristic) {
            return InvokeDynamicSupport.bootstrap("setTextDirection", $$robo$$android_text_DynamicLayout_Builder$setTextDirection(android.text.TextDirectionHeuristic ), this, textDirectionHeuristic);
        }

        public Builder setLineSpacing(float f, float f2) {
            return InvokeDynamicSupport.bootstrap("setLineSpacing", $$robo$$android_text_DynamicLayout_Builder$setLineSpacing(float float ), this, f, f2);
        }

        public Builder setIncludePad(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setIncludePad", $$robo$$android_text_DynamicLayout_Builder$setIncludePad(boolean ), this, bl);
        }

        public Builder setUseLineSpacingFromFallbacks(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUseLineSpacingFromFallbacks", $$robo$$android_text_DynamicLayout_Builder$setUseLineSpacingFromFallbacks(boolean ), this, bl);
        }

        public Builder setEllipsizedWidth(int n) {
            return InvokeDynamicSupport.bootstrap("setEllipsizedWidth", $$robo$$android_text_DynamicLayout_Builder$setEllipsizedWidth(int ), this, n);
        }

        public Builder setEllipsize(TextUtils.TruncateAt truncateAt) {
            return InvokeDynamicSupport.bootstrap("setEllipsize", $$robo$$android_text_DynamicLayout_Builder$setEllipsize(android.text.TextUtils$TruncateAt ), this, truncateAt);
        }

        public Builder setBreakStrategy(int n) {
            return InvokeDynamicSupport.bootstrap("setBreakStrategy", $$robo$$android_text_DynamicLayout_Builder$setBreakStrategy(int ), this, n);
        }

        public Builder setHyphenationFrequency(int n) {
            return InvokeDynamicSupport.bootstrap("setHyphenationFrequency", $$robo$$android_text_DynamicLayout_Builder$setHyphenationFrequency(int ), this, n);
        }

        public Builder setJustificationMode(int n) {
            return InvokeDynamicSupport.bootstrap("setJustificationMode", $$robo$$android_text_DynamicLayout_Builder$setJustificationMode(int ), this, n);
        }

        public DynamicLayout build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_text_DynamicLayout_Builder$build(), this);
        }

        static {
            RobolectricInternals.classInitializing(Builder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

