/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.app.ActivityThread;
import android.app.Application;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.HtmlToSpannedConverter;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextDirectionHeuristics;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Parser;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Html
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int TO_HTML_PARAGRAPH_LINES_CONSECUTIVE = 0;
    public static int TO_HTML_PARAGRAPH_LINES_INDIVIDUAL = 1;
    public static int FROM_HTML_SEPARATOR_LINE_BREAK_PARAGRAPH = 1;
    public static int FROM_HTML_SEPARATOR_LINE_BREAK_HEADING = 2;
    public static int FROM_HTML_SEPARATOR_LINE_BREAK_LIST_ITEM = 4;
    public static int FROM_HTML_SEPARATOR_LINE_BREAK_LIST = 8;
    public static int FROM_HTML_SEPARATOR_LINE_BREAK_DIV = 16;
    public static int FROM_HTML_SEPARATOR_LINE_BREAK_BLOCKQUOTE = 32;
    public static int FROM_HTML_OPTION_USE_CSS_COLORS = 256;
    public static int FROM_HTML_MODE_LEGACY = 0;
    public static int FROM_HTML_MODE_COMPACT = 63;
    private static int TO_HTML_PARAGRAPH_FLAG = 1;

    private void $$robo$$android_text_Html$__constructor__() {
    }

    @Deprecated
    private static final Spanned $$robo$$android_text_Html$fromHtml(String source) {
        return Html.fromHtml(source, 0, null, null);
    }

    private static final Spanned $$robo$$android_text_Html$fromHtml(String source, int flags) {
        return Html.fromHtml(source, flags, null, null);
    }

    @Deprecated
    private static final Spanned $$robo$$android_text_Html$fromHtml(String source, ImageGetter imageGetter, TagHandler tagHandler) {
        return Html.fromHtml(source, 0, imageGetter, tagHandler);
    }

    private static final Spanned $$robo$$android_text_Html$fromHtml(String source, int flags, ImageGetter imageGetter, TagHandler tagHandler) {
        Parser parser = new Parser();
        try {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", HtmlParser.schema);
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e);
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e);
        }
        HtmlToSpannedConverter converter = new HtmlToSpannedConverter(source, imageGetter, tagHandler, parser, flags);
        return converter.convert();
    }

    @Deprecated
    private static final String $$robo$$android_text_Html$toHtml(Spanned text) {
        return Html.toHtml(text, 0);
    }

    private static final String $$robo$$android_text_Html$toHtml(Spanned text, int option) {
        StringBuilder out = new StringBuilder();
        Html.withinHtml(out, text, option);
        return out.toString();
    }

    private static final String $$robo$$android_text_Html$escapeHtml(CharSequence text) {
        StringBuilder out = new StringBuilder();
        Html.withinStyle(out, text, 0, text.length());
        return out.toString();
    }

    private static final void $$robo$$android_text_Html$withinHtml(StringBuilder out, Spanned text, int option) {
        if ((option & 1) == 0) {
            Html.encodeTextAlignmentByDiv(out, text, option);
            return;
        }
        Html.withinDiv(out, text, 0, text.length(), option);
    }

    private static final void $$robo$$android_text_Html$encodeTextAlignmentByDiv(StringBuilder out, Spanned text, int option) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            int next = text.nextSpanTransition(i, len, ParagraphStyle.class);
            ParagraphStyle[] style2 = text.getSpans(i, next, ParagraphStyle.class);
            String elements = " ";
            boolean needDiv = false;
            for (int j = 0; j < style2.length; ++j) {
                if (!(style2[j] instanceof AlignmentSpan)) continue;
                Layout.Alignment align = ((AlignmentSpan)style2[j]).getAlignment();
                needDiv = true;
                elements = align == Layout.Alignment.ALIGN_CENTER ? "align=\"center\" " + elements : (align == Layout.Alignment.ALIGN_OPPOSITE ? "align=\"right\" " + elements : "align=\"left\" " + elements);
            }
            if (needDiv) {
                out.append("<div ").append(elements).append(">");
            }
            Html.withinDiv(out, text, i, next, option);
            if (needDiv) {
                out.append("</div>");
            }
            i = next;
        }
    }

    private static final void $$robo$$android_text_Html$withinDiv(StringBuilder out, Spanned text, int start, int end, int option) {
        int i = start;
        while (i < end) {
            QuoteSpan[] quotes;
            int next = text.nextSpanTransition(i, end, QuoteSpan.class);
            for (QuoteSpan quote : quotes = text.getSpans(i, next, QuoteSpan.class)) {
                out.append("<blockquote>");
            }
            Html.withinBlockquote(out, text, i, next, option);
            for (QuoteSpan quote : quotes) {
                out.append("</blockquote>\n");
            }
            i = next;
        }
    }

    private static final String $$robo$$android_text_Html$getTextDirection(Spanned text, int start, int end) {
        if (TextDirectionHeuristics.FIRSTSTRONG_LTR.isRtl(text, start, end - start)) {
            return " dir=\"rtl\"";
        }
        return " dir=\"ltr\"";
    }

    private static final String $$robo$$android_text_Html$getTextStyles(Spanned text, int start, int end, boolean forceNoVerticalMargin, boolean includeTextAlign) {
        String margin = null;
        String textAlign = null;
        if (forceNoVerticalMargin) {
            margin = "margin-top:0; margin-bottom:0;";
        }
        if (includeTextAlign) {
            AlignmentSpan[] alignmentSpans = text.getSpans(start, end, AlignmentSpan.class);
            for (int i = alignmentSpans.length - 1; i >= 0; --i) {
                AlignmentSpan s = alignmentSpans[i];
                if ((text.getSpanFlags(s) & 0x33) != 51) continue;
                Layout.Alignment alignment = s.getAlignment();
                if (alignment == Layout.Alignment.ALIGN_NORMAL) {
                    textAlign = "text-align:start;";
                    break;
                }
                if (alignment == Layout.Alignment.ALIGN_CENTER) {
                    textAlign = "text-align:center;";
                    break;
                }
                if (alignment != Layout.Alignment.ALIGN_OPPOSITE) break;
                textAlign = "text-align:end;";
                break;
            }
        }
        if (margin == null && textAlign == null) {
            return "";
        }
        StringBuilder style2 = new StringBuilder(" style=\"");
        if (margin != null && textAlign != null) {
            style2.append(margin).append(" ").append(textAlign);
        } else if (margin != null) {
            style2.append(margin);
        } else if (textAlign != null) {
            style2.append(textAlign);
        }
        return style2.append("\"").toString();
    }

    private static final void $$robo$$android_text_Html$withinBlockquote(StringBuilder out, Spanned text, int start, int end, int option) {
        if ((option & 1) == 0) {
            Html.withinBlockquoteConsecutive(out, text, start, end);
        } else {
            Html.withinBlockquoteIndividual(out, text, start, end);
        }
    }

    private static final void $$robo$$android_text_Html$withinBlockquoteIndividual(StringBuilder out, Spanned text, int start, int end) {
        boolean isInList = false;
        int i = start;
        while (i <= end) {
            int next = TextUtils.indexOf((CharSequence)text, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            if (next == i) {
                if (isInList) {
                    isInList = false;
                    out.append("</ul>\n");
                }
                out.append("<br>\n");
            } else {
                ParagraphStyle[] paragraphStyles;
                boolean isListItem = false;
                for (ParagraphStyle paragraphStyle : paragraphStyles = text.getSpans(i, next, ParagraphStyle.class)) {
                    int spanFlags = text.getSpanFlags(paragraphStyle);
                    if ((spanFlags & 0x33) != 51 || !(paragraphStyle instanceof BulletSpan)) continue;
                    isListItem = true;
                    break;
                }
                if (isListItem && !isInList) {
                    isInList = true;
                    out.append("<ul").append(Html.getTextStyles(text, i, next, true, false)).append(">\n");
                }
                if (isInList && !isListItem) {
                    isInList = false;
                    out.append("</ul>\n");
                }
                String tagType = isListItem ? "li" : "p";
                out.append("<").append(tagType).append(Html.getTextDirection(text, i, next)).append(Html.getTextStyles(text, i, next, !isListItem, true)).append(">");
                Html.withinParagraph(out, text, i, next);
                out.append("</");
                out.append(tagType);
                out.append(">\n");
                if (next == end && isInList) {
                    isInList = false;
                    out.append("</ul>\n");
                }
            }
            i = ++next;
        }
    }

    private static final void $$robo$$android_text_Html$withinBlockquoteConsecutive(StringBuilder out, Spanned text, int start, int end) {
        out.append("<p").append(Html.getTextDirection(text, start, end)).append(">");
        int i = start;
        while (i < end) {
            int next = TextUtils.indexOf((CharSequence)text, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            int nl = 0;
            while (next < end && text.charAt(next) == '\n') {
                ++nl;
                ++next;
            }
            Html.withinParagraph(out, text, i, next - nl);
            if (nl == 1) {
                out.append("<br>\n");
            } else {
                for (int j = 2; j < nl; ++j) {
                    out.append("<br>");
                }
                if (next != end) {
                    out.append("</p>\n");
                    out.append("<p").append(Html.getTextDirection(text, start, end)).append(">");
                }
            }
            i = next;
        }
        out.append("</p>\n");
    }

    private static final void $$robo$$android_text_Html$withinParagraph(StringBuilder out, Spanned text, int start, int end) {
        int i = start;
        while (i < end) {
            int j;
            int next = text.nextSpanTransition(i, end, CharacterStyle.class);
            CharacterStyle[] style2 = text.getSpans(i, next, CharacterStyle.class);
            for (j = 0; j < style2.length; ++j) {
                int color2;
                String s;
                if (style2[j] instanceof StyleSpan) {
                    int s2 = ((StyleSpan)style2[j]).getStyle();
                    if ((s2 & 1) != 0) {
                        out.append("<b>");
                    }
                    if ((s2 & 2) != 0) {
                        out.append("<i>");
                    }
                }
                if (style2[j] instanceof TypefaceSpan && "monospace".equals(s = ((TypefaceSpan)style2[j]).getFamily())) {
                    out.append("<tt>");
                }
                if (style2[j] instanceof SuperscriptSpan) {
                    out.append("<sup>");
                }
                if (style2[j] instanceof SubscriptSpan) {
                    out.append("<sub>");
                }
                if (style2[j] instanceof UnderlineSpan) {
                    out.append("<u>");
                }
                if (style2[j] instanceof StrikethroughSpan) {
                    out.append("<span style=\"text-decoration:line-through;\">");
                }
                if (style2[j] instanceof URLSpan) {
                    out.append("<a href=\"");
                    out.append(((URLSpan)style2[j]).getURL());
                    out.append("\">");
                }
                if (style2[j] instanceof ImageSpan) {
                    out.append("<img src=\"");
                    out.append(((ImageSpan)style2[j]).getSource());
                    out.append("\">");
                    i = next;
                }
                if (style2[j] instanceof AbsoluteSizeSpan) {
                    AbsoluteSizeSpan s3 = (AbsoluteSizeSpan)style2[j];
                    float sizeDip = s3.getSize();
                    if (!s3.getDip()) {
                        Application application = ActivityThread.currentApplication();
                        sizeDip /= application.getResources().getDisplayMetrics().density;
                    }
                    out.append(String.format("<span style=\"font-size:%.0fpx\";>", Float.valueOf(sizeDip)));
                }
                if (style2[j] instanceof RelativeSizeSpan) {
                    float sizeEm = ((RelativeSizeSpan)style2[j]).getSizeChange();
                    out.append(String.format("<span style=\"font-size:%.2fem;\">", Float.valueOf(sizeEm)));
                }
                if (style2[j] instanceof ForegroundColorSpan) {
                    color2 = ((ForegroundColorSpan)style2[j]).getForegroundColor();
                    out.append(String.format("<span style=\"color:#%06X;\">", 0xFFFFFF & color2));
                }
                if (!(style2[j] instanceof BackgroundColorSpan)) continue;
                color2 = ((BackgroundColorSpan)style2[j]).getBackgroundColor();
                out.append(String.format("<span style=\"background-color:#%06X;\">", 0xFFFFFF & color2));
            }
            Html.withinStyle(out, text, i, next);
            for (j = style2.length - 1; j >= 0; --j) {
                String s;
                if (style2[j] instanceof BackgroundColorSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof ForegroundColorSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof RelativeSizeSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof AbsoluteSizeSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof URLSpan) {
                    out.append("</a>");
                }
                if (style2[j] instanceof StrikethroughSpan) {
                    out.append("</span>");
                }
                if (style2[j] instanceof UnderlineSpan) {
                    out.append("</u>");
                }
                if (style2[j] instanceof SubscriptSpan) {
                    out.append("</sub>");
                }
                if (style2[j] instanceof SuperscriptSpan) {
                    out.append("</sup>");
                }
                if (style2[j] instanceof TypefaceSpan && (s = ((TypefaceSpan)style2[j]).getFamily()).equals("monospace")) {
                    out.append("</tt>");
                }
                if (!(style2[j] instanceof StyleSpan)) continue;
                int s2 = ((StyleSpan)style2[j]).getStyle();
                if ((s2 & 1) != 0) {
                    out.append("</b>");
                }
                if ((s2 & 2) == 0) continue;
                out.append("</i>");
            }
            i = next;
        }
    }

    private static final void $$robo$$android_text_Html$withinStyle(StringBuilder out, CharSequence text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                out.append("&lt;");
                continue;
            }
            if (c == '>') {
                out.append("&gt;");
                continue;
            }
            if (c == '&') {
                out.append("&amp;");
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                char d;
                if (c >= '\udc00' || i + 1 >= end || (d = text.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                ++i;
                int codepoint = 0x10000 | c - 55296 << 10 | d - 56320;
                out.append("&#").append(codepoint).append(";");
                continue;
            }
            if (c > '~' || c < ' ') {
                out.append("&#").append((int)c).append(";");
                continue;
            }
            if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    out.append("&nbsp;");
                    ++i;
                }
                out.append(' ');
                continue;
            }
            out.append(c);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_text_Html$__constructor__();
    }

    public Html() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Html$__constructor__(), this);
    }

    @Deprecated
    public static Spanned fromHtml(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fromHtml", $$robo$$android_text_Html$fromHtml(java.lang.String ), (String)string2);
    }

    public static Spanned fromHtml(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromHtml", $$robo$$android_text_Html$fromHtml(java.lang.String int ), (String)string2, (int)n);
    }

    @Deprecated
    public static Spanned fromHtml(String string2, ImageGetter imageGetter, TagHandler tagHandler) {
        return InvokeDynamicSupport.bootstrapStatic("fromHtml", $$robo$$android_text_Html$fromHtml(java.lang.String android.text.Html$ImageGetter android.text.Html$TagHandler ), (String)string2, (ImageGetter)imageGetter, (TagHandler)tagHandler);
    }

    public static Spanned fromHtml(String string2, int n, ImageGetter imageGetter, TagHandler tagHandler) {
        return InvokeDynamicSupport.bootstrapStatic("fromHtml", $$robo$$android_text_Html$fromHtml(java.lang.String int android.text.Html$ImageGetter android.text.Html$TagHandler ), (String)string2, (int)n, (ImageGetter)imageGetter, (TagHandler)tagHandler);
    }

    @Deprecated
    public static String toHtml(Spanned spanned) {
        return InvokeDynamicSupport.bootstrapStatic("toHtml", $$robo$$android_text_Html$toHtml(android.text.Spanned ), (Spanned)spanned);
    }

    public static String toHtml(Spanned spanned, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toHtml", $$robo$$android_text_Html$toHtml(android.text.Spanned int ), (Spanned)spanned, (int)n);
    }

    public static String escapeHtml(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("escapeHtml", $$robo$$android_text_Html$escapeHtml(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    private static void withinHtml(StringBuilder stringBuilder, Spanned spanned, int n) {
        InvokeDynamicSupport.bootstrapStatic("withinHtml", $$robo$$android_text_Html$withinHtml(java.lang.StringBuilder android.text.Spanned int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n);
    }

    private static void encodeTextAlignmentByDiv(StringBuilder stringBuilder, Spanned spanned, int n) {
        InvokeDynamicSupport.bootstrapStatic("encodeTextAlignmentByDiv", $$robo$$android_text_Html$encodeTextAlignmentByDiv(java.lang.StringBuilder android.text.Spanned int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n);
    }

    private static void withinDiv(StringBuilder stringBuilder, Spanned spanned, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("withinDiv", $$robo$$android_text_Html$withinDiv(java.lang.StringBuilder android.text.Spanned int int int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2, (int)n3);
    }

    private static String getTextDirection(Spanned spanned, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getTextDirection", $$robo$$android_text_Html$getTextDirection(android.text.Spanned int int ), (Spanned)spanned, (int)n, (int)n2);
    }

    private static String getTextStyles(Spanned spanned, int n, int n2, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getTextStyles", $$robo$$android_text_Html$getTextStyles(android.text.Spanned int int boolean boolean ), (Spanned)spanned, (int)n, (int)n2, (boolean)bl, (boolean)bl2);
    }

    private static void withinBlockquote(StringBuilder stringBuilder, Spanned spanned, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("withinBlockquote", $$robo$$android_text_Html$withinBlockquote(java.lang.StringBuilder android.text.Spanned int int int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2, (int)n3);
    }

    private static void withinBlockquoteIndividual(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinBlockquoteIndividual", $$robo$$android_text_Html$withinBlockquoteIndividual(java.lang.StringBuilder android.text.Spanned int int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2);
    }

    private static void withinBlockquoteConsecutive(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinBlockquoteConsecutive", $$robo$$android_text_Html$withinBlockquoteConsecutive(java.lang.StringBuilder android.text.Spanned int int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2);
    }

    private static void withinParagraph(StringBuilder stringBuilder, Spanned spanned, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinParagraph", $$robo$$android_text_Html$withinParagraph(java.lang.StringBuilder android.text.Spanned int int ), (StringBuilder)stringBuilder, (Spanned)spanned, (int)n, (int)n2);
    }

    private static void withinStyle(StringBuilder stringBuilder, CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("withinStyle", $$robo$$android_text_Html$withinStyle(java.lang.StringBuilder java.lang.CharSequence int int ), (StringBuilder)stringBuilder, (CharSequence)charSequence, (int)n, (int)n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Html)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class HtmlParser
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static HTMLSchema schema;

        private void $$robo$$android_text_Html_HtmlParser$__constructor__() {
        }

        static void __staticInitializer__() {
            schema = new HTMLSchema();
        }

        private void __constructor__() {
            this.$$robo$$android_text_Html_HtmlParser$__constructor__();
        }

        public HtmlParser() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Html_HtmlParser$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(HtmlParser.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HtmlParser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TagHandler {
        public void handleTag(boolean var1, String var2, Editable var3, XMLReader var4);
    }

    public static interface ImageGetter {
        public Drawable getDrawable(String var1);
    }
}

