/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.TextDirectionHeuristic;
import android.text.TextUtils;
import java.nio.CharBuffer;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextDirectionHeuristics
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static TextDirectionHeuristic LTR;
    public static TextDirectionHeuristic RTL;
    public static TextDirectionHeuristic FIRSTSTRONG_LTR;
    public static TextDirectionHeuristic FIRSTSTRONG_RTL;
    public static TextDirectionHeuristic ANYRTL_LTR;
    public static TextDirectionHeuristic LOCALE;
    private static int STATE_TRUE = 0;
    private static int STATE_FALSE = 1;
    private static int STATE_UNKNOWN = 2;

    private void $$robo$$android_text_TextDirectionHeuristics$__constructor__() {
    }

    private static final int $$robo$$android_text_TextDirectionHeuristics$isRtlCodePoint(int codePoint) {
        switch (Character.getDirectionality(codePoint)) {
            case 0: {
                return 1;
            }
            case 1: 
            case 2: {
                return 0;
            }
            case -1: {
                if (1424 <= codePoint && codePoint <= 2303 || 64285 <= codePoint && codePoint <= 64975 || 65008 <= codePoint && codePoint <= 65023 || 65136 <= codePoint && codePoint <= 65279 || 67584 <= codePoint && codePoint <= 69631 || 124928 <= codePoint && codePoint <= 126975) {
                    return 0;
                }
                if (8293 <= codePoint && codePoint <= 8297 || 65520 <= codePoint && codePoint <= 65528 || 917504 <= codePoint && codePoint <= 921599 || 64976 <= codePoint && codePoint <= 65007 || (codePoint & 0xFFFE) == 65534 || 8352 <= codePoint && codePoint <= 8399 || 55296 <= codePoint && codePoint <= 57343) {
                    return 2;
                }
                return 1;
            }
        }
        return 2;
    }

    static void __staticInitializer__() {
        LTR = new TextDirectionHeuristicInternal(null, false, null);
        RTL = new TextDirectionHeuristicInternal(null, true, null);
        FIRSTSTRONG_LTR = new TextDirectionHeuristicInternal(FirstStrong.INSTANCE, false, null);
        FIRSTSTRONG_RTL = new TextDirectionHeuristicInternal(FirstStrong.INSTANCE, true, null);
        ANYRTL_LTR = new TextDirectionHeuristicInternal(AnyStrong.INSTANCE_RTL, false, null);
        LOCALE = TextDirectionHeuristicLocale.INSTANCE;
    }

    private void __constructor__() {
        this.$$robo$$android_text_TextDirectionHeuristics$__constructor__();
    }

    public TextDirectionHeuristics() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics$__constructor__(), this);
    }

    private static int isRtlCodePoint(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("isRtlCodePoint", $$robo$$android_text_TextDirectionHeuristics$isRtlCodePoint(int ), (int)n);
    }

    static {
        RobolectricInternals.classInitializing(TextDirectionHeuristics.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextDirectionHeuristics)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class TextDirectionHeuristicLocale
    extends TextDirectionHeuristicImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static TextDirectionHeuristicLocale INSTANCE;

        private void $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicLocale$__constructor__() {
        }

        private final boolean $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicLocale$defaultIsRtl() {
            int dir = TextUtils.getLayoutDirectionFromLocale(Locale.getDefault());
            return dir == 1;
        }

        static void __staticInitializer__() {
            INSTANCE = new TextDirectionHeuristicLocale();
        }

        private void __constructor__() {
            this.$$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicLocale$__constructor__();
        }

        public TextDirectionHeuristicLocale() {
            super(null);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicLocale$__constructor__(), this);
        }

        @Override
        protected boolean defaultIsRtl() {
            return (boolean)InvokeDynamicSupport.bootstrap("defaultIsRtl", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicLocale$defaultIsRtl(), this);
        }

        static {
            RobolectricInternals.classInitializing(TextDirectionHeuristicLocale.class);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextDirectionHeuristicLocale)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class AnyStrong
    implements TextDirectionAlgorithm,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mLookForRtl;
        public static AnyStrong INSTANCE_RTL;
        public static AnyStrong INSTANCE_LTR;

        private final int $$robo$$android_text_TextDirectionHeuristics_AnyStrong$checkRtl(CharSequence cs, int start, int count) {
            int cp;
            boolean haveUnlookedFor = false;
            int openIsolateCount = 0;
            int end = start + count;
            block4: for (int i = start; i < end; i += Character.charCount(cp)) {
                cp = Character.codePointAt(cs, i);
                if (8294 <= cp && cp <= 8296) {
                    ++openIsolateCount;
                    continue;
                }
                if (cp == 8297) {
                    if (openIsolateCount <= 0) continue;
                    --openIsolateCount;
                    continue;
                }
                if (openIsolateCount != 0) continue;
                switch (TextDirectionHeuristics.isRtlCodePoint(cp)) {
                    case 0: {
                        if (this.mLookForRtl) {
                            return 0;
                        }
                        haveUnlookedFor = true;
                        continue block4;
                    }
                    case 1: {
                        if (!this.mLookForRtl) {
                            return 1;
                        }
                        haveUnlookedFor = true;
                        continue block4;
                    }
                }
            }
            if (haveUnlookedFor) {
                return this.mLookForRtl ? 1 : 0;
            }
            return 2;
        }

        private void $$robo$$android_text_TextDirectionHeuristics_AnyStrong$__constructor__(boolean lookForRtl) {
            this.mLookForRtl = lookForRtl;
        }

        static void __staticInitializer__() {
            INSTANCE_RTL = new AnyStrong(true);
            INSTANCE_LTR = new AnyStrong(false);
        }

        @Override
        public int checkRtl(CharSequence charSequence, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("checkRtl", $$robo$$android_text_TextDirectionHeuristics_AnyStrong$checkRtl(java.lang.CharSequence int int ), this, charSequence, n, n2);
        }

        private void __constructor__(boolean bl) {
            this.$$robo$$android_text_TextDirectionHeuristics_AnyStrong$__constructor__(bl);
        }

        public AnyStrong(boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics_AnyStrong$__constructor__(boolean ), this, bl);
        }

        static {
            RobolectricInternals.classInitializing(AnyStrong.class);
        }

        public /* synthetic */ AnyStrong() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnyStrong)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FirstStrong
    implements TextDirectionAlgorithm,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static FirstStrong INSTANCE;

        private final int $$robo$$android_text_TextDirectionHeuristics_FirstStrong$checkRtl(CharSequence cs, int start, int count) {
            int cp;
            int result = 2;
            int openIsolateCount = 0;
            int end = start + count;
            for (int i = start; i < end && result == 2; i += Character.charCount(cp)) {
                cp = Character.codePointAt(cs, i);
                if (8294 <= cp && cp <= 8296) {
                    ++openIsolateCount;
                    continue;
                }
                if (cp == 8297) {
                    if (openIsolateCount <= 0) continue;
                    --openIsolateCount;
                    continue;
                }
                if (openIsolateCount != 0) continue;
                result = TextDirectionHeuristics.isRtlCodePoint(cp);
            }
            return result;
        }

        private void $$robo$$android_text_TextDirectionHeuristics_FirstStrong$__constructor__() {
        }

        static void __staticInitializer__() {
            INSTANCE = new FirstStrong();
        }

        @Override
        public int checkRtl(CharSequence charSequence, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("checkRtl", $$robo$$android_text_TextDirectionHeuristics_FirstStrong$checkRtl(java.lang.CharSequence int int ), this, charSequence, n, n2);
        }

        private void __constructor__() {
            this.$$robo$$android_text_TextDirectionHeuristics_FirstStrong$__constructor__();
        }

        public FirstStrong() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics_FirstStrong$__constructor__(), this);
        }

        static {
            RobolectricInternals.classInitializing(FirstStrong.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FirstStrong)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface TextDirectionAlgorithm {
        public int checkRtl(CharSequence var1, int var2, int var3);
    }

    private static class TextDirectionHeuristicInternal
    extends TextDirectionHeuristicImpl
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private boolean mDefaultIsRtl;

        private void $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$__constructor__(TextDirectionAlgorithm algorithm, boolean defaultIsRtl) {
            this.mDefaultIsRtl = defaultIsRtl;
        }

        private final boolean $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$defaultIsRtl() {
            return this.mDefaultIsRtl;
        }

        private /* synthetic */ void $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$__constructor__(TextDirectionAlgorithm x0, boolean x1, 1 x2) {
        }

        private void __constructor__(TextDirectionAlgorithm textDirectionAlgorithm, boolean bl) {
            this.$$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$__constructor__(textDirectionAlgorithm, bl);
        }

        public TextDirectionHeuristicInternal(TextDirectionAlgorithm textDirectionAlgorithm, boolean bl) {
            super(textDirectionAlgorithm);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$__constructor__(android.text.TextDirectionHeuristics$TextDirectionAlgorithm boolean ), this, textDirectionAlgorithm, bl);
        }

        @Override
        protected boolean defaultIsRtl() {
            return (boolean)InvokeDynamicSupport.bootstrap("defaultIsRtl", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$defaultIsRtl(), this);
        }

        private /* synthetic */ void __constructor__(TextDirectionAlgorithm textDirectionAlgorithm, boolean bl, 1 var3_3) {
            this.$$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$__constructor__(textDirectionAlgorithm, bl, var3_3);
        }

        public /* synthetic */ TextDirectionHeuristicInternal(TextDirectionAlgorithm textDirectionAlgorithm, boolean bl, 1 var3_3) {
            this(textDirectionAlgorithm, bl);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicInternal$__constructor__(android.text.TextDirectionHeuristics$TextDirectionAlgorithm boolean android.text.TextDirectionHeuristics$1 ), this, textDirectionAlgorithm, bl, var3_3);
        }

        public /* synthetic */ TextDirectionHeuristicInternal() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextDirectionHeuristicInternal)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class TextDirectionHeuristicImpl
    implements TextDirectionHeuristic,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private TextDirectionAlgorithm mAlgorithm;

        private void $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$__constructor__(TextDirectionAlgorithm algorithm) {
            this.mAlgorithm = algorithm;
        }

        protected abstract boolean defaultIsRtl();

        private final boolean $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$isRtl(char[] array2, int start, int count) {
            return this.isRtl(CharBuffer.wrap(array2), start, count);
        }

        private final boolean $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$isRtl(CharSequence cs, int start, int count) {
            if (cs == null || start < 0 || count < 0 || cs.length() - count < start) {
                throw new IllegalArgumentException();
            }
            if (this.mAlgorithm == null) {
                return this.defaultIsRtl();
            }
            return this.doCheck(cs, start, count);
        }

        private final boolean $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$doCheck(CharSequence cs, int start, int count) {
            switch (this.mAlgorithm.checkRtl(cs, start, count)) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return this.defaultIsRtl();
        }

        private void __constructor__(TextDirectionAlgorithm textDirectionAlgorithm) {
            this.$$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$__constructor__(textDirectionAlgorithm);
        }

        public TextDirectionHeuristicImpl(TextDirectionAlgorithm textDirectionAlgorithm) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$__constructor__(android.text.TextDirectionHeuristics$TextDirectionAlgorithm ), this, textDirectionAlgorithm);
        }

        @Override
        public boolean isRtl(char[] cArray, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isRtl", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$isRtl(char[] int int ), this, cArray, n, n2);
        }

        @Override
        public boolean isRtl(CharSequence charSequence, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isRtl", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$isRtl(java.lang.CharSequence int int ), this, charSequence, n, n2);
        }

        private boolean doCheck(CharSequence charSequence, int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("doCheck", $$robo$$android_text_TextDirectionHeuristics_TextDirectionHeuristicImpl$doCheck(java.lang.CharSequence int int ), this, charSequence, n, n2);
        }

        public /* synthetic */ TextDirectionHeuristicImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextDirectionHeuristicImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

