/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.method.BaseKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MultiTapKeyListener
extends BaseKeyListener
implements SpanWatcher,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static MultiTapKeyListener[] sInstance;
    private static SparseArray<String> sRecs;
    private TextKeyListener.Capitalize mCapitalize;
    private boolean mAutoText;

    private void $$robo$$android_text_method_MultiTapKeyListener$__constructor__(TextKeyListener.Capitalize cap, boolean autotext) {
        this.mCapitalize = cap;
        this.mAutoText = autotext;
    }

    private static final MultiTapKeyListener $$robo$$android_text_method_MultiTapKeyListener$getInstance(boolean autotext, TextKeyListener.Capitalize cap) {
        int off = cap.ordinal() * 2 + (autotext ? 1 : 0);
        if (sInstance[off] == null) {
            MultiTapKeyListener.sInstance[off] = new MultiTapKeyListener(cap, autotext);
        }
        return sInstance[off];
    }

    private final int $$robo$$android_text_method_MultiTapKeyListener$getInputType() {
        return MultiTapKeyListener.makeTextContentType(this.mCapitalize, this.mAutoText);
    }

    private final boolean $$robo$$android_text_method_MultiTapKeyListener$onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        int pref = 0;
        if (view != null) {
            pref = TextKeyListener.getInstance().getPrefs(view.getContext());
        }
        int a = Selection.getSelectionStart(content);
        int b = Selection.getSelectionEnd(content);
        int selStart = Math.min(a, b);
        int selEnd = Math.max(a, b);
        int activeStart = content.getSpanStart(TextKeyListener.ACTIVE);
        int activeEnd = content.getSpanEnd(TextKeyListener.ACTIVE);
        int rec = (content.getSpanFlags(TextKeyListener.ACTIVE) & 0xFF000000) >>> 24;
        if (activeStart == selStart && activeEnd == selEnd && selEnd - selStart == 1 && rec >= 0 && rec < sRecs.size()) {
            char ch;
            String val;
            int ix;
            if (keyCode == 17) {
                char current = content.charAt(selStart);
                if (Character.isLowerCase(current)) {
                    content.replace(selStart, selEnd, String.valueOf(current).toUpperCase());
                    MultiTapKeyListener.removeTimeouts(content);
                    new Timeout(this, content);
                    return true;
                }
                if (Character.isUpperCase(current)) {
                    content.replace(selStart, selEnd, String.valueOf(current).toLowerCase());
                    MultiTapKeyListener.removeTimeouts(content);
                    new Timeout(this, content);
                    return true;
                }
            }
            if (sRecs.indexOfKey(keyCode) == rec && (ix = (val = sRecs.valueAt(rec)).indexOf(ch = content.charAt(selStart))) >= 0) {
                ix = (ix + 1) % val.length();
                content.replace(selStart, selEnd, val, ix, ix + 1);
                MultiTapKeyListener.removeTimeouts(content);
                new Timeout(this, content);
                return true;
            }
            rec = sRecs.indexOfKey(keyCode);
            if (rec >= 0) {
                Selection.setSelection(content, selEnd, selEnd);
                selStart = selEnd;
            }
        } else {
            rec = sRecs.indexOfKey(keyCode);
        }
        if (rec >= 0) {
            String val = sRecs.valueAt(rec);
            int off = 0;
            if ((pref & 1) != 0 && TextKeyListener.shouldCap(this.mCapitalize, content, selStart)) {
                for (int i = 0; i < val.length(); ++i) {
                    if (!Character.isUpperCase(val.charAt(i))) continue;
                    off = i;
                    break;
                }
            }
            if (selStart != selEnd) {
                Selection.setSelection(content, selEnd);
            }
            content.setSpan(OLD_SEL_START, selStart, selStart, 17);
            content.replace(selStart, selEnd, val, off, off + 1);
            int oldStart = content.getSpanStart(OLD_SEL_START);
            selEnd = Selection.getSelectionEnd(content);
            if (selEnd != oldStart) {
                Selection.setSelection(content, oldStart, selEnd);
                content.setSpan(TextKeyListener.LAST_TYPED, oldStart, selEnd, 33);
                content.setSpan(TextKeyListener.ACTIVE, oldStart, selEnd, 0x21 | rec << 24);
            }
            MultiTapKeyListener.removeTimeouts(content);
            new Timeout(this, content);
            if (content.getSpanStart(this) < 0) {
                KeyListener[] methods;
                for (KeyListener method : methods = content.getSpans(0, content.length(), KeyListener.class)) {
                    content.removeSpan(method);
                }
                content.setSpan(this, 0, content.length(), 18);
            }
            return true;
        }
        return super.onKeyDown(view, content, keyCode, event);
    }

    private final void $$robo$$android_text_method_MultiTapKeyListener$onSpanChanged(Spannable buf, Object what, int s, int e, int start, int stop) {
        if (what == Selection.SELECTION_END) {
            buf.removeSpan(TextKeyListener.ACTIVE);
            MultiTapKeyListener.removeTimeouts(buf);
        }
    }

    private static final void $$robo$$android_text_method_MultiTapKeyListener$removeTimeouts(Spannable buf) {
        Timeout[] timeout = buf.getSpans(0, buf.length(), Timeout.class);
        for (int i = 0; i < timeout.length; ++i) {
            Timeout t = timeout[i];
            t.removeCallbacks(t);
            t.mBuffer = null;
            buf.removeSpan(t);
        }
    }

    private final void $$robo$$android_text_method_MultiTapKeyListener$onSpanAdded(Spannable s, Object what, int start, int end) {
    }

    private final void $$robo$$android_text_method_MultiTapKeyListener$onSpanRemoved(Spannable s, Object what, int start, int end) {
    }

    static void __staticInitializer__() {
        sInstance = new MultiTapKeyListener[TextKeyListener.Capitalize.values().length * 2];
        sRecs = new SparseArray();
        sRecs.put(8, ".,1!@#$%^&*:/?'=()");
        sRecs.put(9, "abc2ABC");
        sRecs.put(10, "def3DEF");
        sRecs.put(11, "ghi4GHI");
        sRecs.put(12, "jkl5JKL");
        sRecs.put(13, "mno6MNO");
        sRecs.put(14, "pqrs7PQRS");
        sRecs.put(15, "tuv8TUV");
        sRecs.put(16, "wxyz9WXYZ");
        sRecs.put(7, "0+");
        sRecs.put(18, " ");
    }

    private void __constructor__(TextKeyListener.Capitalize capitalize, boolean bl) {
        this.$$robo$$android_text_method_MultiTapKeyListener$__constructor__(capitalize, bl);
    }

    public MultiTapKeyListener(TextKeyListener.Capitalize capitalize, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_MultiTapKeyListener$__constructor__(android.text.method.TextKeyListener$Capitalize boolean ), this, capitalize, bl);
    }

    public static MultiTapKeyListener getInstance(boolean bl, TextKeyListener.Capitalize capitalize) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_MultiTapKeyListener$getInstance(boolean android.text.method.TextKeyListener$Capitalize ), (boolean)bl, (TextKeyListener.Capitalize)capitalize);
    }

    @Override
    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_text_method_MultiTapKeyListener$getInputType(), this);
    }

    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_text_method_MultiTapKeyListener$onKeyDown(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
    }

    @Override
    public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSpanChanged", $$robo$$android_text_method_MultiTapKeyListener$onSpanChanged(android.text.Spannable java.lang.Object int int int int ), this, spannable, object, n, n2, n3, n4);
    }

    private static void removeTimeouts(Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("removeTimeouts", $$robo$$android_text_method_MultiTapKeyListener$removeTimeouts(android.text.Spannable ), (Spannable)spannable);
    }

    @Override
    public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSpanAdded", $$robo$$android_text_method_MultiTapKeyListener$onSpanAdded(android.text.Spannable java.lang.Object int int ), this, spannable, object, n, n2);
    }

    @Override
    public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSpanRemoved", $$robo$$android_text_method_MultiTapKeyListener$onSpanRemoved(android.text.Spannable java.lang.Object int int ), this, spannable, object, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(MultiTapKeyListener.class);
    }

    public /* synthetic */ MultiTapKeyListener() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultiTapKeyListener)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Timeout
    extends Handler
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Editable mBuffer;
        /* synthetic */ MultiTapKeyListener this$0;

        private void $$robo$$android_text_method_MultiTapKeyListener_Timeout$__constructor__(MultiTapKeyListener multiTapKeyListener, Editable buffer) {
            this.this$0 = multiTapKeyListener;
            this.mBuffer = buffer;
            this.mBuffer.setSpan(this, 0, this.mBuffer.length(), 18);
            this.postAtTime(this, SystemClock.uptimeMillis() + 2000L);
        }

        private final void $$robo$$android_text_method_MultiTapKeyListener_Timeout$run() {
            Editable buf = this.mBuffer;
            if (buf != null) {
                int st = Selection.getSelectionStart(buf);
                int en = Selection.getSelectionEnd(buf);
                int start = buf.getSpanStart(TextKeyListener.ACTIVE);
                int end = buf.getSpanEnd(TextKeyListener.ACTIVE);
                if (st == start && en == end) {
                    Selection.setSelection(buf, Selection.getSelectionEnd(buf));
                }
                buf.removeSpan(this);
            }
        }

        private void __constructor__(MultiTapKeyListener multiTapKeyListener, Editable editable) {
            this.$$robo$$android_text_method_MultiTapKeyListener_Timeout$__constructor__(multiTapKeyListener, editable);
        }

        public Timeout(MultiTapKeyListener multiTapKeyListener, Editable editable) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_MultiTapKeyListener_Timeout$__constructor__(android.text.method.MultiTapKeyListener android.text.Editable ), this, multiTapKeyListener, editable);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_text_method_MultiTapKeyListener_Timeout$run(), this);
        }

        public /* synthetic */ Timeout() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Timeout)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

