/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.os.Handler;
import android.provider.Settings;
import android.text.Editable;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.BaseKeyListener;
import android.text.method.KeyListener;
import android.text.method.MultiTapKeyListener;
import android.text.method.QwertyKeyListener;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.View;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextKeyListener
extends BaseKeyListener
implements SpanWatcher,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static TextKeyListener[] sInstance;
    static Object ACTIVE;
    static Object CAPPED;
    static Object INHIBIT_REPLACEMENT;
    static Object LAST_TYPED;
    private Capitalize mAutoCap;
    private boolean mAutoText;
    private int mPrefs;
    private boolean mPrefsInited;
    static int AUTO_CAP = 1;
    static int AUTO_TEXT = 2;
    static int AUTO_PERIOD = 4;
    static int SHOW_PASSWORD = 8;
    private WeakReference<ContentResolver> mResolver;
    private SettingsObserver mObserver;

    private void $$robo$$android_text_method_TextKeyListener$__constructor__(Capitalize cap, boolean autotext) {
        this.mAutoCap = cap;
        this.mAutoText = autotext;
    }

    private static final TextKeyListener $$robo$$android_text_method_TextKeyListener$getInstance(boolean autotext, Capitalize cap) {
        int off = cap.ordinal() * 2 + (autotext ? 1 : 0);
        if (sInstance[off] == null) {
            TextKeyListener.sInstance[off] = new TextKeyListener(cap, autotext);
        }
        return sInstance[off];
    }

    private static final TextKeyListener $$robo$$android_text_method_TextKeyListener$getInstance() {
        return TextKeyListener.getInstance(false, Capitalize.NONE);
    }

    private static final boolean $$robo$$android_text_method_TextKeyListener$shouldCap(Capitalize cap, CharSequence cs, int off) {
        if (cap == Capitalize.NONE) {
            return false;
        }
        if (cap == Capitalize.CHARACTERS) {
            return true;
        }
        return TextUtils.getCapsMode(cs, off, cap == Capitalize.WORDS ? 8192 : 16384) != 0;
    }

    private final int $$robo$$android_text_method_TextKeyListener$getInputType() {
        return TextKeyListener.makeTextContentType(this.mAutoCap, this.mAutoText);
    }

    private final boolean $$robo$$android_text_method_TextKeyListener$onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        KeyListener im = this.getKeyListener(event);
        return im.onKeyDown(view, content, keyCode, event);
    }

    private final boolean $$robo$$android_text_method_TextKeyListener$onKeyUp(View view, Editable content, int keyCode, KeyEvent event) {
        KeyListener im = this.getKeyListener(event);
        return im.onKeyUp(view, content, keyCode, event);
    }

    private final boolean $$robo$$android_text_method_TextKeyListener$onKeyOther(View view, Editable content, KeyEvent event) {
        KeyListener im = this.getKeyListener(event);
        return im.onKeyOther(view, content, event);
    }

    private static final void $$robo$$android_text_method_TextKeyListener$clear(Editable e) {
        e.clear();
        e.removeSpan(ACTIVE);
        e.removeSpan(CAPPED);
        e.removeSpan(INHIBIT_REPLACEMENT);
        e.removeSpan(LAST_TYPED);
        QwertyKeyListener.Replaced[] repl = e.getSpans(0, e.length(), QwertyKeyListener.Replaced.class);
        int count = repl.length;
        for (int i = 0; i < count; ++i) {
            e.removeSpan(repl[i]);
        }
    }

    private final void $$robo$$android_text_method_TextKeyListener$onSpanAdded(Spannable s, Object what, int start, int end) {
    }

    private final void $$robo$$android_text_method_TextKeyListener$onSpanRemoved(Spannable s, Object what, int start, int end) {
    }

    private final void $$robo$$android_text_method_TextKeyListener$onSpanChanged(Spannable s, Object what, int start, int end, int st, int en) {
        if (what == Selection.SELECTION_END) {
            s.removeSpan(ACTIVE);
        }
    }

    private final KeyListener $$robo$$android_text_method_TextKeyListener$getKeyListener(KeyEvent event) {
        KeyCharacterMap kmap = event.getKeyCharacterMap();
        int kind = kmap.getKeyboardType();
        if (kind == 3) {
            return QwertyKeyListener.getInstance(this.mAutoText, this.mAutoCap);
        }
        if (kind == 1) {
            return MultiTapKeyListener.getInstance(this.mAutoText, this.mAutoCap);
        }
        if (kind == 4 || kind == 5) {
            return QwertyKeyListener.getInstanceForFullKeyboard();
        }
        return NullKeyListener.getInstance();
    }

    private final void $$robo$$android_text_method_TextKeyListener$release() {
        if (this.mResolver != null) {
            ContentResolver contentResolver = (ContentResolver)this.mResolver.get();
            if (contentResolver != null) {
                contentResolver.unregisterContentObserver(this.mObserver);
                this.mResolver.clear();
            }
            this.mObserver = null;
            this.mResolver = null;
            this.mPrefsInited = false;
        }
    }

    private final void $$robo$$android_text_method_TextKeyListener$initPrefs(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        this.mResolver = new WeakReference<ContentResolver>(contentResolver);
        if (this.mObserver == null) {
            this.mObserver = new SettingsObserver(this);
            contentResolver.registerContentObserver(Settings.System.CONTENT_URI, true, this.mObserver);
        }
        this.updatePrefs(contentResolver);
        this.mPrefsInited = true;
    }

    private final void $$robo$$android_text_method_TextKeyListener$updatePrefs(ContentResolver resolver) {
        boolean cap = Settings.System.getInt(resolver, "auto_caps", 1) > 0;
        boolean text = Settings.System.getInt(resolver, "auto_replace", 1) > 0;
        boolean period = Settings.System.getInt(resolver, "auto_punctuate", 1) > 0;
        boolean pw = Settings.System.getInt(resolver, "show_password", 1) > 0;
        this.mPrefs = (cap ? 1 : 0) | (text ? 2 : 0) | (period ? 4 : 0) | (pw ? 8 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_text_method_TextKeyListener$getPrefs(Context context) {
        TextKeyListener textKeyListener = this;
        synchronized (textKeyListener) {
            if (!this.mPrefsInited || this.mResolver.get() == null) {
                this.initPrefs(context);
            }
        }
        return this.mPrefs;
    }

    static void __staticInitializer__() {
        sInstance = new TextKeyListener[Capitalize.values().length * 2];
        ACTIVE = new NoCopySpan.Concrete();
        CAPPED = new NoCopySpan.Concrete();
        INHIBIT_REPLACEMENT = new NoCopySpan.Concrete();
        LAST_TYPED = new NoCopySpan.Concrete();
    }

    private void __constructor__(Capitalize capitalize, boolean bl) {
        this.$$robo$$android_text_method_TextKeyListener$__constructor__(capitalize, bl);
    }

    public TextKeyListener(Capitalize capitalize, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_TextKeyListener$__constructor__(android.text.method.TextKeyListener$Capitalize boolean ), this, capitalize, bl);
    }

    public static TextKeyListener getInstance(boolean bl, Capitalize capitalize) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_TextKeyListener$getInstance(boolean android.text.method.TextKeyListener$Capitalize ), (boolean)bl, (Capitalize)capitalize);
    }

    public static TextKeyListener getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_TextKeyListener$getInstance());
    }

    public static boolean shouldCap(Capitalize capitalize, CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldCap", $$robo$$android_text_method_TextKeyListener$shouldCap(android.text.method.TextKeyListener$Capitalize java.lang.CharSequence int ), (Capitalize)capitalize, (CharSequence)charSequence, (int)n);
    }

    @Override
    public int getInputType() {
        return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_text_method_TextKeyListener$getInputType(), this);
    }

    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_text_method_TextKeyListener$onKeyDown(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
    }

    @Override
    public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_text_method_TextKeyListener$onKeyUp(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
    }

    @Override
    public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyOther", $$robo$$android_text_method_TextKeyListener$onKeyOther(android.view.View android.text.Editable android.view.KeyEvent ), this, view, editable, keyEvent);
    }

    public static void clear(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("clear", $$robo$$android_text_method_TextKeyListener$clear(android.text.Editable ), (Editable)editable);
    }

    @Override
    public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSpanAdded", $$robo$$android_text_method_TextKeyListener$onSpanAdded(android.text.Spannable java.lang.Object int int ), this, spannable, object, n, n2);
    }

    @Override
    public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
        InvokeDynamicSupport.bootstrap("onSpanRemoved", $$robo$$android_text_method_TextKeyListener$onSpanRemoved(android.text.Spannable java.lang.Object int int ), this, spannable, object, n, n2);
    }

    @Override
    public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSpanChanged", $$robo$$android_text_method_TextKeyListener$onSpanChanged(android.text.Spannable java.lang.Object int int int int ), this, spannable, object, n, n2, n3, n4);
    }

    private KeyListener getKeyListener(KeyEvent keyEvent) {
        return InvokeDynamicSupport.bootstrap("getKeyListener", $$robo$$android_text_method_TextKeyListener$getKeyListener(android.view.KeyEvent ), this, keyEvent);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_text_method_TextKeyListener$release(), this);
    }

    private void initPrefs(Context context) {
        InvokeDynamicSupport.bootstrap("initPrefs", $$robo$$android_text_method_TextKeyListener$initPrefs(android.content.Context ), this, context);
    }

    private void updatePrefs(ContentResolver contentResolver) {
        InvokeDynamicSupport.bootstrap("updatePrefs", $$robo$$android_text_method_TextKeyListener$updatePrefs(android.content.ContentResolver ), this, contentResolver);
    }

    int getPrefs(Context context) {
        return (int)InvokeDynamicSupport.bootstrap("getPrefs", $$robo$$android_text_method_TextKeyListener$getPrefs(android.content.Context ), this, context);
    }

    static {
        RobolectricInternals.classInitializing(TextKeyListener.class);
    }

    public /* synthetic */ TextKeyListener() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextKeyListener)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SettingsObserver
    extends ContentObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ TextKeyListener this$0;

        private void $$robo$$android_text_method_TextKeyListener_SettingsObserver$__constructor__(TextKeyListener textKeyListener) {
            this.this$0 = textKeyListener;
        }

        private final void $$robo$$android_text_method_TextKeyListener_SettingsObserver$onChange(boolean selfChange) {
            if (this.this$0.mResolver != null) {
                ContentResolver contentResolver = (ContentResolver)this.this$0.mResolver.get();
                if (contentResolver == null) {
                    this.this$0.mPrefsInited = false;
                } else {
                    this.this$0.updatePrefs(contentResolver);
                }
            } else {
                this.this$0.mPrefsInited = false;
            }
        }

        private void __constructor__(TextKeyListener textKeyListener) {
            this.$$robo$$android_text_method_TextKeyListener_SettingsObserver$__constructor__(textKeyListener);
        }

        public SettingsObserver(TextKeyListener textKeyListener) {
            super(new Handler());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_TextKeyListener_SettingsObserver$__constructor__(android.text.method.TextKeyListener ), this, textKeyListener);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_text_method_TextKeyListener_SettingsObserver$onChange(boolean ), this, bl);
        }

        public /* synthetic */ SettingsObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SettingsObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class NullKeyListener
    implements KeyListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static NullKeyListener sInstance;

        private void $$robo$$android_text_method_TextKeyListener_NullKeyListener$__constructor__() {
        }

        private final int $$robo$$android_text_method_TextKeyListener_NullKeyListener$getInputType() {
            return 0;
        }

        private final boolean $$robo$$android_text_method_TextKeyListener_NullKeyListener$onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
            return false;
        }

        private final boolean $$robo$$android_text_method_TextKeyListener_NullKeyListener$onKeyUp(View view, Editable content, int keyCode, KeyEvent event) {
            return false;
        }

        private final boolean $$robo$$android_text_method_TextKeyListener_NullKeyListener$onKeyOther(View view, Editable content, KeyEvent event) {
            return false;
        }

        private final void $$robo$$android_text_method_TextKeyListener_NullKeyListener$clearMetaKeyState(View view, Editable content, int states) {
        }

        private static final NullKeyListener $$robo$$android_text_method_TextKeyListener_NullKeyListener$getInstance() {
            if (sInstance != null) {
                return sInstance;
            }
            sInstance = new NullKeyListener();
            return sInstance;
        }

        private void __constructor__() {
            this.$$robo$$android_text_method_TextKeyListener_NullKeyListener$__constructor__();
        }

        public NullKeyListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_TextKeyListener_NullKeyListener$__constructor__(), this);
        }

        @Override
        public int getInputType() {
            return (int)InvokeDynamicSupport.bootstrap("getInputType", $$robo$$android_text_method_TextKeyListener_NullKeyListener$getInputType(), this);
        }

        @Override
        public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_text_method_TextKeyListener_NullKeyListener$onKeyDown(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
        }

        @Override
        public boolean onKeyUp(View view, Editable editable, int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_text_method_TextKeyListener_NullKeyListener$onKeyUp(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
        }

        @Override
        public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyOther", $$robo$$android_text_method_TextKeyListener_NullKeyListener$onKeyOther(android.view.View android.text.Editable android.view.KeyEvent ), this, view, editable, keyEvent);
        }

        @Override
        public void clearMetaKeyState(View view, Editable editable, int n) {
            InvokeDynamicSupport.bootstrap("clearMetaKeyState", $$robo$$android_text_method_TextKeyListener_NullKeyListener$clearMetaKeyState(android.view.View android.text.Editable int ), this, view, editable, n);
        }

        public static NullKeyListener getInstance() {
            return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_text_method_TextKeyListener_NullKeyListener$getInstance());
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NullKeyListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Capitalize
    extends Enum<Capitalize> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ Capitalize NONE;
        public static /* enum */ Capitalize SENTENCES;
        public static /* enum */ Capitalize WORDS;
        public static /* enum */ Capitalize CHARACTERS;
        private static /* synthetic */ Capitalize[] $VALUES;

        private static final Capitalize[] $$robo$$android_text_method_TextKeyListener_Capitalize$values() {
            return (Capitalize[])$VALUES.clone();
        }

        private static final Capitalize $$robo$$android_text_method_TextKeyListener_Capitalize$valueOf(String name) {
            return Enum.valueOf(Capitalize.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_text_method_TextKeyListener_Capitalize$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NONE = new Capitalize();
            SENTENCES = new Capitalize();
            WORDS = new Capitalize();
            CHARACTERS = new Capitalize();
            $VALUES = new Capitalize[]{NONE, SENTENCES, WORDS, CHARACTERS};
        }

        public static Capitalize[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_text_method_TextKeyListener_Capitalize$values());
        }

        public static Capitalize valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_text_method_TextKeyListener_Capitalize$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_text_method_TextKeyListener_Capitalize$__constructor__(string2, n);
        }

        public Capitalize() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_TextKeyListener_Capitalize$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Capitalize.class);
        }

        public /* synthetic */ Capitalize() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Capitalize)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

