/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BulletSpan
implements LeadingMarginSpan,
ParcelableSpan,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int STANDARD_BULLET_RADIUS = 4;
    public static int STANDARD_GAP_WIDTH = 2;
    private static int STANDARD_COLOR = 0;
    private int mGapWidth;
    private int mBulletRadius;
    private Path mBulletPath;
    private int mColor;
    private boolean mWantColor;

    private void $$robo$$android_text_style_BulletSpan$__constructor__() {
    }

    private void $$robo$$android_text_style_BulletSpan$__constructor__(int gapWidth) {
    }

    private void $$robo$$android_text_style_BulletSpan$__constructor__(int gapWidth, int color2) {
    }

    private void $$robo$$android_text_style_BulletSpan$__constructor__(int gapWidth, int color2, int bulletRadius) {
    }

    private void $$robo$$android_text_style_BulletSpan$__constructor__(int gapWidth, int color2, boolean wantColor, int bulletRadius) {
        this.mBulletPath = null;
        this.mGapWidth = gapWidth;
        this.mBulletRadius = bulletRadius;
        this.mColor = color2;
        this.mWantColor = wantColor;
    }

    private void $$robo$$android_text_style_BulletSpan$__constructor__(Parcel src) {
        this.mBulletPath = null;
        this.mGapWidth = src.readInt();
        this.mWantColor = src.readInt() != 0;
        this.mColor = src.readInt();
        this.mBulletRadius = src.readInt();
    }

    private final int $$robo$$android_text_style_BulletSpan$getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    private final int $$robo$$android_text_style_BulletSpan$getSpanTypeIdInternal() {
        return 8;
    }

    private final int $$robo$$android_text_style_BulletSpan$describeContents() {
        return 0;
    }

    private final void $$robo$$android_text_style_BulletSpan$writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    private final void $$robo$$android_text_style_BulletSpan$writeToParcelInternal(Parcel dest, int flags) {
        dest.writeInt(this.mGapWidth);
        dest.writeInt(this.mWantColor ? 1 : 0);
        dest.writeInt(this.mColor);
        dest.writeInt(this.mBulletRadius);
    }

    private final int $$robo$$android_text_style_BulletSpan$getLeadingMargin(boolean first) {
        return 2 * this.mBulletRadius + this.mGapWidth;
    }

    private final int $$robo$$android_text_style_BulletSpan$getGapWidth() {
        return this.mGapWidth;
    }

    private final int $$robo$$android_text_style_BulletSpan$getBulletRadius() {
        return this.mBulletRadius;
    }

    private final int $$robo$$android_text_style_BulletSpan$getColor() {
        return this.mColor;
    }

    private final void $$robo$$android_text_style_BulletSpan$drawLeadingMargin(Canvas canvas, Paint paint, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
        if (((Spanned)text).getSpanStart(this) == start) {
            Paint.Style style2 = paint.getStyle();
            int oldcolor = 0;
            if (this.mWantColor) {
                oldcolor = paint.getColor();
                paint.setColor(this.mColor);
            }
            paint.setStyle(Paint.Style.FILL);
            if (layout2 != null) {
                int line = layout2.getLineForOffset(start);
                bottom -= layout2.getLineExtra(line);
            }
            float yPosition = (float)(top + bottom) / 2.0f;
            float xPosition = x + dir * this.mBulletRadius;
            if (canvas.isHardwareAccelerated()) {
                if (this.mBulletPath == null) {
                    this.mBulletPath = new Path();
                    this.mBulletPath.addCircle(0.0f, 0.0f, this.mBulletRadius, Path.Direction.CW);
                }
                canvas.save();
                canvas.translate(xPosition, yPosition);
                canvas.drawPath(this.mBulletPath, paint);
                canvas.restore();
            } else {
                canvas.drawCircle(xPosition, yPosition, this.mBulletRadius, paint);
            }
            if (this.mWantColor) {
                paint.setColor(oldcolor);
            }
            paint.setStyle(style2);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_text_style_BulletSpan$__constructor__();
    }

    public BulletSpan() {
        this(2, 0, false, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_BulletSpan$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_text_style_BulletSpan$__constructor__(n);
    }

    public BulletSpan(int n) {
        this(n, 0, false, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_BulletSpan$__constructor__(int ), this, n);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_text_style_BulletSpan$__constructor__(n, n2);
    }

    public BulletSpan(int n, int n2) {
        this(n, n2, true, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_BulletSpan$__constructor__(int int ), this, n, n2);
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_text_style_BulletSpan$__constructor__(n, n2, n3);
    }

    public BulletSpan(int n, int n2, int n3) {
        this(n, n2, true, n3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_BulletSpan$__constructor__(int int int ), this, n, n2, n3);
    }

    private void __constructor__(int n, int n2, boolean bl, int n3) {
        this.$$robo$$android_text_style_BulletSpan$__constructor__(n, n2, bl, n3);
    }

    public BulletSpan(int n, int n2, boolean bl, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_BulletSpan$__constructor__(int int boolean int ), this, n, n2, bl, n3);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_text_style_BulletSpan$__constructor__(parcel);
    }

    public BulletSpan(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_style_BulletSpan$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int getSpanTypeId() {
        return (int)InvokeDynamicSupport.bootstrap("getSpanTypeId", $$robo$$android_text_style_BulletSpan$getSpanTypeId(), this);
    }

    @Override
    public int getSpanTypeIdInternal() {
        return (int)InvokeDynamicSupport.bootstrap("getSpanTypeIdInternal", $$robo$$android_text_style_BulletSpan$getSpanTypeIdInternal(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_text_style_BulletSpan$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_text_style_BulletSpan$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public void writeToParcelInternal(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcelInternal", $$robo$$android_text_style_BulletSpan$writeToParcelInternal(android.os.Parcel int ), this, parcel, n);
    }

    @Override
    public int getLeadingMargin(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getLeadingMargin", $$robo$$android_text_style_BulletSpan$getLeadingMargin(boolean ), this, bl);
    }

    public int getGapWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getGapWidth", $$robo$$android_text_style_BulletSpan$getGapWidth(), this);
    }

    public int getBulletRadius() {
        return (int)InvokeDynamicSupport.bootstrap("getBulletRadius", $$robo$$android_text_style_BulletSpan$getBulletRadius(), this);
    }

    public int getColor() {
        return (int)InvokeDynamicSupport.bootstrap("getColor", $$robo$$android_text_style_BulletSpan$getColor(), this);
    }

    @Override
    public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout2) {
        InvokeDynamicSupport.bootstrap("drawLeadingMargin", $$robo$$android_text_style_BulletSpan$drawLeadingMargin(android.graphics.Canvas android.graphics.Paint int int int int int java.lang.CharSequence int int boolean android.text.Layout ), this, canvas, paint, n, n2, n3, n4, n5, charSequence, n6, n7, bl, layout2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BulletSpan)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

