/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.annotation.SystemApi;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EventLog
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "EventLog";
    private static String TAGS_FILE = "/system/etc/event-log-tags";
    private static String COMMENT_PATTERN = "^\\s*(#.*)?$";
    private static String TAG_PATTERN = "^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$";
    private static HashMap<String, Integer> sTagCodes;
    private static HashMap<Integer, String> sTagNames;

    private void $$robo$$android_util_EventLog$__constructor__() {
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, long l) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, float f) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, String string2) {
        return 0;
    }

    private static final int $$robo$$android_util_EventLog$writeEvent(int n, Object ... objectArray) {
        return 0;
    }

    private static final void $$robo$$android_util_EventLog$readEvents(int[] nArray, Collection<Event> collection) throws IOException {
    }

    @SystemApi
    private static final void $$robo$$android_util_EventLog$readEventsOnWrapping(int[] nArray, long l, Collection<Event> collection) throws IOException {
    }

    private static final String $$robo$$android_util_EventLog$getTagName(int tag) {
        EventLog.readTagsFile();
        return sTagNames.get(tag);
    }

    private static final int $$robo$$android_util_EventLog$getTagCode(String name) {
        EventLog.readTagsFile();
        Integer code = sTagCodes.get(name);
        return code != null ? code : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized void $$robo$$android_util_EventLog$readTagsFile() {
        if (sTagCodes != null && sTagNames != null) {
            return;
        }
        sTagCodes = new HashMap();
        sTagNames = new HashMap();
        Pattern comment = Pattern.compile("^\\s*(#.*)?$");
        Pattern tag = Pattern.compile("^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$");
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/system/etc/event-log-tags"), 256);
            while ((line = reader.readLine()) != null) {
                if (comment.matcher(line).matches()) continue;
                Matcher m = tag.matcher(line);
                if (!m.matches()) {
                    Log.wtf("EventLog", "Bad entry in /system/etc/event-log-tags: " + line);
                    continue;
                }
                try {
                    int num = Integer.parseInt(m.group(1));
                    String name = m.group(2);
                    sTagCodes.put(name, num);
                    sTagNames.put(num, name);
                }
                catch (NumberFormatException e) {
                    Log.wtf("EventLog", "Error in /system/etc/event-log-tags: " + line, e);
                }
            }
        }
        catch (IOException e) {
            Log.wtf("EventLog", "Error reading /system/etc/event-log-tags", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    static void __staticInitializer__() {
        sTagCodes = null;
        sTagNames = null;
    }

    private void __constructor__() {
        this.$$robo$$android_util_EventLog$__constructor__();
    }

    public EventLog() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_EventLog$__constructor__(), this);
    }

    public static int writeEvent(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int int ), (int)n, (int)n2);
    }

    public static int writeEvent(int n, long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int long ), (int)n, (long)l);
    }

    public static int writeEvent(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int float ), (int)n, (float)f);
    }

    public static int writeEvent(int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int java.lang.String ), (int)n, (String)string2);
    }

    public static int writeEvent(int n, Object ... objectArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("writeEvent", $$robo$$android_util_EventLog$writeEvent(int java.lang.Object[] ), (int)n, (Object[])objectArray);
    }

    public static void readEvents(int[] nArray, Collection<Event> collection) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readEvents", $$robo$$android_util_EventLog$readEvents(int[] java.util.Collection<android.util.EventLog$Event> ), (int[])nArray, collection);
    }

    @SystemApi
    public static void readEventsOnWrapping(int[] nArray, long l, Collection<Event> collection) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readEventsOnWrapping", $$robo$$android_util_EventLog$readEventsOnWrapping(int[] long java.util.Collection<android.util.EventLog$Event> ), (int[])nArray, (long)l, collection);
    }

    public static String getTagName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getTagName", $$robo$$android_util_EventLog$getTagName(int ), (int)n);
    }

    public static int getTagCode(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTagCode", $$robo$$android_util_EventLog$getTagCode(java.lang.String ), (String)string2);
    }

    private static synchronized void readTagsFile() {
        InvokeDynamicSupport.bootstrapStatic("readTagsFile", $$robo$$android_util_EventLog$readTagsFile());
    }

    static {
        RobolectricInternals.classInitializing(EventLog.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventLog)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Event
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ByteBuffer mBuffer;
        private Exception mLastWtf;
        private static int LENGTH_OFFSET = 0;
        private static int HEADER_SIZE_OFFSET = 2;
        private static int PROCESS_OFFSET = 4;
        private static int THREAD_OFFSET = 8;
        private static int SECONDS_OFFSET = 12;
        private static int NANOSECONDS_OFFSET = 16;
        private static int UID_OFFSET = 24;
        private static int V1_PAYLOAD_START = 20;
        private static int DATA_OFFSET = 4;
        private static byte INT_TYPE = 0;
        private static byte LONG_TYPE = 1;
        private static byte STRING_TYPE = 2;
        private static byte LIST_TYPE = 3;
        private static byte FLOAT_TYPE = 4;

        private void $$robo$$android_util_EventLog_Event$__constructor__(byte[] data) {
            this.mBuffer = ByteBuffer.wrap(data);
            this.mBuffer.order(ByteOrder.nativeOrder());
        }

        private final int $$robo$$android_util_EventLog_Event$getProcessId() {
            return this.mBuffer.getInt(4);
        }

        @SystemApi
        private final int $$robo$$android_util_EventLog_Event$getUid() {
            try {
                return this.mBuffer.getInt(24);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
        }

        private final int $$robo$$android_util_EventLog_Event$getThreadId() {
            return this.mBuffer.getInt(8);
        }

        private final long $$robo$$android_util_EventLog_Event$getTimeNanos() {
            return (long)this.mBuffer.getInt(12) * 1000000000L + (long)this.mBuffer.getInt(16);
        }

        private final int $$robo$$android_util_EventLog_Event$getTag() {
            int offset = this.mBuffer.getShort(2);
            if (offset == 0) {
                offset = 20;
            }
            return this.mBuffer.getInt(offset);
        }

        private final synchronized Object $$robo$$android_util_EventLog_Event$getData() {
            try {
                int offset = this.mBuffer.getShort(2);
                if (offset == 0) {
                    offset = 20;
                }
                this.mBuffer.limit(offset + this.mBuffer.getShort(0));
                if (offset + 4 >= this.mBuffer.limit()) {
                    return null;
                }
                this.mBuffer.position(offset + 4);
                return this.decodeObject();
            }
            catch (IllegalArgumentException e) {
                Log.wtf("EventLog", "Illegal entry payload: tag=" + this.getTag(), e);
                this.mLastWtf = e;
                return null;
            }
            catch (BufferUnderflowException e) {
                Log.wtf("EventLog", "Truncated entry payload: tag=" + this.getTag(), e);
                this.mLastWtf = e;
                return null;
            }
        }

        private final Object $$robo$$android_util_EventLog_Event$decodeObject() {
            byte type = this.mBuffer.get();
            switch (type) {
                case 0: {
                    return this.mBuffer.getInt();
                }
                case 1: {
                    return this.mBuffer.getLong();
                }
                case 4: {
                    return Float.valueOf(this.mBuffer.getFloat());
                }
                case 2: {
                    try {
                        int length = this.mBuffer.getInt();
                        int start = this.mBuffer.position();
                        this.mBuffer.position(start + length);
                        return new String(this.mBuffer.array(), start, length, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        Log.wtf("EventLog", "UTF-8 is not supported", e);
                        this.mLastWtf = e;
                        return null;
                    }
                }
                case 3: {
                    int length = this.mBuffer.get();
                    if (length < 0) {
                        length += 256;
                    }
                    Object[] array2 = new Object[length];
                    for (int i = 0; i < length; ++i) {
                        array2[i] = this.decodeObject();
                    }
                    return array2;
                }
            }
            throw new IllegalArgumentException("Unknown entry type: " + type);
        }

        private static final Event $$robo$$android_util_EventLog_Event$fromBytes(byte[] data) {
            return new Event(data);
        }

        private final byte[] $$robo$$android_util_EventLog_Event$getBytes() {
            byte[] bytes = this.mBuffer.array();
            return Arrays.copyOf(bytes, bytes.length);
        }

        private final Exception $$robo$$android_util_EventLog_Event$getLastError() {
            return this.mLastWtf;
        }

        private final void $$robo$$android_util_EventLog_Event$clearError() {
            this.mLastWtf = null;
        }

        private final boolean $$robo$$android_util_EventLog_Event$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Event other = (Event)o;
            return Arrays.equals(this.mBuffer.array(), other.mBuffer.array());
        }

        private final int $$robo$$android_util_EventLog_Event$hashCode() {
            return Arrays.hashCode(this.mBuffer.array());
        }

        private void __constructor__(byte[] byArray) {
            this.$$robo$$android_util_EventLog_Event$__constructor__(byArray);
        }

        public Event(byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_EventLog_Event$__constructor__(byte[] ), this, byArray);
        }

        public int getProcessId() {
            return (int)InvokeDynamicSupport.bootstrap("getProcessId", $$robo$$android_util_EventLog_Event$getProcessId(), this);
        }

        @SystemApi
        public int getUid() {
            return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_util_EventLog_Event$getUid(), this);
        }

        public int getThreadId() {
            return (int)InvokeDynamicSupport.bootstrap("getThreadId", $$robo$$android_util_EventLog_Event$getThreadId(), this);
        }

        public long getTimeNanos() {
            return (long)InvokeDynamicSupport.bootstrap("getTimeNanos", $$robo$$android_util_EventLog_Event$getTimeNanos(), this);
        }

        public int getTag() {
            return (int)InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_util_EventLog_Event$getTag(), this);
        }

        public synchronized Object getData() {
            return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_util_EventLog_Event$getData(), this);
        }

        private Object decodeObject() {
            return InvokeDynamicSupport.bootstrap("decodeObject", $$robo$$android_util_EventLog_Event$decodeObject(), this);
        }

        public static Event fromBytes(byte[] byArray) {
            return InvokeDynamicSupport.bootstrapStatic("fromBytes", $$robo$$android_util_EventLog_Event$fromBytes(byte[] ), (byte[])byArray);
        }

        public byte[] getBytes() {
            return InvokeDynamicSupport.bootstrap("getBytes", $$robo$$android_util_EventLog_Event$getBytes(), this);
        }

        public Exception getLastError() {
            return InvokeDynamicSupport.bootstrap("getLastError", $$robo$$android_util_EventLog_Event$getLastError(), this);
        }

        public void clearError() {
            InvokeDynamicSupport.bootstrap("clearError", $$robo$$android_util_EventLog_Event$clearError(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_EventLog_Event$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_EventLog_Event$hashCode(), this);
        }

        public /* synthetic */ Event() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Event)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

