/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IntArray
implements Cloneable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MIN_CAPACITY_INCREMENT = 12;
    private int[] mValues;
    private int mSize;

    private void $$robo$$android_util_IntArray$__constructor__(int[] array2, int size) {
        this.mValues = array2;
        this.mSize = Preconditions.checkArgumentInRange(size, 0, array2.length, "size");
    }

    private void $$robo$$android_util_IntArray$__constructor__() {
    }

    private void $$robo$$android_util_IntArray$__constructor__(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.INT : ArrayUtils.newUnpaddedIntArray(initialCapacity);
        this.mSize = 0;
    }

    private static final IntArray $$robo$$android_util_IntArray$wrap(int[] array2) {
        return new IntArray(array2, array2.length);
    }

    private static final IntArray $$robo$$android_util_IntArray$fromArray(int[] array2, int size) {
        return IntArray.wrap(Arrays.copyOf(array2, size));
    }

    private final void $$robo$$android_util_IntArray$resize(int newSize) {
        Preconditions.checkArgumentNonnegative(newSize);
        if (newSize <= this.mValues.length) {
            Arrays.fill(this.mValues, newSize, this.mValues.length, 0);
        } else {
            this.ensureCapacity(newSize - this.mSize);
        }
        this.mSize = newSize;
    }

    private final void $$robo$$android_util_IntArray$add(int value) {
        this.add(this.mSize, value);
    }

    private final void $$robo$$android_util_IntArray$add(int index, int value) {
        this.ensureCapacity(1);
        int rightSegment = this.mSize - index;
        ++this.mSize;
        this.checkBounds(index);
        if (rightSegment != 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mValues, (int)index, (Object)this.mValues, (int)(index + 1), (int)rightSegment);
        }
        this.mValues[index] = value;
    }

    private final int $$robo$$android_util_IntArray$binarySearch(int value) {
        return ContainerHelpers.binarySearch(this.mValues, this.mSize, value);
    }

    private final void $$robo$$android_util_IntArray$addAll(IntArray values) {
        int count = values.mSize;
        this.ensureCapacity(count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)values.mValues, (int)0, (Object)this.mValues, (int)this.mSize, (int)count);
        this.mSize += count;
    }

    private final void $$robo$$android_util_IntArray$ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            int[] newValues = ArrayUtils.newUnpaddedIntArray(newCapacity);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mValues, (int)0, (Object)newValues, (int)0, (int)currentSize);
            this.mValues = newValues;
        }
    }

    private final void $$robo$$android_util_IntArray$clear() {
        this.mSize = 0;
    }

    private final IntArray $$robo$$android_util_IntArray$clone() throws CloneNotSupportedException {
        IntArray clone = (IntArray)super.clone();
        clone.mValues = (int[])this.mValues.clone();
        return clone;
    }

    private final int $$robo$$android_util_IntArray$get(int index) {
        this.checkBounds(index);
        return this.mValues[index];
    }

    private final void $$robo$$android_util_IntArray$set(int index, int value) {
        this.checkBounds(index);
        this.mValues[index] = value;
    }

    private final int $$robo$$android_util_IntArray$indexOf(int value) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_util_IntArray$remove(int index) {
        this.checkBounds(index);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mValues, (int)(index + 1), (Object)this.mValues, (int)index, (int)(this.mSize - index - 1));
        --this.mSize;
    }

    private final int $$robo$$android_util_IntArray$size() {
        return this.mSize;
    }

    private final int[] $$robo$$android_util_IntArray$toArray() {
        return Arrays.copyOf(this.mValues, this.mSize);
    }

    private final void $$robo$$android_util_IntArray$checkBounds(int index) {
        if (index < 0 || this.mSize <= index) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, index);
        }
    }

    private void __constructor__(int[] nArray, int n) {
        this.$$robo$$android_util_IntArray$__constructor__(nArray, n);
    }

    public IntArray(int[] nArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_IntArray$__constructor__(int[] int ), this, nArray, n);
    }

    private void __constructor__() {
        this.$$robo$$android_util_IntArray$__constructor__();
    }

    public IntArray() {
        this(10);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_IntArray$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_IntArray$__constructor__(n);
    }

    public IntArray(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_IntArray$__constructor__(int ), this, n);
    }

    public static IntArray wrap(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("wrap", $$robo$$android_util_IntArray$wrap(int[] ), (int[])nArray);
    }

    public static IntArray fromArray(int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromArray", $$robo$$android_util_IntArray$fromArray(int[] int ), (int[])nArray, (int)n);
    }

    public void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_util_IntArray$resize(int ), this, n);
    }

    public void add(int n) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_IntArray$add(int ), this, n);
    }

    public void add(int n, int n2) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_IntArray$add(int int ), this, n, n2);
    }

    public int binarySearch(int n) {
        return (int)InvokeDynamicSupport.bootstrap("binarySearch", $$robo$$android_util_IntArray$binarySearch(int ), this, n);
    }

    public void addAll(IntArray intArray) {
        InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_util_IntArray$addAll(android.util.IntArray ), this, intArray);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_util_IntArray$ensureCapacity(int ), this, n);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_IntArray$clear(), this);
    }

    public IntArray clone() throws CloneNotSupportedException {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_util_IntArray$clone(), this);
    }

    public int get(int n) {
        return (int)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_IntArray$get(int ), this, n);
    }

    public void set(int n, int n2) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_util_IntArray$set(int int ), this, n, n2);
    }

    public int indexOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_util_IntArray$indexOf(int ), this, n);
    }

    public void remove(int n) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_IntArray$remove(int ), this, n);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_IntArray$size(), this);
    }

    public int[] toArray() {
        return InvokeDynamicSupport.bootstrap("toArray", $$robo$$android_util_IntArray$toArray(), this);
    }

    private void checkBounds(int n) {
        InvokeDynamicSupport.bootstrap("checkBounds", $$robo$$android_util_IntArray$checkBounds(int ), this, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

