/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LongArray
implements Cloneable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int MIN_CAPACITY_INCREMENT = 12;
    private long[] mValues;
    private int mSize;

    private void $$robo$$android_util_LongArray$__constructor__(long[] array2, int size) {
        this.mValues = array2;
        this.mSize = Preconditions.checkArgumentInRange(size, 0, array2.length, "size");
    }

    private void $$robo$$android_util_LongArray$__constructor__() {
    }

    private void $$robo$$android_util_LongArray$__constructor__(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.LONG : ArrayUtils.newUnpaddedLongArray(initialCapacity);
        this.mSize = 0;
    }

    private static final LongArray $$robo$$android_util_LongArray$wrap(long[] array2) {
        return new LongArray(array2, array2.length);
    }

    private static final LongArray $$robo$$android_util_LongArray$fromArray(long[] array2, int size) {
        return LongArray.wrap(Arrays.copyOf(array2, size));
    }

    private final void $$robo$$android_util_LongArray$resize(int newSize) {
        Preconditions.checkArgumentNonnegative(newSize);
        if (newSize <= this.mValues.length) {
            Arrays.fill(this.mValues, newSize, this.mValues.length, 0L);
        } else {
            this.ensureCapacity(newSize - this.mSize);
        }
        this.mSize = newSize;
    }

    private final void $$robo$$android_util_LongArray$add(long value) {
        this.add(this.mSize, value);
    }

    private final void $$robo$$android_util_LongArray$add(int index, long value) {
        this.ensureCapacity(1);
        int rightSegment = this.mSize - index;
        ++this.mSize;
        this.checkBounds(index);
        if (rightSegment != 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mValues, (int)index, (Object)this.mValues, (int)(index + 1), (int)rightSegment);
        }
        this.mValues[index] = value;
    }

    private final void $$robo$$android_util_LongArray$addAll(LongArray values) {
        int count = values.mSize;
        this.ensureCapacity(count);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)values.mValues, (int)0, (Object)this.mValues, (int)this.mSize, (int)count);
        this.mSize += count;
    }

    private final void $$robo$$android_util_LongArray$ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            long[] newValues = ArrayUtils.newUnpaddedLongArray(newCapacity);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mValues, (int)0, (Object)newValues, (int)0, (int)currentSize);
            this.mValues = newValues;
        }
    }

    private final void $$robo$$android_util_LongArray$clear() {
        this.mSize = 0;
    }

    private final LongArray $$robo$$android_util_LongArray$clone() {
        LongArray clone = null;
        try {
            clone = (LongArray)super.clone();
            clone.mValues = (long[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private final long $$robo$$android_util_LongArray$get(int index) {
        this.checkBounds(index);
        return this.mValues[index];
    }

    private final void $$robo$$android_util_LongArray$set(int index, long value) {
        this.checkBounds(index);
        this.mValues[index] = value;
    }

    private final int $$robo$$android_util_LongArray$indexOf(long value) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_util_LongArray$remove(int index) {
        this.checkBounds(index);
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mValues, (int)(index + 1), (Object)this.mValues, (int)index, (int)(this.mSize - index - 1));
        --this.mSize;
    }

    private final int $$robo$$android_util_LongArray$size() {
        return this.mSize;
    }

    private final long[] $$robo$$android_util_LongArray$toArray() {
        return Arrays.copyOf(this.mValues, this.mSize);
    }

    private final void $$robo$$android_util_LongArray$checkBounds(int index) {
        if (index < 0 || this.mSize <= index) {
            throw new ArrayIndexOutOfBoundsException(this.mSize, index);
        }
    }

    private static final boolean $$robo$$android_util_LongArray$elementsEqual(LongArray a, LongArray b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a.mSize != b.mSize) {
            return false;
        }
        for (int i = 0; i < a.mSize; ++i) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }

    private void __constructor__(long[] lArray, int n) {
        this.$$robo$$android_util_LongArray$__constructor__(lArray, n);
    }

    public LongArray(long[] lArray, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongArray$__constructor__(long[] int ), this, lArray, n);
    }

    private void __constructor__() {
        this.$$robo$$android_util_LongArray$__constructor__();
    }

    public LongArray() {
        this(10);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongArray$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_LongArray$__constructor__(n);
    }

    public LongArray(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongArray$__constructor__(int ), this, n);
    }

    public static LongArray wrap(long[] lArray) {
        return InvokeDynamicSupport.bootstrapStatic("wrap", $$robo$$android_util_LongArray$wrap(long[] ), (long[])lArray);
    }

    public static LongArray fromArray(long[] lArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("fromArray", $$robo$$android_util_LongArray$fromArray(long[] int ), (long[])lArray, (int)n);
    }

    public void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_util_LongArray$resize(int ), this, n);
    }

    public void add(long l) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_LongArray$add(long ), this, l);
    }

    public void add(int n, long l) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_util_LongArray$add(int long ), this, n, l);
    }

    public void addAll(LongArray longArray) {
        InvokeDynamicSupport.bootstrap("addAll", $$robo$$android_util_LongArray$addAll(android.util.LongArray ), this, longArray);
    }

    private void ensureCapacity(int n) {
        InvokeDynamicSupport.bootstrap("ensureCapacity", $$robo$$android_util_LongArray$ensureCapacity(int ), this, n);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_LongArray$clear(), this);
    }

    public LongArray clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_util_LongArray$clone(), this);
    }

    public long get(int n) {
        return (long)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_LongArray$get(int ), this, n);
    }

    public void set(int n, long l) {
        InvokeDynamicSupport.bootstrap("set", $$robo$$android_util_LongArray$set(int long ), this, n, l);
    }

    public int indexOf(long l) {
        return (int)InvokeDynamicSupport.bootstrap("indexOf", $$robo$$android_util_LongArray$indexOf(long ), this, l);
    }

    public void remove(int n) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_LongArray$remove(int ), this, n);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_LongArray$size(), this);
    }

    public long[] toArray() {
        return InvokeDynamicSupport.bootstrap("toArray", $$robo$$android_util_LongArray$toArray(), this);
    }

    private void checkBounds(int n) {
        InvokeDynamicSupport.bootstrap("checkBounds", $$robo$$android_util_LongArray$checkBounds(int ), this, n);
    }

    public static boolean elementsEqual(LongArray longArray, LongArray longArray2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("elementsEqual", $$robo$$android_util_LongArray$elementsEqual(android.util.LongArray android.util.LongArray ), (LongArray)longArray, (LongArray)longArray2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LongArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

