/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class LongSparseArray<E>
implements Cloneable {
    public /* synthetic */ Object __robo_data__;
    private static Object DELETED;
    private boolean mGarbage;
    private long[] mKeys;
    private Object[] mValues;
    private int mSize;

    private void $$robo$$android_util_LongSparseArray$__constructor__() {
    }

    private void $$robo$$android_util_LongSparseArray$__constructor__(int initialCapacity) {
        this.mGarbage = false;
        if (initialCapacity == 0) {
            this.mKeys = EmptyArray.LONG;
            this.mValues = EmptyArray.OBJECT;
        } else {
            this.mKeys = ArrayUtils.newUnpaddedLongArray(initialCapacity);
            this.mValues = ArrayUtils.newUnpaddedObjectArray(initialCapacity);
        }
        this.mSize = 0;
    }

    private final LongSparseArray<E> $$robo$$android_util_LongSparseArray$clone() {
        LongSparseArray clone = null;
        try {
            clone = (LongSparseArray)super.clone();
            clone.mKeys = (long[])this.mKeys.clone();
            clone.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private final E $$robo$$android_util_LongSparseArray$get(long key) {
        return this.get(key, null);
    }

    private final E $$robo$$android_util_LongSparseArray$get(long key, E valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i];
    }

    private final void $$robo$$android_util_LongSparseArray$delete(long key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    private final void $$robo$$android_util_LongSparseArray$remove(long key) {
        this.delete(key);
    }

    private final void $$robo$$android_util_LongSparseArray$removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    private final void $$robo$$android_util_LongSparseArray$gc() {
        int n = this.mSize;
        int o = 0;
        long[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
                values[i] = null;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    private final void $$robo$$android_util_LongSparseArray$put(long key, E value) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
                this.mKeys[i] = key;
                this.mValues[i] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i = ~ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
            }
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i, key);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    private final int $$robo$$android_util_LongSparseArray$size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    private final long $$robo$$android_util_LongSparseArray$keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    private final E $$robo$$android_util_LongSparseArray$valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    private final void $$robo$$android_util_LongSparseArray$setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    private final int $$robo$$android_util_LongSparseArray$indexOfKey(long key) {
        if (this.mGarbage) {
            this.gc();
        }
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    private final int $$robo$$android_util_LongSparseArray$indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_util_LongSparseArray$indexOfValueByValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (!(value == null ? this.mValues[i] == null : value.equals(this.mValues[i]))) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_util_LongSparseArray$clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    private final void $$robo$$android_util_LongSparseArray$append(long key, E value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    private final String $$robo$$android_util_LongSparseArray$toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            long key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            E value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    static void __staticInitializer__() {
        DELETED = new Object();
    }

    private void __constructor__() {
        this.$$robo$$android_util_LongSparseArray$__constructor__();
    }

    public LongSparseArray() {
        this(10);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongSparseArray$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_LongSparseArray$__constructor__(n);
    }

    public LongSparseArray(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LongSparseArray$__constructor__(int ), this, n);
    }

    public LongSparseArray<E> clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_util_LongSparseArray$clone(), this);
    }

    public E get(long l) {
        return (E)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_LongSparseArray$get(long ), this, l);
    }

    public E get(long l, E e) {
        return (E)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_LongSparseArray$get(long E ), this, l, e);
    }

    public void delete(long l) {
        InvokeDynamicSupport.bootstrap("delete", $$robo$$android_util_LongSparseArray$delete(long ), this, l);
    }

    public void remove(long l) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_LongSparseArray$remove(long ), this, l);
    }

    public void removeAt(int n) {
        InvokeDynamicSupport.bootstrap("removeAt", $$robo$$android_util_LongSparseArray$removeAt(int ), this, n);
    }

    private void gc() {
        InvokeDynamicSupport.bootstrap("gc", $$robo$$android_util_LongSparseArray$gc(), this);
    }

    public void put(long l, E e) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_util_LongSparseArray$put(long E ), this, l, e);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_LongSparseArray$size(), this);
    }

    public long keyAt(int n) {
        return (long)InvokeDynamicSupport.bootstrap("keyAt", $$robo$$android_util_LongSparseArray$keyAt(int ), this, n);
    }

    public E valueAt(int n) {
        return (E)InvokeDynamicSupport.bootstrap("valueAt", $$robo$$android_util_LongSparseArray$valueAt(int ), this, n);
    }

    public void setValueAt(int n, E e) {
        InvokeDynamicSupport.bootstrap("setValueAt", $$robo$$android_util_LongSparseArray$setValueAt(int E ), this, n, e);
    }

    public int indexOfKey(long l) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfKey", $$robo$$android_util_LongSparseArray$indexOfKey(long ), this, l);
    }

    public int indexOfValue(E e) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfValue", $$robo$$android_util_LongSparseArray$indexOfValue(E ), this, e);
    }

    public int indexOfValueByValue(E e) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfValueByValue", $$robo$$android_util_LongSparseArray$indexOfValueByValue(E ), this, e);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_LongSparseArray$clear(), this);
    }

    public void append(long l, E e) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_util_LongSparseArray$append(long E ), this, l, e);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_LongSparseArray$toString(), this);
    }

    static {
        RobolectricInternals.classInitializing(LongSparseArray.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LongSparseArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

