/*
 * Decompiled with CFR 0.152.
 */
package android.util.apk;

import android.util.apk.ByteBufferDataSource;
import android.util.apk.ByteBufferFactory;
import android.util.apk.DataDigester;
import android.util.apk.DataSource;
import android.util.apk.MemoryMappedFileDataSource;
import android.util.apk.SignatureInfo;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ApkVerityBuilder
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int CHUNK_SIZE_BYTES = 4096;
    private static int DIGEST_SIZE_BYTES = 32;
    private static int FSVERITY_HEADER_SIZE_BYTES = 64;
    private static int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_SIZE = 4;
    private static int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static String JCA_DIGEST_ALGORITHM = "SHA-256";
    private static byte[] DEFAULT_SALT;
    private static int MMAP_REGION_SIZE_BYTES = 0x100000;

    private void $$robo$$android_util_apk_ApkVerityBuilder$__constructor__() {
    }

    private static final ApkVerityResult $$robo$$android_util_apk_ApkVerityBuilder$generateApkVerity(RandomAccessFile apk, SignatureInfo signatureInfo, ByteBufferFactory bufferFactory) throws IOException, SecurityException, NoSuchAlgorithmException, DigestException {
        long signingBlockSize = signatureInfo.centralDirOffset - signatureInfo.apkSigningBlockOffset;
        long dataSize = apk.length() - signingBlockSize;
        int[] levelOffset = ApkVerityBuilder.calculateVerityLevelOffset(dataSize);
        int merkleTreeSize = levelOffset[levelOffset.length - 1];
        ByteBuffer output = bufferFactory.create(merkleTreeSize + 4096);
        output.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer tree = ApkVerityBuilder.slice(output, 0, merkleTreeSize);
        ByteBuffer header = ApkVerityBuilder.slice(output, merkleTreeSize, merkleTreeSize + 64);
        ByteBuffer extensions = ApkVerityBuilder.slice(output, merkleTreeSize + 64, merkleTreeSize + 4096);
        byte[] apkDigestBytes = new byte[32];
        ByteBuffer apkDigest = ByteBuffer.wrap(apkDigestBytes);
        apkDigest.order(ByteOrder.LITTLE_ENDIAN);
        ApkVerityBuilder.calculateFsveritySignatureInternal(apk, signatureInfo, tree, apkDigest, header, extensions);
        output.position(merkleTreeSize + 64 + extensions.limit());
        output.putInt(64 + extensions.limit() + 4);
        output.flip();
        return new ApkVerityResult(output, apkDigestBytes);
    }

    private static final byte[] $$robo$$android_util_apk_ApkVerityBuilder$generateFsverityRootHash(RandomAccessFile apk, ByteBuffer apkDigest, SignatureInfo signatureInfo) throws NoSuchAlgorithmException, DigestException, IOException {
        ByteBuffer verityBlock = ByteBuffer.allocate(4096).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer header = ApkVerityBuilder.slice(verityBlock, 0, 64);
        ByteBuffer extensions = ApkVerityBuilder.slice(verityBlock, 64, 4032);
        ApkVerityBuilder.calculateFsveritySignatureInternal(apk, signatureInfo, null, null, header, extensions);
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(header);
        md.update(extensions);
        md.update(apkDigest);
        return md.digest();
    }

    private static final void $$robo$$android_util_apk_ApkVerityBuilder$calculateFsveritySignatureInternal(RandomAccessFile apk, SignatureInfo signatureInfo, ByteBuffer treeOutput, ByteBuffer rootHashOutput, ByteBuffer headerOutput, ByteBuffer extensionsOutput) throws IOException, NoSuchAlgorithmException, DigestException {
        ApkVerityBuilder.assertSigningBlockAlignedAndHasFullPages(signatureInfo);
        long signingBlockSize = signatureInfo.centralDirOffset - signatureInfo.apkSigningBlockOffset;
        long dataSize = apk.length() - signingBlockSize;
        int[] levelOffset = ApkVerityBuilder.calculateVerityLevelOffset(dataSize);
        if (treeOutput != null) {
            byte[] apkRootHash = ApkVerityBuilder.generateApkVerityTree(apk, signatureInfo, DEFAULT_SALT, levelOffset, treeOutput);
            if (rootHashOutput != null) {
                rootHashOutput.put(apkRootHash);
                rootHashOutput.flip();
            }
        }
        if (headerOutput != null) {
            headerOutput.order(ByteOrder.LITTLE_ENDIAN);
            ApkVerityBuilder.generateFsverityHeader(headerOutput, apk.length(), levelOffset.length - 1, DEFAULT_SALT);
        }
        if (extensionsOutput != null) {
            extensionsOutput.order(ByteOrder.LITTLE_ENDIAN);
            ApkVerityBuilder.generateFsverityExtensions(extensionsOutput, signatureInfo.apkSigningBlockOffset, signingBlockSize, signatureInfo.eocdOffset);
        }
    }

    private static final void $$robo$$android_util_apk_ApkVerityBuilder$consumeByChunk(DataDigester digester, DataSource source, int chunkSize) throws IOException, DigestException {
        int size;
        long inputOffset = 0L;
        for (long inputRemaining = source.size(); inputRemaining > 0L; inputRemaining -= (long)size) {
            size = (int)Math.min(inputRemaining, (long)chunkSize);
            source.feedIntoDataDigester(digester, inputOffset, size);
            inputOffset += (long)size;
        }
    }

    private static final void $$robo$$android_util_apk_ApkVerityBuilder$generateApkVerityDigestAtLeafLevel(RandomAccessFile apk, SignatureInfo signatureInfo, byte[] salt, ByteBuffer output) throws IOException, NoSuchAlgorithmException, DigestException {
        BufferedDigester digester = new BufferedDigester(salt, output, null);
        ApkVerityBuilder.consumeByChunk(digester, new MemoryMappedFileDataSource(apk.getFD(), 0L, signatureInfo.apkSigningBlockOffset), 0x100000);
        long eocdCdOffsetFieldPosition = signatureInfo.eocdOffset + 16L;
        ApkVerityBuilder.consumeByChunk(digester, new MemoryMappedFileDataSource(apk.getFD(), signatureInfo.centralDirOffset, eocdCdOffsetFieldPosition - signatureInfo.centralDirOffset), 0x100000);
        ByteBuffer alternativeCentralDirOffset = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        alternativeCentralDirOffset.putInt(Math.toIntExact(signatureInfo.apkSigningBlockOffset));
        alternativeCentralDirOffset.flip();
        digester.consume(alternativeCentralDirOffset);
        long offsetAfterEocdCdOffsetField = eocdCdOffsetFieldPosition + 4L;
        ApkVerityBuilder.consumeByChunk(digester, new MemoryMappedFileDataSource(apk.getFD(), offsetAfterEocdCdOffsetField, apk.length() - offsetAfterEocdCdOffsetField), 0x100000);
        int lastIncompleteChunkSize = (int)(apk.length() % 4096L);
        if (lastIncompleteChunkSize != 0) {
            digester.consume(ByteBuffer.allocate(4096 - lastIncompleteChunkSize));
        }
        digester.assertEmptyBuffer();
        digester.fillUpLastOutputChunk();
    }

    private static final byte[] $$robo$$android_util_apk_ApkVerityBuilder$generateApkVerityTree(RandomAccessFile apk, SignatureInfo signatureInfo, byte[] salt, int[] levelOffset, ByteBuffer output) throws IOException, NoSuchAlgorithmException, DigestException {
        ApkVerityBuilder.generateApkVerityDigestAtLeafLevel(apk, signatureInfo, salt, ApkVerityBuilder.slice(output, levelOffset[levelOffset.length - 2], levelOffset[levelOffset.length - 1]));
        for (int level = levelOffset.length - 3; level >= 0; --level) {
            ByteBuffer inputBuffer = ApkVerityBuilder.slice(output, levelOffset[level + 1], levelOffset[level + 2]);
            ByteBuffer outputBuffer = ApkVerityBuilder.slice(output, levelOffset[level], levelOffset[level + 1]);
            ByteBufferDataSource source = new ByteBufferDataSource(inputBuffer);
            BufferedDigester digester = new BufferedDigester(salt, outputBuffer, null);
            ApkVerityBuilder.consumeByChunk(digester, source, 4096);
            digester.assertEmptyBuffer();
            digester.fillUpLastOutputChunk();
        }
        byte[] rootHash = new byte[32];
        BufferedDigester digester = new BufferedDigester(salt, ByteBuffer.wrap(rootHash), null);
        digester.consume(ApkVerityBuilder.slice(output, 0, 4096));
        digester.assertEmptyBuffer();
        return rootHash;
    }

    private static final ByteBuffer $$robo$$android_util_apk_ApkVerityBuilder$generateFsverityHeader(ByteBuffer buffer, long fileSize, int depth, byte[] salt) {
        if (salt.length != 8) {
            throw new IllegalArgumentException("salt is not 8 bytes long");
        }
        buffer.put("TrueBrew".getBytes());
        buffer.put((byte)1);
        buffer.put((byte)0);
        buffer.put((byte)12);
        buffer.put((byte)7);
        buffer.putShort((short)1);
        buffer.putShort((short)1);
        buffer.putInt(0);
        buffer.putInt(0);
        buffer.putLong(fileSize);
        buffer.put((byte)2);
        buffer.put((byte)0);
        buffer.put(salt);
        ApkVerityBuilder.skip(buffer, 22);
        buffer.flip();
        return buffer;
    }

    private static final ByteBuffer $$robo$$android_util_apk_ApkVerityBuilder$generateFsverityExtensions(ByteBuffer buffer, long signingBlockOffset, long signingBlockSize, long eocdOffset) {
        int kSizeOfFsverityExtensionHeader = 8;
        int kExtensionSizeAlignment = 8;
        int kSizeOfFsverityElidedExtension = 16;
        buffer.putInt(24);
        buffer.putShort((short)1);
        ApkVerityBuilder.skip(buffer, 2);
        buffer.putLong(signingBlockOffset);
        buffer.putLong(signingBlockSize);
        int kTotalSize = 20;
        buffer.putInt(20);
        buffer.putShort((short)2);
        ApkVerityBuilder.skip(buffer, 2);
        buffer.putLong(eocdOffset + 16L);
        buffer.putInt(Math.toIntExact(signingBlockOffset));
        int kPadding = 4;
        if (kPadding == 8) {
            kPadding = 0;
        }
        ApkVerityBuilder.skip(buffer, kPadding);
        buffer.flip();
        return buffer;
    }

    private static final int[] $$robo$$android_util_apk_ApkVerityBuilder$calculateVerityLevelOffset(long fileSize) {
        ArrayList<Long> levelSize = new ArrayList<Long>();
        while (true) {
            long levelDigestSize = ApkVerityBuilder.divideRoundup(fileSize, 4096L) * 32L;
            long chunksSize = 4096L * ApkVerityBuilder.divideRoundup(levelDigestSize, 4096L);
            levelSize.add(chunksSize);
            if (levelDigestSize <= 4096L) break;
            fileSize = levelDigestSize;
        }
        int[] levelOffset = new int[levelSize.size() + 1];
        levelOffset[0] = 0;
        for (int i = 0; i < levelSize.size(); ++i) {
            levelOffset[i + 1] = levelOffset[i] + Math.toIntExact((Long)levelSize.get(levelSize.size() - i - 1));
        }
        return levelOffset;
    }

    private static final void $$robo$$android_util_apk_ApkVerityBuilder$assertSigningBlockAlignedAndHasFullPages(SignatureInfo signatureInfo) {
        if (signatureInfo.apkSigningBlockOffset % 4096L != 0L) {
            throw new IllegalArgumentException("APK Signing Block does not start at the page  boundary: " + signatureInfo.apkSigningBlockOffset);
        }
        if ((signatureInfo.centralDirOffset - signatureInfo.apkSigningBlockOffset) % 4096L != 0L) {
            throw new IllegalArgumentException("Size of APK Signing Block is not a multiple of 4096: " + (signatureInfo.centralDirOffset - signatureInfo.apkSigningBlockOffset));
        }
    }

    private static final ByteBuffer $$robo$$android_util_apk_ApkVerityBuilder$slice(ByteBuffer buffer, int begin, int end) {
        ByteBuffer b = buffer.duplicate();
        b.position(0);
        b.limit(end);
        b.position(begin);
        return b.slice();
    }

    private static final void $$robo$$android_util_apk_ApkVerityBuilder$skip(ByteBuffer buffer, int bytes) {
        buffer.position(buffer.position() + bytes);
    }

    private static final long $$robo$$android_util_apk_ApkVerityBuilder$divideRoundup(long dividend, long divisor) {
        return (dividend + divisor - 1L) / divisor;
    }

    static void __staticInitializer__() {
        DEFAULT_SALT = new byte[8];
    }

    private void __constructor__() {
        this.$$robo$$android_util_apk_ApkVerityBuilder$__constructor__();
    }

    public ApkVerityBuilder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkVerityBuilder$__constructor__(), this);
    }

    static ApkVerityResult generateApkVerity(RandomAccessFile randomAccessFile, SignatureInfo signatureInfo, ByteBufferFactory byteBufferFactory) throws IOException, SecurityException, NoSuchAlgorithmException, DigestException {
        return InvokeDynamicSupport.bootstrapStatic("generateApkVerity", $$robo$$android_util_apk_ApkVerityBuilder$generateApkVerity(java.io.RandomAccessFile android.util.apk.SignatureInfo android.util.apk.ByteBufferFactory ), (RandomAccessFile)randomAccessFile, (SignatureInfo)signatureInfo, (ByteBufferFactory)byteBufferFactory);
    }

    static byte[] generateFsverityRootHash(RandomAccessFile randomAccessFile, ByteBuffer byteBuffer, SignatureInfo signatureInfo) throws NoSuchAlgorithmException, DigestException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("generateFsverityRootHash", $$robo$$android_util_apk_ApkVerityBuilder$generateFsverityRootHash(java.io.RandomAccessFile java.nio.ByteBuffer android.util.apk.SignatureInfo ), (RandomAccessFile)randomAccessFile, (ByteBuffer)byteBuffer, (SignatureInfo)signatureInfo);
    }

    private static void calculateFsveritySignatureInternal(RandomAccessFile randomAccessFile, SignatureInfo signatureInfo, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, ByteBuffer byteBuffer4) throws IOException, NoSuchAlgorithmException, DigestException {
        InvokeDynamicSupport.bootstrapStatic("calculateFsveritySignatureInternal", $$robo$$android_util_apk_ApkVerityBuilder$calculateFsveritySignatureInternal(java.io.RandomAccessFile android.util.apk.SignatureInfo java.nio.ByteBuffer java.nio.ByteBuffer java.nio.ByteBuffer java.nio.ByteBuffer ), (RandomAccessFile)randomAccessFile, (SignatureInfo)signatureInfo, (ByteBuffer)byteBuffer, (ByteBuffer)byteBuffer2, (ByteBuffer)byteBuffer3, (ByteBuffer)byteBuffer4);
    }

    private static void consumeByChunk(DataDigester dataDigester, DataSource dataSource, int n) throws IOException, DigestException {
        InvokeDynamicSupport.bootstrapStatic("consumeByChunk", $$robo$$android_util_apk_ApkVerityBuilder$consumeByChunk(android.util.apk.DataDigester android.util.apk.DataSource int ), (DataDigester)dataDigester, (DataSource)dataSource, (int)n);
    }

    private static void generateApkVerityDigestAtLeafLevel(RandomAccessFile randomAccessFile, SignatureInfo signatureInfo, byte[] byArray, ByteBuffer byteBuffer) throws IOException, NoSuchAlgorithmException, DigestException {
        InvokeDynamicSupport.bootstrapStatic("generateApkVerityDigestAtLeafLevel", $$robo$$android_util_apk_ApkVerityBuilder$generateApkVerityDigestAtLeafLevel(java.io.RandomAccessFile android.util.apk.SignatureInfo byte[] java.nio.ByteBuffer ), (RandomAccessFile)randomAccessFile, (SignatureInfo)signatureInfo, (byte[])byArray, (ByteBuffer)byteBuffer);
    }

    private static byte[] generateApkVerityTree(RandomAccessFile randomAccessFile, SignatureInfo signatureInfo, byte[] byArray, int[] nArray, ByteBuffer byteBuffer) throws IOException, NoSuchAlgorithmException, DigestException {
        return InvokeDynamicSupport.bootstrapStatic("generateApkVerityTree", $$robo$$android_util_apk_ApkVerityBuilder$generateApkVerityTree(java.io.RandomAccessFile android.util.apk.SignatureInfo byte[] int[] java.nio.ByteBuffer ), (RandomAccessFile)randomAccessFile, (SignatureInfo)signatureInfo, (byte[])byArray, (int[])nArray, (ByteBuffer)byteBuffer);
    }

    private static ByteBuffer generateFsverityHeader(ByteBuffer byteBuffer, long l, int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("generateFsverityHeader", $$robo$$android_util_apk_ApkVerityBuilder$generateFsverityHeader(java.nio.ByteBuffer long int byte[] ), (ByteBuffer)byteBuffer, (long)l, (int)n, (byte[])byArray);
    }

    private static ByteBuffer generateFsverityExtensions(ByteBuffer byteBuffer, long l, long l2, long l3) {
        return InvokeDynamicSupport.bootstrapStatic("generateFsverityExtensions", $$robo$$android_util_apk_ApkVerityBuilder$generateFsverityExtensions(java.nio.ByteBuffer long long long ), (ByteBuffer)byteBuffer, (long)l, (long)l2, (long)l3);
    }

    private static int[] calculateVerityLevelOffset(long l) {
        return InvokeDynamicSupport.bootstrapStatic("calculateVerityLevelOffset", $$robo$$android_util_apk_ApkVerityBuilder$calculateVerityLevelOffset(long ), (long)l);
    }

    private static void assertSigningBlockAlignedAndHasFullPages(SignatureInfo signatureInfo) {
        InvokeDynamicSupport.bootstrapStatic("assertSigningBlockAlignedAndHasFullPages", $$robo$$android_util_apk_ApkVerityBuilder$assertSigningBlockAlignedAndHasFullPages(android.util.apk.SignatureInfo ), (SignatureInfo)signatureInfo);
    }

    private static ByteBuffer slice(ByteBuffer byteBuffer, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("slice", $$robo$$android_util_apk_ApkVerityBuilder$slice(java.nio.ByteBuffer int int ), (ByteBuffer)byteBuffer, (int)n, (int)n2);
    }

    private static void skip(ByteBuffer byteBuffer, int n) {
        InvokeDynamicSupport.bootstrapStatic("skip", $$robo$$android_util_apk_ApkVerityBuilder$skip(java.nio.ByteBuffer int ), (ByteBuffer)byteBuffer, (int)n);
    }

    private static long divideRoundup(long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("divideRoundup", $$robo$$android_util_apk_ApkVerityBuilder$divideRoundup(long long ), (long)l, (long)l2);
    }

    static {
        RobolectricInternals.classInitializing(ApkVerityBuilder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkVerityBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class BufferedDigester
    implements DataDigester,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int BUFFER_SIZE = 4096;
        private int mBytesDigestedSinceReset;
        private ByteBuffer mOutput;
        private MessageDigest mMd;
        private byte[] mDigestBuffer;
        private byte[] mSalt;

        private void $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$__constructor__(byte[] salt, ByteBuffer output) throws NoSuchAlgorithmException {
            this.mDigestBuffer = new byte[32];
            this.mSalt = salt;
            this.mOutput = output.slice();
            this.mMd = MessageDigest.getInstance("SHA-256");
            this.mMd.update(this.mSalt);
            this.mBytesDigestedSinceReset = 0;
        }

        private final void $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$consume(ByteBuffer buffer) throws DigestException {
            int offset = buffer.position();
            int remaining = buffer.remaining();
            while (remaining > 0) {
                int allowance = Math.min(remaining, 4096 - this.mBytesDigestedSinceReset);
                buffer.limit(buffer.position() + allowance);
                this.mMd.update(buffer);
                offset += allowance;
                remaining -= allowance;
                this.mBytesDigestedSinceReset += allowance;
                if (this.mBytesDigestedSinceReset != 4096) continue;
                this.mMd.digest(this.mDigestBuffer, 0, this.mDigestBuffer.length);
                this.mOutput.put(this.mDigestBuffer);
                this.mMd.update(this.mSalt);
                this.mBytesDigestedSinceReset = 0;
            }
        }

        private final void $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$assertEmptyBuffer() throws DigestException {
            if (this.mBytesDigestedSinceReset != 0) {
                throw new IllegalStateException("Buffer is not empty: " + this.mBytesDigestedSinceReset);
            }
        }

        private final void $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$fillUpLastOutputChunk() {
            int lastBlockSize = this.mOutput.position() % 4096;
            if (lastBlockSize == 0) {
                return;
            }
            this.mOutput.put(ByteBuffer.allocate(4096 - lastBlockSize));
        }

        private /* synthetic */ void $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$__constructor__(byte[] x0, ByteBuffer x1, 1 x2) throws NoSuchAlgorithmException {
        }

        private void __constructor__(byte[] byArray, ByteBuffer byteBuffer) throws NoSuchAlgorithmException {
            this.$$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$__constructor__(byArray, byteBuffer);
        }

        public BufferedDigester(byte[] byArray, ByteBuffer byteBuffer) throws NoSuchAlgorithmException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$__constructor__(byte[] java.nio.ByteBuffer ), this, byArray, byteBuffer);
        }

        @Override
        public void consume(ByteBuffer byteBuffer) throws DigestException {
            InvokeDynamicSupport.bootstrap("consume", $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$consume(java.nio.ByteBuffer ), this, byteBuffer);
        }

        public void assertEmptyBuffer() throws DigestException {
            InvokeDynamicSupport.bootstrap("assertEmptyBuffer", $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$assertEmptyBuffer(), this);
        }

        private void fillUpLastOutputChunk() {
            InvokeDynamicSupport.bootstrap("fillUpLastOutputChunk", $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$fillUpLastOutputChunk(), this);
        }

        private /* synthetic */ void __constructor__(byte[] byArray, ByteBuffer byteBuffer, 1 var3_3) throws NoSuchAlgorithmException {
            this.$$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$__constructor__(byArray, byteBuffer, var3_3);
        }

        public /* synthetic */ BufferedDigester(byte[] byArray, ByteBuffer byteBuffer, 1 var3_3) throws NoSuchAlgorithmException {
            this(byArray, byteBuffer);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkVerityBuilder_BufferedDigester$__constructor__(byte[] java.nio.ByteBuffer android.util.apk.ApkVerityBuilder$1 ), this, byArray, byteBuffer, var3_3);
        }

        public /* synthetic */ BufferedDigester() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BufferedDigester)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ApkVerityResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ByteBuffer fsverityData;
        public byte[] rootHash;

        private void $$robo$$android_util_apk_ApkVerityBuilder_ApkVerityResult$__constructor__(ByteBuffer fsverityData, byte[] rootHash) {
            this.fsverityData = fsverityData;
            this.rootHash = rootHash;
        }

        private void __constructor__(ByteBuffer byteBuffer, byte[] byArray) {
            this.$$robo$$android_util_apk_ApkVerityBuilder_ApkVerityResult$__constructor__(byteBuffer, byArray);
        }

        public ApkVerityResult(ByteBuffer byteBuffer, byte[] byArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_apk_ApkVerityBuilder_ApkVerityResult$__constructor__(java.nio.ByteBuffer byte[] ), this, byteBuffer, byArray);
        }

        public /* synthetic */ ApkVerityResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApkVerityResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

