/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.util.jar.StrictJarManifest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StrictJarManifestReader
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private HashMap<String, Attributes.Name> attributeNameCache;
    private ByteArrayOutputStream valueBuffer;
    private byte[] buf;
    private int endOfMainSection;
    private int pos;
    private Attributes.Name name;
    private String value;
    private int consecutiveLineBreaks;

    private void $$robo$$android_util_jar_StrictJarManifestReader$__constructor__(byte[] buf, Attributes main) throws IOException {
        this.attributeNameCache = new HashMap();
        this.valueBuffer = new ByteArrayOutputStream(80);
        this.consecutiveLineBreaks = 0;
        this.buf = buf;
        while (this.readHeader()) {
            main.put(this.name, this.value);
        }
        this.endOfMainSection = this.pos;
    }

    private final void $$robo$$android_util_jar_StrictJarManifestReader$readEntries(Map<String, Attributes> entries, Map<String, StrictJarManifest.Chunk> chunks) throws IOException {
        int mark = this.pos;
        while (this.readHeader()) {
            if (!Attributes.Name.NAME.equals(this.name)) {
                throw new IOException("Entry is not named");
            }
            String entryNameValue = this.value;
            Attributes entry = entries.get(entryNameValue);
            if (entry == null) {
                entry = new Attributes(12);
            }
            while (this.readHeader()) {
                entry.put(this.name, this.value);
            }
            if (chunks != null) {
                if (chunks.get(entryNameValue) != null) {
                    throw new IOException("A jar verifier does not support more than one entry with the same name");
                }
                chunks.put(entryNameValue, new StrictJarManifest.Chunk(mark, this.pos));
                mark = this.pos;
            }
            entries.put(entryNameValue, entry);
        }
    }

    private final int $$robo$$android_util_jar_StrictJarManifestReader$getEndOfMainSection() {
        return this.endOfMainSection;
    }

    private final boolean $$robo$$android_util_jar_StrictJarManifestReader$readHeader() throws IOException {
        if (this.consecutiveLineBreaks > 1) {
            this.consecutiveLineBreaks = 0;
            return false;
        }
        this.readName();
        this.consecutiveLineBreaks = 0;
        this.readValue();
        return this.consecutiveLineBreaks > 0;
    }

    private final void $$robo$$android_util_jar_StrictJarManifestReader$readName() throws IOException {
        int mark = this.pos;
        while (this.pos < this.buf.length) {
            if (this.buf[this.pos++] != 58) continue;
            String nameString = new String(this.buf, mark, this.pos - mark - 1, StandardCharsets.US_ASCII);
            if (this.buf[this.pos++] != 32) {
                throw new IOException(String.format("Invalid value for attribute '%s'", nameString));
            }
            try {
                this.name = this.attributeNameCache.get(nameString);
                if (this.name == null) {
                    this.name = new Attributes.Name(nameString);
                    this.attributeNameCache.put(nameString, this.name);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            return;
        }
    }

    private final void $$robo$$android_util_jar_StrictJarManifestReader$readValue() throws IOException {
        boolean lastCr = false;
        int mark = this.pos;
        int last = this.pos;
        this.valueBuffer.reset();
        block6: while (this.pos < this.buf.length) {
            byte next = this.buf[this.pos++];
            switch (next) {
                case 0: {
                    throw new IOException("NUL character in a manifest");
                }
                case 10: {
                    if (lastCr) {
                        lastCr = false;
                        continue block6;
                    }
                    ++this.consecutiveLineBreaks;
                    continue block6;
                }
                case 13: {
                    lastCr = true;
                    ++this.consecutiveLineBreaks;
                    continue block6;
                }
                case 32: {
                    if (this.consecutiveLineBreaks != 1) break;
                    this.valueBuffer.write(this.buf, mark, last - mark);
                    mark = this.pos;
                    this.consecutiveLineBreaks = 0;
                    continue block6;
                }
            }
            if (this.consecutiveLineBreaks >= 1) {
                --this.pos;
                break;
            }
            last = this.pos;
        }
        this.valueBuffer.write(this.buf, mark, last - mark);
        this.value = this.valueBuffer.toString(StandardCharsets.UTF_8.name());
    }

    private void __constructor__(byte[] byArray, Attributes attributes) throws IOException {
        this.$$robo$$android_util_jar_StrictJarManifestReader$__constructor__(byArray, attributes);
    }

    public StrictJarManifestReader(byte[] byArray, Attributes attributes) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarManifestReader$__constructor__(byte[] java.util.jar.Attributes ), this, byArray, attributes);
    }

    public void readEntries(Map<String, Attributes> map, Map<String, StrictJarManifest.Chunk> map2) throws IOException {
        InvokeDynamicSupport.bootstrap("readEntries", $$robo$$android_util_jar_StrictJarManifestReader$readEntries(java.util.Map<java.lang.String, java.util.jar.Attributes> java.util.Map<java.lang.String, android.util.jar.StrictJarManifest$Chunk> ), this, map, map2);
    }

    public int getEndOfMainSection() {
        return (int)InvokeDynamicSupport.bootstrap("getEndOfMainSection", $$robo$$android_util_jar_StrictJarManifestReader$getEndOfMainSection(), this);
    }

    private boolean readHeader() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("readHeader", $$robo$$android_util_jar_StrictJarManifestReader$readHeader(), this);
    }

    private void readName() throws IOException {
        InvokeDynamicSupport.bootstrap("readName", $$robo$$android_util_jar_StrictJarManifestReader$readName(), this);
    }

    private void readValue() throws IOException {
        InvokeDynamicSupport.bootstrap("readValue", $$robo$$android_util_jar_StrictJarManifestReader$readValue(), this);
    }

    public /* synthetic */ StrictJarManifestReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictJarManifestReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

