/*
 * Decompiled with CFR 0.152.
 */
package android.util.proto;

import android.util.Log;
import android.util.proto.ProtoParseException;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class EncodedBuffer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "EncodedBuffer";
    private ArrayList<byte[]> mBuffers;
    private int mChunkSize;
    private int mBufferCount;
    private byte[] mWriteBuffer;
    private int mWriteIndex;
    private int mWriteBufIndex;
    private byte[] mReadBuffer;
    private int mReadBufIndex;
    private int mReadIndex;
    private int mReadLimit;
    private int mReadableSize;

    private void $$robo$$android_util_proto_EncodedBuffer$__constructor__() {
    }

    private void $$robo$$android_util_proto_EncodedBuffer$__constructor__(int chunkSize) {
        this.mBuffers = new ArrayList();
        this.mReadLimit = -1;
        this.mReadableSize = -1;
        if (chunkSize <= 0) {
            chunkSize = 8192;
        }
        this.mChunkSize = chunkSize;
        this.mWriteBuffer = new byte[this.mChunkSize];
        this.mBuffers.add(this.mWriteBuffer);
        this.mBufferCount = 1;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$startEditing() {
        this.mReadableSize = this.mWriteBufIndex * this.mChunkSize + this.mWriteIndex;
        this.mReadLimit = this.mWriteIndex;
        this.mWriteBuffer = this.mBuffers.get(0);
        this.mWriteIndex = 0;
        this.mWriteBufIndex = 0;
        this.mReadBuffer = this.mWriteBuffer;
        this.mReadBufIndex = 0;
        this.mReadIndex = 0;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$rewindRead() {
        this.mReadBuffer = this.mBuffers.get(0);
        this.mReadBufIndex = 0;
        this.mReadIndex = 0;
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getReadableSize() {
        return this.mReadableSize;
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getReadPos() {
        return this.mReadBufIndex * this.mChunkSize + this.mReadIndex;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$skipRead(int amount) {
        if (amount < 0) {
            throw new RuntimeException("skipRead with negative amount=" + amount);
        }
        if (amount == 0) {
            return;
        }
        if (amount <= this.mChunkSize - this.mReadIndex) {
            this.mReadIndex += amount;
        } else {
            this.mReadIndex = (amount -= this.mChunkSize - this.mReadIndex) % this.mChunkSize;
            if (this.mReadIndex == 0) {
                this.mReadIndex = this.mChunkSize;
                this.mReadBufIndex += amount / this.mChunkSize;
            } else {
                this.mReadBufIndex += 1 + amount / this.mChunkSize;
            }
            this.mReadBuffer = this.mBuffers.get(this.mReadBufIndex);
        }
    }

    private final byte $$robo$$android_util_proto_EncodedBuffer$readRawByte() {
        if (this.mReadBufIndex > this.mBufferCount || this.mReadBufIndex == this.mBufferCount - 1 && this.mReadIndex >= this.mReadLimit) {
            throw new IndexOutOfBoundsException("Trying to read too much data mReadBufIndex=" + this.mReadBufIndex + " mBufferCount=" + this.mBufferCount + " mReadIndex=" + this.mReadIndex + " mReadLimit=" + this.mReadLimit);
        }
        if (this.mReadIndex >= this.mChunkSize) {
            ++this.mReadBufIndex;
            this.mReadBuffer = this.mBuffers.get(this.mReadBufIndex);
            this.mReadIndex = 0;
        }
        return this.mReadBuffer[this.mReadIndex++];
    }

    private final long $$robo$$android_util_proto_EncodedBuffer$readRawUnsigned() {
        int bits = 0;
        long result = 0L;
        do {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << bits;
            if ((b & 0x80) != 0) continue;
            return result;
        } while ((bits += 7) <= 64);
        throw new ProtoParseException("Varint too long -- " + this.getDebugString());
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$readRawFixed32() {
        return this.readRawByte() & 0xFF | (this.readRawByte() & 0xFF) << 8 | (this.readRawByte() & 0xFF) << 16 | (this.readRawByte() & 0xFF) << 24;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$nextWriteBuffer() {
        ++this.mWriteBufIndex;
        if (this.mWriteBufIndex >= this.mBufferCount) {
            this.mWriteBuffer = new byte[this.mChunkSize];
            this.mBuffers.add(this.mWriteBuffer);
            ++this.mBufferCount;
        } else {
            this.mWriteBuffer = this.mBuffers.get(this.mWriteBufIndex);
        }
        this.mWriteIndex = 0;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawByte(byte val) {
        if (this.mWriteIndex >= this.mChunkSize) {
            this.nextWriteBuffer();
        }
        this.mWriteBuffer[this.mWriteIndex++] = val;
    }

    private static final int $$robo$$android_util_proto_EncodedBuffer$getRawVarint32Size(int val) {
        if ((val & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((val & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((val & 0xFFE00000) == 0) {
            return 3;
        }
        if ((val & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawVarint32(int val) {
        while (true) {
            if ((val & 0xFFFFFF80) == 0) {
                this.writeRawByte((byte)val);
                return;
            }
            this.writeRawByte((byte)(val & 0x7F | 0x80));
            val >>>= 7;
        }
    }

    private static final int $$robo$$android_util_proto_EncodedBuffer$getRawZigZag32Size(int val) {
        return EncodedBuffer.getRawVarint32Size(EncodedBuffer.zigZag32(val));
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawZigZag32(int val) {
        this.writeRawVarint32(EncodedBuffer.zigZag32(val));
    }

    private static final int $$robo$$android_util_proto_EncodedBuffer$getRawVarint64Size(long val) {
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((val & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((val & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((val & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((val & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((val & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((val & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((val & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((val & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawVarint64(long val) {
        while (true) {
            if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((byte)val);
                return;
            }
            this.writeRawByte((byte)(val & 0x7FL | 0x80L));
            val >>>= 7;
        }
    }

    private static final int $$robo$$android_util_proto_EncodedBuffer$getRawZigZag64Size(long val) {
        return EncodedBuffer.getRawVarint64Size(EncodedBuffer.zigZag64(val));
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawZigZag64(long val) {
        this.writeRawVarint64(EncodedBuffer.zigZag64(val));
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawFixed32(int val) {
        this.writeRawByte((byte)val);
        this.writeRawByte((byte)(val >> 8));
        this.writeRawByte((byte)(val >> 16));
        this.writeRawByte((byte)(val >> 24));
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawFixed64(long val) {
        this.writeRawByte((byte)val);
        this.writeRawByte((byte)(val >> 8));
        this.writeRawByte((byte)(val >> 16));
        this.writeRawByte((byte)(val >> 24));
        this.writeRawByte((byte)(val >> 32));
        this.writeRawByte((byte)(val >> 40));
        this.writeRawByte((byte)(val >> 48));
        this.writeRawByte((byte)(val >> 56));
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawBuffer(byte[] val) {
        if (val != null && val.length > 0) {
            this.writeRawBuffer(val, 0, val.length);
        }
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeRawBuffer(byte[] val, int offset, int length) {
        int amt;
        if (val == null) {
            return;
        }
        int n = amt = length < this.mChunkSize - this.mWriteIndex ? length : this.mChunkSize - this.mWriteIndex;
        if (amt > 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])val, (int)offset, (byte[])this.mWriteBuffer, (int)this.mWriteIndex, (int)amt);
            this.mWriteIndex += amt;
            length -= amt;
            offset += amt;
        }
        while (length > 0) {
            this.nextWriteBuffer();
            amt = length < this.mChunkSize ? length : this.mChunkSize;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])val, (int)offset, (byte[])this.mWriteBuffer, (int)this.mWriteIndex, (int)amt);
            this.mWriteIndex += amt;
            length -= amt;
            offset += amt;
        }
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$writeFromThisBuffer(int srcOffset, int size) {
        if (this.mReadLimit < 0) {
            throw new IllegalStateException("writeFromThisBuffer before startEditing");
        }
        if (srcOffset < this.getWritePos()) {
            throw new IllegalArgumentException("Can only move forward in the buffer -- srcOffset=" + srcOffset + " size=" + size + " " + this.getDebugString());
        }
        if (srcOffset + size > this.mReadableSize) {
            throw new IllegalArgumentException("Trying to move more data than there is -- srcOffset=" + srcOffset + " size=" + size + " " + this.getDebugString());
        }
        if (size == 0) {
            return;
        }
        if (srcOffset == this.mWriteBufIndex * this.mChunkSize + this.mWriteIndex) {
            if (size <= this.mChunkSize - this.mWriteIndex) {
                this.mWriteIndex += size;
            } else {
                this.mWriteIndex = (size -= this.mChunkSize - this.mWriteIndex) % this.mChunkSize;
                if (this.mWriteIndex == 0) {
                    this.mWriteIndex = this.mChunkSize;
                    this.mWriteBufIndex += size / this.mChunkSize;
                } else {
                    this.mWriteBufIndex += 1 + size / this.mChunkSize;
                }
                this.mWriteBuffer = this.mBuffers.get(this.mWriteBufIndex);
            }
        } else {
            int readBufIndex = srcOffset / this.mChunkSize;
            byte[] readBuffer = this.mBuffers.get(readBufIndex);
            int readIndex = srcOffset % this.mChunkSize;
            while (size > 0) {
                if (this.mWriteIndex >= this.mChunkSize) {
                    this.nextWriteBuffer();
                }
                if (readIndex >= this.mChunkSize) {
                    readBuffer = this.mBuffers.get(++readBufIndex);
                    readIndex = 0;
                }
                int spaceInWriteBuffer = this.mChunkSize - this.mWriteIndex;
                int availableInReadBuffer = this.mChunkSize - readIndex;
                int amt = Math.min(size, Math.min(spaceInWriteBuffer, availableInReadBuffer));
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])readBuffer, (int)readIndex, (byte[])this.mWriteBuffer, (int)this.mWriteIndex, (int)amt);
                this.mWriteIndex += amt;
                readIndex += amt;
                size -= amt;
            }
        }
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getWritePos() {
        return this.mWriteBufIndex * this.mChunkSize + this.mWriteIndex;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$rewindWriteTo(int writePos) {
        if (writePos > this.getWritePos()) {
            throw new RuntimeException("rewindWriteTo only can go backwards" + writePos);
        }
        this.mWriteBufIndex = writePos / this.mChunkSize;
        this.mWriteIndex = writePos % this.mChunkSize;
        if (this.mWriteIndex == 0 && this.mWriteBufIndex != 0) {
            this.mWriteIndex = this.mChunkSize;
            --this.mWriteBufIndex;
        }
        this.mWriteBuffer = this.mBuffers.get(this.mWriteBufIndex);
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getRawFixed32At(int pos) {
        return 0xFF & this.mBuffers.get(pos / this.mChunkSize)[pos % this.mChunkSize] | (0xFF & this.mBuffers.get((pos + 1) / this.mChunkSize)[(pos + 1) % this.mChunkSize]) << 8 | (0xFF & this.mBuffers.get((pos + 2) / this.mChunkSize)[(pos + 2) % this.mChunkSize]) << 16 | (0xFF & this.mBuffers.get((pos + 3) / this.mChunkSize)[(pos + 3) % this.mChunkSize]) << 24;
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$editRawFixed32(int pos, int val) {
        this.mBuffers.get((int)(pos / this.mChunkSize))[pos % this.mChunkSize] = (byte)val;
        this.mBuffers.get((int)((pos + 1) / this.mChunkSize))[(pos + 1) % this.mChunkSize] = (byte)(val >> 8);
        this.mBuffers.get((int)((pos + 2) / this.mChunkSize))[(pos + 2) % this.mChunkSize] = (byte)(val >> 16);
        this.mBuffers.get((int)((pos + 3) / this.mChunkSize))[(pos + 3) % this.mChunkSize] = (byte)(val >> 24);
    }

    private static final int $$robo$$android_util_proto_EncodedBuffer$zigZag32(int val) {
        return val << 1 ^ val >> 31;
    }

    private static final long $$robo$$android_util_proto_EncodedBuffer$zigZag64(long val) {
        return val << 1 ^ val >> 63;
    }

    private final byte[] $$robo$$android_util_proto_EncodedBuffer$getBytes(int size) {
        int bufIndex;
        byte[] result = new byte[size];
        int bufCount = size / this.mChunkSize;
        int writeIndex = 0;
        for (bufIndex = 0; bufIndex < bufCount; ++bufIndex) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mBuffers.get(bufIndex), (int)0, (byte[])result, (int)writeIndex, (int)this.mChunkSize);
            writeIndex += this.mChunkSize;
        }
        int lastSize = size - bufCount * this.mChunkSize;
        if (lastSize > 0) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])this.mBuffers.get(bufIndex), (int)0, (byte[])result, (int)writeIndex, (int)lastSize);
        }
        return result;
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getChunkCount() {
        return this.mBuffers.size();
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getWriteIndex() {
        return this.mWriteIndex;
    }

    private final int $$robo$$android_util_proto_EncodedBuffer$getWriteBufIndex() {
        return this.mWriteBufIndex;
    }

    private final String $$robo$$android_util_proto_EncodedBuffer$getDebugString() {
        return "EncodedBuffer( mChunkSize=" + this.mChunkSize + " mBuffers.size=" + this.mBuffers.size() + " mBufferCount=" + this.mBufferCount + " mWriteIndex=" + this.mWriteIndex + " mWriteBufIndex=" + this.mWriteBufIndex + " mReadBufIndex=" + this.mReadBufIndex + " mReadIndex=" + this.mReadIndex + " mReadableSize=" + this.mReadableSize + " mReadLimit=" + this.mReadLimit + " )";
    }

    private final void $$robo$$android_util_proto_EncodedBuffer$dumpBuffers(String tag) {
        int N = this.mBuffers.size();
        int start = 0;
        for (int i = 0; i < N; ++i) {
            start += EncodedBuffer.dumpByteString(tag, "{" + i + "} ", start, this.mBuffers.get(i));
        }
    }

    private static final void $$robo$$android_util_proto_EncodedBuffer$dumpByteString(String tag, String prefix, byte[] buf) {
        EncodedBuffer.dumpByteString(tag, prefix, 0, buf);
    }

    private static final int $$robo$$android_util_proto_EncodedBuffer$dumpByteString(String tag, String prefix, int start, byte[] buf) {
        StringBuffer sb = new StringBuffer();
        int length = buf.length;
        int lineLen = 16;
        for (int i = 0; i < length; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    Log.d(tag, sb.toString());
                    sb = new StringBuffer();
                }
                sb.append(prefix);
                sb.append('[');
                sb.append(start + i);
                sb.append(']');
                sb.append(' ');
            } else {
                sb.append(' ');
            }
            byte b = buf[i];
            byte c = (byte)(b >> 4 & 0xF);
            if (c < 10) {
                sb.append((char)(48 + c));
            } else {
                sb.append((char)(87 + c));
            }
            byte d = (byte)(b & 0xF);
            if (d < 10) {
                sb.append((char)(48 + d));
                continue;
            }
            sb.append((char)(87 + d));
        }
        Log.d(tag, sb.toString());
        return length;
    }

    private void __constructor__() {
        this.$$robo$$android_util_proto_EncodedBuffer$__constructor__();
    }

    public EncodedBuffer() {
        this(0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_proto_EncodedBuffer$__constructor__(), this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_proto_EncodedBuffer$__constructor__(n);
    }

    public EncodedBuffer(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_proto_EncodedBuffer$__constructor__(int ), this, n);
    }

    public void startEditing() {
        InvokeDynamicSupport.bootstrap("startEditing", $$robo$$android_util_proto_EncodedBuffer$startEditing(), this);
    }

    public void rewindRead() {
        InvokeDynamicSupport.bootstrap("rewindRead", $$robo$$android_util_proto_EncodedBuffer$rewindRead(), this);
    }

    public int getReadableSize() {
        return (int)InvokeDynamicSupport.bootstrap("getReadableSize", $$robo$$android_util_proto_EncodedBuffer$getReadableSize(), this);
    }

    public int getReadPos() {
        return (int)InvokeDynamicSupport.bootstrap("getReadPos", $$robo$$android_util_proto_EncodedBuffer$getReadPos(), this);
    }

    public void skipRead(int n) {
        InvokeDynamicSupport.bootstrap("skipRead", $$robo$$android_util_proto_EncodedBuffer$skipRead(int ), this, n);
    }

    public byte readRawByte() {
        return (byte)InvokeDynamicSupport.bootstrap("readRawByte", $$robo$$android_util_proto_EncodedBuffer$readRawByte(), this);
    }

    public long readRawUnsigned() {
        return (long)InvokeDynamicSupport.bootstrap("readRawUnsigned", $$robo$$android_util_proto_EncodedBuffer$readRawUnsigned(), this);
    }

    public int readRawFixed32() {
        return (int)InvokeDynamicSupport.bootstrap("readRawFixed32", $$robo$$android_util_proto_EncodedBuffer$readRawFixed32(), this);
    }

    private void nextWriteBuffer() {
        InvokeDynamicSupport.bootstrap("nextWriteBuffer", $$robo$$android_util_proto_EncodedBuffer$nextWriteBuffer(), this);
    }

    public void writeRawByte(byte by) {
        InvokeDynamicSupport.bootstrap("writeRawByte", $$robo$$android_util_proto_EncodedBuffer$writeRawByte(byte ), this, by);
    }

    public static int getRawVarint32Size(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRawVarint32Size", $$robo$$android_util_proto_EncodedBuffer$getRawVarint32Size(int ), (int)n);
    }

    public void writeRawVarint32(int n) {
        InvokeDynamicSupport.bootstrap("writeRawVarint32", $$robo$$android_util_proto_EncodedBuffer$writeRawVarint32(int ), this, n);
    }

    public static int getRawZigZag32Size(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRawZigZag32Size", $$robo$$android_util_proto_EncodedBuffer$getRawZigZag32Size(int ), (int)n);
    }

    public void writeRawZigZag32(int n) {
        InvokeDynamicSupport.bootstrap("writeRawZigZag32", $$robo$$android_util_proto_EncodedBuffer$writeRawZigZag32(int ), this, n);
    }

    public static int getRawVarint64Size(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRawVarint64Size", $$robo$$android_util_proto_EncodedBuffer$getRawVarint64Size(long ), (long)l);
    }

    public void writeRawVarint64(long l) {
        InvokeDynamicSupport.bootstrap("writeRawVarint64", $$robo$$android_util_proto_EncodedBuffer$writeRawVarint64(long ), this, l);
    }

    public static int getRawZigZag64Size(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getRawZigZag64Size", $$robo$$android_util_proto_EncodedBuffer$getRawZigZag64Size(long ), (long)l);
    }

    public void writeRawZigZag64(long l) {
        InvokeDynamicSupport.bootstrap("writeRawZigZag64", $$robo$$android_util_proto_EncodedBuffer$writeRawZigZag64(long ), this, l);
    }

    public void writeRawFixed32(int n) {
        InvokeDynamicSupport.bootstrap("writeRawFixed32", $$robo$$android_util_proto_EncodedBuffer$writeRawFixed32(int ), this, n);
    }

    public void writeRawFixed64(long l) {
        InvokeDynamicSupport.bootstrap("writeRawFixed64", $$robo$$android_util_proto_EncodedBuffer$writeRawFixed64(long ), this, l);
    }

    public void writeRawBuffer(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("writeRawBuffer", $$robo$$android_util_proto_EncodedBuffer$writeRawBuffer(byte[] ), this, byArray);
    }

    public void writeRawBuffer(byte[] byArray, int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeRawBuffer", $$robo$$android_util_proto_EncodedBuffer$writeRawBuffer(byte[] int int ), this, byArray, n, n2);
    }

    public void writeFromThisBuffer(int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeFromThisBuffer", $$robo$$android_util_proto_EncodedBuffer$writeFromThisBuffer(int int ), this, n, n2);
    }

    public int getWritePos() {
        return (int)InvokeDynamicSupport.bootstrap("getWritePos", $$robo$$android_util_proto_EncodedBuffer$getWritePos(), this);
    }

    public void rewindWriteTo(int n) {
        InvokeDynamicSupport.bootstrap("rewindWriteTo", $$robo$$android_util_proto_EncodedBuffer$rewindWriteTo(int ), this, n);
    }

    public int getRawFixed32At(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRawFixed32At", $$robo$$android_util_proto_EncodedBuffer$getRawFixed32At(int ), this, n);
    }

    public void editRawFixed32(int n, int n2) {
        InvokeDynamicSupport.bootstrap("editRawFixed32", $$robo$$android_util_proto_EncodedBuffer$editRawFixed32(int int ), this, n, n2);
    }

    private static int zigZag32(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("zigZag32", $$robo$$android_util_proto_EncodedBuffer$zigZag32(int ), (int)n);
    }

    private static long zigZag64(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("zigZag64", $$robo$$android_util_proto_EncodedBuffer$zigZag64(long ), (long)l);
    }

    public byte[] getBytes(int n) {
        return InvokeDynamicSupport.bootstrap("getBytes", $$robo$$android_util_proto_EncodedBuffer$getBytes(int ), this, n);
    }

    public int getChunkCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChunkCount", $$robo$$android_util_proto_EncodedBuffer$getChunkCount(), this);
    }

    public int getWriteIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getWriteIndex", $$robo$$android_util_proto_EncodedBuffer$getWriteIndex(), this);
    }

    public int getWriteBufIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getWriteBufIndex", $$robo$$android_util_proto_EncodedBuffer$getWriteBufIndex(), this);
    }

    public String getDebugString() {
        return InvokeDynamicSupport.bootstrap("getDebugString", $$robo$$android_util_proto_EncodedBuffer$getDebugString(), this);
    }

    public void dumpBuffers(String string2) {
        InvokeDynamicSupport.bootstrap("dumpBuffers", $$robo$$android_util_proto_EncodedBuffer$dumpBuffers(java.lang.String ), this, string2);
    }

    public static void dumpByteString(String string2, String string3, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("dumpByteString", $$robo$$android_util_proto_EncodedBuffer$dumpByteString(java.lang.String java.lang.String byte[] ), (String)string2, (String)string3, (byte[])byArray);
    }

    private static int dumpByteString(String string2, String string3, int n, byte[] byArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("dumpByteString", $$robo$$android_util_proto_EncodedBuffer$dumpByteString(java.lang.String java.lang.String int byte[] ), (String)string2, (String)string3, (int)n, (byte[])byArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EncodedBuffer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

