/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.InputChannel;
import android.view.InputEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class InputEventReceiver
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "InputEventReceiver";
    private CloseGuard mCloseGuard;
    private long mReceiverPtr;
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;
    private SparseIntArray mSeqMap;

    private static final long $$robo$$android_view_InputEventReceiver$nativeInit(WeakReference<InputEventReceiver> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return 0L;
    }

    private static final void $$robo$$android_view_InputEventReceiver$nativeDispose(long l) {
    }

    private static final void $$robo$$android_view_InputEventReceiver$nativeFinishInputEvent(long l, int n, boolean bl) {
    }

    private static final boolean $$robo$$android_view_InputEventReceiver$nativeConsumeBatchedInputEvents(long l, long l2) {
        return false;
    }

    private void $$robo$$android_view_InputEventReceiver$__constructor__(InputChannel inputChannel, Looper looper) {
        this.mCloseGuard = CloseGuard.get();
        this.mSeqMap = new SparseIntArray();
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mReceiverPtr = InputEventReceiver.nativeInit(new WeakReference<InputEventReceiver>(this), inputChannel, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    private final void $$robo$$android_view_InputEventReceiver$finalize() throws Throwable {
        try {
            this.dispose(true);
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_view_InputEventReceiver$dispose() {
        this.dispose(false);
    }

    private final void $$robo$$android_view_InputEventReceiver$dispose(boolean finalized) {
        if (this.mCloseGuard != null) {
            if (finalized) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mReceiverPtr != 0L) {
            InputEventReceiver.nativeDispose(this.mReceiverPtr);
            this.mReceiverPtr = 0L;
        }
        this.mInputChannel = null;
        this.mMessageQueue = null;
    }

    private final void $$robo$$android_view_InputEventReceiver$onInputEvent(InputEvent event, int displayId) {
        this.finishInputEvent(event, false);
    }

    private final void $$robo$$android_view_InputEventReceiver$onBatchedInputEventPending() {
        this.consumeBatchedInputEvents(-1L);
    }

    private final void $$robo$$android_view_InputEventReceiver$finishInputEvent(InputEvent event, boolean handled) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mReceiverPtr == 0L) {
            Log.w("InputEventReceiver", "Attempted to finish an input event but the input event receiver has already been disposed.");
        } else {
            int index = this.mSeqMap.indexOfKey(event.getSequenceNumber());
            if (index < 0) {
                Log.w("InputEventReceiver", "Attempted to finish an input event that is not in progress.");
            } else {
                int seq = this.mSeqMap.valueAt(index);
                this.mSeqMap.removeAt(index);
                InputEventReceiver.nativeFinishInputEvent(this.mReceiverPtr, seq, handled);
            }
        }
        event.recycleIfNeededAfterDispatch();
    }

    private final boolean $$robo$$android_view_InputEventReceiver$consumeBatchedInputEvents(long frameTimeNanos) {
        if (this.mReceiverPtr != 0L) {
            return InputEventReceiver.nativeConsumeBatchedInputEvents(this.mReceiverPtr, frameTimeNanos);
        }
        Log.w("InputEventReceiver", "Attempted to consume batched input events but the input event receiver has already been disposed.");
        return false;
    }

    private final void $$robo$$android_view_InputEventReceiver$dispatchInputEvent(int seq, InputEvent event, int displayId) {
        this.mSeqMap.put(event.getSequenceNumber(), seq);
        this.onInputEvent(event, displayId);
    }

    private final void $$robo$$android_view_InputEventReceiver$dispatchBatchedInputEventPending() {
        this.onBatchedInputEventPending();
    }

    private static long nativeInit(WeakReference<InputEventReceiver> weakReference, InputChannel inputChannel, MessageQueue messageQueue) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeInit", $$robo$$android_view_InputEventReceiver$nativeInit(java.lang.ref.WeakReference<android.view.InputEventReceiver> android.view.InputChannel android.os.MessageQueue ), weakReference, (InputChannel)inputChannel, (MessageQueue)messageQueue);
    }

    private static void nativeDispose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDispose", $$robo$$android_view_InputEventReceiver$nativeDispose(long ), (long)l);
    }

    private static void nativeFinishInputEvent(long l, int n, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nativeFinishInputEvent", $$robo$$android_view_InputEventReceiver$nativeFinishInputEvent(long int boolean ), (long)l, (int)n, (boolean)bl);
    }

    private static boolean nativeConsumeBatchedInputEvents(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeConsumeBatchedInputEvents", $$robo$$android_view_InputEventReceiver$nativeConsumeBatchedInputEvents(long long ), (long)l, (long)l2);
    }

    private void __constructor__(InputChannel inputChannel, Looper looper) {
        this.$$robo$$android_view_InputEventReceiver$__constructor__(inputChannel, looper);
    }

    public InputEventReceiver(InputChannel inputChannel, Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_InputEventReceiver$__constructor__(android.view.InputChannel android.os.Looper ), this, inputChannel, looper);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_InputEventReceiver$finalize(), this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_InputEventReceiver$dispose(), this);
    }

    private void dispose(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_view_InputEventReceiver$dispose(boolean ), this, bl);
    }

    public void onInputEvent(InputEvent inputEvent, int n) {
        InvokeDynamicSupport.bootstrap("onInputEvent", $$robo$$android_view_InputEventReceiver$onInputEvent(android.view.InputEvent int ), this, inputEvent, n);
    }

    public void onBatchedInputEventPending() {
        InvokeDynamicSupport.bootstrap("onBatchedInputEventPending", $$robo$$android_view_InputEventReceiver$onBatchedInputEventPending(), this);
    }

    public void finishInputEvent(InputEvent inputEvent, boolean bl) {
        InvokeDynamicSupport.bootstrap("finishInputEvent", $$robo$$android_view_InputEventReceiver$finishInputEvent(android.view.InputEvent boolean ), this, inputEvent, bl);
    }

    public boolean consumeBatchedInputEvents(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("consumeBatchedInputEvents", $$robo$$android_view_InputEventReceiver$consumeBatchedInputEvents(long ), this, l);
    }

    private void dispatchInputEvent(int n, InputEvent inputEvent, int n2) {
        InvokeDynamicSupport.bootstrap("dispatchInputEvent", $$robo$$android_view_InputEventReceiver$dispatchInputEvent(int android.view.InputEvent int ), this, n, inputEvent, n2);
    }

    private void dispatchBatchedInputEventPending() {
        InvokeDynamicSupport.bootstrap("dispatchBatchedInputEventPending", $$robo$$android_view_InputEventReceiver$dispatchBatchedInputEventPending(), this);
    }

    public /* synthetic */ InputEventReceiver() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputEventReceiver)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Factory {
        public InputEventReceiver createInputEventReceiver(InputChannel var1, Looper var2);
    }
}

