/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PointerIcon
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "PointerIcon";
    public static int TYPE_CUSTOM = -1;
    public static int TYPE_NULL = 0;
    public static int TYPE_NOT_SPECIFIED = 1;
    public static int TYPE_ARROW = 1000;
    public static int TYPE_SPOT_HOVER = 2000;
    public static int TYPE_SPOT_TOUCH = 2001;
    public static int TYPE_SPOT_ANCHOR = 2002;
    public static int TYPE_CONTEXT_MENU = 1001;
    public static int TYPE_HAND = 1002;
    public static int TYPE_HELP = 1003;
    public static int TYPE_WAIT = 1004;
    public static int TYPE_CELL = 1006;
    public static int TYPE_CROSSHAIR = 1007;
    public static int TYPE_TEXT = 1008;
    public static int TYPE_VERTICAL_TEXT = 1009;
    public static int TYPE_ALIAS = 1010;
    public static int TYPE_COPY = 1011;
    public static int TYPE_NO_DROP = 1012;
    public static int TYPE_ALL_SCROLL = 1013;
    public static int TYPE_HORIZONTAL_DOUBLE_ARROW = 1014;
    public static int TYPE_VERTICAL_DOUBLE_ARROW = 1015;
    public static int TYPE_TOP_RIGHT_DIAGONAL_DOUBLE_ARROW = 1016;
    public static int TYPE_TOP_LEFT_DIAGONAL_DOUBLE_ARROW = 1017;
    public static int TYPE_ZOOM_IN = 1018;
    public static int TYPE_ZOOM_OUT = 1019;
    public static int TYPE_GRAB = 1020;
    public static int TYPE_GRABBING = 1021;
    private static int TYPE_OEM_FIRST = 10000;
    public static int TYPE_DEFAULT = 1000;
    private static PointerIcon gNullIcon;
    private static SparseArray<PointerIcon> gSystemIcons;
    private static boolean sUseLargeIcons;
    private int mType;
    private int mSystemIconResourceId;
    private Bitmap mBitmap;
    private float mHotSpotX;
    private float mHotSpotY;
    private Bitmap[] mBitmapFrames;
    private int mDurationPerFrame;
    public static Parcelable.Creator<PointerIcon> CREATOR;

    private void $$robo$$android_view_PointerIcon$__constructor__(int type) {
        this.mType = type;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$getNullIcon() {
        return gNullIcon;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$getDefaultIcon(Context context) {
        return PointerIcon.getSystemIcon(context, 1000);
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$getSystemIcon(Context context, int type) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (type == 0) {
            return gNullIcon;
        }
        PointerIcon icon = gSystemIcons.get(type);
        if (icon != null) {
            return icon;
        }
        int typeIndex = PointerIcon.getSystemIconTypeIndex(type);
        if (typeIndex == 0) {
            typeIndex = PointerIcon.getSystemIconTypeIndex(1000);
        }
        int defStyle = sUseLargeIcons ? 16974619 : 16974626;
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Pointer, 0, defStyle);
        int resourceId = a.getResourceId(typeIndex, -1);
        a.recycle();
        if (resourceId == -1) {
            Log.w("PointerIcon", "Missing theme resources for pointer icon type " + type);
            return type == 1000 ? gNullIcon : PointerIcon.getSystemIcon(context, 1000);
        }
        icon = new PointerIcon(type);
        if ((resourceId & 0xFF000000) == 0x1000000) {
            icon.mSystemIconResourceId = resourceId;
        } else {
            icon.loadResource(context, context.getResources(), resourceId);
        }
        gSystemIcons.append(type, icon);
        return icon;
    }

    private static final void $$robo$$android_view_PointerIcon$setUseLargeIcons(boolean use) {
        sUseLargeIcons = use;
        gSystemIcons.clear();
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$create(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY);
        PointerIcon icon = new PointerIcon(-1);
        icon.mBitmap = bitmap;
        icon.mHotSpotX = hotSpotX;
        icon.mHotSpotY = hotSpotY;
        return icon;
    }

    private static final PointerIcon $$robo$$android_view_PointerIcon$load(Resources resources, int resourceId) {
        if (resources == null) {
            throw new IllegalArgumentException("resources must not be null");
        }
        PointerIcon icon = new PointerIcon(-1);
        icon.loadResource(null, resources, resourceId);
        return icon;
    }

    private final PointerIcon $$robo$$android_view_PointerIcon$load(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        if (this.mSystemIconResourceId == 0 || this.mBitmap != null) {
            return this;
        }
        PointerIcon result = new PointerIcon(this.mType);
        result.mSystemIconResourceId = this.mSystemIconResourceId;
        result.loadResource(context, context.getResources(), this.mSystemIconResourceId);
        return result;
    }

    private final int $$robo$$android_view_PointerIcon$getType() {
        return this.mType;
    }

    private final int $$robo$$android_view_PointerIcon$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_PointerIcon$writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mType);
        if (this.mType != 0) {
            out.writeInt(this.mSystemIconResourceId);
            if (this.mSystemIconResourceId == 0) {
                this.mBitmap.writeToParcel(out, flags);
                out.writeFloat(this.mHotSpotX);
                out.writeFloat(this.mHotSpotY);
            }
        }
    }

    private final boolean $$robo$$android_view_PointerIcon$equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof PointerIcon)) {
            return false;
        }
        PointerIcon otherIcon = (PointerIcon)other;
        if (this.mType != otherIcon.mType || this.mSystemIconResourceId != otherIcon.mSystemIconResourceId) {
            return false;
        }
        return this.mSystemIconResourceId != 0 || this.mBitmap == otherIcon.mBitmap && this.mHotSpotX == otherIcon.mHotSpotX && this.mHotSpotY == otherIcon.mHotSpotY;
    }

    private final Bitmap $$robo$$android_view_PointerIcon$getBitmapFromDrawable(BitmapDrawable bitmapDrawable) {
        Bitmap bitmap = bitmapDrawable.getBitmap();
        int scaledWidth = bitmapDrawable.getIntrinsicWidth();
        int scaledHeight = bitmapDrawable.getIntrinsicHeight();
        if (scaledWidth == bitmap.getWidth() && scaledHeight == bitmap.getHeight()) {
            return bitmap;
        }
        Rect src = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF dst = new RectF(0.0f, 0.0f, scaledWidth, scaledHeight);
        Bitmap scaled = Bitmap.createBitmap(scaledWidth, scaledHeight, bitmap.getConfig());
        Canvas canvas = new Canvas(scaled);
        Paint paint = new Paint();
        paint.setFilterBitmap(true);
        canvas.drawBitmap(bitmap, src, dst, paint);
        return scaled;
    }

    private final void $$robo$$android_view_PointerIcon$loadResource(Context context, Resources resources, int resourceId) {
        float hotSpotY;
        float hotSpotX;
        int bitmapRes;
        try (XmlResourceParser parser = resources.getXml(resourceId);){
            XmlUtils.beginDocument(parser, "pointer-icon");
            TypedArray a = resources.obtainAttributes(parser, R.styleable.PointerIcon);
            bitmapRes = a.getResourceId(0, 0);
            hotSpotX = a.getDimension(1, 0.0f);
            hotSpotY = a.getDimension(2, 0.0f);
            a.recycle();
        }
        if (bitmapRes == 0) {
            throw new IllegalArgumentException("<pointer-icon> is missing bitmap attribute.");
        }
        Drawable drawable2 = context == null ? resources.getDrawable(bitmapRes) : context.getDrawable(bitmapRes);
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable animationDrawable = (AnimationDrawable)drawable2;
            int frames = animationDrawable.getNumberOfFrames();
            drawable2 = animationDrawable.getFrame(0);
            if (frames == 1) {
                Log.w("PointerIcon", "Animation icon with single frame -- simply treating the first frame as a normal bitmap icon.");
            } else {
                this.mDurationPerFrame = animationDrawable.getDuration(0);
                this.mBitmapFrames = new Bitmap[frames - 1];
                int width = drawable2.getIntrinsicWidth();
                int height = drawable2.getIntrinsicHeight();
                for (int i = 1; i < frames; ++i) {
                    Drawable drawableFrame = animationDrawable.getFrame(i);
                    if (!(drawableFrame instanceof BitmapDrawable)) {
                        throw new IllegalArgumentException("Frame of an animated pointer icon must refer to a bitmap drawable.");
                    }
                    if (drawableFrame.getIntrinsicWidth() != width || drawableFrame.getIntrinsicHeight() != height) {
                        throw new IllegalArgumentException("The bitmap size of " + i + "-th frame is different. All frames should have the exact same size and share the same hotspot.");
                    }
                    BitmapDrawable bitmapDrawableFrame = (BitmapDrawable)drawableFrame;
                    this.mBitmapFrames[i - 1] = this.getBitmapFromDrawable(bitmapDrawableFrame);
                }
            }
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("<pointer-icon> bitmap attribute must refer to a bitmap drawable.");
        }
        BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
        Bitmap bitmap = this.getBitmapFromDrawable(bitmapDrawable);
        PointerIcon.validateHotSpot(bitmap, hotSpotX, hotSpotY);
        this.mBitmap = bitmap;
        this.mHotSpotX = hotSpotX;
        this.mHotSpotY = hotSpotY;
    }

    private static final void $$robo$$android_view_PointerIcon$validateHotSpot(Bitmap bitmap, float hotSpotX, float hotSpotY) {
        if (hotSpotX < 0.0f || hotSpotX >= (float)bitmap.getWidth()) {
            throw new IllegalArgumentException("x hotspot lies outside of the bitmap area");
        }
        if (hotSpotY < 0.0f || hotSpotY >= (float)bitmap.getHeight()) {
            throw new IllegalArgumentException("y hotspot lies outside of the bitmap area");
        }
    }

    private static final int $$robo$$android_view_PointerIcon$getSystemIconTypeIndex(int type) {
        switch (type) {
            case 1000: {
                return 2;
            }
            case 2000: {
                return 14;
            }
            case 2001: {
                return 15;
            }
            case 2002: {
                return 13;
            }
            case 1002: {
                return 9;
            }
            case 1001: {
                return 4;
            }
            case 1003: {
                return 10;
            }
            case 1004: {
                return 21;
            }
            case 1006: {
                return 3;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 16;
            }
            case 1009: {
                return 20;
            }
            case 1010: {
                return 0;
            }
            case 1011: {
                return 5;
            }
            case 1013: {
                return 1;
            }
            case 1012: {
                return 12;
            }
            case 1014: {
                return 11;
            }
            case 1015: {
                return 19;
            }
            case 1016: {
                return 18;
            }
            case 1017: {
                return 17;
            }
            case 1018: {
                return 22;
            }
            case 1019: {
                return 23;
            }
            case 1020: {
                return 7;
            }
            case 1021: {
                return 8;
            }
        }
        return 0;
    }

    private /* synthetic */ void $$robo$$android_view_PointerIcon$__constructor__(int x0, 1 x1) {
    }

    static void __staticInitializer__() {
        gNullIcon = new PointerIcon(0);
        gSystemIcons = new SparseArray();
        sUseLargeIcons = false;
        CREATOR = new Parcelable.Creator<PointerIcon>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_PointerIcon_1$__constructor__() {
            }

            private final PointerIcon $$robo$$android_view_PointerIcon_1$createFromParcel(Parcel in) {
                int type = in.readInt();
                if (type == 0) {
                    return PointerIcon.getNullIcon();
                }
                int systemIconResourceId = in.readInt();
                if (systemIconResourceId != 0) {
                    PointerIcon icon = new PointerIcon(type, null);
                    icon.mSystemIconResourceId = systemIconResourceId;
                    return icon;
                }
                Bitmap bitmap = Bitmap.CREATOR.createFromParcel(in);
                float hotSpotX = in.readFloat();
                float hotSpotY = in.readFloat();
                return PointerIcon.create(bitmap, hotSpotX, hotSpotY);
            }

            private final PointerIcon[] $$robo$$android_view_PointerIcon_1$newArray(int size) {
                return new PointerIcon[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_PointerIcon_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_PointerIcon_1$__constructor__(), this);
            }

            @Override
            public PointerIcon createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_PointerIcon_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public PointerIcon[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_PointerIcon_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n) {
        this.$$robo$$android_view_PointerIcon$__constructor__(n);
    }

    public PointerIcon(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_PointerIcon$__constructor__(int ), this, n);
    }

    public static PointerIcon getNullIcon() {
        return InvokeDynamicSupport.bootstrapStatic("getNullIcon", $$robo$$android_view_PointerIcon$getNullIcon());
    }

    public static PointerIcon getDefaultIcon(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultIcon", $$robo$$android_view_PointerIcon$getDefaultIcon(android.content.Context ), (Context)context);
    }

    public static PointerIcon getSystemIcon(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSystemIcon", $$robo$$android_view_PointerIcon$getSystemIcon(android.content.Context int ), (Context)context, (int)n);
    }

    public static void setUseLargeIcons(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setUseLargeIcons", $$robo$$android_view_PointerIcon$setUseLargeIcons(boolean ), (boolean)bl);
    }

    public static PointerIcon create(Bitmap bitmap, float f, float f2) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_PointerIcon$create(android.graphics.Bitmap float float ), (Bitmap)bitmap, (float)f, (float)f2);
    }

    public static PointerIcon load(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("load", $$robo$$android_view_PointerIcon$load(android.content.res.Resources int ), (Resources)resources, (int)n);
    }

    public PointerIcon load(Context context) {
        return InvokeDynamicSupport.bootstrap("load", $$robo$$android_view_PointerIcon$load(android.content.Context ), this, context);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_view_PointerIcon$getType(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_PointerIcon$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_PointerIcon$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_PointerIcon$equals(java.lang.Object ), this, object);
    }

    private Bitmap getBitmapFromDrawable(BitmapDrawable bitmapDrawable) {
        return InvokeDynamicSupport.bootstrap("getBitmapFromDrawable", $$robo$$android_view_PointerIcon$getBitmapFromDrawable(android.graphics.drawable.BitmapDrawable ), this, bitmapDrawable);
    }

    private void loadResource(Context context, Resources resources, int n) {
        InvokeDynamicSupport.bootstrap("loadResource", $$robo$$android_view_PointerIcon$loadResource(android.content.Context android.content.res.Resources int ), this, context, resources, n);
    }

    private static void validateHotSpot(Bitmap bitmap, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("validateHotSpot", $$robo$$android_view_PointerIcon$validateHotSpot(android.graphics.Bitmap float float ), (Bitmap)bitmap, (float)f, (float)f2);
    }

    private static int getSystemIconTypeIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSystemIconTypeIndex", $$robo$$android_view_PointerIcon$getSystemIconTypeIndex(int ), (int)n);
    }

    private /* synthetic */ void __constructor__(int n, 1 var2_2) {
        this.$$robo$$android_view_PointerIcon$__constructor__(n, var2_2);
    }

    public /* synthetic */ PointerIcon(int n, 1 var2_2) {
        this(n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_PointerIcon$__constructor__(int android.view.PointerIcon$1 ), this, n, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PointerIcon.class);
    }

    public /* synthetic */ PointerIcon() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointerIcon)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

