/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.view.IWindow;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityRequestPreparer;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.IntPair;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String LOG_TAG = "AccessibilityManager";
    public static int STATE_FLAG_ACCESSIBILITY_ENABLED = 1;
    public static int STATE_FLAG_TOUCH_EXPLORATION_ENABLED = 2;
    public static int STATE_FLAG_HIGH_TEXT_CONTRAST_ENABLED = 4;
    public static int DALTONIZER_DISABLED = -1;
    public static int DALTONIZER_SIMULATE_MONOCHROMACY = 0;
    public static int DALTONIZER_CORRECT_DEUTERANOMALY = 12;
    public static int AUTOCLICK_DELAY_DEFAULT = 600;
    public static String ACTION_CHOOSE_ACCESSIBILITY_BUTTON = "com.android.internal.intent.action.CHOOSE_ACCESSIBILITY_BUTTON";
    static Object sInstanceSync;
    private static AccessibilityManager sInstance;
    private Object mLock;
    private IAccessibilityManager mService;
    int mUserId;
    Handler mHandler;
    Handler.Callback mCallback;
    boolean mIsEnabled;
    int mRelevantEventTypes;
    boolean mIsTouchExplorationEnabled;
    boolean mIsHighTextContrastEnabled;
    AccessibilityPolicy mAccessibilityPolicy;
    private ArrayMap<AccessibilityStateChangeListener, Handler> mAccessibilityStateChangeListeners;
    private ArrayMap<TouchExplorationStateChangeListener, Handler> mTouchExplorationStateChangeListeners;
    private ArrayMap<HighTextContrastChangeListener, Handler> mHighTextContrastStateChangeListeners;
    private ArrayMap<AccessibilityServicesStateChangeListener, Handler> mServicesStateChangeListeners;
    private SparseArray<List<AccessibilityRequestPreparer>> mRequestPreparerLists;
    private IAccessibilityManagerClient.Stub mClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AccessibilityManager $$robo$$android_view_accessibility_AccessibilityManager$getInstance(Context context) {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                int userId = Binder.getCallingUid() == 1000 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS") == 0 || context.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") == 0 ? -2 : context.getUserId();
                sInstance = new AccessibilityManager(context, null, userId);
            }
        }
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_view_accessibility_AccessibilityManager$__constructor__(Context context, IAccessibilityManager service, int userId) {
        this.mLock = new Object();
        this.mRelevantEventTypes = -1;
        this.mAccessibilityStateChangeListeners = new ArrayMap();
        this.mTouchExplorationStateChangeListeners = new ArrayMap();
        this.mHighTextContrastStateChangeListeners = new ArrayMap();
        this.mServicesStateChangeListeners = new ArrayMap();
        this.mClient = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AccessibilityManager this$0;

            private void $$robo$$android_view_accessibility_AccessibilityManager_1$__constructor__(AccessibilityManager this$0) {
                this.this$0 = this$0;
            }

            private final void $$robo$$android_view_accessibility_AccessibilityManager_1$setState(int state) {
                this.this$0.mHandler.obtainMessage(1, state, 0).sendToTarget();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_view_accessibility_AccessibilityManager_1$notifyServicesStateChanged() {
                ArrayMap listeners;
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (this.this$0.mServicesStateChangeListeners.isEmpty()) {
                        return;
                    }
                    listeners = new ArrayMap(this.this$0.mServicesStateChangeListeners);
                }
                int numListeners = listeners.size();
                for (int i = 0; i < numListeners; ++i) {
                    AccessibilityServicesStateChangeListener listener = (AccessibilityServicesStateChangeListener)this.this$0.mServicesStateChangeListeners.keyAt(i);
                    ((Handler)this.this$0.mServicesStateChangeListeners.valueAt(i)).post(() -> listener.onAccessibilityServicesStateChanged(this.this$0));
                }
            }

            private final void $$robo$$android_view_accessibility_AccessibilityManager_1$setRelevantEventTypes(int eventTypes) {
                this.this$0.mRelevantEventTypes = eventTypes;
            }

            private void __constructor__(AccessibilityManager accessibilityManager) {
                this.$$robo$$android_view_accessibility_AccessibilityManager_1$__constructor__(accessibilityManager);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager_1$__constructor__(android.view.accessibility.AccessibilityManager ), this, accessibilityManager);
            }

            @Override
            public void setState(int n) {
                InvokeDynamicSupport.bootstrap("setState", $$robo$$android_view_accessibility_AccessibilityManager_1$setState(int ), this, n);
            }

            @Override
            public void notifyServicesStateChanged() {
                InvokeDynamicSupport.bootstrap("notifyServicesStateChanged", $$robo$$android_view_accessibility_AccessibilityManager_1$notifyServicesStateChanged(), this);
            }

            @Override
            public void setRelevantEventTypes(int n) {
                InvokeDynamicSupport.bootstrap("setRelevantEventTypes", $$robo$$android_view_accessibility_AccessibilityManager_1$setRelevantEventTypes(int ), this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallback = new MyCallback(this, null);
        this.mHandler = new Handler(context.getMainLooper(), this.mCallback);
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_view_accessibility_AccessibilityManager$__constructor__(Handler handler, IAccessibilityManager service, int userId) {
        this.mLock = new Object();
        this.mRelevantEventTypes = -1;
        this.mAccessibilityStateChangeListeners = new ArrayMap();
        this.mTouchExplorationStateChangeListeners = new ArrayMap();
        this.mHighTextContrastStateChangeListeners = new ArrayMap();
        this.mServicesStateChangeListeners = new ArrayMap();
        this.mClient = new /* invalid duplicate definition of identical inner class */;
        this.mCallback = new MyCallback(this, null);
        this.mHandler = handler;
        this.mUserId = userId;
        Object object = this.mLock;
        synchronized (object) {
            this.tryConnectToServiceLocked(service);
        }
    }

    private final IAccessibilityManagerClient $$robo$$android_view_accessibility_AccessibilityManager$getClient() {
        return this.mClient;
    }

    @VisibleForTesting
    private final Handler.Callback $$robo$$android_view_accessibility_AccessibilityManager$getCallback() {
        return this.mCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIsEnabled || this.mAccessibilityPolicy != null && this.mAccessibilityPolicy.isEnabled(this.mIsEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isTouchExplorationEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsTouchExplorationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isHighTextContrastEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            IAccessibilityManager service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
            return this.mIsHighTextContrastEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$sendAccessibilityEvent(AccessibilityEvent event) {
        int userId;
        AccessibilityEvent dispatchedEvent;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            event.setEventTime(SystemClock.uptimeMillis());
            if (this.mAccessibilityPolicy != null) {
                dispatchedEvent = this.mAccessibilityPolicy.onAccessibilityEvent(event, this.mIsEnabled, this.mRelevantEventTypes);
                if (dispatchedEvent == null) {
                    return;
                }
            } else {
                dispatchedEvent = event;
            }
            if (!this.isEnabled()) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e("AccessibilityManager", "AccessibilityEvent sent with accessibility disabled");
                return;
            }
            if ((dispatchedEvent.getEventType() & this.mRelevantEventTypes) == 0) {
                return;
            }
            userId = this.mUserId;
        }
        try {
            long identityToken = Binder.clearCallingIdentity();
            try {
                service.sendAccessibilityEvent(dispatchedEvent, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error during sending " + dispatchedEvent + " ", re);
        }
        finally {
            if (event != dispatchedEvent) {
                event.recycle();
            }
            dispatchedEvent.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$interrupt() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
            if (!this.isEnabled()) {
                Looper myLooper = Looper.myLooper();
                if (myLooper == Looper.getMainLooper()) {
                    throw new IllegalStateException("Accessibility off. Did you forget to check that?");
                }
                Log.e("AccessibilityManager", "Interrupt called with accessibility disabled");
                return;
            }
            userId = this.mUserId;
        }
        try {
            service.interrupt(userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while requesting interrupt from all services. ", re);
        }
    }

    @Deprecated
    private final List<ServiceInfo> $$robo$$android_view_accessibility_AccessibilityManager$getAccessibilityServiceList() {
        List<AccessibilityServiceInfo> infos = this.getInstalledAccessibilityServiceList();
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            AccessibilityServiceInfo info = infos.get(i);
            services.add(info.getResolveInfo().serviceInfo);
        }
        return Collections.unmodifiableList(services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityServiceInfo> $$robo$$android_view_accessibility_AccessibilityManager$getInstalledAccessibilityServiceList() {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getInstalledAccessibilityServiceList(userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (this.mAccessibilityPolicy != null) {
            services = this.mAccessibilityPolicy.getInstalledAccessibilityServiceList(services);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityServiceInfo> $$robo$$android_view_accessibility_AccessibilityManager$getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return Collections.emptyList();
            }
            userId = this.mUserId;
        }
        List<AccessibilityServiceInfo> services = null;
        try {
            services = service.getEnabledAccessibilityServiceList(feedbackTypeFlags, userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while obtaining the installed AccessibilityServices. ", re);
        }
        if (this.mAccessibilityPolicy != null) {
            services = this.mAccessibilityPolicy.getEnabledAccessibilityServiceList(feedbackTypeFlags, services);
        }
        if (services != null) {
            return Collections.unmodifiableList(services);
        }
        return Collections.emptyList();
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        this.addAccessibilityStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityStateChangeListener(AccessibilityStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityStateChangeListener(AccessibilityStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mAccessibilityStateChangeListeners.indexOfKey(listener);
            this.mAccessibilityStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        this.addTouchExplorationStateChangeListener(listener, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTouchExplorationStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mTouchExplorationStateChangeListeners.indexOfKey(listener);
            this.mTouchExplorationStateChangeListeners.remove(listener);
            return index >= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mServicesStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mServicesStateChangeListeners.remove(listener);
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityRequestPreparer(AccessibilityRequestPreparer preparer) {
        int id2;
        List<AccessibilityRequestPreparer> requestPreparerList;
        if (this.mRequestPreparerLists == null) {
            this.mRequestPreparerLists = new SparseArray(1);
        }
        if ((requestPreparerList = this.mRequestPreparerLists.get(id2 = preparer.getView().getAccessibilityViewId())) == null) {
            requestPreparerList = new ArrayList<AccessibilityRequestPreparer>(1);
            this.mRequestPreparerLists.put(id2, requestPreparerList);
        }
        requestPreparerList.add(preparer);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityRequestPreparer(AccessibilityRequestPreparer preparer) {
        if (this.mRequestPreparerLists == null) {
            return;
        }
        int viewId = preparer.getView().getAccessibilityViewId();
        List<AccessibilityRequestPreparer> requestPreparerList = this.mRequestPreparerLists.get(viewId);
        if (requestPreparerList != null) {
            requestPreparerList.remove(preparer);
            if (requestPreparerList.isEmpty()) {
                this.mRequestPreparerLists.remove(viewId);
            }
        }
    }

    private final List<AccessibilityRequestPreparer> $$robo$$android_view_accessibility_AccessibilityManager$getRequestPreparersForAccessibilityId(int id2) {
        if (this.mRequestPreparerLists == null) {
            return null;
        }
        return this.mRequestPreparerLists.get(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$addHighTextContrastStateChangeListener(HighTextContrastChangeListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighTextContrastStateChangeListeners.put(listener, handler == null ? this.mHandler : handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$removeHighTextContrastStateChangeListener(HighTextContrastChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHighTextContrastStateChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$setAccessibilityPolicy(AccessibilityPolicy policy) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAccessibilityPolicy = policy;
        }
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$isAccessibilityVolumeStreamActive() {
        List<AccessibilityServiceInfo> serviceInfos = this.getEnabledAccessibilityServiceList(-1);
        for (int i = 0; i < serviceInfos.size(); ++i) {
            if ((serviceInfos.get((int)i).flags & 0x80) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityManager$sendFingerprintGesture(int keyCode) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return false;
            }
        }
        try {
            return service.sendFingerprintGesture(keyCode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityManager$setStateLocked(int stateFlags) {
        boolean enabled = (stateFlags & 1) != 0;
        boolean touchExplorationEnabled = (stateFlags & 2) != 0;
        boolean highTextContrastEnabled = (stateFlags & 4) != 0;
        boolean wasEnabled = this.isEnabled();
        boolean wasTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
        boolean wasHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
        this.mIsEnabled = enabled;
        this.mIsTouchExplorationEnabled = touchExplorationEnabled;
        this.mIsHighTextContrastEnabled = highTextContrastEnabled;
        if (wasEnabled != this.isEnabled()) {
            this.notifyAccessibilityStateChanged();
        }
        if (wasTouchExplorationEnabled != touchExplorationEnabled) {
            this.notifyTouchExplorationStateChanged();
        }
        if (wasHighTextContrastEnabled != highTextContrastEnabled) {
            this.notifyHighTextContrastStateChanged();
        }
    }

    private final AccessibilityServiceInfo $$robo$$android_view_accessibility_AccessibilityManager$getInstalledServiceInfoWithComponentName(ComponentName componentName) {
        List<AccessibilityServiceInfo> installedServiceInfos = this.getInstalledAccessibilityServiceList();
        if (installedServiceInfos == null || componentName == null) {
            return null;
        }
        for (int i = 0; i < installedServiceInfos.size(); ++i) {
            if (!componentName.equals(installedServiceInfos.get(i).getComponentName())) continue;
            return installedServiceInfos.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityInteractionConnection(IWindow windowToken, String packageName, IAccessibilityInteractionConnection connection) {
        int userId;
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return -1;
            }
            userId = this.mUserId;
        }
        try {
            return service.addAccessibilityInteractionConnection(windowToken, connection, packageName, userId);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while adding an accessibility interaction connection. ", re);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityInteractionConnection(IWindow windowToken) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.removeAccessibilityInteractionConnection(windowToken);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while removing an accessibility interaction connection. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$performAccessibilityShortcut() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.performAccessibilityShortcut();
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error performing accessibility shortcut. ", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$notifyAccessibilityButtonClicked() {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonClicked();
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while dispatching accessibility button click", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$notifyAccessibilityButtonVisibilityChanged(boolean shown) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.notifyAccessibilityButtonVisibilityChanged(shown);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error while dispatching accessibility button visibility change", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) {
        IAccessibilityManager service;
        Object object = this.mLock;
        synchronized (object) {
            service = this.getServiceLocked();
            if (service == null) {
                return;
            }
        }
        try {
            service.setPictureInPictureActionReplacingConnection(connection);
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "Error setting picture in picture action replacement", re);
        }
    }

    private final IAccessibilityManager $$robo$$android_view_accessibility_AccessibilityManager$getServiceLocked() {
        if (this.mService == null) {
            this.tryConnectToServiceLocked(null);
        }
        return this.mService;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityManager$tryConnectToServiceLocked(IAccessibilityManager service) {
        if (service == null) {
            IBinder iBinder = ServiceManager.getService("accessibility");
            if (iBinder == null) {
                return;
            }
            service = IAccessibilityManager.Stub.asInterface(iBinder);
        }
        try {
            long userStateAndRelevantEvents = service.addClient(this.mClient, this.mUserId);
            this.setStateLocked(IntPair.first(userStateAndRelevantEvents));
            this.mRelevantEventTypes = IntPair.second(userStateAndRelevantEvents);
            this.mService = service;
        }
        catch (RemoteException re) {
            Log.e("AccessibilityManager", "AccessibilityManagerService is dead", re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$notifyAccessibilityStateChanged() {
        ArrayMap<AccessibilityStateChangeListener, Handler> listeners;
        boolean isEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAccessibilityStateChangeListeners.isEmpty()) {
                return;
            }
            isEnabled = this.isEnabled();
            listeners = new ArrayMap<AccessibilityStateChangeListener, Handler>(this.mAccessibilityStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            AccessibilityStateChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).post(() -> listener.onAccessibilityStateChanged(isEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$notifyTouchExplorationStateChanged() {
        ArrayMap<TouchExplorationStateChangeListener, Handler> listeners;
        boolean isTouchExplorationEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTouchExplorationStateChangeListeners.isEmpty()) {
                return;
            }
            isTouchExplorationEnabled = this.mIsTouchExplorationEnabled;
            listeners = new ArrayMap<TouchExplorationStateChangeListener, Handler>(this.mTouchExplorationStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            TouchExplorationStateChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).post(() -> listener.onTouchExplorationStateChanged(isTouchExplorationEnabled));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityManager$notifyHighTextContrastStateChanged() {
        ArrayMap<HighTextContrastChangeListener, Handler> listeners;
        boolean isHighTextContrastEnabled;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHighTextContrastStateChangeListeners.isEmpty()) {
                return;
            }
            isHighTextContrastEnabled = this.mIsHighTextContrastEnabled;
            listeners = new ArrayMap<HighTextContrastChangeListener, Handler>(this.mHighTextContrastStateChangeListeners);
        }
        int numListeners = listeners.size();
        for (int i = 0; i < numListeners; ++i) {
            HighTextContrastChangeListener listener = listeners.keyAt(i);
            listeners.valueAt(i).post(() -> listener.onHighTextContrastStateChanged(isHighTextContrastEnabled));
        }
    }

    private static final boolean $$robo$$android_view_accessibility_AccessibilityManager$isAccessibilityButtonSupported() {
        Resources res = Resources.getSystem();
        return res.getBoolean(17957022);
    }

    static void __staticInitializer__() {
        sInstanceSync = new Object();
    }

    public static AccessibilityManager getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_accessibility_AccessibilityManager$getInstance(android.content.Context ), (Context)context);
    }

    private void __constructor__(Context context, IAccessibilityManager iAccessibilityManager, int n) {
        this.$$robo$$android_view_accessibility_AccessibilityManager$__constructor__(context, iAccessibilityManager, n);
    }

    public AccessibilityManager(Context context, IAccessibilityManager iAccessibilityManager, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager$__constructor__(android.content.Context android.view.accessibility.IAccessibilityManager int ), this, context, iAccessibilityManager, n);
    }

    private void __constructor__(Handler handler, IAccessibilityManager iAccessibilityManager, int n) {
        this.$$robo$$android_view_accessibility_AccessibilityManager$__constructor__(handler, iAccessibilityManager, n);
    }

    public AccessibilityManager(Handler handler, IAccessibilityManager iAccessibilityManager, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager$__constructor__(android.os.Handler android.view.accessibility.IAccessibilityManager int ), this, handler, iAccessibilityManager, n);
    }

    public IAccessibilityManagerClient getClient() {
        return InvokeDynamicSupport.bootstrap("getClient", $$robo$$android_view_accessibility_AccessibilityManager$getClient(), this);
    }

    public Handler.Callback getCallback() {
        return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$android_view_accessibility_AccessibilityManager$getCallback(), this);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_accessibility_AccessibilityManager$isEnabled(), this);
    }

    public boolean isTouchExplorationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchExplorationEnabled", $$robo$$android_view_accessibility_AccessibilityManager$isTouchExplorationEnabled(), this);
    }

    public boolean isHighTextContrastEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHighTextContrastEnabled", $$robo$$android_view_accessibility_AccessibilityManager$isHighTextContrastEnabled(), this);
    }

    public void sendAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEvent", $$robo$$android_view_accessibility_AccessibilityManager$sendAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    public void interrupt() {
        InvokeDynamicSupport.bootstrap("interrupt", $$robo$$android_view_accessibility_AccessibilityManager$interrupt(), this);
    }

    @Deprecated
    public List<ServiceInfo> getAccessibilityServiceList() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityServiceList", $$robo$$android_view_accessibility_AccessibilityManager$getAccessibilityServiceList(), this);
    }

    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        return InvokeDynamicSupport.bootstrap("getInstalledAccessibilityServiceList", $$robo$$android_view_accessibility_AccessibilityManager$getInstalledAccessibilityServiceList(), this);
    }

    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int n) {
        return InvokeDynamicSupport.bootstrap("getEnabledAccessibilityServiceList", $$robo$$android_view_accessibility_AccessibilityManager$getEnabledAccessibilityServiceList(int ), this, n);
    }

    public boolean addAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAccessibilityStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityStateChangeListener ), this, accessibilityStateChangeListener);
    }

    public void addAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addAccessibilityStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityStateChangeListener android.os.Handler ), this, accessibilityStateChangeListener, handler);
    }

    public boolean removeAccessibilityStateChangeListener(AccessibilityStateChangeListener accessibilityStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAccessibilityStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityStateChangeListener ), this, accessibilityStateChangeListener);
    }

    public boolean addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("addTouchExplorationStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addTouchExplorationStateChangeListener(android.view.accessibility.AccessibilityManager$TouchExplorationStateChangeListener ), this, touchExplorationStateChangeListener);
    }

    public void addTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addTouchExplorationStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addTouchExplorationStateChangeListener(android.view.accessibility.AccessibilityManager$TouchExplorationStateChangeListener android.os.Handler ), this, touchExplorationStateChangeListener, handler);
    }

    public boolean removeTouchExplorationStateChangeListener(TouchExplorationStateChangeListener touchExplorationStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeTouchExplorationStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeTouchExplorationStateChangeListener(android.view.accessibility.AccessibilityManager$TouchExplorationStateChangeListener ), this, touchExplorationStateChangeListener);
    }

    public void addAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener accessibilityServicesStateChangeListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addAccessibilityServicesStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityServicesStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityServicesStateChangeListener android.os.Handler ), this, accessibilityServicesStateChangeListener, handler);
    }

    public void removeAccessibilityServicesStateChangeListener(AccessibilityServicesStateChangeListener accessibilityServicesStateChangeListener) {
        InvokeDynamicSupport.bootstrap("removeAccessibilityServicesStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityServicesStateChangeListener(android.view.accessibility.AccessibilityManager$AccessibilityServicesStateChangeListener ), this, accessibilityServicesStateChangeListener);
    }

    public void addAccessibilityRequestPreparer(AccessibilityRequestPreparer accessibilityRequestPreparer) {
        InvokeDynamicSupport.bootstrap("addAccessibilityRequestPreparer", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityRequestPreparer(android.view.accessibility.AccessibilityRequestPreparer ), this, accessibilityRequestPreparer);
    }

    public void removeAccessibilityRequestPreparer(AccessibilityRequestPreparer accessibilityRequestPreparer) {
        InvokeDynamicSupport.bootstrap("removeAccessibilityRequestPreparer", $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityRequestPreparer(android.view.accessibility.AccessibilityRequestPreparer ), this, accessibilityRequestPreparer);
    }

    public List<AccessibilityRequestPreparer> getRequestPreparersForAccessibilityId(int n) {
        return InvokeDynamicSupport.bootstrap("getRequestPreparersForAccessibilityId", $$robo$$android_view_accessibility_AccessibilityManager$getRequestPreparersForAccessibilityId(int ), this, n);
    }

    public void addHighTextContrastStateChangeListener(HighTextContrastChangeListener highTextContrastChangeListener, Handler handler) {
        InvokeDynamicSupport.bootstrap("addHighTextContrastStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$addHighTextContrastStateChangeListener(android.view.accessibility.AccessibilityManager$HighTextContrastChangeListener android.os.Handler ), this, highTextContrastChangeListener, handler);
    }

    public void removeHighTextContrastStateChangeListener(HighTextContrastChangeListener highTextContrastChangeListener) {
        InvokeDynamicSupport.bootstrap("removeHighTextContrastStateChangeListener", $$robo$$android_view_accessibility_AccessibilityManager$removeHighTextContrastStateChangeListener(android.view.accessibility.AccessibilityManager$HighTextContrastChangeListener ), this, highTextContrastChangeListener);
    }

    public void setAccessibilityPolicy(AccessibilityPolicy accessibilityPolicy) {
        InvokeDynamicSupport.bootstrap("setAccessibilityPolicy", $$robo$$android_view_accessibility_AccessibilityManager$setAccessibilityPolicy(android.view.accessibility.AccessibilityManager$AccessibilityPolicy ), this, accessibilityPolicy);
    }

    public boolean isAccessibilityVolumeStreamActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityVolumeStreamActive", $$robo$$android_view_accessibility_AccessibilityManager$isAccessibilityVolumeStreamActive(), this);
    }

    public boolean sendFingerprintGesture(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendFingerprintGesture", $$robo$$android_view_accessibility_AccessibilityManager$sendFingerprintGesture(int ), this, n);
    }

    private void setStateLocked(int n) {
        InvokeDynamicSupport.bootstrap("setStateLocked", $$robo$$android_view_accessibility_AccessibilityManager$setStateLocked(int ), this, n);
    }

    public AccessibilityServiceInfo getInstalledServiceInfoWithComponentName(ComponentName componentName) {
        return InvokeDynamicSupport.bootstrap("getInstalledServiceInfoWithComponentName", $$robo$$android_view_accessibility_AccessibilityManager$getInstalledServiceInfoWithComponentName(android.content.ComponentName ), this, componentName);
    }

    public int addAccessibilityInteractionConnection(IWindow iWindow, String string2, IAccessibilityInteractionConnection iAccessibilityInteractionConnection) {
        return (int)InvokeDynamicSupport.bootstrap("addAccessibilityInteractionConnection", $$robo$$android_view_accessibility_AccessibilityManager$addAccessibilityInteractionConnection(android.view.IWindow java.lang.String android.view.accessibility.IAccessibilityInteractionConnection ), this, iWindow, string2, iAccessibilityInteractionConnection);
    }

    public void removeAccessibilityInteractionConnection(IWindow iWindow) {
        InvokeDynamicSupport.bootstrap("removeAccessibilityInteractionConnection", $$robo$$android_view_accessibility_AccessibilityManager$removeAccessibilityInteractionConnection(android.view.IWindow ), this, iWindow);
    }

    public void performAccessibilityShortcut() {
        InvokeDynamicSupport.bootstrap("performAccessibilityShortcut", $$robo$$android_view_accessibility_AccessibilityManager$performAccessibilityShortcut(), this);
    }

    public void notifyAccessibilityButtonClicked() {
        InvokeDynamicSupport.bootstrap("notifyAccessibilityButtonClicked", $$robo$$android_view_accessibility_AccessibilityManager$notifyAccessibilityButtonClicked(), this);
    }

    public void notifyAccessibilityButtonVisibilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyAccessibilityButtonVisibilityChanged", $$robo$$android_view_accessibility_AccessibilityManager$notifyAccessibilityButtonVisibilityChanged(boolean ), this, bl);
    }

    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection iAccessibilityInteractionConnection) {
        InvokeDynamicSupport.bootstrap("setPictureInPictureActionReplacingConnection", $$robo$$android_view_accessibility_AccessibilityManager$setPictureInPictureActionReplacingConnection(android.view.accessibility.IAccessibilityInteractionConnection ), this, iAccessibilityInteractionConnection);
    }

    private IAccessibilityManager getServiceLocked() {
        return InvokeDynamicSupport.bootstrap("getServiceLocked", $$robo$$android_view_accessibility_AccessibilityManager$getServiceLocked(), this);
    }

    private void tryConnectToServiceLocked(IAccessibilityManager iAccessibilityManager) {
        InvokeDynamicSupport.bootstrap("tryConnectToServiceLocked", $$robo$$android_view_accessibility_AccessibilityManager$tryConnectToServiceLocked(android.view.accessibility.IAccessibilityManager ), this, iAccessibilityManager);
    }

    private void notifyAccessibilityStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyAccessibilityStateChanged", $$robo$$android_view_accessibility_AccessibilityManager$notifyAccessibilityStateChanged(), this);
    }

    private void notifyTouchExplorationStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyTouchExplorationStateChanged", $$robo$$android_view_accessibility_AccessibilityManager$notifyTouchExplorationStateChanged(), this);
    }

    private void notifyHighTextContrastStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyHighTextContrastStateChanged", $$robo$$android_view_accessibility_AccessibilityManager$notifyHighTextContrastStateChanged(), this);
    }

    public static boolean isAccessibilityButtonSupported() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAccessibilityButtonSupported", $$robo$$android_view_accessibility_AccessibilityManager$isAccessibilityButtonSupported());
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityManager.class);
    }

    public /* synthetic */ AccessibilityManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MyCallback
    implements Handler.Callback,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int MSG_SET_STATE = 1;
        /* synthetic */ AccessibilityManager this$0;

        private void $$robo$$android_view_accessibility_AccessibilityManager_MyCallback$__constructor__(AccessibilityManager accessibilityManager) {
            this.this$0 = accessibilityManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_view_accessibility_AccessibilityManager_MyCallback$handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    int state = message.arg1;
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        this.this$0.setStateLocked(state);
                        break;
                    }
                }
            }
            return true;
        }

        private /* synthetic */ void $$robo$$android_view_accessibility_AccessibilityManager_MyCallback$__constructor__(AccessibilityManager x0, 1 x1) {
        }

        private void __constructor__(AccessibilityManager accessibilityManager) {
            this.$$robo$$android_view_accessibility_AccessibilityManager_MyCallback$__constructor__(accessibilityManager);
        }

        public MyCallback(AccessibilityManager accessibilityManager) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager_MyCallback$__constructor__(android.view.accessibility.AccessibilityManager ), this, accessibilityManager);
        }

        @Override
        public boolean handleMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_view_accessibility_AccessibilityManager_MyCallback$handleMessage(android.os.Message ), this, message);
        }

        private /* synthetic */ void __constructor__(AccessibilityManager accessibilityManager, 1 var2_2) {
            this.$$robo$$android_view_accessibility_AccessibilityManager_MyCallback$__constructor__(accessibilityManager, var2_2);
        }

        public /* synthetic */ MyCallback(AccessibilityManager accessibilityManager, 1 var2_2) {
            this(accessibilityManager);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityManager_MyCallback$__constructor__(android.view.accessibility.AccessibilityManager android.view.accessibility.AccessibilityManager$1 ), this, accessibilityManager, var2_2);
        }

        public /* synthetic */ MyCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface AccessibilityPolicy {
        public boolean isEnabled(boolean var1);

        public AccessibilityEvent onAccessibilityEvent(AccessibilityEvent var1, boolean var2, int var3);

        public int getRelevantEventTypes(int var1);

        public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> var1);

        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int var1, List<AccessibilityServiceInfo> var2);
    }

    public static interface HighTextContrastChangeListener {
        public void onHighTextContrastStateChanged(boolean var1);
    }

    public static interface AccessibilityServicesStateChangeListener {
        public void onAccessibilityServicesStateChanged(AccessibilityManager var1);
    }

    public static interface TouchExplorationStateChangeListener {
        public void onTouchExplorationStateChanged(boolean var1);
    }

    public static interface AccessibilityStateChangeListener {
        public void onAccessibilityStateChanged(boolean var1);
    }
}

